/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin;

import com.sap.platin.micro.Dynamic;
import com.sap.platin.micro.Installation;
import com.sap.platin.micro.InstallationInfo;
import com.sap.platin.micro.PathInfo;
import com.sap.platin.micro.Version;
import com.sap.platin.trace.T;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import sun.awt.AppContext;

public abstract class GuiAppletBase2
extends JApplet {
    public static final String __PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/GuiAppletBase2.java#18 $";
    private static int threadInitNumber = 0;
    private static int workerThreadNumber = 0;
    private Object mAppletInstance = null;
    private AppletWorkThread mAppletWorkThread = new AppletWorkThread();
    private SplashImage mSplashImage = new SplashImage();

    public GuiAppletBase2() throws HeadlessException {
        Version v = Version.CURRENT;
        if (T.race("APPLET")) {
            T.race("APPLET", "===========================================================");
            T.race("APPLET", "GuiAppletBase2 created.");
            T.race("APPLET", "            Instance: GuiApplet2@" + Integer.toHexString(System.identityHashCode(this)));
            T.race("APPLET", "            Product : " + v.getFullProductName());
            T.race("APPLET", "-----------------------------------------------------------");
            T.race("APPLET", "Current environment:");
            T.race("APPLET", "   Current AppContext   : " + AppContext.getAppContext() + "@" + Integer.toHexString(System.identityHashCode(AppContext.getAppContext())));
            T.race("APPLET", "   Current Applet thread: " + Thread.currentThread().getName() + " instance " + Thread.currentThread().getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(Thread.currentThread())));
            T.race("APPLET", "   Current ThreadGroup  : " + Thread.currentThread().getThreadGroup().getName());
            T.race("APPLET", "===========================================================");
        }
        this.setFocusTraversalPolicyProvider(false);
    }

    @Override
    public void init() {
        Thread.currentThread().setName("GuiAppletBase2[" + GuiAppletBase2.nextThreadNum() + "]");
        this.mAppletWorkThread.start();
        if (T.race("APPLET")) {
            T.race("APPLET", "Applet worker thread started.");
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.add(this.mSplashImage);
        this.getContentPane().setBackground(Color.white);
        this.setSystemProperties();
        System.setProperty("com.sap.platin.applet.codebase", String.valueOf(this.getCodeBase()));
        System.setProperty("com.sap.platin.applet.documentbase", String.valueOf(this.getDocumentBase()));
        String traceString = this.getParameter("trace");
        T.raceSetup(traceString, ":");
        RunnableTask r = new RunnableTask("Init"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (T.race("APPLET")) {
                    T.race("APPLET", "GuiAppletBase2.init(): running init on instance " + GuiAppletBase2.this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
                }
                Locale defaultLocale = Locale.getDefault();
                Class<System> clazz = System.class;
                synchronized (System.class) {
                    block16: {
                        GuiAppletBase2.this.setCursor(Cursor.getPredefinedCursor(3));
                        Object microKernel = null;
                        Installation inst = InstallationInfo.findAppropriateInstallation(Version.CURRENT);
                        if (inst == null) {
                            Locale.setDefault(new Locale("en", "US"));
                            Class<?> microKernelClass = Dynamic.createClass("com.sap.platin.micro.Microkernel", this.getClass().getClassLoader());
                            if (T.race("APPLET")) {
                                T.race("APPLET", "GuiAppletBase2.init(): instantiated Microkernel.class: " + microKernelClass);
                            }
                            Dynamic.callMethod(microKernelClass, "install", new Class[]{String[].class}, new Object[]{GuiAppletBase2.this.parseParameters()});
                            inst = InstallationInfo.getInstallation(Version.CURRENT);
                            if (T.race("APPLET")) {
                                T.race("APPLET", "GuiAppletBase2.init(): installed gui version: " + inst);
                            }
                            Locale.setDefault(defaultLocale);
                        }
                        GuiAppletBase2.this.getContentPane().remove(GuiAppletBase2.this.mSplashImage);
                        if (inst == null) {
                            JOptionPane.showMessageDialog(null, "There is no suitable version of the " + Version.CURRENT.getLongName() + " installed.", Version.CURRENT.getFullProductName(), 0);
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            break block16;
                        }
                        if (T.race("APPLET")) {
                            T.race("APPLET", "===========================================================");
                            T.race("APPLET", "GuiAppletBase2.init(): try to start Version :  " + inst.toString() + " (" + inst.getVersion().getFullNumericVersionString() + ") ");
                            T.race("APPLET", "                         product directory  : <" + inst.getProductDir() + ">");
                            T.race("APPLET", "===========================================================");
                        }
                        File jarDir = PathInfo.get(inst).locatePath(10008);
                        File guiStartFile = new File(jarDir, "GuiStartS.jar");
                        try {
                            URL[] urls = new URL[]{guiStartFile.toURI().toURL()};
                            ClassLoader startClassLoader = (ClassLoader)Dynamic.createObject("com.sap.platin.micro.MicroAppletClassLoader", new Class[]{URL[].class}, new Object[]{urls}, this.getClass().getClassLoader());
                            microKernel = Dynamic.createObject("com.sap.platin.micro.Microkernel", new Class[0], new Object[0], startClassLoader);
                            Class startClass = (Class)Dynamic.callMethod(microKernel, "loadStartClass", new Class[]{String.class}, new Object[]{"com.sap.platin.applet.GuiAppletImpl"});
                            if (T.race("APPLET")) {
                                T.race("APPLET", "GuiAppletBase2.init(): startClass: " + startClass);
                            }
                            if (startClass == null) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                break block16;
                            }
                            GuiAppletBase2.this.mAppletInstance = Dynamic.createObject(startClass, new Class[]{JApplet.class}, new Object[]{GuiAppletBase2.this});
                            if (T.race("APPLET")) {
                                T.race("APPLET", "GuiAppletBase2.init(): mAppletInstance: " + GuiAppletBase2.this.mAppletInstance);
                            }
                            if (GuiAppletBase2.this.mAppletInstance == null) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                break block16;
                            }
                            Dynamic.callMethod(GuiAppletBase2.this.mAppletInstance, "init", new Class[0], new Object[0]);
                        }
                        catch (MalformedURLException e) {
                            T.raceError("GuiAppletBase2.init(): Can't create valid URL from File: \"" + guiStartFile + "\"", e);
                        }
                    }
                    GuiAppletBase2.this.setCursor(Cursor.getPredefinedCursor(0));
                    GuiAppletBase2.this.repaint();
                    if (T.race("APPLET")) {
                        T.race("APPLET", "GuiAppletBase2.init() done.");
                    }
                    return;
                }
            }
        };
        this.mAppletWorkThread.addTask(r);
        if (T.race("APPLET")) {
            T.race("APPLET", "GuiAppletBase2.init(): have scheduled init task, leaving.");
        }
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    private static synchronized int nextWorkThreadNum() {
        return workerThreadNumber++;
    }

    @Override
    public void start() {
        RunnableTask r = new RunnableTask("Start"){

            @Override
            public void run() {
                if (T.race("APPLET")) {
                    T.race("APPLET", "GuiAppletBase2.start() ...");
                }
                if (GuiAppletBase2.this.mAppletInstance != null) {
                    Dynamic.callMethod(GuiAppletBase2.this.mAppletInstance, "start", new Class[0], new Object[0]);
                }
                if (T.race("APPLET")) {
                    T.race("APPLET", "GuiAppletBase2.start() done.");
                }
            }
        };
        this.mAppletWorkThread.addTask(r);
        if (T.race("APPLET")) {
            T.race("APPLET", "GuiAppletBase2.start(): have scheduled start task, leaving.");
        }
    }

    @Override
    public void stop() {
        RunnableTask r = new RunnableTask("Stop"){

            @Override
            public void run() {
                if (T.race("APPLET")) {
                    T.race("APPLET", "GuiAppletBase2.stop() ...");
                }
                if (GuiAppletBase2.this.mAppletInstance != null) {
                    Dynamic.callMethod(GuiAppletBase2.this.mAppletInstance, "stop", new Class[0], new Object[0]);
                }
                if (T.race("APPLET")) {
                    T.race("APPLET", "GuiAppletBase2.stop() done.");
                }
            }
        };
        this.mAppletWorkThread.addTask(r);
        if (T.race("APPLET")) {
            T.race("APPLET", "GuiAppletBase2.init(): have scheduled stop task, leaving.");
        }
    }

    @Override
    public void destroy() {
        RunnableTask r = new RunnableTask("Destroy"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (T.race("APPLET")) {
                    T.race("APPLET", "GuiAppletBase2.destroy() ...");
                }
                Class<System> clazz = System.class;
                synchronized (System.class) {
                    if (GuiAppletBase2.this.mAppletInstance != null) {
                        Dynamic.callMethod(GuiAppletBase2.this.mAppletInstance, "destroy", new Class[0], new Object[0]);
                    }
                    if (T.race("APPLET")) {
                        T.race("APPLET", "GuiAppletBase2.destroy() done");
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        this.mAppletWorkThread.addTask(r);
        if (T.race("APPLET")) {
            T.race("APPLET", "GuiAppletBase2.destroy(): have scheduled destroy task, leaving.");
        }
        try {
            this.mAppletWorkThread.shutdown();
            if (T.race("APPLET")) {
                T.race("APPLET", "GuiAppletBase2.destroy(): shutdown task completed.");
            }
        }
        catch (InterruptedException e) {
            T.raceError("GuiAppletBase2.destroy(): Shutdown of applet worker thread has been interrupted.", e);
        }
    }

    public void setEPCMObject(Object epcm) {
        Dynamic.callMethod(this.mAppletInstance, "setEPCMObject", new Class[]{Object.class}, new Object[]{epcm});
    }

    public void redirectPortalEvent(Object epcm) {
        Dynamic.callMethod(this.mAppletInstance, "redirectPortalEvent", new Class[]{Object.class}, new Object[]{epcm});
    }

    public Object getApplication() {
        return Dynamic.callMethod(this.mAppletInstance, "getApplication", new Class[0], new Object[0]);
    }

    protected abstract int getProductType(StringBuffer var1);

    private String[] parseParameters() {
        ArrayList<String> args = new ArrayList<String>();
        String value = this.getParameter("installdir");
        if (value != null && value.length() > 0) {
            args.add("-d");
            args.add(value);
        }
        if ((value = this.getParameter("noshortcuts")) != null && Boolean.parseBoolean(value) && Boolean.parseBoolean(value)) {
            args.add("-M");
        }
        if ((value = this.getParameter("disableui")) != null && Boolean.parseBoolean(value) && Boolean.parseBoolean(value)) {
            args.add("-G");
        }
        if ((value = this.getParameter("silent")) != null && Boolean.parseBoolean(value) && Boolean.parseBoolean(value)) {
            args.add("-V");
        }
        if ((value = this.getParameter("automatic")) != null && Boolean.parseBoolean(value) && Boolean.parseBoolean(value)) {
            args.add("-s");
        }
        if ((value = this.getParameter("reinstall")) != null && Boolean.parseBoolean(value) && Boolean.parseBoolean(value)) {
            args.add("-f");
        }
        return args.toArray(new String[args.size()]);
    }

    protected int findProductType(StringBuffer message) {
        return Version.CURRENT.getProductType();
    }

    private void setSystemProperties() {
        String systemProperties = this.getParameter("SystemProperties");
        if (systemProperties != null) {
            String key = null;
            String value = null;
            StringTokenizer tok = new StringTokenizer(systemProperties, " ");
            while (tok.hasMoreTokens()) {
                key = tok.nextToken("=");
                key = key.trim();
                value = tok.nextToken(" ");
                value = value.replace('=', ' ');
                value = value.trim();
                System.setProperty(key, value);
            }
        }
    }

    public class AppletWorkThread
    extends Thread {
        private BlockingQueue<RunnableTask> mWorkQueue;
        private boolean mRunning;

        public AppletWorkThread() {
            super("AppletWorkThread[" + GuiAppletBase2.nextWorkThreadNum() + "]");
            this.mWorkQueue = new LinkedBlockingQueue<RunnableTask>();
            this.mRunning = false;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            T.race("APPLET", "GuiAppletBase2.AppletWorkerThread.run(): Worker Thread is now running.");
            try {
                this.mRunning = true;
                do {
                    RunnableTask r = this.mWorkQueue.take();
                    T.race("APPLET", "GuiAppletBase2.AppletWorkerThread.run(): Starting task: " + r.getTitle());
                    r.run();
                    T.race("APPLET", "GuiAppletBase2.AppletWorkerThread.run(): Task ended: " + r.getTitle());
                } while (this.mRunning);
            }
            catch (InterruptedException e) {
                this.mRunning = false;
            }
        }

        public void addTask(RunnableTask task) {
            T.race("APPLET", "GuiAppletBase2.AppletWorkerThread.addTask(): Adding task: " + task.getTitle());
            this.mWorkQueue.add(task);
        }

        public void shutdown() throws InterruptedException {
            T.race("SHUTDOWN", "Shut down applet worker thread.");
            this.mRunning = false;
            this.addTask(new RunnableTask("Shutdown"){

                @Override
                public void run() {
                    AppletWorkThread.this.mRunning = false;
                }
            });
            this.join();
            T.race("APPLET", "GuiAppletBase2.AppletWorkerThread.shutdown(): Worker thread has stopped");
        }
    }

    public abstract class RunnableTask
    implements Runnable {
        private String mTitle = "Unnamed";

        public RunnableTask(String title) {
            this.mTitle = title;
        }

        public String getTitle() {
            return this.mTitle;
        }
    }

    private static class SplashImage
    extends JComponent {
        ImageIcon mImage = this.getSplashImage();

        public SplashImage() {
            this.setVisible(true);
        }

        private ImageIcon getSplashImage() {
            ImageIcon retVal = null;
            ClassLoader cl = Version.class.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : Version.class.getClassLoader();
            URL splashUrl = null;
            switch (Version.CURRENT.getProductType()) {
                case 5: {
                    splashUrl = cl.getResource("com/sap/platin/base/splash/NWBCSplash.jpg");
                    break;
                }
                case 1: {
                    splashUrl = cl.getResource("com/sap/platin/base/splash/SAPGUISplash.jpg");
                    break;
                }
                case 2: {
                    splashUrl = cl.getResource("com/sap/platin/base/splash/SAPWDPSplash.jpg");
                }
            }
            if (splashUrl == null) {
                splashUrl = cl.getResource("com/sap/platin/base/splash/SAPGUISplash.jpg");
            }
            if (splashUrl != null) {
                retVal = new ImageIcon(splashUrl);
            }
            return retVal;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retVal = new Dimension(this.mImage.getIconWidth(), this.mImage.getIconHeight());
            return retVal;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension retVal = new Dimension(this.mImage.getIconWidth(), this.mImage.getIconHeight());
            return retVal;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension retVal = new Dimension(this.mImage.getIconWidth(), this.mImage.getIconHeight());
            return retVal;
        }

        @Override
        public void paint(Graphics g) {
            Rectangle rc = this.getBounds();
            int width = this.mImage.getIconWidth();
            int height = this.mImage.getIconHeight();
            g.drawImage(this.mImage.getImage(), (rc.width - width) / 2, (rc.height - height) / 2, this);
        }
    }
}

