/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.base.splash;

import com.sap.platin.micro.Version;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import sun.awt.AppContext;

public class SplashWindow
extends Window {
    private Image splashImage;
    private boolean paintCalled = false;

    public SplashWindow(Frame owner, Image splashImage) {
        super(owner);
        this.splashImage = splashImage;
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(splashImage, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int imgWidth = splashImage.getWidth(this);
        int imgHeight = splashImage.getHeight(this);
        this.setSize(imgWidth, imgHeight);
        this.setLocationRelativeTo(null);
        MouseAdapter disposeOnClick = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(disposeOnClick);
    }

    private static final Frame getOwnerFrame() {
        Frame f = (Frame)AppContext.getAppContext().get("SAP:SplashFrame");
        if (f == null) {
            f = new Frame();
            SplashWindow.setOwnerFrame(f);
        }
        return f;
    }

    private static final void setOwnerFrame(Frame frame) {
        if (frame != null) {
            AppContext.getAppContext().put("SAP:SplashFrame", frame);
        } else {
            AppContext.getAppContext().remove("SAP:SplashFrame");
        }
    }

    @Override
    public void update(Graphics g) {
        g.setColor(this.getForeground());
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.drawImage(this.splashImage, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    public static synchronized void splash() {
        ClassLoader cl = Version.class.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : Version.class.getClassLoader();
        URL splashUrl = null;
        switch (Version.CURRENT.getProductType()) {
            case 5: {
                splashUrl = cl.getResource("com/sap/platin/base/splash/NWBCSplash.jpg");
                break;
            }
            case 1: {
                splashUrl = cl.getResource("com/sap/platin/base/splash/SAPGUISplash.jpg");
                break;
            }
            case 2: {
                splashUrl = cl.getResource("com/sap/platin/base/splash/SAPWDPSplash.jpg");
            }
        }
        if (splashUrl == null) {
            splashUrl = cl.getResource("com/sap/platin/base/splash/SAPGUISplash.jpg");
        }
        if (splashUrl != null) {
            SplashWindow.splashImpl(Toolkit.getDefaultToolkit().createImage(splashUrl));
        } else {
            System.err.println("Splash image not found: " + splashUrl);
        }
    }

    public static synchronized void disposeSplash() {
        final Frame f = SplashWindow.getOwnerFrame();
        if (f != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    f.dispose();
                    SplashWindow.setOwnerFrame(null);
                }
            };
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                EventQueue.invokeLater(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void splashImpl(Image splashImage) {
        SplashWindow w = new SplashWindow(SplashWindow.getOwnerFrame(), splashImage);
        w.toFront();
        w.setVisible(true);
        if (!EventQueue.isDispatchThread()) {
            SplashWindow splashWindow = w;
            synchronized (splashWindow) {
                while (!w.paintCalled) {
                    try {
                        w.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

