/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.micro.DResult;
import com.sap.platin.trace.T;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Dynamic {
    public static Object createObject(Class<?> cls, Class<?>[] paramList, Object[] args) {
        DResult result = new DResult();
        Object retVal = Dynamic.createObject(result, cls, paramList, args);
        if (result.isFailure()) {
            T.raceError("Exception occured: " + result.get(), result.get());
        }
        return retVal;
    }

    public static Object createObject(DResult result, Class<?> cls, Class<?>[] paramList, Object[] args) {
        Object retVal = null;
        result.reset();
        try {
            if (cls != null) {
                Constructor<?> constructor = cls.getConstructor(paramList);
                retVal = constructor.newInstance(args);
            }
        }
        catch (Exception e) {
            result.set(e);
        }
        return retVal;
    }

    public static Object createObject(String className, Class<?>[] paramList, Object[] args, ClassLoader cl) {
        DResult result = new DResult();
        Object retVal = Dynamic.createObject(result, className, paramList, args, cl);
        if (result.isFailure()) {
            T.raceError("Exception occured: " + result.get(), result.get());
        }
        return retVal;
    }

    public static Object createObject(DResult result, String className, Class<?>[] paramList, Object[] args, ClassLoader cl) {
        Object retVal = null;
        result.reset();
        Class<?> cls = Dynamic.createClass(result, className, cl);
        if (result.isSuccess()) {
            retVal = Dynamic.createObject(result, cls, paramList, args);
        }
        return retVal;
    }

    public static Class<?> createClass(String className, ClassLoader cl) {
        DResult result = new DResult();
        Class<?> retVal = Dynamic.createClass(result, className, cl);
        if (result.isFailure()) {
            T.raceError("Exception occured: " + result.get(), result.get());
        }
        return retVal;
    }

    public static Class<?> createClass(DResult result, String className, ClassLoader cl) {
        Class<?> retVal = null;
        result.reset();
        try {
            retVal = cl == null ? Class.forName(className) : Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            result.set(e);
        }
        return retVal;
    }

    public static Object callMethod(Class<?> cls, String methodName, Class<?>[] paramList, Object[] args) {
        DResult result = new DResult();
        Object retVal = Dynamic.callMethod(result, cls, methodName, paramList, args);
        if (result.isFailure()) {
            T.raceError("Exception occured: " + result.get(), result.get());
        }
        return retVal;
    }

    public static Object callMethod(DResult result, Class<?> cls, String methodName, Class<?>[] paramList, Object[] args) {
        Object retVal = null;
        result.reset();
        try {
            Method method = cls.getMethod(methodName, paramList);
            retVal = method.invoke(null, args);
        }
        catch (Exception e) {
            result.set(e);
        }
        return retVal;
    }

    public static Object callMethod(Object clsInstance, String methodName, Class<?>[] paramList, Object[] args) {
        DResult result = new DResult();
        Object retVal = Dynamic.callMethod(result, clsInstance, methodName, paramList, args);
        if (result.isFailure()) {
            T.raceError("Exception occured: " + result.get(), result.get());
        }
        return retVal;
    }

    public static Object callMethod(DResult result, Object clsInstance, String methodName, Class<?>[] paramList, Object[] args) {
        Object retVal = null;
        result.reset();
        try {
            Method method = clsInstance.getClass().getMethod(methodName, paramList);
            retVal = method.invoke(clsInstance, args);
        }
        catch (Exception e) {
            result.set(e);
        }
        return retVal;
    }

    public static DResult setPrivateProperty(Class<?> cls, String name, Object value) {
        DResult retVal = new DResult();
        try {
            Field f = cls.getDeclaredField(name);
            f.setAccessible(true);
            f.set(null, value);
        }
        catch (Exception e) {
            retVal.set(e);
        }
        return retVal;
    }

    public static DResult setPrivateProperty(Object clsInstance, String name, Object value) {
        DResult retVal = new DResult();
        try {
            Field f = clsInstance.getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(null, value);
        }
        catch (Exception e) {
            retVal.set(e);
        }
        return retVal;
    }

    public static Object getPrivateProperty(DResult result, Class<?> cls, String name) {
        Object retVal = null;
        try {
            Field f = cls.getDeclaredField(name);
            f.setAccessible(true);
            retVal = f.get(null);
        }
        catch (Exception e) {
            result.set(e);
        }
        return retVal;
    }

    public static Object getPrivateProperty(DResult result, Object clsInstance, String name) {
        Object retVal = null;
        try {
            Field f = clsInstance.getClass().getDeclaredField(name);
            f.setAccessible(true);
            retVal = f.get(clsInstance);
        }
        catch (Exception e) {
            result.set(e);
        }
        return retVal;
    }

    public static Object getProperty(Class<?> cls, String name) {
        DResult result = new DResult();
        Object retVal = null;
        retVal = Dynamic.getProperty(result, cls, name);
        if (result.isFailure()) {
            T.raceError("Exception occured: " + result.get(), result.get());
        }
        return retVal;
    }

    public static Object getProperty(DResult result, Class<?> cls, String name) {
        Object retVal = null;
        try {
            retVal = cls.getField(name).get(null);
        }
        catch (Exception e) {
            result.set(e);
        }
        return retVal;
    }

    public static Object getProperty(Object clsInstance, String name) {
        DResult result = new DResult();
        Object retVal = null;
        retVal = Dynamic.getProperty(result, clsInstance, name);
        if (result.isFailure()) {
            T.raceError("Exception occured: " + result.get(), result.get());
        }
        return retVal;
    }

    public static Object getProperty(DResult result, Object clsInstance, String name) {
        Object retVal = null;
        try {
            retVal = clsInstance.getClass().getField(name).get(clsInstance);
        }
        catch (Exception e) {
            result.set(e);
        }
        return retVal;
    }
}

