/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.micro.InstallationDescription;
import com.sap.platin.micro.InstallationInfo;
import com.sap.platin.micro.PathInfo;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.Version;
import com.sap.platin.micro.util.IOUtils;
import com.sap.platin.trace.T;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarFile;

public class Installation
implements Comparable<Installation> {
    private static File mClassBase = null;
    private static File mRunningGuiBaseDir = null;
    private String mKey = null;
    private String mOSName = null;
    private Version mVersion = null;
    private File mInstallationDir = null;
    private File mProductDir = null;
    private File mApplicationDir = null;
    private SortedSet<File> mManifest = null;
    private Validation mIsValid = Validation.UNDEF;
    private Type mInstallationType = Type.CHANGING;
    private File mPrefix = null;
    private Set<String> mNonMandatoryFiles = new TreeSet<String>();
    private String[] mUnusedData;
    private static final String mVersionLabel = "#@ Version: ";

    private Installation(Version version) {
        this.mOSName = SystemInfo.getOperatingSystemName();
        this.mVersion = version;
        this.mNonMandatoryFiles.add(version.getProductDirName() + ".lnk");
        this.mNonMandatoryFiles.add(version.getCompressedProductName() + ".desktop");
        if (SystemInfo.getOSClass() == 3) {
            this.mNonMandatoryFiles.add("Documentation");
            this.mNonMandatoryFiles.add("settings.template");
            this.mNonMandatoryFiles.add("connections.template");
            this.mNonMandatoryFiles.add("SAPMessageServer.template");
            this.mNonMandatoryFiles.add("SAPRouter.template");
        }
    }

    public static Installation valueOf(Version v, Type type) {
        Installation retVal = new Installation(v);
        retVal.mOSName = SystemInfo.getOperatingSystemName();
        retVal.mInstallationDir = null;
        retVal.mProductDir = null;
        retVal.mApplicationDir = null;
        retVal.setInstallationType(type);
        return retVal;
    }

    public static Installation valueOf(InstallationInfo.Record r) {
        Installation retVal = Installation.valueOf(r.getVersion(), Type.INSTALLED);
        retVal.setInstallationValue(r.getResourceDir());
        retVal.setUnusedData(r.getUnusedData());
        return retVal;
    }

    public String toString() {
        return this.getVersion().getFullProductName();
    }

    public URL[] getClasspath() {
        URL[] retVal = new URL[]{};
        File jarDir = PathInfo.get(this).locatePath(10008);
        ArrayList<File> files = new ArrayList<File>();
        if (T.race("MICRO")) {
            T.race("MICRO", "Installation.getClasspath(): Setup classpath:");
        }
        if (this.isInstalled()) {
            for (File jar : this.getJarFilesFromManifest()) {
                if (!jar.exists() || files.contains(jar)) continue;
                files.add(jar);
                if (!T.race("MICRO")) continue;
                T.race("MICRO", "     " + jar);
            }
        } else {
            Set<String> jarFileNames = InstallationDescription.createInstance().getJarNames();
            if (T.race("MICRO")) {
                T.race("MICRO", "     Entries from installation description:");
            }
            for (String name : jarFileNames) {
                File jar = new File(jarDir, name);
                if (!jar.exists() || files.contains(jar)) continue;
                files.add(jar);
                if (!T.race("MICRO")) continue;
                T.race("MICRO", "     " + jar);
            }
        }
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokens = new StringTokenizer(classpath, File.pathSeparator);
        if (T.race("MICRO")) {
            T.race("MICRO", "     Entries from external class path:");
        }
        while (tokens.hasMoreElements()) {
            File element = new File(tokens.nextToken());
            if (!element.exists() || files.contains(element)) continue;
            files.add(element);
            if (!T.race("MICRO")) continue;
            T.race("MICRO", "     " + element);
        }
        retVal = new URL[files.size()];
        int a = 0;
        for (File f : files) {
            try {
                retVal[a++] = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                T.raceError("Installation.getClasspath(): Can't convert File to URL: \"" + f + "\"", e);
            }
        }
        return retVal;
    }

    private Set<File> getNativeJarFiles() {
        HashSet<File> files = new HashSet<File>();
        File jarDir = PathInfo.get(this).locatePath(10008);
        Set<String> jarFileNames = InstallationDescription.createInstance().getNativeJarNames();
        for (String name : jarFileNames) {
            files.add(new File(jarDir, name));
        }
        return files;
    }

    public Set<File> getInternalJarFiles() {
        HashSet<File> files = new HashSet<File>();
        File jarDir = PathInfo.get(this).locatePath(10008);
        Set<String> jarFileNames = InstallationDescription.createInstance().getInternalJarNames();
        for (String name : jarFileNames) {
            files.add(new File(jarDir, name));
        }
        return files;
    }

    private Set<File> getJarFilesFromManifest() {
        HashSet<File> retVal = new HashSet<File>();
        Set<File> nativeJars = this.getNativeJarFiles();
        String jName = PathInfo.get(this).locatePath(10008).getPath();
        if (T.race("MICRO")) {
            T.race("MICRO", "     Entries from installation database:");
        }
        for (File f : this.getFilesImpl()) {
            File jar;
            String name = f.getPath();
            if (!name.startsWith(jName) || nativeJars.contains(f) || !(jar = new File(name)).exists()) continue;
            retVal.add(jar);
            if (!T.race("MICRO")) continue;
            T.race("MICRO", "     " + jar);
        }
        return retVal;
    }

    public int getProductType() {
        int retVal = 0;
        if (this.mVersion != null) {
            retVal = this.mVersion.getProductType();
        }
        return retVal;
    }

    public Version getVersion() {
        return this.mVersion;
    }

    public void setInstallationDir(File instDir) {
        try {
            this.mProductDir = null;
            File file = this.mInstallationDir = instDir == null ? null : instDir.getCanonicalFile();
            if (this.mProductDir == null) {
                this.mProductDir = new File(this.mInstallationDir, this.mVersion.getProductDirName());
            }
            this.mApplicationDir = SystemInfo.getOSClass() == 3 ? new File(this.getProductDir(), this.getVersion().getProductDirName() + ".app") : this.mProductDir;
        }
        catch (IOException e) {
            T.raceError("setInstallationDir(): can't access " + instDir, e);
        }
    }

    public void setInstallationValue(File appDir) {
        if (appDir != null) {
            this.mApplicationDir = appDir;
            try {
                this.mApplicationDir = this.mApplicationDir.getCanonicalFile();
            }
            catch (IOException e) {
                T.raceError("Installation.setInstallationValue(): can not determine canonical path for installation value: \"" + appDir + "\"", e);
            }
            if (this.mInstallationType == Type.RUNNING) {
                this.mProductDir = this.mInstallationDir = this.mApplicationDir;
            } else {
                this.mProductDir = SystemInfo.getOSClass() == 3 ? appDir.getParentFile() : appDir;
                this.mInstallationDir = this.mProductDir.getParentFile();
            }
        }
    }

    void setInstallationValues(File installationDir, File productDir, File applicationDir) {
        this.mInstallationDir = installationDir;
        this.mProductDir = productDir;
        this.mApplicationDir = applicationDir;
    }

    public String getOSName() {
        return this.mOSName;
    }

    public static File getJarDir() {
        if (mClassBase == null) {
            Installation.getRunningGuiBase();
        }
        return mClassBase;
    }

    public File getInstallationValue() {
        return this.getApplicationDir();
    }

    public File getInstallationDir() {
        return this.mInstallationDir;
    }

    public File getApplicationDir() {
        return this.mApplicationDir;
    }

    public File getProductDir() {
        return this.mProductDir;
    }

    public File getStaticProductDir() {
        return new File(this.getInstallationDir(), this.mVersion.getStaticProductDirName());
    }

    public void addEntry(File file) {
        this.mIsValid = Validation.UNDEF;
        File prefix = this.getPrefix();
        if (prefix != null && file.getAbsolutePath().startsWith(prefix.getAbsolutePath())) {
            file = new File(file.getAbsolutePath().substring(prefix.getAbsolutePath().length()));
        }
        if (this.mManifest == null) {
            Set<File> files = this.getFilesImpl();
            this.mManifest = new TreeSet<File>(files);
        }
        this.mManifest.add(file);
    }

    public void closeManifest() {
        String prefixName;
        if (this.mManifest == null) {
            return;
        }
        File prefix = this.getPrefix();
        File manifest = IOUtils.patchRoot(prefix, this.getManifestFile());
        File appDir = PathInfo.get(this).locatePath(10009);
        String appDirName = appDir.getAbsolutePath();
        if (prefix != null && prefix.length() != 0L && appDirName.startsWith(prefixName = prefix.getAbsolutePath())) {
            appDirName = appDirName.substring(prefixName.length());
            appDir = new File(appDirName);
        }
        PrintWriter manifestOut = null;
        try {
            manifestOut = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(manifest, true), "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (manifestOut != null) {
            manifestOut.println(mVersionLabel + this.getVersion().getFullNumericVersionString());
            for (File resourceFile : this.mManifest) {
                String fileName = resourceFile.getPath();
                if (fileName.startsWith(appDirName)) {
                    fileName = fileName.substring(appDirName.length() + 1);
                }
                manifestOut.println(fileName);
            }
            manifestOut.close();
        }
        this.mManifest = null;
    }

    public File[] getFiles() {
        Set<File> retVal = this.getFilesImpl();
        if (this.getManifestFile().exists()) {
            retVal.add(this.getManifestFile());
        }
        return retVal.toArray(new File[retVal.size()]);
    }

    public File getPrefix() {
        return this.mPrefix;
    }

    public void setPrefix(File prefix) {
        this.mPrefix = prefix;
    }

    public File getManifestFile() {
        File retVal = null;
        String name = SystemInfo.getOSClass() != 3 ? "install.db" : "Contents/Resources/install.db";
        retVal = new File(this.getApplicationDir(), name);
        return retVal;
    }

    private static File getRunningManifestFile() {
        File retVal = null;
        File base = Installation.getJarDir();
        if (base != null) {
            base = base.getParentFile();
            retVal = new File(base, "install.db");
        }
        return retVal;
    }

    private static File getApplicationDirectoryFromManifest(File manifest) {
        File appDir = manifest;
        for (int a = 0; a < (SystemInfo.getOSClass() == 3 ? 3 : 1); ++a) {
            appDir = appDir.getParentFile();
        }
        return appDir;
    }

    public static File getRunningGuiBase() {
        if (mRunningGuiBaseDir == null) {
            File retVal;
            block15: {
                retVal = null;
                ClassLoader cl = Installation.class.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : Installation.class.getClassLoader();
                URL url = cl.getResource("com/sap/platin/micro/Version.class");
                if (url != null) {
                    if ("jar".equals(url.getProtocol())) {
                        try {
                            File f;
                            JarURLConnection conn = (JarURLConnection)url.openConnection();
                            url = conn.getJarFileURL();
                            if (!"file".equals(url.getProtocol())) break block15;
                            JarFile jf = conn.getJarFile();
                            String fileName = jf.getName();
                            retVal = new File(fileName);
                            retVal = retVal.getCanonicalFile();
                            for (int a = 0; a < 2; ++a) {
                                f = retVal.getParentFile();
                                if (f != null) {
                                    retVal = f;
                                }
                                if (a != 0) continue;
                                mClassBase = retVal;
                            }
                            File db = new File(retVal, "install.db");
                            if (db.exists()) {
                                retVal = Installation.getApplicationDirectoryFromManifest(db);
                            } else {
                                f = retVal.getParentFile();
                                if (f != null) {
                                    retVal = f;
                                }
                            }
                        }
                        catch (IOException e) {
                            T.raceError("Error when calling Installation.getRunningGuiDirectories() ", e);
                        }
                    } else if ("file".equals(url.getProtocol())) {
                        try {
                            retVal = new File(url.toURI());
                            for (int a = 0; a < 6; ++a) {
                                retVal = retVal.getParentFile();
                                if (a != 4) continue;
                                mClassBase = retVal;
                            }
                        }
                        catch (URISyntaxException e) {
                            T.raceError("Error when calling Installation.getRunningGuiDirectories() ", e);
                        }
                    }
                }
            }
            mRunningGuiBaseDir = retVal;
        }
        return mRunningGuiBaseDir;
    }

    public static Installation getRunningInstallationFromFile() {
        Installation retVal = null;
        File manifest = Installation.getRunningManifestFile();
        Version v = Installation.getVersionFromManifest(manifest);
        if (v != null && manifest != null) {
            retVal = new Installation(v);
            File appDir = Installation.getApplicationDirectoryFromManifest(manifest);
            retVal.setInstallationValue(appDir);
            retVal.setInstallationType(Type.INSTALLED);
        }
        return retVal;
    }

    public static Version getRunningVersionFromFile() {
        return Installation.getVersionFromManifest(Installation.getRunningManifestFile());
    }

    public Version getVersionFromFile() {
        return Installation.getVersionFromManifest(this.getManifestFile());
    }

    private static Version getVersionFromManifest(File manifest) {
        Version retVal = null;
        if (manifest != null && manifest.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(manifest), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith(mVersionLabel)) continue;
                    line = line.substring(mVersionLabel.length()).trim();
                    retVal = Version.valueOf(line);
                    break;
                }
                reader.close();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return retVal;
    }

    private Set<File> getFilesImpl() {
        Set<File> retVal = new HashSet<File>();
        File manifest = this.getManifestFile();
        File appDir = PathInfo.get(this).locatePath(10009);
        if (manifest.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(manifest), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    File file = new File(line);
                    if (!file.isAbsolute()) {
                        file = new File(appDir, line);
                    }
                    retVal.add(file);
                }
                reader.close();
            }
            catch (FileNotFoundException e) {
                retVal = Collections.emptySet();
                e.printStackTrace();
            }
            catch (IOException e) {
                retVal = Collections.emptySet();
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public Validation reValidate() {
        this.mIsValid = Validation.UNDEF;
        return this.isValid();
    }

    public Validation isValid() {
        if (this.mIsValid == Validation.UNDEF) {
            Validation retVal = Validation.EMPTY;
            StringBuffer missingFiles = new StringBuffer();
            if (this.getProductDir().exists()) {
                retVal = Validation.DAMAGED;
                File[] files = this.getFiles();
                if (files.length == 0) {
                    missingFiles.append("Installation database is missing: can't build file list.\n");
                } else {
                    boolean foundAnyFiles = false;
                    boolean foundAllFiles = true;
                    for (File f : files) {
                        if (this.mNonMandatoryFiles.contains(f.getName())) continue;
                        final File fileUnderTest = f;
                        boolean exists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                            @Override
                            public Boolean run() {
                                return fileUnderTest.exists();
                            }
                        });
                        if (!exists) {
                            if (missingFiles.length() == 0) {
                                missingFiles.append("Missing Files:\n");
                            }
                            missingFiles.append(f.getAbsolutePath()).append("\n");
                        }
                        foundAnyFiles = foundAnyFiles || exists;
                        foundAllFiles = foundAllFiles && exists;
                    }
                    if (foundAllFiles) {
                        retVal = Validation.VALID;
                    } else if (!foundAnyFiles) {
                        retVal = Validation.EMPTY;
                    } else {
                        retVal = Validation.DAMAGED;
                        retVal.setReason(missingFiles.toString());
                    }
                }
                this.mIsValid = retVal;
            }
        }
        return this.mIsValid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mInstallationType == null ? 0 : this.mInstallationType.hashCode());
        result = 31 * result + (this.mOSName == null ? 0 : this.mOSName.hashCode());
        result = 31 * result + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Installation other = (Installation)obj;
        if (this.mInstallationType != other.mInstallationType) {
            return false;
        }
        if (this.mOSName == null ? other.mOSName != null : !this.mOSName.equals(other.mOSName)) {
            return false;
        }
        return !(this.mVersion == null ? other.mVersion != null : !this.mVersion.equals(other.mVersion));
    }

    @Override
    public int compareTo(Installation o) {
        Version that = o.getVersion();
        return this.getVersion().compareTo(that);
    }

    public boolean isInstalled() {
        File manifestFile = this.getManifestFile();
        if (!manifestFile.exists()) {
            manifestFile = Installation.getRunningManifestFile();
        }
        return this.mInstallationType != Type.RUNNING || manifestFile.exists();
    }

    public void setInstallationType(Type installationType) {
        this.mInstallationType = installationType;
    }

    public String getKey() {
        if (this.mKey == null) {
            InstallationInfo.Record r = new InstallationInfo.Record(this, false);
            this.mKey = r.getKey();
        }
        return this.mKey;
    }

    public String formatLine(boolean def) {
        InstallationInfo.Record r = new InstallationInfo.Record(this, def);
        return r.formatLine();
    }

    public void setUnusedData(String[] unused) {
        this.mUnusedData = unused;
    }

    public String[] getUnusedData() {
        return this.mUnusedData;
    }

    public static enum Type {
        CHANGING,
        INSTALLED,
        RUNNING;

    }

    public static enum Validation {
        UNDEF,
        EMPTY,
        DAMAGED,
        VALID;

        private String mReason = null;

        public String getReason() {
            return this.mReason != null ? this.mReason : "";
        }

        public void setReason(String s) {
            this.mReason = s;
        }
    }
}

