/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.micro.DResult;
import com.sap.platin.micro.DownloadResource;
import com.sap.platin.micro.Dynamic;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.Version;
import com.sap.platin.micro.installer.InstallationOptions;
import com.sap.platin.micro.installer.LogWriter;
import com.sap.platin.micro.installer.MsgType;
import com.sap.platin.trace.T;
import com.sap.xml.XMLNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;

public abstract class InstallationDescription {
    public static final String __PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/micro/InstallationDescription.java#11 $";
    private static InstallationDescription mInstance = null;
    private static final boolean kNativeResource = true;
    private static final boolean kNoNativeResource = false;
    private static final String mExtensionJNLPFileName = "externalPackages.jnlp";
    private URI mJnlpFileURI = null;
    private URI mCodebase = null;
    private URI mAlternateCodebase = null;
    private TreeSet<DownloadResource> mPartList = new TreeSet();
    private TreeSet<DownloadResource> mInternalPartList = new TreeSet();

    protected InstallationDescription(URI codebase, URI jnlpFileURI) {
    }

    protected void init(URI codebase, URI jnlpFileURI) {
        this.mCodebase = codebase;
        this.mJnlpFileURI = jnlpFileURI;
        this.initDataTable();
        if (jnlpFileURI != null) {
            this.mPartList.clear();
            boolean failed = this.readJNLPFile(this.mJnlpFileURI, false);
            if (failed) {
                throw new IllegalArgumentException("Can't read or parse JNLP file: " + this.mJnlpFileURI);
            }
        }
        this.mInternalPartList.addAll(this.mPartList);
        URI extJNLP = this.getExternalJNLP();
        if (extJNLP != null) {
            this.readJNLPFile(extJNLP, true);
        }
    }

    protected abstract void initDataTable();

    protected void addResource(DownloadResource d) {
        if (this.isPlatformResource(d.getPlatform())) {
            this.mPartList.add(d);
        }
    }

    public static InstallationDescription createInstance() {
        if (mInstance == null) {
            Version version = Version.CURRENT;
            URI jnlpURI = (URI)InstallationOptions.jnlpfile.value();
            URI codebase = InstallationDescription.findCodebase();
            ClassLoader cl = InstallationDescription.class.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            if (version.isOfSameType(1)) {
                mInstance = (InstallationDescription)Dynamic.createObject("com.sap.platin.micro.SAPGUIDescription", new Class[]{URI.class, URI.class}, new Object[]{codebase, jnlpURI}, InstallationDescription.class.getClassLoader());
            } else if (version.isOfSameType(2)) {
                mInstance = (InstallationDescription)Dynamic.createObject("com.sap.platin.micro.SAPWDPDescription", new Class[]{URI.class, URI.class}, new Object[]{codebase, jnlpURI}, InstallationDescription.class.getClassLoader());
            } else if (version.isOfSameType(5)) {
                mInstance = (InstallationDescription)Dynamic.createObject("com.sap.platin.micro.SAPNWBCDescription", new Class[]{URI.class, URI.class}, new Object[]{codebase, jnlpURI}, InstallationDescription.class.getClassLoader());
            }
        }
        return mInstance;
    }

    private static URI extractCodebaseFromResource(URI inputURI) {
        URI retVal = null;
        if (inputURI != null) {
            String name = inputURI.toASCIIString();
            if (inputURI.getScheme().equalsIgnoreCase("jar")) {
                if ((name = name.substring(0, name.lastIndexOf("!/") + 2)).endsWith("GuiStartS.jar!/")) {
                    name = name.substring(4, name.length() - 15);
                }
            } else {
                name = name.substring(0, name.lastIndexOf(47) + 1);
            }
            retVal = URI.create(name);
        }
        return retVal;
    }

    public Collection<DownloadResource> getDownloadResources() {
        return this.mPartList;
    }

    public int getNumberOfResources() {
        return this.mPartList.size();
    }

    public Set<String> getJarNames() {
        HashSet<String> retVal = new HashSet<String>();
        for (DownloadResource part : this.mPartList) {
            if (part.isNative()) continue;
            retVal.add(part.getResource());
        }
        return retVal;
    }

    public Set<String> getNativeJarNames() {
        HashSet<String> retVal = new HashSet<String>();
        for (DownloadResource part : this.mPartList) {
            if (!part.isNative()) continue;
            retVal.add(part.getResource());
        }
        return retVal;
    }

    public Set<String> getInternalJarNames() {
        HashSet<String> retVal = new HashSet<String>();
        for (DownloadResource part : this.mInternalPartList) {
            if (part.isNative()) continue;
            retVal.add(part.getResource());
        }
        return retVal;
    }

    private static URI findCodebase() {
        URI retVal = (URI)InstallationOptions.codebase.value();
        if (retVal == null) {
            URI jnlpFileURI = (URI)InstallationOptions.jnlpfile.value();
            if (jnlpFileURI != null) {
                retVal = InstallationDescription.extractCodebaseFromResource(jnlpFileURI);
            } else {
                ClassLoader cl = InstallationDescription.class.getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                String name = InstallationDescription.class.getName();
                name = name.replace('.', '/') + ".class";
                URL jnlpFileURL = cl.getResource(name);
                retVal = InstallationDescription.extractCodebaseFromResource(URI.create(jnlpFileURL.toString()));
            }
        }
        return retVal;
    }

    public URI getAlternateCodebase() {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (this.mAlternateCodebase == null) {
            try {
                URL url;
                Object bs;
                DResult drc = new DResult();
                Class<?> smc = Dynamic.createClass(drc, "javax.jnlp.ServiceManager", cl);
                if (smc != null && (bs = Dynamic.callMethod(drc, smc, "lookup", new Class[]{String.class}, new Object[]{"javax.jnlp.BasicService"})) != null && (url = (URL)Dynamic.callMethod(drc, bs, "getCodeBase", new Class[0], new Object[0])) != null) {
                    this.mAlternateCodebase = url.toURI();
                    InstallationOptions.deploymentModel = InstallationOptions.DeploymentModel.WEBSTART;
                    return this.mAlternateCodebase;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            String name = InstallationDescription.class.getName();
            name = name.replace('.', '/') + ".class";
            URL jnlpFileURL = cl.getResource(name);
            String prefix = String.valueOf(jnlpFileURL);
            int pos = prefix.lastIndexOf(".jar!/");
            if (pos >= 0) {
                prefix = prefix.substring(0, Math.max(0, pos + 4));
            }
            if (prefix.startsWith("jar:file:") && !prefix.endsWith("GuiStartS.jar")) {
                URL resourceUrl = null;
                try {
                    JarURLConnection conn;
                    URL url;
                    resourceUrl = jnlpFileURL;
                    if (resourceUrl != null && "jar".equalsIgnoreCase(resourceUrl.getProtocol()) && "file".equalsIgnoreCase((url = (conn = (JarURLConnection)resourceUrl.openConnection()).getJarFileURL()).getProtocol())) {
                        JarFile jf = conn.getJarFile();
                        String fileName = jf.getName();
                        File dirName = new File(fileName);
                        dirName = dirName.getParentFile();
                        this.mAlternateCodebase = dirName.toURI();
                    }
                }
                catch (MalformedURLException e) {
                    LogWriter.writeLog(MsgType.error, "JNLPFile.getAlternateCodebase(): Can't parse URL: \"" + jnlpFileURL + "\"\n" + T.formatStackTrace("", e));
                }
                catch (IOException e) {
                    LogWriter.writeLog(MsgType.error, "JNLPFile.getAlternateCodebase(): can't access resource input stream from url: \"" + resourceUrl + "\"\n" + T.formatStackTrace("", e));
                }
            }
        }
        return this.mAlternateCodebase;
    }

    public URI getCodebase() {
        return this.mCodebase;
    }

    public URI getJNLPFileUrl() {
        return this.mJnlpFileURI;
    }

    private boolean readJNLPFile(URI jnlpFileUrl, boolean optional) {
        boolean failed = false;
        if (jnlpFileUrl != null) {
            try {
                Reader br = this.getReader(jnlpFileUrl, optional);
                if (br != null) {
                    XMLNode rootNode = XMLNode.parseFrom(br);
                    failed |= this.parseJNLPResources(rootNode, optional);
                    br.close();
                }
            }
            catch (Exception e) {
                LogWriter.writeLog(MsgType.error, "InstallationDescription.readJNLPFile(): Exception while parsing JNLP file: " + jnlpFileUrl + ", " + e.getMessage() + "\n" + T.formatStackTrace("", e));
            }
        }
        return failed;
    }

    private Reader getReader(URI jnlpFileUrl, boolean optional) {
        BufferedReader br;
        block4: {
            br = null;
            try {
                URL jnlpFile = jnlpFileUrl.toURL();
                URLConnection connectionUrl = jnlpFile.openConnection();
                if (connectionUrl instanceof HttpURLConnection) {
                    ((HttpURLConnection)connectionUrl).setInstanceFollowRedirects(false);
                }
                br = new BufferedReader(new InputStreamReader(connectionUrl.getInputStream()));
            }
            catch (IOException e1) {
                MsgType mode;
                MsgType msgType = mode = optional ? MsgType.info : MsgType.error;
                if (!optional) {
                    LogWriter.writeLog(mode, "JNLPFile.getReader(): I/O error reading JNLP file from url: " + jnlpFileUrl + "\n" + e1.getMessage() + "\n" + T.formatStackTrace("", e1));
                }
                if (!T.race("MICRO")) break block4;
                LogWriter.writeLog(mode, "Optional JNLP file: \"" + jnlpFileUrl + "\" not avaialable.\n");
            }
        }
        return br;
    }

    private URI getExternalJNLP() {
        URI retVal = null;
        URI altCodeBase = this.getAlternateCodebase();
        if (altCodeBase != null) {
            File f;
            retVal = URI.create(altCodeBase + mExtensionJNLPFileName);
            if ("file".equals(retVal.getScheme()) && !(f = new File(retVal)).exists()) {
                retVal = null;
            }
        } else {
            retVal = URI.create(this.getCodebase() + mExtensionJNLPFileName);
        }
        return retVal;
    }

    private boolean parseJNLPResources(XMLNode rootNode, boolean forceOptional) {
        boolean failed = false;
        List<XMLNode> resourceNodes = this.getNodesByType(rootNode, "resources");
        for (XMLNode currNode : resourceNodes) {
            if (failed |= this.parseResourceNode(currNode, forceOptional)) break;
        }
        return failed;
    }

    private boolean parseResourceNode(XMLNode resourceNode, boolean forceOptional) {
        boolean failed = false;
        String platform = resourceNode.getAttribute("os");
        Enumeration<XMLNode> e = resourceNode.getChildren();
        while (e.hasMoreElements()) {
            XMLNode currNode = e.nextElement();
            if (currNode.getName().equals("jar")) {
                this.parseResource(currNode, platform, false, forceOptional);
                continue;
            }
            if (!currNode.getName().equals("nativelib")) continue;
            this.parseResource(currNode, platform, true, forceOptional);
        }
        return failed;
    }

    private List<XMLNode> getNodesByType(XMLNode root, String type) {
        ArrayList<XMLNode> result = new ArrayList<XMLNode>();
        if (type.equals(root.getName())) {
            result.add(root);
        }
        Enumeration<XMLNode> en = root.getChildren();
        while (en.hasMoreElements()) {
            XMLNode childNode = en.nextElement();
            result.addAll(this.getNodesByType(childNode, type));
        }
        return result;
    }

    private boolean isPlatformResource(String platform) {
        boolean retVal = false;
        retVal = platform == null || "all".equalsIgnoreCase(platform) ? true : SystemInfo.getOperatingSystemName().equalsIgnoreCase(platform);
        return retVal;
    }

    private void parseResource(XMLNode currNode, String platform, boolean isNative, boolean forceOptional) {
        String jarName = currNode.getAttribute("href");
        boolean optional = forceOptional || Boolean.valueOf(currNode.getAttribute("optional")) != false;
        DownloadResource dr = new DownloadResource(jarName, optional, platform, isNative);
        if (this.isPlatformResource(platform)) {
            this.mPartList.add(dr);
        }
    }

    public String dump() {
        StringBuffer buf = new StringBuffer();
        buf.append("-----------------------------------------------------------").append("\n");
        buf.append("JNLP File Summary").append("\n");
        buf.append("-----------------------------------------------------------").append("\n");
        buf.append("URI             : ").append(this.getJNLPFileUrl()).append("\n");
        buf.append("Codebase        : ").append(this.getCodebase()).append("\n");
        buf.append("-----------------------------------------------------------").append("\n");
        buf.append("Resource Summary\n");
        buf.append("-----------------------------------------------------------").append("\n");
        for (DownloadResource dr : this.getDownloadResources()) {
            buf.append(dr.toString()).append("\n");
        }
        return buf.toString();
    }
}

