/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.micro.Installation;
import com.sap.platin.micro.PathInfo;
import com.sap.platin.micro.SystemAccess;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.Version;
import com.sap.platin.micro.installer.InstallationOptions;
import com.sap.platin.micro.util.IOUtils;
import com.sap.platin.trace.T;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InstallationInfo {
    public static final String __PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/micro/InstallationInfo.java#29 $";
    private static InstallationInfo mInstance = null;
    private Installation mRunningInstallation = null;
    private InstallationProperties mSystemInstallations = null;
    private InstallationProperties mUserInstallations = null;
    private Boolean mVistaAuthorizationState = null;

    private InstallationInfo() {
        this.init();
    }

    public static final InstallationInfo getInstance() {
        if (mInstance == null) {
            mInstance = new InstallationInfo();
        }
        return mInstance;
    }

    public static void updateData() {
        InstallationInfo.getInstance().updateDataImpl();
    }

    public static boolean registerInstallation(Installation inst, boolean isDefault) {
        return InstallationInfo.getInstance().registerInstallationImpl(inst, isDefault);
    }

    public static boolean remove(Installation inst) {
        return InstallationInfo.getInstance().deRegisterInstallationImpl(inst);
    }

    public static Installation getInstallation(Version v) {
        Installation retVal = InstallationInfo.getInstance().getInstallationImpl(v);
        return retVal;
    }

    public static boolean isUserLocalInstallation() {
        InstallationInfo info = InstallationInfo.getInstance();
        return !info.shouldUseSystemRepository();
    }

    public static Installation getDefaultInstallation() {
        Installation retVal = InstallationInfo.getDefaultInstallation(Version.CURRENT.getProductType());
        return retVal;
    }

    public static Installation getSystemDefaultInstallation() {
        Installation retVal = InstallationInfo.getInstance().getSystemDefaultInstallationImpl(Version.CURRENT.getProductType());
        return retVal;
    }

    public static Installation getUserDefaultInstallation() {
        Installation retVal = InstallationInfo.getInstance().getUserDefaultInstallationImpl(Version.CURRENT.getProductType());
        return retVal;
    }

    public static Installation getSystemDefaultInstallation(int type) {
        Installation retVal = InstallationInfo.getInstance().getSystemDefaultInstallationImpl(type);
        return retVal;
    }

    public static Installation getUserDefaultInstallation(int type) {
        Installation retVal = InstallationInfo.getInstance().getUserDefaultInstallationImpl(type);
        return retVal;
    }

    public static Installation getDefaultInstallation(int type) {
        Installation retVal = InstallationInfo.getInstance().getDefaultInstallationImpl(type);
        return retVal;
    }

    public static boolean removeDefault() {
        return InstallationInfo.getInstance().removeDefaultImpl();
    }

    public static boolean setDefault(Installation inst) {
        return InstallationInfo.getInstance().setDefaultImpl(inst);
    }

    public static boolean setStaticApplicationLinks(Installation inst) {
        return InstallationInfo.getInstance().setStaticApplicationLinksImpl(inst);
    }

    public static Installation getNewestInstallation(int type) {
        Installation retVal = InstallationInfo.getInstance().getNewestInstallationImpl(type);
        return retVal;
    }

    public static Installation getInstallation(File prodDir) {
        Installation retVal = InstallationInfo.getInstance().getInstallationImpl(prodDir);
        return retVal;
    }

    public static List<Installation> getInstallations() {
        return InstallationInfo.getInstallations(Version.CURRENT.getProductType());
    }

    public static List<Installation> getInstallations(int type) {
        return InstallationInfo.getInstance().getInstallationsImpl(type);
    }

    public static void setCurrent(Installation inst) {
        InstallationInfo.getInstance().setCurrentImpl(inst);
    }

    public static Installation findAppropriateInstallation(Version v) {
        Installation installation = null;
        Installation newestInst = InstallationInfo.getNewestInstallation(v.getProductType());
        Installation defaultInst = InstallationInfo.getDefaultInstallation(v.getProductType());
        Installation registered = InstallationInfo.getInstallation(v);
        if (defaultInst != null && defaultInst.getVersion().compareTo(v) >= 0) {
            installation = defaultInst;
        } else if (registered != null) {
            installation = registered;
        } else if (newestInst != null && newestInst.getVersion().compareTo(v) >= 0) {
            installation = newestInst;
        }
        return installation;
    }

    public static Installation getRunningInstallation() {
        return InstallationInfo.getInstance().getRunningInstallationImpl();
    }

    private boolean registerInstallationImpl(Installation inst, boolean isDefault) {
        boolean failed = inst == null;
        boolean done = false;
        boolean systemInstallationChanged = false;
        boolean userInstallationChanged = false;
        if (!failed && inst != null) {
            String key = inst.getKey();
            File prefix = (File)InstallationOptions.prefix.value();
            if (prefix != null) {
                failed |= !this.mSystemInstallations.getDataFile().getParentFile().mkdirs();
            }
            if (this.shouldUseSystemRepository() && IOUtils.isWritable(this.mSystemInstallations.getDataFile())) {
                systemInstallationChanged |= this.mSystemInstallations.putInstallation(inst, isDefault);
                if (this.mUserInstallations.containsKey(key)) {
                    if (isDefault == this.mUserInstallations.getDefaultState(inst)) {
                        this.mUserInstallations.remove(inst);
                        userInstallationChanged = true;
                    }
                    if (this.mUserInstallations.mInactiveDefaultMap.containsKey(key)) {
                        if (isDefault) {
                            this.mUserInstallations.mInactiveDefaultMap.remove(key);
                            userInstallationChanged = true;
                        } else {
                            userInstallationChanged |= this.mUserInstallations.putInstallation(inst, true);
                        }
                    }
                }
                done = true;
            }
            if (!done) {
                userInstallationChanged |= this.mUserInstallations.putInstallation(inst, isDefault);
            }
            if (systemInstallationChanged) {
                failed |= this.mSystemInstallations.writeData();
            }
            if (userInstallationChanged) {
                failed |= this.mUserInstallations.writeData();
            }
        }
        return failed;
    }

    private boolean deRegisterInstallationImpl(Installation inst) {
        boolean failed = true;
        boolean systemInstallationChanged = false;
        boolean userInstallationChanged = false;
        if (inst != null) {
            Installation obj;
            failed = false;
            boolean done = false;
            String key = inst.getKey();
            if (this.shouldUseSystemRepository() && IOUtils.isWritable(this.mSystemInstallations.getDataFile()) && (obj = this.mSystemInstallations.remove(inst)) != null) {
                Installation iu;
                this.mSystemInstallations.mInactiveDefaultMap.remove(key);
                systemInstallationChanged = true;
                if (this.mUserInstallations.containsKey(key) && (iu = this.mUserInstallations.get(key)).getInstallationValue().equals(inst.getInstallationValue())) {
                    this.mUserInstallations.remove(inst);
                    this.mUserInstallations.mInactiveDefaultMap.remove(key);
                    userInstallationChanged = true;
                }
                done = true;
            }
            if (!done && (obj = this.mUserInstallations.remove(inst)) != null) {
                this.mUserInstallations.mInactiveDefaultMap.remove(key);
                userInstallationChanged = true;
            }
            failed |= this.removeSystemSpecificData(inst);
            InstallationInfo.removeStaticApplicationLinks(inst, true);
            if (systemInstallationChanged) {
                failed |= this.mSystemInstallations.writeData();
            }
            if (userInstallationChanged) {
                failed |= this.mUserInstallations.writeData();
            }
        }
        return failed;
    }

    private boolean removeSystemSpecificData(Installation inst) {
        boolean failed = false;
        switch (SystemInfo.getOSClass()) {
            case 1: {
                failed |= this.removeUnixSpecificData(inst);
            }
        }
        return failed;
    }

    private boolean removeUnixSpecificData(Installation inst) {
        boolean failed = false;
        File desktopFileName = PathInfo.get(inst).locatePath(20011);
        if (desktopFileName.exists()) {
            desktopFileName.delete();
        }
        return failed;
    }

    private void setCurrentImpl(Installation inst) {
        this.mRunningInstallation = inst;
    }

    private Installation getRunningInstallationImpl() {
        if (this.mRunningInstallation == null) {
            Installation retVal = null;
            File baseDir = Installation.getRunningGuiBase();
            Installation runInst = Installation.getRunningInstallationFromFile();
            Installation regInst = this.getInstallationImpl(baseDir);
            if (regInst != null) {
                retVal = regInst;
            } else if (runInst != null) {
                boolean def = this.getDefaultState(runInst);
                this.registerInstallationImpl(runInst, def);
                regInst = this.getInstallationImpl(baseDir);
                if (regInst != null) {
                    retVal = regInst;
                } else {
                    retVal = runInst;
                    retVal.setInstallationType(Installation.Type.INSTALLED);
                    retVal.setInstallationValue(baseDir);
                }
            } else {
                retVal = Installation.valueOf(Version.CURRENT, Installation.Type.RUNNING);
                retVal.setInstallationValue(baseDir);
            }
            this.mRunningInstallation = retVal;
        }
        return this.mRunningInstallation;
    }

    private boolean getDefaultState(Installation inst) {
        return this.mSystemInstallations.getDefaultState(inst) || this.mUserInstallations.getDefaultState(inst);
    }

    private Installation getInstallationImpl(Version v) {
        String key = Record.getKey(v);
        Installation retVal = this.mUserInstallations.get(key);
        if (retVal == null) {
            retVal = this.mSystemInstallations.get(key);
        }
        return retVal;
    }

    private Installation getInstallationImpl(File prodDir) {
        Installation retVal = this.mUserInstallations.get(prodDir);
        if (retVal == null) {
            retVal = this.mSystemInstallations.get(prodDir);
        }
        return retVal;
    }

    private List<Installation> getInstallationsImpl(int type) {
        ArrayList<Installation> retVal = new ArrayList<Installation>();
        for (Installation inst : this.mUserInstallations.getInstallations()) {
            if (!inst.getVersion().isOfSameType(type)) continue;
            retVal.add(inst);
        }
        for (Installation inst : this.mSystemInstallations.getInstallations()) {
            if (!inst.getVersion().isOfSameType(type) || retVal.contains(inst)) continue;
            retVal.add(inst);
        }
        return retVal;
    }

    private Installation getNewestInstallationImpl(int type) {
        Installation retVal = null;
        for (Installation inst : this.mUserInstallations.getInstallations()) {
            if (!inst.getVersion().isOfSameType(type) || retVal != null && inst.compareTo(retVal) <= 0) continue;
            retVal = inst;
        }
        for (Installation inst : this.mSystemInstallations.getInstallations()) {
            if (!inst.getVersion().isOfSameType(type) || retVal != null && inst.compareTo(retVal) <= 0) continue;
            retVal = inst;
        }
        return retVal;
    }

    private Installation getSystemDefaultInstallationImpl(int type) {
        Installation retVal = this.mSystemInstallations.getDefault(type);
        return retVal;
    }

    private Installation getUserDefaultInstallationImpl(int type) {
        Installation retVal = this.mUserInstallations.getDefault(type);
        return retVal;
    }

    private Installation getDefaultInstallationImpl(int type) {
        Installation retVal = this.mUserInstallations.getDefault(type);
        if (retVal == null) {
            retVal = this.mSystemInstallations.getDefault(type);
        }
        return retVal;
    }

    private boolean removeDefaultImpl() {
        int type = Version.CURRENT.getProductType();
        Installation defaultInst = this.getDefaultInstallationImpl(type);
        this.mUserInstallations.removeDefault(Version.CURRENT.getProductType());
        InstallationInfo.removeStaticApplicationLinks(defaultInst);
        return this.mUserInstallations.writeData();
    }

    private boolean setDefaultImpl(Installation inst) {
        boolean failed;
        boolean bl = failed = inst == null;
        if (!(this.mSystemInstallations.isDefault(inst) || this.mUserInstallations.isDefault(inst) || failed || inst == null)) {
            this.mUserInstallations.setDefault(inst);
            failed |= this.mUserInstallations.writeData();
            this.setStaticApplicationLinksImpl(inst);
        }
        return failed;
    }

    private boolean setStaticApplicationLinksImpl(Installation inst) {
        boolean failed = false;
        if (inst != null) {
            InstallationInfo.removeStaticApplicationLinks(inst);
            switch (SystemInfo.getOSClass()) {
                case 1: {
                    File prefix = (File)InstallationOptions.prefix.value();
                    File dstDir = new File(inst.getStaticProductDir(), "bin");
                    File srcDir = new File(inst.getProductDir(), "bin");
                    File[] fileArr = new File[]{new File(srcDir, "guilogon"), new File(srcDir, "guistart")};
                    if (prefix != null) {
                        dstDir = IOUtils.patchRoot(prefix, dstDir);
                    }
                    if (!IOUtils.isWritable(dstDir)) break;
                    for (File file : fileArr) {
                        this.linkFile(file, new File(dstDir, file.getName()));
                    }
                    break;
                }
                case 3: {
                    File prefix = (File)InstallationOptions.prefix.value();
                    File dstFile = new File(inst.getStaticProductDir(), inst.getVersion().getCompressedName() + ".app");
                    File srcFile = inst.getApplicationDir();
                    if (prefix != null) {
                        dstFile = IOUtils.patchRoot(prefix, dstFile);
                    }
                    if (!IOUtils.isWritable(dstFile.getParentFile())) break;
                    this.linkFile(srcFile, dstFile);
                    break;
                }
                case 2: {
                    File dstDir = new File(inst.getStaticProductDir(), "bin");
                    File srcDir = new File(inst.getProductDir(), "bin");
                    File[] fileArr = new File[]{new File(srcDir, "guilogon.bat"), new File(srcDir, "guistart.bat"), new File(srcDir, "guilgn2.bat")};
                    if (!IOUtils.isWritable(dstDir)) break;
                    for (File file : fileArr) {
                        this.copyFile(file, dstDir);
                    }
                    break;
                }
            }
        }
        return failed;
    }

    private void copyFile(File file, File dstDir) {
        StringBuilder message = new StringBuilder();
        if (file.exists()) {
            if (!dstDir.exists()) {
                dstDir.mkdirs();
            }
            IOUtils.copyFile(message, file, new File(dstDir, file.getName()));
        }
    }

    private boolean linkFile(File file, File dstFile) {
        boolean failed = false;
        if (dstFile.exists()) {
            dstFile.delete();
        }
        if (!dstFile.getParentFile().exists()) {
            dstFile.getParentFile().mkdirs();
        }
        try {
            String[] cmdArr = new String[]{"ln", "-s", file.getAbsolutePath(), dstFile.getAbsolutePath()};
            Process p = Runtime.getRuntime().exec(cmdArr);
            p.waitFor();
            failed = p.exitValue() != 0;
        }
        catch (IOException e) {
            failed = false;
            T.raceError("Can't link " + file + " to " + dstFile, e);
        }
        catch (InterruptedException e) {
            T.raceError("Link creation interrupted: " + file + " to " + dstFile, e);
        }
        return failed;
    }

    public static boolean removeStaticApplicationLinks(Installation inst) {
        return InstallationInfo.removeStaticApplicationLinks(inst, false);
    }

    public static boolean removeStaticApplicationLinks(Installation inst, boolean cleanup) {
        boolean failed = false;
        if (inst != null) {
            File spDir = inst.getStaticProductDir();
            File dstDir = new File(spDir, "bin");
            if (spDir.exists() && IOUtils.isWritable(spDir)) {
                switch (SystemInfo.getOSClass()) {
                    case 2: {
                        File[] files;
                        for (File file : files = new File[]{new File(dstDir, "guilogon.bat"), new File(dstDir, "guistart.bat"), new File(dstDir, "guilgn2.bat")}) {
                            file.delete();
                        }
                        dstDir.delete();
                        spDir.delete();
                        break;
                    }
                    case 1: {
                        File[] files;
                        for (File file : files = new File[]{new File(dstDir, "guilogon"), new File(dstDir, "guistart")}) {
                            if (cleanup) {
                                if (file.exists()) continue;
                                file.delete();
                                IOUtils.deleteEmptyDirectories(new StringBuilder(), spDir);
                                continue;
                            }
                            file.delete();
                            dstDir.delete();
                            spDir.delete();
                        }
                        break;
                    }
                    case 3: {
                        File app = new File(spDir, inst.getVersion().getCompressedName() + ".app");
                        if (cleanup) {
                            if (app.exists()) break;
                            app.delete();
                            IOUtils.deleteEmptyDirectories(new StringBuilder(), spDir);
                            break;
                        }
                        app.delete();
                        spDir.delete();
                    }
                }
            }
        }
        return failed;
    }

    private boolean shouldUseSystemRepository() {
        boolean retVal = true;
        if (SystemInfo.getOSClass() == 2 && Float.parseFloat(SystemInfo.getOSVersion()) >= 6.0f) {
            if (this.mVistaAuthorizationState == null) {
                this.mVistaAuthorizationState = Boolean.FALSE;
                String progFilesName = System.getenv("ProgramFiles");
                if (progFilesName != null) {
                    File programFilesDir = new File(progFilesName);
                    if (programFilesDir.exists()) {
                        if (IOUtils.isWritable(programFilesDir, ".exe")) {
                            this.mVistaAuthorizationState = Boolean.TRUE;
                            T.race("MICRO", "VISTA: Assign escalated rights.");
                        } else {
                            T.race("MICRO", "VISTA: Assign limited rights because of system restrictions!");
                        }
                    } else {
                        T.race("MICRO", "VISTA: Assign limited rights because program folder (" + programFilesDir + ") does not exist!");
                    }
                } else {
                    T.race("MICRO", "VISTA: Assign limited rights because environment variable (%ProgramFiles%) is not set!");
                }
            }
            retVal = this.mVistaAuthorizationState;
        }
        return retVal;
    }

    private static File getRepositoryFile(int repository, String repositoryOption) {
        File prefix = (File)InstallationOptions.prefix.value();
        String dirName = System.getProperty(repositoryOption);
        File dir = dirName != null ? new File(dirName) : SystemAccess.locatePath(repository);
        File retVal = new File(dir, "sapgui.registry");
        return IOUtils.patchRoot(prefix, retVal);
    }

    private void init() {
        File systemPropFile = InstallationInfo.getRepositoryFile(6, "platin.properties.path");
        File userPropFile = InstallationInfo.getRepositoryFile(5, "user.platin.properties.path");
        this.mSystemInstallations = new InstallationProperties(systemPropFile);
        boolean dataChanged = this.mSystemInstallations.readData();
        if (dataChanged |= this.mSystemInstallations.cleanup()) {
            this.mSystemInstallations.writeData();
        }
        this.mUserInstallations = new InstallationProperties(userPropFile);
        dataChanged = this.mUserInstallations.readData();
        if (dataChanged |= this.mUserInstallations.cleanup()) {
            this.mUserInstallations.writeData();
        }
        this.mRunningInstallation = this.getRunningInstallationImpl();
    }

    private void updateDataImpl() {
        this.mSystemInstallations.readData();
        this.mUserInstallations.readData();
    }

    public static void main(String[] args) {
        Installation current = InstallationInfo.getRunningInstallation();
        Installation newestInst1 = InstallationInfo.getNewestInstallation(1);
        Installation newestInst2 = InstallationInfo.getNewestInstallation(2);
        System.err.println("Current: " + current + ", at " + current.getInstallationDir().toString());
        System.err.println("Newest SAPGUI : " + newestInst1);
        System.err.println("Newest SAPWDP : " + newestInst2);
    }

    public static class InstallationProperties {
        private Map<String, Installation> mInstallationsByKey = new HashMap<String, Installation>();
        private List<Record> mUnusedRecords = new ArrayList<Record>();
        private Map<File, Installation> mInstallationsByPath = new HashMap<File, Installation>();
        private Map<Integer, Installation> mDefaultMap = new HashMap<Integer, Installation>();
        private Map<String, Record> mInactiveDefaultMap = new HashMap<String, Record>();
        private File mDataFile = null;

        public InstallationProperties(File f) {
            this.mDataFile = f;
        }

        private boolean isDefault(Installation inst) {
            boolean retVal = false;
            if (inst != null) {
                retVal = this.mDefaultMap.containsValue(inst);
            }
            return retVal;
        }

        private boolean getDefaultState(Installation inst) {
            boolean retVal = false;
            if (inst != null) {
                String key = inst.getKey();
                Record r = this.mInactiveDefaultMap.get(key);
                retVal = this.mDefaultMap.containsValue(inst) || r != null && r.isDefault();
            }
            return retVal;
        }

        public boolean cleanup() {
            boolean changed = false;
            ArrayList<Installation> toRemove = new ArrayList<Installation>();
            for (Installation inst : this.mInstallationsByKey.values()) {
                File productDir = inst.getProductDir();
                File manifestFile = inst.getManifestFile();
                if (productDir.exists() && productDir.isDirectory() && manifestFile.exists()) continue;
                toRemove.add(inst);
            }
            for (Installation inst : toRemove) {
                boolean wasDefault = this.isDefault(inst);
                Installation old = this.remove(inst);
                if (old == null) continue;
                changed = true;
                if (!wasDefault) continue;
                Record r = new Record(inst.getVersion(), wasDefault, inst.getOSName(), inst.getUnusedData(), null);
                this.mInactiveDefaultMap.put(r.getKey(), r);
            }
            return changed;
        }

        public List<Installation> getInstallations() {
            return new ArrayList<Installation>(this.mInstallationsByKey.values());
        }

        public boolean writeData() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss zzz", Locale.getDefault());
            String generationTime = simpleDateFormat.format(new Date());
            File parent = this.mDataFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            boolean canWrite = IOUtils.isWritable(this.mDataFile);
            boolean fileWritten = false;
            if (canWrite) {
                PrintWriter writer;
                FileLock lock;
                block10: {
                    lock = null;
                    writer = null;
                    try {
                        FileOutputStream fo = new FileOutputStream(this.mDataFile);
                        writer = new PrintWriter(new OutputStreamWriter((OutputStream)fo, "UTF-8"));
                        lock = fo.getChannel().lock();
                    }
                    catch (IOException e) {
                        if (writer != null) {
                            writer.close();
                            writer = null;
                        }
                        if (!T.race("MICRO")) break block10;
                        T.race("MICRO", "InstallationInfo.writeData(): Can't get FileOutputStream.\n" + T.formatStackTrace("MICRO", e));
                    }
                }
                if (writer != null && lock != null) {
                    writer.println("# SAPGUI for Java installation database");
                    writer.println("# Please don't change this file by hand.");
                    writer.println("# Content encoding: UTF-8");
                    writer.println("# Format          : Version:Default:OS:Path:Application Path");
                    writer.println("# Last written    : " + generationTime);
                    for (Installation inst : this.mInstallationsByKey.values()) {
                        boolean d = this.mDefaultMap.containsValue(inst);
                        writer.println(inst.formatLine(d));
                    }
                    ArrayList<Record> cr = new ArrayList<Record>(this.mInactiveDefaultMap.values());
                    cr.addAll(this.mUnusedRecords);
                    for (Record r : cr) {
                        writer.println(r.formatLine());
                    }
                    writer.flush();
                    try {
                        lock.release();
                    }
                    catch (IOException e) {
                        T.raceError("InstallationInfo.writeData(): Can't write data", e);
                    }
                    writer.close();
                    fileWritten = true;
                }
            }
            return !fileWritten;
        }

        public boolean readData() {
            boolean dataChanged = false;
            if (IOUtils.fileExists(this.mDataFile)) {
                BufferedReader reader = null;
                try {
                    FileInputStream fi = new FileInputStream(this.mDataFile);
                    reader = new BufferedReader(new InputStreamReader((InputStream)fi, "UTF-8"));
                }
                catch (FileNotFoundException e) {
                }
                catch (UnsupportedEncodingException e1) {
                    // empty catch block
                }
                if (reader != null) {
                    String line = "";
                    try {
                        while ((line = reader.readLine()) != null) {
                            Record r;
                            if ("".equals(line = line.trim()) || line.startsWith("#") || (r = Record.createRecord(line)) == null) continue;
                            if (SystemInfo.getOperatingSystemName().equals(r.getOSName())) {
                                if (r.isDefined()) {
                                    Installation inst = Installation.valueOf(r);
                                    dataChanged |= this.putInstallation(inst, r.isDefault());
                                    continue;
                                }
                                this.mInactiveDefaultMap.put(r.getKey(), r);
                                continue;
                            }
                            this.mUnusedRecords.add(r);
                        }
                        reader.close();
                        Iterator<Record> iter = this.mInactiveDefaultMap.values().iterator();
                        while (iter.hasNext()) {
                            Record i = iter.next();
                            if (!this.mDefaultMap.containsKey(i.getVersion().getProductType())) continue;
                            iter.remove();
                            dataChanged = true;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return dataChanged;
        }

        public boolean putInstallation(Installation inst, boolean isDefault) {
            boolean dataChanged = false;
            if (inst != null) {
                String key = inst.getKey();
                Record r = this.mInactiveDefaultMap.get(key);
                if (r != null) {
                    inst.setUnusedData(r.getUnusedData());
                }
                dataChanged |= this.putInstallation(inst);
                if (isDefault || r != null && r.isDefault()) {
                    dataChanged |= this.setDefault(inst);
                }
            }
            return dataChanged;
        }

        private boolean putInstallation(Installation inst) {
            boolean dataChanged = false;
            String key = inst.getKey();
            File value = inst.getInstallationValue();
            Installation i = this.mInstallationsByKey.get(key);
            if (i == null || !i.getInstallationValue().equals(inst.getInstallationValue())) {
                this.mInstallationsByKey.put(key, inst);
                this.mInstallationsByPath.put(value, inst);
                dataChanged = true;
            }
            return dataChanged;
        }

        public boolean containsKey(String key) {
            return this.mInstallationsByKey.containsKey(key);
        }

        public boolean containsKey(File key) {
            return this.mInstallationsByPath.containsKey(key);
        }

        public Installation get(String key) {
            return this.mInstallationsByKey.get(key);
        }

        public File getDataFile() {
            return this.mDataFile;
        }

        public Installation get(File key) {
            Installation retVal = this.mInstallationsByPath.get(key);
            if (retVal != null) {
                retVal.setInstallationType(Installation.Type.INSTALLED);
            }
            return retVal;
        }

        public Installation getDefault(int t) {
            Installation retVal = this.mDefaultMap.get(t);
            if (retVal != null) {
                retVal.setInstallationType(Installation.Type.INSTALLED);
            }
            return retVal;
        }

        public Installation remove(Installation inst) {
            Installation old = this.mInstallationsByKey.remove(inst.getKey());
            this.mInstallationsByPath.remove(inst.getInstallationValue());
            this.mInactiveDefaultMap.remove(inst.getKey());
            if (old != null && this.mDefaultMap.containsValue(old)) {
                this.mDefaultMap.remove(old.getProductType());
            }
            return old;
        }

        public boolean removeDefault(int type) {
            Installation old = this.mDefaultMap.remove(type);
            return old != null;
        }

        public boolean setDefault(Installation inst) {
            boolean dataChanged = false;
            String key = inst.getKey();
            Integer t = inst.getProductType();
            if (!this.containsKey(key)) {
                this.putInstallation(inst);
                dataChanged = true;
            }
            this.mInactiveDefaultMap.remove(key);
            if (!this.mDefaultMap.containsValue(inst)) {
                this.mDefaultMap.put(t, inst);
                dataChanged = true;
            }
            return dataChanged;
        }
    }

    public static class Record {
        private static String PATHMARKER = ":Path:";
        Version mVersion = null;
        String mOSName = null;
        boolean mDefault = false;
        File mResourceDir = null;
        String[] mUnusedData = null;
        boolean mDefined = false;

        public Record(Installation inst, boolean def) {
            this(inst.getVersion(), def, inst.getOSName(), inst.getUnusedData(), inst.getInstallationValue());
        }

        private Record(Version version, boolean def, String osName, String[] unused, File resourceDir) {
            this.mVersion = version;
            this.mDefault = def;
            this.mOSName = osName;
            this.mUnusedData = unused;
            this.mResourceDir = resourceDir;
            this.mDefined = resourceDir != null;
        }

        public static Record createRecord(String line) {
            Record retVal = null;
            if (line.contains(PATHMARKER)) {
                Version v;
                String[] records = line.trim().split(PATHMARKER);
                File value = "<REMOVED>".equals(records[1]) ? null : new File(records[1]);
                String[] token = records[0].split(":");
                if (token.length >= 3 && (v = Version.valueOf(token[0])) != null) {
                    boolean def = "default".equals(token[1]);
                    String os = token[2];
                    String[] unused = null;
                    if (token.length > 3) {
                        int num = token.length - 3;
                        unused = new String[num];
                        System.arraycopy(token, 3, unused, 0, num);
                    }
                    retVal = new Record(v, def, os, unused, value);
                }
            }
            return retVal;
        }

        public static String getKey(Version v) {
            return v.getFullNumericVersionString() + ":" + SystemInfo.getOperatingSystemName();
        }

        public String getKey() {
            return this.mVersion.getFullNumericVersionString() + ":" + this.getOSName();
        }

        public String formatLine() {
            StringBuffer retVal = new StringBuffer();
            retVal.append(this.mVersion.getFullNumericVersionString());
            retVal.append(":").append(this.mDefault ? "default" : "");
            retVal.append(":").append(this.mOSName);
            if (this.mUnusedData != null) {
                for (String s : this.mUnusedData) {
                    retVal.append(":").append(s);
                }
            }
            retVal.append(PATHMARKER);
            retVal.append(this.isDefined() ? this.mResourceDir : "<REMOVED>");
            return retVal.toString();
        }

        public Version getVersion() {
            return this.mVersion;
        }

        public boolean isDefault() {
            return this.mDefault;
        }

        public boolean isDefined() {
            return this.mDefined;
        }

        public File getResourceDir() {
            return this.mResourceDir;
        }

        public String getOSName() {
            return this.mOSName;
        }

        public String[] getUnusedData() {
            return this.mUnusedData;
        }
    }
}

