/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;

public class MicroAppletClassLoader
extends URLClassLoader {
    private Object[] mTrustedCertificateList = this.getClass().getSigners();

    public MicroAppletClassLoader(URL[] urls) {
        super(urls);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection permissioncollection = super.getPermissions(codesource);
        if (System.getProperty("SkipCertificateCheck") != null || this.checkCertificateList(codesource.getCertificates())) {
            permissioncollection.add(new AllPermission());
        }
        return permissioncollection;
    }

    private boolean checkCertificateList(Object[] certificateList) {
        if (certificateList == null || this.mTrustedCertificateList == null) {
            return this.mTrustedCertificateList == null;
        }
        if (certificateList.length < this.mTrustedCertificateList.length) {
            return false;
        }
        for (int i = 0; i < this.mTrustedCertificateList.length; ++i) {
            int j;
            boolean found = false;
            for (j = i; j < certificateList.length; ++j) {
                if (!this.mTrustedCertificateList[i].equals(certificateList[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            for (j = 0; j < i; ++j) {
                if (!this.mTrustedCertificateList[i].equals(certificateList[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

