/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.micro.Installation;
import com.sap.platin.micro.InstallationInfo;
import com.sap.platin.micro.PathInfo;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.installer.LogWriter;
import com.sap.platin.micro.installer.MessageHandler;
import com.sap.platin.micro.installer.MsgSubType;
import com.sap.platin.micro.installer.MsgType;
import com.sap.platin.micro.installer.ProgressHandler;
import com.sap.platin.micro.util.IOUtils;
import com.sap.platin.trace.T;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class MicroTransaction {
    public static final String __PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/micro/MicroTransaction.java#6 $";
    private static MicroTransaction mTransaction = null;
    private MessageHandler mMessageHandler = null;
    private ProgressHandler mProgressHandler = null;
    private Hashtable<String, Vector<String>> mPermissions = new Hashtable();
    private HashMap<String, File> mTransformations = null;

    private MicroTransaction() {
    }

    public static synchronized MicroTransaction openTransaction(Installation inst, MessageHandler messageHandler, ProgressHandler progresshandler) {
        if (mTransaction != null) {
            return null;
        }
        mTransaction = new MicroTransaction();
        if (mTransaction.setupTransaction(inst)) {
            mTransaction = null;
        }
        if (mTransaction != null) {
            MicroTransaction.mTransaction.mMessageHandler = messageHandler;
            MicroTransaction.mTransaction.mProgressHandler = progresshandler;
        }
        return mTransaction;
    }

    public boolean loadResource(Installation inst, URI resourceURI, InputStream resourceConnection, String resourceName, boolean isNative, boolean isOptional) {
        boolean failed = false;
        File target = new File(PathInfo.get(inst).locatePath(10023), resourceName);
        if (target.exists()) {
            LogWriter.writeLog(MsgType.warning, "MicroTransaction.loadResource(): resource " + target.getAbsolutePath() + " already exists. Try to remove");
            if (failed |= !target.delete()) {
                LogWriter.writeLog(MsgType.error, "MicroTransaction.loadResource(): could not remove existing file " + target.getAbsolutePath());
            }
        }
        if (!failed) {
            File rFile = new File(PathInfo.get(inst).locatePath(10008), resourceName);
            try {
                File parentDir = target.getParentFile();
                if (!parentDir.exists()) {
                    failed |= !parentDir.mkdirs();
                }
                failed |= IOUtils.transferData(resourceConnection, target);
            }
            catch (IOException e) {
                failed = true;
                LogWriter.writeLog(MsgType.error, "MicroTransaction.loadResource(): could not copy data:\n   \"" + resourceURI + "\" -> \"" + target + "\"\n" + T.formatStackTrace("", e));
            }
            if (!failed) {
                try {
                    if (isNative) {
                        failed |= this.unpackResource(inst, resourceName);
                    }
                    inst.addEntry(rFile);
                }
                catch (IOException e) {
                    failed = true;
                    LogWriter.writeLog(MsgType.error, "MicroTransaction.loadResource(): could not unpack data from \"" + resourceName + "\"");
                }
            }
        }
        return failed;
    }

    public boolean abortTransaction(Installation installation) {
        boolean failed = false;
        StringBuilder msg = new StringBuilder();
        File updateFolder = PathInfo.get(installation).locatePath(10016);
        if (failed |= IOUtils.deleteDirectoryHierarchy(msg, updateFolder)) {
            LogWriter.writeLog(MsgType.error, "MicroTransaction.deleteFolders(): can't delete " + updateFolder + " folder hierarchy.");
            LogWriter.writeLog(MsgType.error, msg.toString());
        }
        mTransaction = null;
        return failed;
    }

    public boolean closeTransaction(Installation inst) {
        boolean failed = false;
        File productDir = PathInfo.get(inst).locatePath(10004);
        File applicationDir = PathInfo.get(inst).locatePath(10009);
        File downloadDir = PathInfo.get(inst).locatePath(10018);
        File updateFolder = PathInfo.get(inst).locatePath(10016);
        StringBuilder msg = new StringBuilder();
        if (failed |= this.moveFiles(inst, downloadDir, productDir)) {
            this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Can't move installation files from: \"" + downloadDir + "\" to \"" + productDir + "\"", true);
        }
        if (!failed) {
            if (failed |= IOUtils.deleteDirectoryHierarchy(msg, updateFolder)) {
                LogWriter.writeLog(MsgType.error, "MicroTransaction.deleteFolders(): can't delete " + updateFolder + " folder hierarchy.");
                LogWriter.writeLog(MsgType.error, msg.toString());
                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Delete of " + inst.getVersion().getLongName() + " installation files failed.", true);
                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Please delete \"" + applicationDir + "GuiUpdate directory manually after this installation program has finished.");
            }
            if (!this.mPermissions.isEmpty()) {
                failed |= this.setPermissions(inst);
            }
            if (!failed) {
                inst.setInstallationType(Installation.Type.INSTALLED);
                InstallationInfo.registerInstallation(inst, true);
            }
        }
        mTransaction = null;
        return failed;
    }

    private boolean setupTransaction(Installation inst) {
        boolean failed = false;
        File productDir = PathInfo.get(inst).locatePath(10004);
        if (!productDir.exists()) {
            failed |= !productDir.mkdirs();
        }
        if (failed) {
            LogWriter.writeLog(MsgType.error, "MicroTransaction.setupTransaction() : Could not create directory \"" + productDir + "\"");
        }
        if (!failed) {
            failed |= this.createFolders(inst);
        }
        if (!failed && SystemInfo.getOSClass() == 3) {
            File proddir = PathInfo.get(inst).locatePath(10004);
            File dlappdir = PathInfo.get(inst).locatePath(10019);
            File dlresources = PathInfo.get(inst).locatePath(10020);
            File dljardir = PathInfo.get(inst).locatePath(10023);
            File securityFolder = new File(PathInfo.get(inst).locatePath(10020), "security");
            this.addTransformation(new File(dlappdir, "Contents/Resources/Contents"), new File(dlappdir, "Contents"));
            this.addTransformation(new File(dlresources, "security"), securityFolder);
            this.addTransformation(new File(dlresources, "jar"), dljardir);
            this.addTransformation("*.template", proddir);
        }
        return failed;
    }

    private boolean createFolders(Installation inst) {
        boolean failed = false;
        File[] directories = new File[]{PathInfo.get(inst).locatePath(10016), PathInfo.get(inst).locatePath(10017), PathInfo.get(inst).locatePath(10018)};
        StringBuilder msg = new StringBuilder();
        for (int a = 0; a < directories.length; ++a) {
            File dir = directories[a];
            if (!dir.exists()) continue;
            LogWriter.writeLog(MsgType.warning, "MicroTransaction.createFolders(): folder " + dir + " already exists, try to remove it.");
            if (failed |= IOUtils.deleteDirectoryHierarchy(msg, dir)) {
                LogWriter.writeLog(MsgType.error, "MicroTransaction.createFolders(): can't delete directory " + dir);
                LogWriter.writeLog(MsgType.error, msg.toString());
                LogWriter.writeLog(MsgType.error, "MicroTransaction.createFolders() : Could not delete directory \"" + dir + "\"");
                break;
            }
            if (!(failed |= !dir.mkdirs())) continue;
            LogWriter.writeLog(MsgType.error, "MicroTransaction.createFolders() : Could not create directory \"" + dir + "\"");
        }
        return failed;
    }

    private boolean moveFiles(Installation inst, File sourcePath, File destinationPath) {
        boolean f = false;
        boolean failed = !sourcePath.exists();
        StringBuffer moveLog = new StringBuffer("MicroTransaction.moveFiles(" + inst + ", " + sourcePath + ", " + destinationPath + "\n");
        if (failed) {
            moveLog.append("   Source path does not exist ").append(sourcePath).append("\n");
            return failed;
        }
        String[] fileList = sourcePath.list();
        for (int i = 0; i < fileList.length; ++i) {
            String currentFile = fileList[i];
            File moveFile = new File(sourcePath, currentFile);
            File moveFileTo = new File(destinationPath, currentFile);
            File parentFile = new File(moveFileTo.getParent());
            if (!parentFile.exists()) {
                f = !parentFile.mkdirs();
                failed |= f;
                if (f) {
                    moveLog.append("   Error creating destination directory ").append(parentFile).append("\n");
                }
            }
            if (moveFileTo.exists()) {
                if (moveFileTo.isDirectory()) {
                    f = this.moveFiles(inst, moveFile, moveFileTo);
                    failed |= f;
                    continue;
                }
                f = !moveFileTo.delete();
                failed |= f;
                moveLog.append(f ? "    ERROR: " : "   OK   : ").append("Existing targetfile ").append(moveFileTo).append(f ? "not deleted\n" : "deleted\n");
                f = !moveFile.renameTo(moveFileTo);
                failed |= f;
                moveLog.append(f ? "   ERROR: " : "   OK   : ").append(moveFile).append(" => ").append(moveFileTo).append("\n");
                continue;
            }
            f = !moveFile.renameTo(moveFileTo);
            failed |= f;
            moveLog.append(f ? "   ERROR: " : "   OK   : ").append(moveFile).append(" => ").append(moveFileTo).append("\n");
        }
        moveLog.append("Exit MicroTransaction.moveFiles() for: ").append(sourcePath).append("\n");
        if (failed) {
            LogWriter.writeLog(MsgType.error, moveLog.toString());
        }
        return failed;
    }

    private File transformDestination(File destinationPath, String currentFile) {
        File retVal = new File(destinationPath, currentFile);
        String filename = retVal.getAbsolutePath();
        if (this.mTransformations != null && !this.mTransformations.isEmpty()) {
            for (String srcString : this.mTransformations.keySet()) {
                File dst = this.mTransformations.get(srcString);
                if (srcString.startsWith("*") && currentFile.endsWith(srcString.substring(1))) {
                    retVal = new File(dst, currentFile);
                    if (!T.race("MICRO")) continue;
                    T.race("MICRO", "MicroTransaction.transformDestination(): transformation rule src: " + srcString + " -> " + dst);
                    T.race("MICRO", "                                         " + filename + " -> " + retVal);
                    continue;
                }
                if (!filename.startsWith(srcString)) continue;
                retVal = new File(dst, filename.substring(srcString.length() + 1));
                if (!T.race("MICRO")) continue;
                T.race("MICRO", "MicroTransaction.transformDestination(): transformation rule src: " + srcString + " -> " + dst);
                T.race("MICRO", "                                         " + filename + " -> " + retVal);
            }
        }
        return retVal;
    }

    private void addTransformation(File src, File dest) {
        this.addTransformation(src.getAbsolutePath(), dest);
    }

    private void addTransformation(String src, File dest) {
        if (this.mTransformations == null) {
            this.mTransformations = new HashMap();
        }
        this.mTransformations.put(src, dest);
    }

    private boolean unpackResource(Installation inst, String resourceName) throws IOException {
        boolean failed = false;
        File resourceFile = null;
        String permissions = PathInfo.get(inst).getPart(30007);
        File fileToUnpack = new File(PathInfo.get(inst).locatePath(10023), resourceName);
        this.mProgressHandler.setText("Unpacking native resource " + resourceName);
        LogWriter.writeLog(MsgType.info, "   Unpack native resource: " + fileToUnpack);
        ZipFile zipFile = new ZipFile(fileToUnpack);
        File dlResourceDir = PathInfo.get(inst).locatePath(10020);
        File downloadDir = PathInfo.get(inst).locatePath(10018);
        File productDir = PathInfo.get(inst).locatePath(10004);
        String dlDirPrefix = downloadDir.getAbsolutePath();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            File targetFile;
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory() || entry.getName().toUpperCase().startsWith("META-INF")) continue;
            resourceFile = this.transformDestination(dlResourceDir, entry.getName());
            File parentDir = resourceFile.getParentFile();
            if (!parentDir.exists()) {
                failed |= !parentDir.mkdirs();
            }
            if (entry.getName().endsWith(permissions)) {
                failed |= this.parsePermissions(zipFile.getInputStream(entry));
                continue;
            }
            InputStream istream = zipFile.getInputStream(entry);
            long size = (int)entry.getSize();
            failed |= IOUtils.transferData(istream, size, resourceFile);
            String resourceFileAbsolute = resourceFile.getAbsolutePath();
            if (resourceFileAbsolute.startsWith(dlDirPrefix)) {
                String resourceFileName = resourceFileAbsolute.substring(dlDirPrefix.length() + 1);
                targetFile = new File(productDir, resourceFileName);
            } else {
                targetFile = resourceFile;
            }
            inst.addEntry(targetFile);
        }
        File fileToDelete = new File(PathInfo.get(inst).locatePath(10023), resourceName);
        ZipEntry manifestEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
        byte[] manifestBytes = this.readZipEntry(zipFile, manifestEntry);
        zipFile.close();
        this.createZipFileWithManifest(fileToDelete, manifestEntry, manifestBytes);
        return failed;
    }

    private void createZipFileWithManifest(File fileToDelete, ZipEntry manifestEntry, byte[] manifestBytes) throws FileNotFoundException, IOException {
        boolean isDeleted = fileToDelete.delete();
        if (isDeleted) {
            ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(fileToDelete));
            zipStream.putNextEntry(manifestEntry);
            zipStream.write(manifestBytes, 0, manifestBytes.length);
            zipStream.close();
        } else {
            LogWriter.writeLog(MsgType.error, "MicroTransaction.unpackResource(): can't delete native resource jar " + fileToDelete + ".");
        }
    }

    private byte[] readZipEntry(ZipFile zipFile, ZipEntry entry) throws IOException {
        int counter;
        byte[] buf = null;
        InputStream is = zipFile.getInputStream(entry);
        int bufSize = (int)entry.getSize();
        buf = new byte[bufSize];
        int bytesRead = 0;
        for (counter = 0; counter != bufSize && bytesRead != -1; counter += bytesRead) {
            bytesRead = is.read(buf, counter, bufSize - counter);
        }
        is.close();
        if (counter != bufSize) {
            LogWriter.writeLog(MsgType.error, "MicroLoader.readZipEntry(): zip error at " + entry.getName());
        }
        return buf;
    }

    private boolean parsePermissions(InputStream input) {
        boolean failed = false;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String line = "";
        String key = null;
        Vector<String> values = null;
        try {
            while (line != null) {
                line = reader.readLine();
                if (line == null || line.startsWith("#")) continue;
                if (line.startsWith("permissions=")) {
                    if (key != null) {
                        this.mPermissions.put(key, values);
                    }
                    key = line.substring(12, line.length());
                    values = this.mPermissions.get(key);
                    continue;
                }
                if (values == null) {
                    values = new Vector<String>();
                }
                values.addElement(line);
            }
            this.mPermissions.put(key, values);
            reader.close();
        }
        catch (IOException e) {
            failed = true;
            LogWriter.writeLog(MsgType.error, "MicroTransaction.parsePermissions(): can't parse permissions file. " + e.getMessage() + "\n" + T.formatStackTrace("", e));
        }
        return failed;
    }

    private boolean setPermissions(Installation inst) {
        boolean failed = false;
        Enumeration<String> e = this.mPermissions.keys();
        while (e.hasMoreElements()) {
            String permissions = e.nextElement();
            Vector<String> values = this.mPermissions.get(permissions);
            if (values == null) continue;
            Enumeration<String> en = values.elements();
            while (en.hasMoreElements()) {
                failed |= this.setPermissions(inst, permissions, en.nextElement());
            }
        }
        return failed;
    }

    private boolean setPermissions(Installation inst, String permissions, String resource) {
        boolean failed = false;
        File filePath = new File(PathInfo.get(inst).locatePath(10009), resource);
        if (filePath.exists()) {
            String[] command = new String[]{"chmod", permissions, filePath.getAbsolutePath()};
            Process shell = null;
            int rc = -1;
            try {
                failed = true;
                shell = Runtime.getRuntime().exec(command);
                rc = shell.waitFor();
                failed = rc != 0;
            }
            catch (IOException e) {
                LogWriter.writeLog(MsgType.error, "MicroTransaction.setPermissions() for resource " + filePath + ", can't find shell command: " + e);
                failed = true;
            }
            catch (InterruptedException e) {
                LogWriter.writeLog(MsgType.error, "MicroTransaction.setPermissions() for resource " + filePath + ", external command has been stopped: " + e);
                failed = true;
            }
            if (failed) {
                LogWriter.writeLog(MsgType.error, "MicroTransaction.setPermissions() for resource " + filePath + " failed with error: " + rc);
            }
        }
        return failed;
    }
}

