/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.micro.Installation;
import java.io.File;
import java.net.URI;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.HashSet;

public class MicroURLClassLoader
extends URLClassLoader {
    public static final String __PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/micro/MicroURLClassLoader.java#16 $";
    private Object[] mTrustedCertificateList = this.getClass().getSigners();
    private CodeSource mGuiStartCodeSource = this.getClass().getProtectionDomain().getCodeSource();

    public MicroURLClassLoader(Installation inst, ClassLoader parent) {
        super(inst.getClasspath(), parent);
        File jar;
        if (this.mGuiStartCodeSource != null && "file".equals(this.mGuiStartCodeSource.getLocation().getProtocol().toLowerCase()) && (jar = new File(this.mGuiStartCodeSource.getLocation().getFile())).isDirectory()) {
            this.mGuiStartCodeSource = null;
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        String name = null;
        HashSet<String> priviledgedJars = new HashSet<String>(Arrays.asList("platinsecS.jar", "platincoreS.jar"));
        PermissionCollection permissioncollection = super.getPermissions(codesource);
        if ("file".equalsIgnoreCase(codesource.getLocation().getProtocol())) {
            File f = new File(URI.create(codesource.getLocation().toExternalForm()));
            name = f.getName();
        }
        if ((codesource.equals(this.mGuiStartCodeSource) || priviledgedJars.contains(name)) && (System.getProperty("SkipCertificateCheck") != null || this.checkCertificateList(codesource.getCertificates()))) {
            permissioncollection.add(new AllPermission());
        }
        return permissioncollection;
    }

    private boolean checkCertificateList(Object[] certificateList) {
        if (certificateList == null || this.mTrustedCertificateList == null) {
            return this.mTrustedCertificateList == null;
        }
        if (certificateList.length < this.mTrustedCertificateList.length) {
            return false;
        }
        for (int i = 0; i < this.mTrustedCertificateList.length; ++i) {
            int j;
            boolean found = false;
            for (j = i; j < certificateList.length; ++j) {
                if (!this.mTrustedCertificateList[i].equals(certificateList[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            for (j = 0; j < i; ++j) {
                if (!this.mTrustedCertificateList[i].equals(certificateList[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

