/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.micro.DResult;
import com.sap.platin.micro.Dynamic;
import com.sap.platin.micro.Installation;
import com.sap.platin.micro.InstallationInfo;
import com.sap.platin.micro.Version;
import com.sap.platin.micro.installer.InstallationOptions;
import com.sap.platin.trace.T;
import com.sap.platin.trace.TraceHookI;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class MicroUtils
implements TraceHookI {
    public static final String __PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/micro/MicroUtils.java#10 $";
    public static final int kNote = 0;
    public static final int kWarning = 1;
    public static final int kError = 2;
    private static SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat("dd.MM. HH:mm:ss.SSS", Locale.getDefault());
    private static String mBuildDate = null;
    private static String mBuildDetails = null;
    public static final MicroUtils mInstance = new MicroUtils();

    public static String getEmbeddedVersion(Installation inst) {
        Version vers = inst.getVersion();
        boolean isDefault = false;
        Installation defInst = InstallationInfo.getDefaultInstallation(vers.getProductType());
        if (defInst != null) {
            Version defVer = defInst.getVersion();
            isDefault = vers.equals(defVer);
        }
        return vers.dumpVersion() + ":" + inst.getApplicationDir() + ":" + Boolean.valueOf(isDefault).toString();
    }

    public static String join(List<String> lines, String indent, String delimiter) {
        StringBuffer retVal = new StringBuffer();
        Iterator<String> l = lines.iterator();
        while (l.hasNext()) {
            String line = l.next();
            retVal.append(indent).append(line);
            if (!l.hasNext() || line.endsWith(delimiter)) continue;
            retVal.append(delimiter);
        }
        return retVal.toString();
    }

    public static void showMessage(String title, String text, int mode) {
        boolean disableUI = false;
        String prefix = null;
        String postfix = null;
        String textprefix = null;
        int type = 0;
        switch (mode) {
            case 2: {
                if (disableUI) {
                    prefix = mSimpleDateFormat.format(new Date()) + "  " + "============================================================" + T.LINESEP;
                    prefix = prefix + mSimpleDateFormat.format(new Date()) + "  " + "ERROR: ";
                    postfix = mSimpleDateFormat.format(new Date()) + "  " + "============================================================";
                    textprefix = mSimpleDateFormat.format(new Date()) + "  " + "       ";
                    break;
                }
                type = 0;
                break;
            }
            case 1: {
                if (disableUI) {
                    prefix = mSimpleDateFormat.format(new Date()) + "  " + "==============================================================" + T.LINESEP;
                    prefix = prefix + mSimpleDateFormat.format(new Date()) + "  " + "WARNING: ";
                    postfix = mSimpleDateFormat.format(new Date()) + "  " + "==============================================================";
                    textprefix = mSimpleDateFormat.format(new Date()) + "  " + "         ";
                    break;
                }
                type = 2;
                break;
            }
            default: {
                if (disableUI) {
                    prefix = mSimpleDateFormat.format(new Date()) + "  " + "================================================================" + T.LINESEP;
                    prefix = prefix + mSimpleDateFormat.format(new Date()) + "  " + "INFO: ";
                    postfix = mSimpleDateFormat.format(new Date()) + "  " + "================================================================";
                    textprefix = mSimpleDateFormat.format(new Date()) + "  " + "      ";
                    break;
                }
                type = -1;
            }
        }
        if (disableUI) {
            if (InstallationOptions.verbose.booleanValue()) {
                System.out.print(prefix);
                StringTokenizer st = new StringTokenizer(text, "\n");
                System.out.println(st.nextToken());
                while (st.hasMoreTokens()) {
                    System.out.println(textprefix + st.nextToken());
                }
                System.out.println(postfix);
            }
        } else {
            JTextArea area = new JTextArea(text);
            area.setOpaque(false);
            area.setEditable(false);
            JOptionPane jop = new JOptionPane(area, type);
            JDialog jd = jop.createDialog(null, title);
            jd.setLocationRelativeTo(null);
            jd.setVisible(true);
            jd.dispose();
        }
    }

    public static String getBuildDetails() {
        if (mBuildDetails == null) {
            mBuildDetails = "Unofficial Development Build";
            DResult result = new DResult();
            Class<?> bc = Dynamic.createClass(result, "com.sap.platin.BuildID", MicroUtils.class.getClassLoader());
            if (!result.isFailure()) {
                String host = (String)Dynamic.getProperty(bc, "HOST");
                String change = (String)Dynamic.getProperty(bc, "CHANGE");
                String sid = (String)Dynamic.getProperty(bc, "SID");
                if (sid == null || sid.trim().length() == 0) {
                    sid = "no version";
                }
                mBuildDetails = host + ", " + sid + ", " + change;
            }
        }
        return mBuildDetails;
    }

    public static String getBuildDate() {
        if (mBuildDate == null) {
            mBuildDate = "No date available";
            DResult result = new DResult();
            Class<?> bc = Dynamic.createClass(result, "com.sap.platin.BuildID", MicroUtils.class.getClassLoader());
            if (!result.isFailure()) {
                mBuildDate = (String)Dynamic.getProperty(bc, "DATE");
            }
        }
        return mBuildDate;
    }

    public static String getInstallationSystemInfo() {
        StringBuffer sb = new StringBuffer();
        String line = "-----------------------------------------------------------\n";
        sb.append(mInstance.getSystemInfo()).append("\n");
        sb.append(line);
        sb.append("Java system properties").append("\n");
        sb.append(line);
        Properties p = System.getProperties();
        sb.append("System properties [").append(p.getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(p))).append("]: ").append("\n");
        TreeSet<String> props = new TreeSet<String>();
        Enumeration<?> en = p.propertyNames();
        while (en.hasMoreElements()) {
            String k = en.nextElement().toString();
            Object o = p.get(k);
            if (o == null) {
                o = p.getProperty(k);
            }
            String v = o != null ? o.toString() : "<null>";
            props.add(k + ": " + v + "\n");
        }
        Iterator a = props.iterator();
        while (a.hasNext()) {
            sb.append(a.next()).append("\n");
        }
        Map<String, String> env = System.getenv();
        if (env.size() > 0) {
            sb.append(line);
            sb.append("Environment Variables").append("\n");
            sb.append(line);
            for (Map.Entry<String, String> entry : env.entrySet()) {
                sb.append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String getAdvancedSystemInfo() {
        return this.getSystemInfo();
    }

    @Override
    public String getSystemInfo() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String javaVersion;
                StringBuffer sb = new StringBuffer();
                String line = "-----------------------------------------------------------\n";
                Version version = Version.CURRENT;
                String versionString = javaVersion = version.getFullProductName();
                String libversion = Version.getLibVersion();
                if (libversion != null && !javaVersion.equals(libversion)) {
                    versionString = versionString + " (java), " + libversion + " (lib)" + "\n";
                }
                String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
                sb.append("-----------------------------------------------------------\n");
                sb.append("Date: ").append(mSimpleDateFormat.format(new Date())).append("\n");
                sb.append("-----------------------------------------------------------\n");
                sb.append("System Details").append("\n");
                sb.append("-----------------------------------------------------------\n");
                sb.append("Java VM: ").append(System.getProperty("java.vendor")).append(" Version ").append(System.getProperty("java.version")).append("\n");
                sb.append("OS: ").append(System.getProperty("os.name")).append("(").append(System.getProperty("os.arch")).append(") Version ").append(System.getProperty("os.version")).append("\n");
                sb.append("Java Directory: ").append(System.getProperty("java.home")).append("\n");
                sb.append("Home Directory: ").append(System.getProperty("user.home")).append("\n");
                sb.append("Current Directory: ").append(System.getProperty("user.dir")).append("\n");
                sb.append("Locale: ").append(Locale.getDefault().getDisplayName()).append("\n");
                sb.append("Default Character Encoding: ").append(defaultEncoding).append("\n");
                sb.append("-----------------------------------------------------------\n");
                sb.append("Product Details").append("\n");
                sb.append("-----------------------------------------------------------\n");
                sb.append(versionString).append("\n");
                sb.append(MicroUtils.getBuildDate()).append("\n");
                sb.append(MicroUtils.getBuildDetails()).append("\n");
                sb.append("(Version ID ").append(version.getFullNumericVersionString()).append(")").append("\n");
                return sb.toString();
            }
        });
    }
}

