/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.base.splash.SplashWindow;
import com.sap.platin.micro.DResult;
import com.sap.platin.micro.Dynamic;
import com.sap.platin.micro.Installation;
import com.sap.platin.micro.InstallationInfo;
import com.sap.platin.micro.MicroURLClassLoader;
import com.sap.platin.micro.MicroUtils;
import com.sap.platin.micro.PathInfo;
import com.sap.platin.micro.SAPProperties;
import com.sap.platin.micro.SystemAccess;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.Version;
import com.sap.platin.micro.installer.AbstractInstallationFilter;
import com.sap.platin.micro.installer.InstallationController;
import com.sap.platin.micro.installer.InstallationFilter;
import com.sap.platin.micro.installer.InstallationOptions;
import com.sap.platin.micro.installer.Installer;
import com.sap.platin.micro.installer.LogWriter;
import com.sap.platin.micro.installer.MsgType;
import com.sap.platin.trace.T;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Microkernel {
    public static final String __PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/micro/Microkernel.java#31 $";
    private static final String kEventQueueClass = "com.sap.platin.micro.event.GuiEventQueue";
    public static String[] mArguments = null;
    private Boolean mIsolateClassloader = Boolean.FALSE;
    private ClassLoader mMicroURLClassLoader = null;
    private Class<?> mStartClass = null;

    public static boolean startApplication(String[] args) {
        boolean failed = false;
        StringBuffer sb = new StringBuffer();
        if (SystemInfo.getOSClass() == 0) {
            failed = true;
            SplashWindow.disposeSplash();
            MicroUtils.showMessage(Version.CURRENT.getFullProductName() + ": Error", "Your operating system is not supported.", 2);
        } else if (!SystemAccess.isSupported(sb)) {
            SplashWindow.disposeSplash();
            MicroUtils.showMessage(Version.CURRENT.getLongProductName() + ": Error", "The " + Version.CURRENT.getLongProductName() + " can not be run in this environment\n" + sb.toString(), 2);
            failed = true;
        } else if (!SystemAccess.meetsRequirement(2, sb)) {
            failed = true;
            SplashWindow.disposeSplash();
            MicroUtils.showMessage(Version.CURRENT.getLongProductName() + ": Error", "The system reqirements are not met.\n" + sb.toString(), 2);
        }
        sb.setLength(0);
        if (!SystemAccess.meetsRequirement(1, sb)) {
            SplashWindow.disposeSplash();
            String errMsg = sb.toString();
            boolean sloppyRequirements = Boolean.valueOf(System.getProperty("com.sap.platin.ignoreSystemRequirements"));
            if (!sloppyRequirements) {
                MicroUtils.showMessage(Version.CURRENT.getLongProductName() + ": Warning", "The system reqirements are not met.\n" + errMsg, 1);
            } else {
                errMsg = errMsg + "\n \nFurthermore someone has decided not to report this failure,\nbut to just ignore the fact.";
                T.raceError("The system reqirements are not met.\n \n" + errMsg);
            }
        }
        if (!failed) {
            Microkernel microKernel = new Microkernel();
            Installation runningInst = InstallationInfo.getRunningInstallation();
            failed = microKernel.startApplication(runningInst, "com.sap.platin.base.logon.GuiImpl", args);
        }
        return failed;
    }

    public static boolean install(String[] args) {
        InstallationFilter.Result retVal;
        InstallationOptions.deploymentModel = InstallationOptions.DeploymentModel.APPLET;
        boolean failed = false;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> argList = new ArrayList<String>();
        int rc = InstallationOptions.parse(sb, args, argList);
        if (rc >= 0 && (retVal = Microkernel.install()).failed()) {
            failed = true;
        }
        return failed;
    }

    public List<String> getInstallations(int type) {
        List<String> retVal = Collections.emptyList();
        List<Installation> instList = InstallationInfo.getInstallations(type);
        retVal = new ArrayList(instList.size());
        for (Installation inst : instList) {
            Version vers = inst.getVersion();
            boolean isDefault = false;
            Installation defInst = InstallationInfo.getDefaultInstallation(type);
            if (defInst != null) {
                Version defVer = defInst.getVersion();
                isDefault = vers.equals(defVer);
            }
            retVal.add(vers.dumpVersion() + ":" + inst.getApplicationDir() + ":" + Boolean.valueOf(isDefault).toString());
        }
        return retVal;
    }

    public static InstallationFilter.Result install() {
        if (InstallationOptions.gui.booleanValue()) {
            if (EventQueue.isDispatchThread()) {
                Toolkit.getDefaultToolkit();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Toolkit.getDefaultToolkit();
                    }
                });
            }
        }
        InstallationFilter.Result retVal = InstallationFilter.Result.Unknown;
        new Microkernel();
        InstallationInfo.getRunningInstallation().setInstallationType(Installation.Type.CHANGING);
        if (InstallationOptions.gui.booleanValue()) {
            InstallerRunnable ir = new InstallerRunnable();
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(ir);
            } else {
                ir.run();
            }
            retVal = ir.waitForInstaller();
        } else {
            System.setProperty("java.awt.headless", "true");
            InstallationFilter instCtrl = AbstractInstallationFilter.createInstallationFilter(null, null);
            if (InstallationController.isVersionInstalled(Version.CURRENT) && InstallationOptions.force.booleanValue()) {
                retVal = instCtrl.reinstallInstallation();
                if (T.race("MICRO")) {
                    T.race("MICRO", "Microkernel.install(): REINSTALLATION done.");
                }
            } else {
                retVal = instCtrl.addInstallation();
                if (T.race("MICRO")) {
                    T.race("MICRO", "Microkernel.install(): INSTALLATION done.");
                }
            }
        }
        return retVal;
    }

    public static InstallationFilter.Result uninstall() {
        InstallationFilter.Result retVal = InstallationFilter.Result.Unknown;
        new Microkernel();
        System.setProperty("java.awt.headless", "true");
        InstallationFilter instCtrl = AbstractInstallationFilter.createInstallationFilter(null, null);
        retVal = instCtrl.removeInstallation();
        if (T.race("MICRO")) {
            T.race("MICRO", "Microkernel.uninstall(): UNINSTALL done. ");
        }
        return retVal;
    }

    public static InstallationFilter.Result reinstall() {
        InstallationFilter.Result retVal = InstallationFilter.Result.Unknown;
        if (T.race("MICRO")) {
            T.race("MICRO", "Microkernel.reinstall(): enter REINSTALL");
        }
        new Microkernel();
        System.setProperty("java.awt.headless", "true");
        InstallationFilter instCtrl = AbstractInstallationFilter.createInstallationFilter(null, null);
        retVal = instCtrl.reinstallInstallation();
        if (T.race("MICRO")) {
            T.race("MICRO", "Microkernel.reinstall(): REINSTALL done.");
        }
        return retVal;
    }

    private static boolean showVersion() {
        System.out.println("Build date           : " + MicroUtils.getBuildDate());
        System.out.println("Build Info           : " + MicroUtils.getBuildDetails());
        System.out.println("Product type         : " + Version.CURRENT.getProductType());
        System.out.println("Numeric Version      : " + Version.CURRENT.getFullNumericVersionString());
        System.out.println("Short Version Number : " + Version.CURRENT.getShortVersion());
        System.out.println("Long Version Number  : " + Version.CURRENT.getLongVersion());
        System.out.println("Short Version        : " + Version.CURRENT.getCompressedProductName());
        System.out.println("Long Version         : " + Version.CURRENT.getLongProductName());
        System.out.println("Full Version         : " + Version.CURRENT.getFullProductName());
        System.out.println("Official Version     : " + Version.CURRENT.getOfficialProductName());
        return false;
    }

    private boolean startApplication(Installation inst, String startClass, String[] args) {
        boolean failed = false;
        Class<?> cls = null;
        Method mainMethod = null;
        try {
            failed = true;
            cls = this.loadStartClass(inst, startClass);
            mainMethod = cls.getDeclaredMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
            failed = false;
        }
        catch (ClassNotFoundException e) {
            failed = true;
            T.raceError("Microkernel.startApplication(): starting application failed with: " + e, e);
            JOptionPane.showMessageDialog(null, inst.getVersion().getLongProductName() + " can't start. Microkernel can't load start class.\nError:\n" + e, inst.getVersion().getLongProductName(), 0);
        }
        catch (SecurityException e) {
            failed = true;
            T.raceError("Microkernel.startApplication(): Security restrictions prevent this installation from starting: " + e, e);
            JOptionPane.showMessageDialog(null, inst.getVersion().getLongProductName() + " can't start. Microkernel can't find main method for start class\nError:\n" + e, inst.getVersion().getLongProductName(), 0);
        }
        catch (NoSuchMethodException e) {
            failed = true;
            T.raceError("Microkernel.startApplication(): starting application failed with: " + e, e);
            JOptionPane.showMessageDialog(null, inst.getVersion().getLongProductName() + " can't start. Microkernel can't find main method for start class\nError:\n" + e, inst.getVersion().getLongProductName(), 0);
        }
        catch (InvocationTargetException e) {
            failed = true;
            T.raceError("Microkernel.startApplication(): starting application failed with exception somewhere below " + String.valueOf(cls) + "." + String.valueOf(mainMethod) + "(): " + e.getTargetException(), e.getTargetException());
        }
        catch (IllegalArgumentException e) {
            failed = true;
            T.raceError("Microkernel.startApplication(): illegal argument calling " + startClass + ".main()" + e, e);
        }
        catch (IllegalAccessException e) {
            failed = true;
            T.raceError("Microkernel.startApplication(): can't access method " + startClass + ".main()" + e, e);
        }
        return failed;
    }

    public void isolateClassloader(Boolean b) {
        this.mIsolateClassloader = b;
        Version.CURRENT.setStrict(this.mIsolateClassloader);
    }

    public Class<?> loadStartClass(Installation inst, String className) throws ClassNotFoundException {
        return this.loadStartClass(inst, className, null);
    }

    public Class<?> loadStartClass(String version, String className) throws ClassNotFoundException {
        Version v = Version.valueOf(version);
        Installation inst = InstallationInfo.findAppropriateInstallation(v);
        InstallationInfo.setCurrent(inst);
        return this.loadStartClass(inst, className, null);
    }

    public Class<?> loadStartClass(String className) throws ClassNotFoundException {
        Installation inst = InstallationInfo.findAppropriateInstallation(Version.CURRENT);
        if (inst == null) {
            inst = InstallationInfo.getRunningInstallation();
        }
        this.mStartClass = this.loadStartClass(inst, className, null);
        return this.mStartClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadStartClass(Installation inst, String className, ClassLoader parent) throws ClassNotFoundException {
        Class<?> retVal = null;
        if (!this.mIsolateClassloader.booleanValue() && parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        Class<System> clazz = System.class;
        synchronized (System.class) {
            Properties props = System.getProperties();
            if (!"com.sap.platin.micro.SAPProperties".equals(props.getClass().getName())) {
                T.race("JPLATIN", "Microkernel.loadStartClass(): created new properties table. Old table instance : " + props.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(props)));
                props = new SAPProperties(props);
            }
            this.mMicroURLClassLoader = (ClassLoader)props.get("platin.classloader");
            if (T.race("JPLATIN")) {
                ClassLoader cl = System.class.getClass().getClassLoader();
                T.race("JPLATIN", "Microkernel.loadStartClass(): System.class instance     : " + System.class.getName() + "@" + Integer.toHexString(System.identityHashCode(System.class)) + " loaded by " + (cl != null ? cl.toString() : "Bootstrap class loader"));
                T.race("JPLATIN", "Microkernel.loadStartClass(): Properties table instance : " + props.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(props)));
                T.race("JPLATIN", "Microkernel.loadStartClass(): platin.classloader        : " + this.mMicroURLClassLoader);
                T.dumpSystemProperties("JPLATIN");
            }
            if (this.mMicroURLClassLoader == null) {
                this.mMicroURLClassLoader = new MicroURLClassLoader(inst, parent);
                props.put("platin.classloader", this.mMicroURLClassLoader);
                System.setProperties(props);
            }
            Thread.currentThread().setContextClassLoader(this.mMicroURLClassLoader);
            UIManager.put("ClassLoader", this.mMicroURLClassLoader);
            EventQueue sysevq = Toolkit.getDefaultToolkit().getSystemEventQueue();
            Class<?> evqc = Dynamic.createClass(kEventQueueClass, this.mMicroURLClassLoader);
            if (evqc != null && !evqc.isAssignableFrom(sysevq.getClass())) {
                DResult rc = new DResult();
                EventQueue guiEventQueue = (EventQueue)Dynamic.createObject(rc, kEventQueueClass, new Class[0], new Object[0], this.mMicroURLClassLoader);
                if (rc.isSuccess()) {
                    sysevq.push(guiEventQueue);
                } else {
                    T.raceError("Microkernel.loadStartClass() can't push GuiEventQueue: " + rc.get());
                }
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setContextClassLoader(Microkernel.this.mMicroURLClassLoader);
                }
            };
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                try {
                    EventQueue.invokeAndWait(r);
                }
                catch (InterruptedException e) {
                    T.raceError("Microkernel.loadStartClass(): runnable interrupted, while setting AWT context class loader.", e);
                }
                catch (InvocationTargetException e) {
                    T.raceError("Microkernel.loadStartClass(): unable to set AWT context class loader.", e);
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            retVal = Class.forName(className, true, this.mMicroURLClassLoader);
            return retVal;
        }
    }

    public Object invokeConstructor(Class<?>[] paramClasses, Object[] params) throws Throwable {
        Object startObject = null;
        Constructor<?> constructor = this.mStartClass.getConstructor(paramClasses);
        try {
            startObject = constructor.newInstance(params);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return startObject;
    }

    public void setInstallBase(String ib) {
    }

    public void setGuiVersion(String ver) {
    }

    public static boolean callInstallScript(Installation installation, String cmd) {
        boolean retVal = true;
        try {
            File script = PathInfo.get(installation).locatePath(20004);
            if (script.exists()) {
                String[] command = new String[]{script.getAbsolutePath(), cmd, installation.getProductDir().getAbsolutePath(), installation.getVersion().getProductDirName()};
                String cmdLog = command[0] + " " + command[1] + " " + command[2] + " " + command[3];
                LogWriter.writeLog(MsgType.info, "MicroKernel.callInstallScript() execute install script: " + cmdLog);
                Process shell = Runtime.getRuntime().exec(command);
                shell.waitFor();
                if (shell.exitValue() < 0) {
                    LogWriter.writeLog(MsgType.error, "MicroKernel.callInstallScript() execute install script failed:  error = " + shell.exitValue());
                }
            }
            retVal = false;
        }
        catch (Exception e) {
            LogWriter.writeLog(MsgType.error, "MicroKernel.callInstallScript() failed with exception: " + e.getMessage());
        }
        return retVal;
    }

    private static InstallationMode parseCommand() {
        InstallationMode retVal = InstallationMode.UNDEFINED;
        if (mArguments.length > 0 && !mArguments[0].startsWith("-")) {
            String command = mArguments[0];
            InstallationMode[] modes = InstallationMode.values();
            for (int a = InstallationMode.INSTALL.ordinal(); a < modes.length; ++a) {
                if (!command.equals(modes[a].commandValue())) continue;
                retVal = modes[a];
                break;
            }
            if (retVal != InstallationMode.UNDEFINED) {
                String[] newArgs = new String[mArguments.length - 1];
                if (newArgs.length > 0) {
                    System.arraycopy(mArguments, 1, newArgs, 0, newArgs.length);
                }
                mArguments = newArgs;
            }
        }
        return retVal;
    }

    private static InstallationMode parseInputFile(InstallationMode mode, File responseFile) {
        InstallationMode retVal = mode;
        if (responseFile != null && responseFile.exists() && !responseFile.isDirectory()) {
            Properties p = new Properties();
            try {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(responseFile));
                p.load(input);
                input.close();
            }
            catch (FileNotFoundException e) {
                T.raceError("Can't find installation response file: " + responseFile, e);
            }
            catch (IOException e) {
                T.raceError("Can't read data from file: " + responseFile, e);
            }
            Iterator<Object> i = p.keySet().iterator();
            while (i.hasNext()) {
                String key = ((String)i.next()).trim();
                String val = p.getProperty(key).trim();
                if (key.equals("disableui") && !InstallationOptions.gui.isValueSet()) {
                    InstallationOptions.gui.setValue(!Boolean.parseBoolean(val));
                    continue;
                }
                if (key.equals("automatic") && !InstallationOptions.standard.isValueSet()) {
                    InstallationOptions.standard.setValue(Boolean.parseBoolean(val));
                    continue;
                }
                if (key.equals("registerapplication") && !InstallationOptions.register.isValueSet()) {
                    InstallationOptions.register.setValue(Boolean.parseBoolean(val));
                    continue;
                }
                if (key.equals("noshortcuts") && !InstallationOptions.desktopicons.isValueSet()) {
                    InstallationOptions.desktopicons.setValue(!Boolean.parseBoolean(val));
                    continue;
                }
                if (key.equals("reinstall") && !InstallationOptions.force.isValueSet()) {
                    InstallationOptions.force.setValue(Boolean.parseBoolean(val));
                    continue;
                }
                if ((key.equals("installdir") || key.equals("installpath")) && !InstallationOptions.installdir.isValueSet()) {
                    File dir = "default".equalsIgnoreCase(val) ? PathInfo.get(null).locatePath(10015) : new File(val);
                    InstallationOptions.installdir.setValue(dir);
                    continue;
                }
                if (key.equals("logfile") && !InstallationOptions.logfile.isValueSet()) {
                    InstallationOptions.logfile.setValue(new File(val));
                    continue;
                }
                if (key.equals("traceKeys") && !InstallationOptions.trace.isValueSet()) {
                    InstallationOptions.trace.setValue(val);
                    continue;
                }
                if (!key.equals("uninstall")) continue;
                retVal = InstallationMode.DEINSTALL;
            }
        }
        return retVal;
    }

    private static InstallationMode processArguments(InstallationMode mode) {
        InstallationMode retVal = mode;
        int rc = 0;
        ArrayList<String> argList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        rc = InstallationOptions.parse(sb, mArguments, argList);
        if (InstallationOptions.slave.booleanValue()) {
            InstallationOptions.gui.setValue(false);
            InstallationOptions.elevated.setValue(false);
            InstallationOptions.force.setValue(true);
        }
        if (rc < 0) {
            System.err.println(sb.toString());
            retVal = rc == -1 ? InstallationMode.EXIT : InstallationMode.ABORT;
        } else if (InstallationOptions.inputfile.value() != null) {
            retVal = Microkernel.parseInputFile(mode, (File)InstallationOptions.inputfile.value());
        }
        return retVal;
    }

    public static void main(String[] args) {
        InstallationFilter.Result retVal = InstallationFilter.Result.Unknown;
        Version v = Version.CURRENT;
        mArguments = args;
        InstallationMode mode = Microkernel.parseCommand();
        if (mode == InstallationMode.UNDEFINED) {
            mode = InstallationMode.INSTALL;
        }
        if ((mode == InstallationMode.INSTALL || mode == InstallationMode.DEINSTALL || mode == InstallationMode.REINSTALL) && (mode = Microkernel.processArguments(mode)) == InstallationMode.ABORT) {
            retVal = InstallationFilter.Result.Failed;
        }
        T.raceSetup((String)InstallationOptions.trace.value(), ":;,|");
        if (T.race("MICRO")) {
            T.race("MICRO", "Microkernel.main(): start Traces");
        }
        if (mode.ordinal() > InstallationMode.UNDEFINED.ordinal()) {
            switch (mode) {
                case INSTALL: {
                    retVal = Microkernel.install();
                    break;
                }
                case DEINSTALL: {
                    retVal = Microkernel.uninstall();
                    break;
                }
                case REINSTALL: {
                    retVal = Microkernel.reinstall();
                    break;
                }
                case VERSION: {
                    if (!Microkernel.showVersion()) break;
                    retVal = InstallationFilter.Result.Failed;
                }
            }
        }
        System.exit(retVal.failed() ? -1 : 0);
    }

    public static enum InstallationMode {
        ABORT(-2, ""),
        EXIT(-1, ""),
        UNDEFINED(0, ""),
        INSTALL(1, "install"),
        DEINSTALL(2, "uninstall"),
        REINSTALL(3, "reinstall"),
        VERSION(4, "version");

        private int mIntValue = 0;
        private String mCommand = null;

        private InstallationMode(int ordinal, String cmd) {
            this.mIntValue = ordinal;
            this.mCommand = cmd;
        }

        public int intValue() {
            return this.mIntValue;
        }

        public String commandValue() {
            return this.mCommand;
        }
    }

    public static class InstallerRunnable
    implements Runnable {
        private Installer mInstaller = null;

        @Override
        public void run() {
            this.mInstaller = new Installer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InstallationFilter.Result waitForInstaller() {
            try {
                while (this.mInstaller == null) {
                    Thread.sleep(100L);
                }
                Installer installer = this.mInstaller;
                synchronized (installer) {
                    this.mInstaller.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.mInstaller.getResult();
        }
    }
}

