/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.micro.Installation;
import com.sap.platin.micro.InstallationInfo;
import com.sap.platin.micro.SystemAccess;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.Version;
import com.sap.platin.micro.util.IOUtils;
import com.sap.platin.micro.util.XDGInfo;
import java.io.File;
import java.net.URL;
import java.util.HashMap;

public abstract class PathInfo {
    public static final String __PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/micro/PathInfo.java#34 $";
    public static final int D_SYSTEMPREFERENCES = 10001;
    public static final int D_USERPREFERENCES = 10002;
    public static final int D_INSTALLATIONDIR = 10003;
    public static final int D_PRODUCTDIR = 10004;
    public static final int D_RESOURCEDIR = 10005;
    public static final int D_BINARYDIR = 10006;
    public static final int D_GMUXDIR = 10007;
    public static final int D_JARDIR = 10008;
    public static final int D_APPLICATION = 10009;
    public static final int D_DOCUMENTATION = 10010;
    public static final int D_SECURITY = 10011;
    public static final int D_INSTALLSCRIPTDIR = 10012;
    public static final int D_USERINSTALLDIR = 10013;
    public static final int D_SYSTEMINSTALLDIR = 10014;
    public static final int D_DEFAULTINSTALLDIR = 10015;
    public static final int D_UPDATEDIR = 10016;
    public static final int D_ARCHIVEDIR = 10017;
    public static final int D_DOWNLOADDIR = 10018;
    public static final int D_DLAPPDIR = 10019;
    public static final int D_DLRESOURCEDIR = 10020;
    public static final int D_DLBINARYDIR = 10021;
    public static final int D_DLGMUXDIR = 10022;
    public static final int D_DLJARDIR = 10023;
    public static final int D_STATICBINARYDIR = 10025;
    public static final int D_USERTMPDIR = 10026;
    public static final int D_CACHEDIR = 10027;
    public static final int D_TRACEDIR = 10028;
    public static final int D_GUITMPDIR = 10029;
    public static final int F_INSTALLATIONLOG = 20001;
    public static final int F_INSTALLATIONLOCK = 20002;
    public static final int F_INSTALLSCRIPT = 20004;
    public static final int F_PERMISSIONS = 20005;
    public static final int F_DEINSTALLER = 20006;
    public static final int F_GUILOGON = 20007;
    public static final int F_GUISTART = 20008;
    public static final int F_SYSTEMKEYSTORE = 20009;
    public static final int F_USERKEYSTORE = 20010;
    public static final int F_LOGONDESKTOPFILE = 20011;
    public static final int F_CLIENTDIRFILE = 20012;
    public static final int F_LIBNAME = 20013;
    public static final int F_KDE3CONNECTLIB = 20014;
    public static final int F_GNOME2CONNECTLIB = 20015;
    public static final int F_GLOBFILE = 20016;
    public static final int F_MAGICFILE = 20017;
    public static final int F_DESKTOPMENUFILE = 20018;
    public static final int F_FINDERCONNECTLIB = 20019;
    public static final int F_STATICGUILOGON = 20020;
    public static final int F_STATICGUISTART = 20021;
    public static final int F_LOCALSAPLANDSCAPE = 20022;
    public static final int F_GUICOMMONEXEC = 20023;
    public static final int F_GLOBALSAPLANDSCAPE = 20024;
    public static final int F_GUILOGON2 = 20025;
    public static final int F_STATICGUILOGON2 = 20026;
    public static final int F_CONNECTIONTREE = 20027;
    public static final int F_SAPGUILANDSCAPE = 20028;
    public static final int F_CLEANUPLIST = 20029;
    public static final int F_AELIB = 20030;
    public static final int F_TRUSTCLASSIFICATION = 20031;
    public static final int F_SAPHTMLPROPERTIES = 20032;
    public static final int F_PRIVATEUSERPOLICY = 20033;
    public static final int F_GLOBALUSERPOLICY = 20034;
    public static final int F_SYSTEMCLASSIFICATION = 20035;
    public static final int F_SAPWINDLL = 30036;
    public static final int F_SNCLIB = 30037;
    public static final int R_BINARYDIRNAME = 30001;
    public static final int R_GMUXDIRNAME = 30002;
    public static final int R_JARDIRNAME = 30003;
    public static final int R_DOCUMENTATIONNAME = 30004;
    public static final int R_SECURITY = 30006;
    public static final int R_PERMISSIONS = 30007;
    public static final int R_INSTALLSCRIPTDIRNAME = 30008;
    public static final int R_INSTALLSCRIPT = 30009;
    public static final int R_INSTALLATIONLOG = 30010;
    public static final int R_INSTALLPROPERTIES = 30011;
    public static final int R_INSTALLATIONLOCK = 30012;
    public static final int R_INSTALLATIONPROTOKOLL = 30013;
    public static final int R_MANIFEST = 30014;
    public static final int R_WORKDIRNAME = 30015;
    public static final int R_SYSTEMPREFDIRNAME = 30016;
    public static final int R_GUISTARTCLASS = 30017;
    public static final int R_DEINSTALLERNAME = 30018;
    public static final int R_GUILOGONNAME = 30019;
    public static final int R_GUISTARTNAME = 30020;
    public static final int R_SYSTEMKEYSTORE = 30021;
    public static final int R_USERKEYSTORE = 30022;
    public static final int R_LOGONDESKTOPFILE = 30023;
    public static final int R_CLIENTDIRFILE = 30024;
    public static final int R_LIBNAME = 30025;
    public static final int R_KDE3CONNECTLIB = 30026;
    public static final int R_GNOME2CONNECTLIB = 30027;
    public static final int R_SAPGUIDATADIRNAME = 30028;
    public static final int R_GLOBFILENAME = 30029;
    public static final int R_MAGICFILENAME = 30030;
    public static final int R_DESKTOPMENUFILE = 30031;
    public static final int R_FINDERCONNECTLIB = 30032;
    public static final int R_GLOBALSAPLANDSCAPE = 30033;
    public static final int R_GUICOMMONEXECNAME = 30034;
    public static final int R_GUILOGON2NAME = 30035;
    public static final int R_SAPCLIENTS = 30036;
    public static final int R_CONNECTIONTREE = 30037;
    public static final int R_LOCALSAPLANDSCAPE = 30038;
    public static final int R_DOCUMENTATIONALIASNAME = 30039;
    public static final int R_SAPGUILANDSCAPE = 30040;
    public static final int R_USERTMPDIR = 30041;
    public static final int R_CACHEDIRNAME = 30042;
    public static final int R_CLEANUPLISTNAME = 30043;
    public static final int R_AELIBNAME = 30045;
    public static final int R_TRUSTCLASSIFICATION = 30046;
    public static final int R_SAPHTMLPROPERTIES = 30047;
    public static final int R_POLICYNAME = 30048;
    public static final int R_SAPWINDLL = 30049;
    public static final int R_GUITMPDIRNAME = 30050;
    public static final int R_SNCLIB = 30051;
    private static final HashMap<String, PathInfo> mInstances = new HashMap();
    protected File mBinaryPath = null;
    protected File mGmuxPath = null;
    protected final Installation mInstallation;

    private PathInfo(Installation inst) {
        this.mInstallation = inst;
    }

    public abstract String getPart(int var1);

    protected abstract File locatePathImpl(int var1);

    public File locatePath(int key) {
        File f = this.locatePath(key, false);
        return f;
    }

    public File locatePath(int key, boolean create) {
        File prefix = this.mInstallation != null ? this.mInstallation.getPrefix() : null;
        File f = IOUtils.patchRoot(prefix, this.locatePathImpl(key));
        if (create && !IOUtils.fileExists(f)) {
            IOUtils.createDirectories(f);
        }
        return f;
    }

    public final void setBinaryPath(File libraryPath) {
        this.mBinaryPath = libraryPath;
    }

    public final void setGmuxPath(File gmuxPath) {
        this.mGmuxPath = gmuxPath;
    }

    public static PathInfo getCurrent() {
        return PathInfo.get(InstallationInfo.getRunningInstallation());
    }

    public static PathInfo get(Installation inst) {
        String instKey = inst == null ? "<null>" : inst.getKey() + ":" + String.valueOf(inst.getApplicationDir());
        PathInfo specificInstance = mInstances.get(instKey);
        if (specificInstance == null) {
            if (SystemInfo.getOSClass() == 2) {
                float version = Float.parseFloat(SystemInfo.getOSVersion());
                specificInstance = version >= 6.0f ? new WindowsVistaPathRegistry(inst) : new WindowsPathRegistry(inst);
            } else {
                switch (SystemInfo.getOSClass()) {
                    case 3: {
                        specificInstance = new MacPathRegistry(inst);
                        break;
                    }
                    case 1: {
                        specificInstance = new UnixPathRegistry(inst);
                    }
                }
            }
            if (inst != null) {
                mInstances.put(instKey, specificInstance);
            }
        }
        return specificInstance;
    }

    public static void reset() {
        mInstances.clear();
    }

    public static String dumpPathInfo(PathInfo pi) {
        if (pi == null) {
            pi = PathInfo.getCurrent();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SAP GUI traces          : <" + pi.locatePath(10028) + ">").append("\n");
        sb.append("SAP GUI user prefs      : <" + pi.locatePath(10002) + ">").append("\n");
        sb.append("SAP GUI system prefs    : <" + pi.locatePath(10001) + ">").append("\n");
        sb.append(" ").append("\n");
        sb.append("Installation Dir        : <" + pi.locatePath(10003) + ">").append("\n");
        sb.append("Product Dir             : <" + pi.locatePath(10004) + ">").append("\n");
        sb.append("Application Dir         : <" + pi.locatePath(10009) + ">").append("\n");
        sb.append("Resource Dir            : <" + pi.locatePath(10005) + ">").append("\n");
        sb.append(" ").append("\n");
        sb.append("Binary Dir              : <" + pi.locatePath(10006) + ">").append("\n");
        sb.append("GMUX Dir                : <" + pi.locatePath(10007) + ">").append("\n");
        sb.append("Jar Dir                 : <" + pi.locatePath(10008) + ">").append("\n");
        sb.append("Install Script Dir      : <" + pi.locatePath(10012) + ">").append("\n");
        sb.append("Security Dir            : <" + pi.locatePath(10011) + ">").append("\n");
        sb.append("Documentation Dir       : <" + pi.locatePath(10010) + ">").append("\n");
        sb.append(" ").append("\n");
        sb.append("Default Installation Dir: <" + pi.locatePath(10015) + ">").append("\n");
        sb.append("System Installation Dir : <" + pi.locatePath(10014) + ">").append("\n");
        sb.append("User Installation Dir   : <" + pi.locatePath(10013) + ">").append("\n");
        sb.append(" \nFiles:").append("\n");
        sb.append("Installation Script     : <" + pi.locatePath(20004) + ">").append("\n");
        sb.append("Deinstaller             : <" + pi.locatePath(20006) + ">").append("\n");
        sb.append("guilogon                : <" + pi.locatePath(20007) + ">").append("\n");
        sb.append("guistart                : <" + pi.locatePath(20008) + ">").append("\n");
        sb.append("Installation LOCK       : <" + pi.locatePath(20002) + ">").append("\n");
        sb.append("Installation Log        : <" + pi.locatePath(20001) + ">").append("\n");
        sb.append("Permissions             : <" + pi.locatePath(20005) + ">").append("\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        String name = new String(PathInfo.class.getName());
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        name = name.replace('.', '/');
        Version v = Version.CURRENT;
        Installation installation = InstallationInfo.getInstallation(v);
        System.err.println("Installation base for " + v.getFullProductName() + ": " + (installation == null ? "NO Installation" : installation.getInstallationDir().getAbsolutePath()));
        URL url = PathInfo.class.getResource(name + ".class");
        System.err.println("Name: " + name);
        System.err.println("Url: " + url);
        System.err.println(PathInfo.dumpPathInfo(null));
    }

    private static class WindowsVistaPathRegistry
    extends PathInfo {
        private WindowsVistaPathRegistry(Installation inst) {
            super(inst);
        }

        @Override
        protected File locatePathImpl(int key) {
            File retVal = null;
            File base = null;
            switch (key) {
                case 10002: {
                    retVal = SystemAccess.locatePath(1);
                    break;
                }
                case 10001: {
                    retVal = SystemAccess.locatePath(2);
                    break;
                }
                case 10014: {
                    base = SystemAccess.locatePath(3);
                    retVal = base != null ? new File(base, this.getPart(30036)) : new File("C:\\Program Files", this.getPart(30036));
                    break;
                }
                case 10013: {
                    retVal = new File(SystemAccess.locatePath(4), this.getPart(30036));
                    break;
                }
                case 10015: {
                    base = this.locatePathImpl(10014);
                    boolean canWrite = IOUtils.isWritable(base, ".exe");
                    canWrite |= IOUtils.isWritable(base, ".dll");
                    retVal = (canWrite |= IOUtils.isWritable(base, ".bat")) ? base : this.locatePathImpl(10013);
                    break;
                }
                case 10003: {
                    retVal = this.mInstallation.getInstallationDir();
                    break;
                }
                case 10004: {
                    retVal = this.mInstallation.getProductDir();
                    break;
                }
                case 10009: {
                    retVal = this.mInstallation.getApplicationDir();
                    break;
                }
                case 10019: {
                    base = this.locatePathImpl(10018);
                    retVal = new File(base, this.mInstallation.getApplicationDir().getName());
                    break;
                }
                case 10005: {
                    retVal = this.locatePathImpl(10009);
                    break;
                }
                case 10008: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30003));
                    if (this.mInstallation == null || this.mInstallation.isInstalled()) break;
                    retVal = Installation.getJarDir();
                    break;
                }
                case 10010: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30004));
                    break;
                }
                case 10011: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30006));
                    break;
                }
                case 10025: {
                    base = this.mInstallation.getStaticProductDir();
                    retVal = new File(base, this.getPart(30001));
                    break;
                }
                case 10006: {
                    retVal = this.mBinaryPath == null ? new File(this.locatePathImpl(10005), this.getPart(30001)) : this.mBinaryPath;
                    break;
                }
                case 10007: {
                    base = this.mGmuxPath == null ? this.locatePathImpl(10006) : this.mGmuxPath;
                    retVal = new File(base, this.getPart(30002));
                    break;
                }
                case 10012: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30008));
                    break;
                }
                case 10016: {
                    base = this.locatePathImpl(10004);
                    retVal = new File(base, "GuiUpdate");
                    break;
                }
                case 10017: {
                    base = this.locatePathImpl(10016);
                    retVal = new File(base, "Archive");
                    break;
                }
                case 10018: {
                    base = this.locatePathImpl(10016);
                    retVal = new File(base, "Download");
                    break;
                }
                case 10020: {
                    retVal = this.locatePathImpl(10018);
                    break;
                }
                case 10023: {
                    base = this.locatePathImpl(10020);
                    retVal = new File(base, this.getPart(30003));
                    break;
                }
                case 10021: {
                    base = this.locatePathImpl(10020);
                    retVal = new File(base, this.getPart(30001));
                    break;
                }
                case 10022: {
                    base = this.locatePathImpl(10021);
                    retVal = new File(base, this.getPart(30002));
                    break;
                }
                case 10026: {
                    base = new File(System.getProperty("java.io.tmpdir"));
                    retVal = new File(base, this.getPart(30041));
                    break;
                }
                case 10029: {
                    base = new File(System.getProperty("java.io.tmpdir"));
                    retVal = new File(base, this.getPart(30050));
                    break;
                }
                case 10027: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30042));
                    break;
                }
                case 10028: {
                    retVal = SystemAccess.locatePath(9);
                    break;
                }
                case 20002: {
                    base = this.locatePathImpl(10004);
                    retVal = new File(base, "platin.lock");
                    break;
                }
                case 20001: {
                    base = SystemAccess.locatePath(7);
                    retVal = new File(base, this.getPart(30010));
                    break;
                }
                case 20004: {
                    base = this.locatePathImpl(10012);
                    retVal = new File(base, this.getPart(30009));
                    break;
                }
                case 20005: {
                    base = this.locatePathImpl(10018);
                    retVal = new File(base, this.getPart(30007));
                    break;
                }
                case 20007: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30019));
                    break;
                }
                case 20025: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30035));
                    break;
                }
                case 20008: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30020));
                    break;
                }
                case 20023: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30034));
                    break;
                }
                case 20020: {
                    base = this.locatePathImpl(10025);
                    retVal = new File(base, this.getPart(30019));
                    break;
                }
                case 20026: {
                    base = this.locatePathImpl(10025);
                    retVal = new File(base, this.getPart(30035));
                    break;
                }
                case 20021: {
                    base = this.locatePathImpl(10025);
                    retVal = new File(base, this.getPart(30020));
                    break;
                }
                case 20006: {
                    base = this.locatePathImpl(10009);
                    retVal = new File(base, this.getPart(30018));
                    break;
                }
                case 20009: {
                    base = this.locatePathImpl(10011);
                    retVal = new File(base, this.getPart(30021));
                    break;
                }
                case 20010: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30022));
                    break;
                }
                case 20013: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30025));
                    break;
                }
                case 20016: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30029));
                    break;
                }
                case 20017: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30030));
                    break;
                }
                case 20022: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30038));
                    break;
                }
                case 20024: {
                    base = SystemAccess.locatePath(2);
                    retVal = new File(base, this.getPart(30033));
                    break;
                }
                case 20027: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30037));
                    break;
                }
                case 20028: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30040));
                    break;
                }
                case 20029: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30043));
                    break;
                }
                case 20031: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30046));
                    break;
                }
                case 20035: {
                    base = this.locatePathImpl(10001);
                    retVal = new File(base, this.getPart(30046));
                    break;
                }
                case 20032: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30047));
                    break;
                }
                case 20034: {
                    base = this.locatePathImpl(10001);
                    retVal = new File(base, this.getPart(30048));
                    break;
                }
                case 20033: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30048));
                    break;
                }
                case 30036: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30049));
                }
            }
            if (retVal != null) {
                retVal = IOUtils.canonicalFile(retVal);
            }
            return retVal;
        }

        @Override
        public String getPart(int key) {
            String retVal = null;
            switch (key) {
                case 30001: {
                    retVal = "bin";
                    break;
                }
                case 30004: {
                    retVal = "doc";
                    break;
                }
                case 30002: {
                    retVal = "gmux";
                    break;
                }
                case 30003: {
                    retVal = this.mInstallation != null && this.mInstallation.isInstalled() ? "jar" : "java";
                    break;
                }
                case 30006: {
                    retVal = "security";
                    break;
                }
                case 30007: {
                    retVal = "permissions";
                    break;
                }
                case 30008: {
                    retVal = "inst";
                    break;
                }
                case 30009: {
                    retVal = "install.cmd";
                    break;
                }
                case 30010: {
                    retVal = "sapgui.log";
                    break;
                }
                case 30013: {
                    retVal = "Protocol.log";
                    break;
                }
                case 30014: {
                    retVal = "Installation.db";
                    break;
                }
                case 30015: {
                    retVal = "work";
                    break;
                }
                case 30017: {
                    retVal = "com.sap.platin.Gui";
                    break;
                }
                case 30019: {
                    retVal = "guilogon.bat";
                    break;
                }
                case 30020: {
                    retVal = "guistart.bat";
                    break;
                }
                case 30034: {
                    if (this.mInstallation == null) break;
                    if (this.mInstallation.getVersion().isOfType(5)) {
                        retVal = "sapnwbc.bat";
                        break;
                    }
                    if (this.mInstallation.getVersion().isOfType(2)) {
                        retVal = "sapwdp.bat";
                        break;
                    }
                    retVal = this.getPart(30035);
                    break;
                }
                case 30018: {
                    retVal = "uninstall.bat";
                    break;
                }
                case 30021: {
                    retVal = "sapcacerts";
                    break;
                }
                case 30022: {
                    retVal = "certificates";
                    break;
                }
                case 30025: {
                    retVal = "JPlatin" + SystemInfo.getArchitectureSuffix() + ".dll";
                    break;
                }
                case 30028: {
                    retVal = "SAPGUI";
                    break;
                }
                case 30029: {
                    retVal = "globs";
                    break;
                }
                case 30030: {
                    retVal = "magic";
                    break;
                }
                case 30033: {
                    retVal = "SAPLandscape.xml";
                    break;
                }
                case 30038: {
                    retVal = "nwbcLandscape.xml";
                    break;
                }
                case 30035: {
                    retVal = "guilgn2.bat";
                    break;
                }
                case 30036: {
                    retVal = "SAP Clients";
                    break;
                }
                case 30037: {
                    retVal = "connectionTree.xml";
                    break;
                }
                case 30040: {
                    retVal = "SAPGUILandscape.xml";
                    break;
                }
                case 30041: {
                    retVal = System.getProperty("user.name") + File.separator + "SAPGUI";
                    break;
                }
                case 30042: {
                    retVal = "Cache";
                    break;
                }
                case 30050: {
                    retVal = this.getPart(30041) + File.separator + "tmp";
                    break;
                }
                case 30043: {
                    retVal = "cleanupList";
                    break;
                }
                case 30046: {
                    retVal = "trustClassification";
                    break;
                }
                case 30047: {
                    retVal = "sapHtmlViewer.properties";
                    break;
                }
                case 30048: {
                    retVal = "SAPGUI.policy";
                    break;
                }
                case 30049: {
                    retVal = "sapwin" + SystemInfo.getArchitectureSuffix() + ".dll";
                }
            }
            return retVal;
        }
    }

    private static class WindowsPathRegistry
    extends PathInfo {
        private WindowsPathRegistry(Installation inst) {
            super(inst);
        }

        @Override
        protected File locatePathImpl(int key) {
            File retVal = null;
            File base = null;
            switch (key) {
                case 10002: {
                    retVal = SystemAccess.locatePath(1);
                    break;
                }
                case 10001: {
                    retVal = SystemAccess.locatePath(2);
                    break;
                }
                case 10014: {
                    base = SystemAccess.locatePath(3);
                    retVal = base != null ? new File(base, this.getPart(30036)) : new File("C:\\Program Files", this.getPart(30036));
                    break;
                }
                case 10013: {
                    retVal = new File(SystemAccess.locatePath(4), this.getPart(30036));
                    break;
                }
                case 10015: {
                    base = this.locatePathImpl(10014);
                    boolean canWrite = IOUtils.isWritable(base);
                    retVal = canWrite ? base : this.locatePathImpl(10013);
                    break;
                }
                case 10003: {
                    retVal = this.mInstallation.getInstallationDir();
                    break;
                }
                case 10004: {
                    retVal = this.mInstallation.getProductDir();
                    break;
                }
                case 10009: {
                    retVal = this.mInstallation.getApplicationDir();
                    break;
                }
                case 10019: {
                    base = this.locatePathImpl(10018);
                    retVal = new File(base, this.mInstallation.getApplicationDir().getName());
                    break;
                }
                case 10005: {
                    retVal = this.locatePathImpl(10009);
                    break;
                }
                case 10008: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30003));
                    if (this.mInstallation == null || this.mInstallation.isInstalled()) break;
                    retVal = Installation.getJarDir();
                    break;
                }
                case 10010: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30004));
                    break;
                }
                case 10011: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30006));
                    break;
                }
                case 10025: {
                    base = this.mInstallation.getStaticProductDir();
                    retVal = new File(base, this.getPart(30001));
                    break;
                }
                case 10006: {
                    retVal = this.mBinaryPath == null ? new File(this.locatePathImpl(10005), this.getPart(30001)) : this.mBinaryPath;
                    break;
                }
                case 10007: {
                    base = this.mGmuxPath == null ? this.locatePathImpl(10006) : this.mGmuxPath;
                    retVal = new File(base, this.getPart(30002));
                    break;
                }
                case 10012: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30008));
                    break;
                }
                case 10016: {
                    base = this.locatePathImpl(10004);
                    retVal = new File(base, "GuiUpdate");
                    break;
                }
                case 10017: {
                    base = this.locatePathImpl(10016);
                    retVal = new File(base, "Archive");
                    break;
                }
                case 10018: {
                    base = this.locatePathImpl(10016);
                    retVal = new File(base, "Download");
                    break;
                }
                case 10020: {
                    retVal = this.locatePathImpl(10018);
                    break;
                }
                case 10023: {
                    base = this.locatePathImpl(10020);
                    retVal = new File(base, this.getPart(30003));
                    break;
                }
                case 10021: {
                    base = this.locatePathImpl(10020);
                    retVal = new File(base, this.getPart(30001));
                    break;
                }
                case 10022: {
                    base = this.locatePathImpl(10021);
                    retVal = new File(base, this.getPart(30002));
                    break;
                }
                case 10026: {
                    base = new File(System.getProperty("java.io.tmpdir"));
                    retVal = new File(base, this.getPart(30041));
                    break;
                }
                case 10029: {
                    base = new File(System.getProperty("java.io.tmpdir"));
                    retVal = new File(base, this.getPart(30050));
                    break;
                }
                case 10027: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30042));
                    break;
                }
                case 10028: {
                    retVal = SystemAccess.locatePath(9);
                    break;
                }
                case 20002: {
                    base = this.locatePathImpl(10004);
                    retVal = new File(base, "platin.lock");
                    break;
                }
                case 20001: {
                    base = SystemAccess.locatePath(7);
                    retVal = new File(base, this.getPart(30010));
                    break;
                }
                case 20004: {
                    base = this.locatePathImpl(10012);
                    retVal = new File(base, this.getPart(30009));
                    break;
                }
                case 20005: {
                    base = this.locatePathImpl(10018);
                    retVal = new File(base, this.getPart(30007));
                    break;
                }
                case 20007: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30019));
                    break;
                }
                case 20025: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30035));
                    break;
                }
                case 20008: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30020));
                    break;
                }
                case 20023: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30034));
                    break;
                }
                case 20020: {
                    base = this.locatePathImpl(10025);
                    retVal = new File(base, this.getPart(30019));
                    break;
                }
                case 20021: {
                    base = this.locatePathImpl(10025);
                    retVal = new File(base, this.getPart(30020));
                    break;
                }
                case 20026: {
                    base = this.locatePathImpl(10025);
                    retVal = new File(base, this.getPart(30035));
                    break;
                }
                case 20006: {
                    base = this.locatePathImpl(10009);
                    retVal = new File(base, this.getPart(30018));
                    break;
                }
                case 20009: {
                    base = this.locatePathImpl(10011);
                    retVal = new File(base, this.getPart(30021));
                    break;
                }
                case 20010: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30022));
                    break;
                }
                case 20011: {
                    break;
                }
                case 20012: {
                    break;
                }
                case 20013: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30025));
                    break;
                }
                case 20016: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30029));
                    break;
                }
                case 20017: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30030));
                    break;
                }
                case 20022: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30038));
                    break;
                }
                case 20024: {
                    base = SystemAccess.locatePath(2);
                    retVal = new File(base, this.getPart(30033));
                    break;
                }
                case 20027: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30037));
                    break;
                }
                case 20028: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30040));
                    break;
                }
                case 20029: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30043));
                    break;
                }
                case 20031: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30046));
                    break;
                }
                case 20035: {
                    base = this.locatePathImpl(10001);
                    retVal = new File(base, this.getPart(30046));
                    break;
                }
                case 20032: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30047));
                    break;
                }
                case 20034: {
                    base = this.locatePathImpl(10001);
                    retVal = new File(base, this.getPart(30048));
                    break;
                }
                case 20033: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30048));
                    break;
                }
                case 30036: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30049));
                }
            }
            if (retVal != null) {
                retVal = IOUtils.canonicalFile(retVal);
            }
            return retVal;
        }

        @Override
        public String getPart(int key) {
            String retVal = null;
            switch (key) {
                case 30001: {
                    retVal = "bin";
                    break;
                }
                case 30004: {
                    retVal = "doc";
                    break;
                }
                case 30039: {
                    retVal = "Documentation";
                    break;
                }
                case 30002: {
                    retVal = "gmux";
                    break;
                }
                case 30003: {
                    retVal = this.mInstallation != null && this.mInstallation.isInstalled() ? "jar" : "java";
                    break;
                }
                case 30006: {
                    retVal = "security";
                    break;
                }
                case 30007: {
                    retVal = "permissions";
                    break;
                }
                case 30008: {
                    retVal = "inst";
                    break;
                }
                case 30009: {
                    retVal = "install.cmd";
                    break;
                }
                case 30010: {
                    retVal = "sapgui.log";
                    break;
                }
                case 30013: {
                    retVal = "Protocol.log";
                    break;
                }
                case 30014: {
                    retVal = "Installation.db";
                    break;
                }
                case 30015: {
                    retVal = "work";
                    break;
                }
                case 30017: {
                    retVal = "com.sap.platin.Gui";
                    break;
                }
                case 30019: {
                    retVal = "guilogon.bat";
                    break;
                }
                case 30020: {
                    retVal = "guistart.bat";
                    break;
                }
                case 30034: {
                    if (this.mInstallation == null) break;
                    if (this.mInstallation.getVersion().isOfType(5)) {
                        retVal = "sapnwbc.bat";
                        break;
                    }
                    if (this.mInstallation.getVersion().isOfType(2)) {
                        retVal = "sapwdp.bat";
                        break;
                    }
                    retVal = this.getPart(30035);
                    break;
                }
                case 30018: {
                    retVal = "uninstall.bat";
                    break;
                }
                case 30021: {
                    retVal = "sapcacerts";
                    break;
                }
                case 30022: {
                    retVal = "certificates";
                    break;
                }
                case 30025: {
                    retVal = "JPlatin" + SystemInfo.getArchitectureSuffix() + ".dll";
                    break;
                }
                case 30028: {
                    retVal = "SAPGUI";
                    break;
                }
                case 30029: {
                    retVal = "globs";
                    break;
                }
                case 30030: {
                    retVal = "magic";
                    break;
                }
                case 30033: {
                    retVal = "SAPLandscape.xml";
                    break;
                }
                case 30038: {
                    retVal = "nwbcLandscape.xml";
                    break;
                }
                case 30035: {
                    retVal = "guilgn2.bat";
                    break;
                }
                case 30036: {
                    retVal = "SAP Clients";
                    break;
                }
                case 30037: {
                    retVal = "connectionTree.xml";
                    break;
                }
                case 30040: {
                    retVal = "SAPGUILandscape.xml";
                    break;
                }
                case 30041: {
                    retVal = System.getProperty("user.name") + File.separator + "SAPGUI";
                    break;
                }
                case 30050: {
                    retVal = this.getPart(30041) + File.separator + "tmp";
                    break;
                }
                case 30042: {
                    retVal = "Cache";
                    break;
                }
                case 30043: {
                    retVal = "cleanupList";
                    break;
                }
                case 30046: {
                    retVal = "trustClassification";
                    break;
                }
                case 30047: {
                    retVal = "sapHtmlViewer.properties";
                    break;
                }
                case 30048: {
                    retVal = "SAPGUI.policy";
                    break;
                }
                case 30049: {
                    retVal = "sapwin" + SystemInfo.getArchitectureSuffix() + ".dll";
                }
            }
            return retVal;
        }
    }

    private static class UnixPathRegistry
    extends PathInfo {
        private UnixPathRegistry(Installation inst) {
            super(inst);
        }

        @Override
        protected File locatePathImpl(int key) {
            File retVal = null;
            File base = null;
            switch (key) {
                case 10002: {
                    retVal = SystemAccess.locatePath(1);
                    break;
                }
                case 10001: {
                    retVal = SystemAccess.locatePath(2);
                    break;
                }
                case 10014: {
                    retVal = new File(SystemAccess.locatePath(3), this.getPart(30036));
                    break;
                }
                case 10013: {
                    retVal = new File(SystemAccess.locatePath(4), this.getPart(30036));
                    break;
                }
                case 10015: {
                    base = this.locatePathImpl(10014);
                    boolean canWrite = IOUtils.isWritable(base);
                    retVal = canWrite ? base : this.locatePathImpl(10013);
                    break;
                }
                case 10003: {
                    retVal = this.mInstallation.getInstallationDir();
                    break;
                }
                case 10004: {
                    retVal = this.mInstallation.getProductDir();
                    break;
                }
                case 10009: {
                    retVal = this.mInstallation.getApplicationDir();
                    break;
                }
                case 10019: {
                    retVal = this.locatePathImpl(10018);
                    break;
                }
                case 10005: {
                    retVal = this.locatePathImpl(10009);
                    break;
                }
                case 10008: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30003));
                    if (this.mInstallation == null || this.mInstallation.isInstalled()) break;
                    retVal = Installation.getJarDir();
                    break;
                }
                case 10010: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30004));
                    break;
                }
                case 10011: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30006));
                    break;
                }
                case 10025: {
                    base = this.mInstallation.getStaticProductDir();
                    retVal = new File(base, this.getPart(30001));
                    break;
                }
                case 10006: {
                    retVal = this.mBinaryPath == null ? new File(this.locatePathImpl(10005), this.getPart(30001)) : this.mBinaryPath;
                    break;
                }
                case 10007: {
                    base = this.mGmuxPath == null ? this.locatePathImpl(10006) : this.mGmuxPath;
                    retVal = new File(base, this.getPart(30002));
                    break;
                }
                case 10012: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30008));
                    break;
                }
                case 10016: {
                    base = this.locatePathImpl(10004);
                    retVal = new File(base, "GuiUpdate");
                    break;
                }
                case 10017: {
                    base = this.locatePathImpl(10016);
                    retVal = new File(base, "Archive");
                    break;
                }
                case 10018: {
                    base = this.locatePathImpl(10016);
                    retVal = new File(base, "Download");
                    break;
                }
                case 10020: {
                    retVal = this.locatePathImpl(10018);
                    break;
                }
                case 10023: {
                    base = this.locatePathImpl(10020);
                    retVal = new File(base, this.getPart(30003));
                    break;
                }
                case 10021: {
                    base = this.locatePathImpl(10020);
                    retVal = new File(base, this.getPart(30001));
                    break;
                }
                case 10022: {
                    base = this.locatePathImpl(10021);
                    retVal = new File(base, this.getPart(30002));
                    break;
                }
                case 10026: {
                    base = new File(System.getProperty("java.io.tmpdir"));
                    retVal = new File(base, this.getPart(30041));
                    break;
                }
                case 10029: {
                    base = new File(System.getProperty("java.io.tmpdir"));
                    retVal = new File(base, this.getPart(30050));
                    break;
                }
                case 10027: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30042));
                    break;
                }
                case 10028: {
                    retVal = SystemAccess.locatePath(9);
                    break;
                }
                case 20002: {
                    base = this.locatePathImpl(10004);
                    retVal = new File(base, "platin.lock");
                    break;
                }
                case 20001: {
                    base = SystemAccess.locatePath(7);
                    retVal = new File(base, this.getPart(30010));
                    break;
                }
                case 20004: {
                    base = this.locatePathImpl(10012);
                    retVal = new File(base, this.getPart(30009));
                    break;
                }
                case 20005: {
                    base = this.locatePathImpl(10018);
                    retVal = new File(base, this.getPart(30007));
                    break;
                }
                case 20007: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30019));
                    break;
                }
                case 20008: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30020));
                    break;
                }
                case 20023: {
                    retVal = this.locatePathImpl(20007);
                    break;
                }
                case 20020: {
                    base = this.locatePathImpl(10025);
                    retVal = new File(base, this.getPart(30019));
                    break;
                }
                case 20021: {
                    base = this.locatePathImpl(10025);
                    retVal = new File(base, this.getPart(30020));
                    break;
                }
                case 20006: {
                    break;
                }
                case 20009: {
                    base = this.locatePathImpl(10011);
                    retVal = new File(base, this.getPart(30021));
                    break;
                }
                case 20010: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30022));
                    break;
                }
                case 20011: {
                    base = XDGInfo.getFirstWritableDataFile("applications", false);
                    retVal = new File(base, this.getPart(30023));
                    break;
                }
                case 20012: {
                    base = XDGInfo.getFirstWritableDataFile("desktop-directories", false);
                    if (!IOUtils.fileExists(base)) {
                        base.mkdirs();
                    }
                    retVal = new File(base, this.getPart(30024));
                    break;
                }
                case 20018: {
                    base = XDGInfo.getFirstWritableConfigFile("menus/applications-merged", false);
                    if (!IOUtils.fileExists(base)) {
                        IOUtils.createDirectories(base);
                    }
                    retVal = new File(base, this.getPart(30031));
                    break;
                }
                case 20013: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30025));
                    break;
                }
                case 20014: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30026));
                    break;
                }
                case 20015: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30027));
                    break;
                }
                case 20016: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30029));
                    break;
                }
                case 20017: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30030));
                    break;
                }
                case 20022: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30038));
                    break;
                }
                case 20024: {
                    base = SystemAccess.locatePath(2);
                    retVal = new File(base, this.getPart(30033));
                    break;
                }
                case 20027: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30037));
                    break;
                }
                case 20028: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30040));
                    break;
                }
                case 20029: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30043));
                    break;
                }
                case 20031: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30046));
                    break;
                }
                case 20035: {
                    base = this.locatePathImpl(10001);
                    retVal = new File(base, this.getPart(30046));
                    break;
                }
                case 20032: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30047));
                    break;
                }
                case 20034: {
                    base = this.locatePathImpl(10001);
                    retVal = new File(base, this.getPart(30048));
                    break;
                }
                case 20033: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30048));
                }
            }
            return retVal;
        }

        @Override
        public String getPart(int key) {
            String retVal = null;
            switch (key) {
                case 30001: {
                    retVal = "bin";
                    break;
                }
                case 30004: {
                    retVal = "doc";
                    break;
                }
                case 30039: {
                    retVal = "Documentation";
                    break;
                }
                case 30002: {
                    retVal = "gmux";
                    break;
                }
                case 30003: {
                    retVal = "jar";
                    break;
                }
                case 30006: {
                    retVal = "security";
                    break;
                }
                case 30007: {
                    retVal = "permissions";
                    break;
                }
                case 30008: {
                    retVal = "inst";
                    break;
                }
                case 30009: {
                    retVal = "install";
                    break;
                }
                case 30010: {
                    retVal = "sapgui.log";
                    break;
                }
                case 30013: {
                    retVal = "Protocol.log";
                    break;
                }
                case 30014: {
                    retVal = "Installation.db";
                    break;
                }
                case 30015: {
                    retVal = "work";
                    break;
                }
                case 30017: {
                    retVal = "com.sap.platin.Gui";
                    break;
                }
                case 30019: {
                    retVal = "guilogon";
                    break;
                }
                case 30020: {
                    retVal = "guistart";
                    break;
                }
                case 30034: {
                    if (this.mInstallation == null) break;
                    if (this.mInstallation.getVersion().isOfType(5)) {
                        retVal = "sapnwbc";
                        break;
                    }
                    if (this.mInstallation.getVersion().isOfType(2)) {
                        retVal = "sapwdp";
                        break;
                    }
                    retVal = "guilogon";
                    break;
                }
                case 30018: {
                    break;
                }
                case 30021: {
                    retVal = "sapcacerts";
                    break;
                }
                case 30022: {
                    retVal = "certificates";
                    break;
                }
                case 30023: {
                    retVal = this.mInstallation.getVersion().getCompressedProductName() + ".desktop";
                    break;
                }
                case 30024: {
                    retVal = "SAPClients.directory";
                    break;
                }
                case 30031: {
                    retVal = "SAPClients.menu";
                    break;
                }
                case 30025: {
                    retVal = SystemInfo.getOperatingSystem() != 4 ? "libJPlatin" + SystemInfo.getArchitectureSuffix() + ".so" : "libJPlatin.sl";
                    break;
                }
                case 30026: {
                    retVal = "libKde3Connect" + SystemInfo.getArchitectureSuffix() + ".so";
                    break;
                }
                case 30027: {
                    retVal = "libGnomeConnect" + SystemInfo.getArchitectureSuffix() + ".so";
                    break;
                }
                case 30028: {
                    retVal = ".SAPGUI";
                    break;
                }
                case 30029: {
                    retVal = "globs";
                    break;
                }
                case 30030: {
                    retVal = "magic";
                    break;
                }
                case 30033: {
                    retVal = "SAPLandscape.xml";
                    break;
                }
                case 30038: {
                    retVal = "nwbcLandscape.xml";
                    break;
                }
                case 30036: {
                    retVal = "SAPClients";
                    break;
                }
                case 30037: {
                    retVal = "connectionTree.xml";
                    break;
                }
                case 30040: {
                    retVal = "SAPGUILandscape.xml";
                    break;
                }
                case 30041: {
                    retVal = System.getProperty("user.name") + File.separator + "SAPGUI";
                    break;
                }
                case 30050: {
                    retVal = this.getPart(30041) + File.separator + "tmp";
                    break;
                }
                case 30042: {
                    retVal = "Cache";
                    break;
                }
                case 30043: {
                    retVal = "cleanupList";
                    break;
                }
                case 30046: {
                    retVal = "trustClassification";
                    break;
                }
                case 30047: {
                    retVal = "sapHtmlViewer.properties";
                    break;
                }
                case 30048: {
                    retVal = "SAPGUI.policy";
                }
            }
            return retVal;
        }
    }

    private static class MacPathRegistry
    extends PathInfo {
        private MacPathRegistry(Installation inst) {
            super(inst);
        }

        @Override
        protected File locatePathImpl(int key) {
            File retVal = null;
            File base = null;
            switch (key) {
                case 10002: {
                    retVal = SystemAccess.locatePath(1);
                    break;
                }
                case 10001: {
                    retVal = SystemAccess.locatePath(2);
                    break;
                }
                case 10014: {
                    retVal = new File(SystemAccess.locatePath(3), this.getPart(30036));
                    break;
                }
                case 10013: {
                    retVal = new File(SystemAccess.locatePath(4), this.getPart(30036));
                    break;
                }
                case 10015: {
                    base = this.locatePathImpl(10014);
                    boolean canWrite = IOUtils.isWritable(base);
                    retVal = canWrite ? base : this.locatePathImpl(10013);
                    break;
                }
                case 10003: {
                    retVal = this.mInstallation.getInstallationDir();
                    break;
                }
                case 10004: {
                    retVal = this.mInstallation.getProductDir();
                    break;
                }
                case 10009: {
                    base = this.locatePathImpl(10004);
                    retVal = this.mInstallation.getApplicationDir();
                    break;
                }
                case 10019: {
                    base = this.locatePathImpl(10018);
                    retVal = new File(base, this.mInstallation.getApplicationDir().getName());
                    break;
                }
                case 10005: {
                    base = this.locatePathImpl(10009);
                    retVal = this.mInstallation.isInstalled() ? new File(base, "Contents" + File.separator + "Resources") : base;
                    break;
                }
                case 10008: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30003));
                    if (this.mInstallation == null || this.mInstallation.isInstalled()) break;
                    retVal = Installation.getJarDir();
                    break;
                }
                case 10010: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30004));
                    break;
                }
                case 10011: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30006));
                    break;
                }
                case 10025: {
                    base = this.mInstallation.getStaticProductDir();
                    retVal = new File(base, this.getPart(30001));
                    break;
                }
                case 10006: {
                    retVal = this.mBinaryPath == null ? new File(this.locatePathImpl(10005), this.getPart(30001)) : this.mBinaryPath;
                    break;
                }
                case 10007: {
                    base = this.mGmuxPath == null ? this.locatePathImpl(10006) : this.mGmuxPath;
                    retVal = new File(base, this.getPart(30002));
                    break;
                }
                case 10016: {
                    base = this.locatePathImpl(10004);
                    retVal = new File(base, "GuiUpdate");
                    break;
                }
                case 10017: {
                    base = this.locatePathImpl(10016);
                    retVal = new File(base, "Archive");
                    break;
                }
                case 10018: {
                    base = this.locatePathImpl(10016);
                    retVal = new File(base, "Download");
                    break;
                }
                case 10020: {
                    base = this.locatePathImpl(10019);
                    retVal = this.mInstallation.isInstalled() ? new File(base, "Contents" + File.separator + "Resources") : base;
                    break;
                }
                case 10023: {
                    base = this.locatePathImpl(10020);
                    retVal = new File(base, this.getPart(30003));
                    break;
                }
                case 10021: {
                    base = this.locatePathImpl(10020);
                    retVal = new File(base, this.getPart(30001));
                    break;
                }
                case 10022: {
                    base = this.locatePathImpl(10021);
                    retVal = new File(base, this.getPart(30002));
                    break;
                }
                case 10012: {
                    base = this.locatePathImpl(10005);
                    retVal = new File(base, this.getPart(30008));
                    break;
                }
                case 10026: {
                    base = new File(System.getProperty("java.io.tmpdir"));
                    retVal = new File(base, this.getPart(30041));
                    break;
                }
                case 10029: {
                    base = new File(System.getProperty("java.io.tmpdir"));
                    retVal = new File(base, this.getPart(30050));
                    break;
                }
                case 10027: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30042));
                    break;
                }
                case 10028: {
                    retVal = SystemAccess.locatePath(9);
                    break;
                }
                case 20002: {
                    base = this.locatePathImpl(10004);
                    retVal = new File(base, "platin.lock");
                    break;
                }
                case 20001: {
                    base = SystemAccess.locatePath(7);
                    retVal = new File(base, this.getPart(30010));
                    break;
                }
                case 20004: {
                    base = this.locatePathImpl(10012);
                    retVal = new File(base, this.getPart(30009));
                    break;
                }
                case 20005: {
                    base = this.locatePathImpl(10018);
                    retVal = new File(base, this.getPart(30007));
                    break;
                }
                case 20007: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30019));
                    break;
                }
                case 20008: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30020));
                    break;
                }
                case 20023: {
                    retVal = this.locatePathImpl(20007);
                    break;
                }
                case 20020: {
                    base = this.locatePathImpl(10025);
                    retVal = new File(base, this.getPart(30019));
                    break;
                }
                case 20021: {
                    base = this.locatePathImpl(10025);
                    retVal = new File(base, this.getPart(30020));
                    break;
                }
                case 20009: {
                    base = this.locatePathImpl(10011);
                    retVal = new File(base, this.getPart(30021));
                    break;
                }
                case 20010: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30022));
                    break;
                }
                case 20013: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30025));
                    break;
                }
                case 20016: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30029));
                    break;
                }
                case 20017: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30030));
                    break;
                }
                case 20019: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30032));
                    break;
                }
                case 20022: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30038));
                    break;
                }
                case 20024: {
                    base = SystemAccess.locatePath(2);
                    retVal = new File(base, this.getPart(30033));
                    break;
                }
                case 20027: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30037));
                    break;
                }
                case 20028: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30040));
                    break;
                }
                case 20029: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30043));
                    break;
                }
                case 20030: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30045));
                    break;
                }
                case 20031: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30046));
                    break;
                }
                case 20035: {
                    base = this.locatePathImpl(10001);
                    retVal = new File(base, this.getPart(30046));
                    break;
                }
                case 20032: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30047));
                    break;
                }
                case 20034: {
                    base = this.locatePathImpl(10001);
                    retVal = new File(base, this.getPart(30048));
                    break;
                }
                case 20033: {
                    base = this.locatePathImpl(10002);
                    retVal = new File(base, this.getPart(30048));
                    break;
                }
                case 30037: {
                    base = this.locatePathImpl(10006);
                    retVal = new File(base, this.getPart(30051));
                }
            }
            return retVal;
        }

        @Override
        public String getPart(int key) {
            String retVal = null;
            switch (key) {
                case 30001: {
                    retVal = "bin";
                    break;
                }
                case 30004: {
                    retVal = "doc";
                    break;
                }
                case 30039: {
                    retVal = "Documentation";
                    break;
                }
                case 30002: {
                    retVal = "gmux";
                    break;
                }
                case 30003: {
                    retVal = this.mInstallation != null && this.mInstallation.isInstalled() ? "Java" : "java";
                    break;
                }
                case 30006: {
                    retVal = "security";
                    break;
                }
                case 30007: {
                    retVal = "permissions";
                    break;
                }
                case 30008: {
                    retVal = "inst";
                    break;
                }
                case 30009: {
                    retVal = "install";
                    break;
                }
                case 30010: {
                    retVal = "sapgui.log";
                    break;
                }
                case 30013: {
                    retVal = "Protocol.log";
                    break;
                }
                case 30014: {
                    retVal = "Installation.db";
                    break;
                }
                case 30015: {
                    retVal = "work";
                    break;
                }
                case 30017: {
                    retVal = "com.sap.platin.Gui";
                    break;
                }
                case 30019: {
                    retVal = "guilogon";
                    break;
                }
                case 30020: {
                    retVal = "guistart";
                    break;
                }
                case 30034: {
                    if (this.mInstallation == null) break;
                    if (this.mInstallation.getVersion().isOfType(5)) {
                        retVal = "sapnwbc";
                        break;
                    }
                    if (this.mInstallation.getVersion().isOfType(2)) {
                        retVal = "sapwdp";
                        break;
                    }
                    retVal = "sapgui";
                    break;
                }
                case 30021: {
                    retVal = "sapcacerts";
                    break;
                }
                case 30022: {
                    retVal = "certificates";
                    break;
                }
                case 30025: {
                    retVal = "libJPlatin" + SystemInfo.getArchitectureSuffix() + ".dylib";
                    break;
                }
                case 30028: {
                    retVal = "SAP";
                    break;
                }
                case 30029: {
                    retVal = "globs";
                    break;
                }
                case 30030: {
                    retVal = "magic";
                    break;
                }
                case 30032: {
                    retVal = "libMacOSXConnect" + SystemInfo.getArchitectureSuffix() + ".dylib";
                    break;
                }
                case 30033: {
                    retVal = "SAPLandscape.xml";
                    break;
                }
                case 30038: {
                    retVal = "nwbcLandscape.xml";
                    break;
                }
                case 30036: {
                    retVal = "SAP Clients";
                    break;
                }
                case 30037: {
                    retVal = "connectionTree.xml";
                    break;
                }
                case 30040: {
                    retVal = "SAPGUILandscape.xml";
                    break;
                }
                case 30041: {
                    retVal = System.getProperty("user.name") + File.separator + "SAPGUI";
                    break;
                }
                case 30050: {
                    retVal = this.getPart(30041) + File.separator + "tmp";
                    break;
                }
                case 30042: {
                    retVal = "Cache";
                    break;
                }
                case 30043: {
                    retVal = "cleanupList";
                    break;
                }
                case 30045: {
                    retVal = "libSAPGUIAppleEvent.dylib";
                    break;
                }
                case 30046: {
                    retVal = "trustClassification";
                    break;
                }
                case 30047: {
                    retVal = "sapHtmlViewer.properties";
                    break;
                }
                case 30048: {
                    retVal = "SAPGUI.policy";
                    break;
                }
                case 30051: {
                    retVal = "sncgss.dylib";
                }
            }
            return retVal;
        }
    }
}

