/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.apple.eio.FileManager;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.Version;
import com.sap.platin.micro.Win32RegistryUtils;
import com.sap.platin.trace.T;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SystemAccess {
    private static SystemAccess mInstance = null;
    private static String lastMessage = null;
    public static final int PTH_USERPREFDIR = 1;
    public static final int PTH_SYSTEMPREFDIR = 2;
    public static final int PTH_SYSAPPLICATIONS = 3;
    public static final int PTH_USERAPPLICATIONS = 4;
    public static final int PTH_USERREPOSITORY = 5;
    public static final int PTH_SYSTEMREPOSITORY = 6;
    public static final int PTH_USERLOGDIR = 7;
    public static final int PTH_USERDOWNLOADS = 8;
    public static final int PTH_TRACEDIR = 9;
    private static final Pattern WINVERPATTERN = Pattern.compile("^(\\d+\\.\\d+)");
    public static final int REQ_SYSACCESS = 1;
    public static final int REQ_VMVERSION = 2;

    private SystemAccess() {
    }

    public static final boolean meetsRequirement(int type, StringBuffer resultBuffer) {
        return SystemAccess.getInstance().meetsRequirementImpl(type, resultBuffer);
    }

    public static final File locatePath(int key) {
        return SystemAccess.getInstance().locatePathImpl(key);
    }

    public static final SystemAccess getInstance() {
        if (mInstance == null) {
            if (SystemInfo.getOSClass() == 2) {
                try {
                    String osVer = SystemInfo.getOSVersion();
                    Matcher m = WINVERPATTERN.matcher(osVer);
                    if (m.find()) {
                        String ver = m.group(1);
                        float version = Float.parseFloat(ver);
                        mInstance = version >= 6.0f ? new VistaAccess() : new WindowsAccess();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (mInstance == null) {
                    lastMessage = "Can not determine which Windows version is in use.";
                    mInstance = new UnsupportedAccess();
                }
            } else {
                switch (SystemInfo.getOSClass()) {
                    case 3: {
                        mInstance = new MacOSXAccess();
                        break;
                    }
                    case 1: {
                        mInstance = new UnixAccess();
                        break;
                    }
                    default: {
                        mInstance = new UnsupportedAccess();
                    }
                }
            }
        }
        return mInstance;
    }

    public static boolean isSupported(StringBuffer resultBuffer) {
        return SystemAccess.getInstance().isSupportedImpl(resultBuffer);
    }

    protected boolean meetsRequirementImpl(int type, StringBuffer resultBuffer) {
        boolean retVal = true;
        switch (type) {
            case 2: {
                if (!Version.CURRENT.isOfType(5) || "false".equals(System.getProperty("com.sap.platin.nwbc.checkjdk"))) break;
                String v = System.getProperty("java.version");
                boolean bl = retVal = v.charAt(0) >= '1' && v.charAt(2) >= '6';
                if (retVal) break;
                resultBuffer.append("\n").append(Version.CURRENT.getOfficialProductName()).append("\n needs at least a Java version 6.0 to run.\n");
            }
        }
        return retVal;
    }

    protected boolean isSupportedImpl(StringBuffer resultBuffer) {
        return true;
    }

    protected File locatePathImpl(int key) {
        File retVal = null;
        return retVal;
    }

    private static class VistaAccess
    extends WindowsAccess {
        private VistaAccess() {
        }

        protected File getUserAppDataFolder() {
            File appFolder = null;
            String appDirPath = System.getenv("LOCALAPPDATA");
            if (appDirPath != null && !(appFolder = new File(appDirPath + "Low")).exists()) {
                appFolder = new File(appDirPath);
            }
            return appFolder;
        }

        @Override
        protected boolean meetsRequirementImpl(int type, StringBuffer resultBuffer) {
            boolean retVal = super.meetsRequirementImpl(type, resultBuffer);
            switch (type) {
                case 1: {
                    if (Win32RegistryUtils.isRegistryAvailable()) break;
                    resultBuffer.append("Could not request values from Windows registry.\n").append("Probably you are running on a low integrity level. This is not supported.\n\n").append("If you are running inside a Browser please disable 'Protection Mode'\n");
                    retVal = false;
                }
            }
            return retVal;
        }

        @Override
        protected File locatePathImpl(int key) {
            File retVal = null;
            switch (key) {
                case 1: 
                case 5: {
                    retVal = new File(this.getUserAppDataFolder(), "SAPGUI");
                    break;
                }
                default: {
                    retVal = super.locatePathImpl(key);
                }
            }
            return retVal;
        }
    }

    private static class WindowsAccess
    extends SystemAccess {
        private WindowsAccess() {
        }

        @Override
        protected boolean meetsRequirementImpl(int type, StringBuffer resultBuffer) {
            boolean retVal = super.meetsRequirementImpl(type, resultBuffer);
            switch (type) {
                case 1: {
                    if (Win32RegistryUtils.isRegistryAvailable()) break;
                    resultBuffer.append("Could not read values from Windows registry.\n").append("Usually this means your administrator has denied you registry access.\n").append("Since this program requires read access to the windows registry\n").append("you will be missing functionality.\n");
                    retVal = false;
                }
            }
            return retVal;
        }

        protected File getAllUsersFolder() {
            File retVal = null;
            String dirName = System.getenv("ALLUSERSPROFILE");
            if (dirName != null) {
                retVal = new File(dirName);
            }
            return retVal;
        }

        protected File getProgramFilesFolder() {
            File retVal = null;
            String[] pList = new String[]{"ProgramW6432", "ProgramFiles"};
            String dirName = null;
            for (String d : pList) {
                dirName = System.getenv(d);
                if (dirName == null) continue;
                retVal = new File(dirName);
                break;
            }
            return retVal;
        }

        @Override
        protected File locatePathImpl(int key) {
            File retVal = null;
            switch (key) {
                case 2: 
                case 6: {
                    retVal = new File(this.getAllUsersFolder(), "SAPGUI");
                    break;
                }
                case 1: 
                case 5: {
                    retVal = new File(System.getProperty("user.home"), "SAPGUI");
                    break;
                }
                case 3: {
                    retVal = this.getProgramFilesFolder();
                    break;
                }
                case 4: {
                    retVal = new File(System.getProperty("user.home"));
                    break;
                }
                case 7: {
                    retVal = new File(System.getProperty("user.home"));
                    break;
                }
                case 9: {
                    File base = this.locatePathImpl(1);
                    retVal = new File(base, "traces");
                    break;
                }
                default: {
                    retVal = super.locatePathImpl(key);
                }
            }
            return retVal;
        }
    }

    private static class MacOSXAccess
    extends SystemAccess {
        public static final short kSystemDomain = -32766;
        public static final short kLocalDomain = -32765;
        public static final short kNetworkDomain = -32764;
        public static final short kUserDomain = -32763;
        private static final String kPreferences = "pref";
        private static final String kApplication = "apps";
        private static final String kLogfiledir = "logs";
        private static final String kDownloadsdir = "down";

        private MacOSXAccess() {
        }

        public static String getWellKnownFolder(short domain, String key) {
            return MacOSXAccess.getWellKnownFolder(domain, key, true);
        }

        public static String getWellKnownFolder(short domain, String key, boolean required) {
            String retVal;
            block3: {
                retVal = null;
                try {
                    retVal = FileManager.findFolder((short)domain, (int)FileManager.OSTypeToInt((String)key), (boolean)false);
                }
                catch (FileNotFoundException e) {
                    if (!required) break block3;
                    T.raceError("Could not locate well known Mac OSX folder: " + key);
                    e.printStackTrace();
                }
            }
            if (retVal == null) {
                retVal = System.getProperty("user.home");
            }
            return retVal;
        }

        @Override
        protected File locatePathImpl(int key) {
            File retVal = null;
            switch (key) {
                case 2: 
                case 6: {
                    retVal = new File(MacOSXAccess.getWellKnownFolder((short)-32765, kPreferences), "SAP");
                    break;
                }
                case 1: 
                case 5: {
                    retVal = new File(MacOSXAccess.getWellKnownFolder((short)-32763, kPreferences), "SAP");
                    break;
                }
                case 3: {
                    retVal = new File(MacOSXAccess.getWellKnownFolder((short)-32765, kApplication));
                    break;
                }
                case 8: {
                    retVal = new File(MacOSXAccess.getWellKnownFolder((short)-32763, kDownloadsdir, false));
                    break;
                }
                case 4: {
                    retVal = new File(MacOSXAccess.getWellKnownFolder((short)-32763, kApplication, false));
                    break;
                }
                case 7: {
                    retVal = new File(MacOSXAccess.getWellKnownFolder((short)-32763, kLogfiledir, false));
                    break;
                }
                case 9: {
                    File base = this.locatePathImpl(1);
                    retVal = new File(base, "traces");
                    break;
                }
                default: {
                    retVal = super.locatePathImpl(key);
                }
            }
            return retVal;
        }
    }

    private static class UnixAccess
    extends SystemAccess {
        private UnixAccess() {
        }

        @Override
        protected File locatePathImpl(int key) {
            File retVal = null;
            switch (key) {
                case 2: 
                case 6: {
                    retVal = new File("/etc/SAPGUI");
                    break;
                }
                case 1: 
                case 5: {
                    retVal = new File(System.getProperty("user.home"), ".SAPGUI");
                    break;
                }
                case 3: {
                    retVal = new File("/opt");
                    break;
                }
                case 4: {
                    retVal = new File(System.getProperty("user.home"));
                    break;
                }
                case 7: {
                    retVal = new File(System.getProperty("user.home"));
                    break;
                }
                case 9: {
                    File base = this.locatePathImpl(1);
                    retVal = new File(base, "traces");
                    break;
                }
                default: {
                    retVal = super.locatePathImpl(key);
                }
            }
            return retVal;
        }
    }

    private static class UnsupportedAccess
    extends SystemAccess {
        private UnsupportedAccess() {
        }

        @Override
        protected boolean meetsRequirementImpl(int type, StringBuffer resultBuffer) {
            resultBuffer.append("Operating system is not supported.");
            if (lastMessage != null) {
                resultBuffer.append("\n").append(lastMessage);
            }
            return false;
        }

        @Override
        protected boolean isSupportedImpl(StringBuffer resultBuffer) {
            this.meetsRequirementImpl(0, resultBuffer);
            return false;
        }
    }
}

