/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import java.util.Locale;

public abstract class SystemInfo {
    private static final SystemInfo theInstance = SystemInfo.createInstance();
    public static final int OS_MACOSX = 1;
    public static final int OS_WIN = 2;
    public static final int OS_LINUX = 3;
    public static final int OS_HPUX = 4;
    public static final int OS_AIX = 5;
    public static final int OS_SOLARIS = 6;
    public static final int OS_DARWIN = 7;
    public static final int OS_MIN = 1;
    public static final int OS_MAX = 7;
    public static final int CLASS_UNSUPPORTED = 0;
    public static final int CLASS_UNIX = 1;
    public static final int CLASS_WINDOWS = 2;
    public static final int CLASS_MACOSX = 3;
    public static final int WS_MAC = 1;
    public static final int WS_X11 = 2;
    public static final int WS_WINDOWS = 3;
    private static String mArchitectureSuffix = null;

    private SystemInfo() {
    }

    private static SystemInfo createInstance() {
        SystemInfo retVal = null;
        String osname = System.getProperty("os.name");
        retVal = (osname = osname.toUpperCase(Locale.US)).startsWith("MAC") ? new MacOSXInfo() : (osname.startsWith("DARWIN") ? new DarwinInfo() : (osname.startsWith("WINDOWS") ? new WindowsInfo() : (osname.startsWith("SOLARIS") || osname.startsWith("SUNOS") ? new SolarisInfo() : (osname.startsWith("HP-UX") ? new HPUXInfo() : (osname.startsWith("AIX") ? new AIXInfo() : (osname.startsWith("LINUX") ? new LinuxInfo() : new UnsupportedInfo()))))));
        return retVal;
    }

    public static SystemInfo getInstance() {
        return theInstance;
    }

    public static int getOperatingSystem() {
        return theInstance.getOperatingSystemImpl();
    }

    public static String getOperatingSystemName() {
        return theInstance.getOperatingSystemNameImpl();
    }

    public static final String getOSVersion() {
        return theInstance.getOSVersionImpl();
    }

    public static int getOSClass() {
        return theInstance.getOSClassImpl();
    }

    public static int getWindowSystem() {
        return theInstance.getWindowSystemImpl();
    }

    public static boolean isOSSupported() {
        int os = SystemInfo.getOperatingSystem();
        return os >= 1 && os <= 7;
    }

    public static String getArchitectureSuffix() {
        if (mArchitectureSuffix == null) {
            String[] keyArray = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode"};
            for (int a = 0; a < keyArray.length; ++a) {
                String t = System.getProperty(keyArray[a]);
                if (t == null) continue;
                mArchitectureSuffix = "64".equals(t) ? "64" : "";
                break;
            }
        }
        return mArchitectureSuffix;
    }

    public abstract int getOperatingSystemImpl();

    public abstract String getOperatingSystemNameImpl();

    public abstract int getOSClassImpl();

    public abstract int getWindowSystemImpl();

    public final String getOSVersionImpl() {
        return System.getProperty("os.version");
    }

    public static class UnsupportedInfo
    extends SystemInfo {
        private UnsupportedInfo() {
        }

        @Override
        public int getOperatingSystemImpl() {
            return 0;
        }

        @Override
        public String getOperatingSystemNameImpl() {
            return "UNSUPPORTED";
        }

        @Override
        public int getOSClassImpl() {
            return 0;
        }

        @Override
        public int getWindowSystemImpl() {
            return 0;
        }
    }

    private static class DarwinInfo
    extends SystemInfo {
        private DarwinInfo() {
        }

        @Override
        public int getOperatingSystemImpl() {
            return 7;
        }

        @Override
        public int getOSClassImpl() {
            return 1;
        }

        @Override
        public int getWindowSystemImpl() {
            return 2;
        }

        @Override
        public String getOperatingSystemNameImpl() {
            return "DARWIN";
        }
    }

    public static class MacOSXInfo
    extends SystemInfo {
        private MacOSXInfo() {
        }

        @Override
        public int getOperatingSystemImpl() {
            return 1;
        }

        @Override
        public int getOSClassImpl() {
            return 3;
        }

        @Override
        public int getWindowSystemImpl() {
            return 1;
        }

        @Override
        public String getOperatingSystemNameImpl() {
            return "MACOSX";
        }
    }

    public static class WindowsInfo
    extends SystemInfo {
        private WindowsInfo() {
        }

        @Override
        public int getOperatingSystemImpl() {
            return 2;
        }

        @Override
        public int getOSClassImpl() {
            return 2;
        }

        @Override
        public int getWindowSystemImpl() {
            return 3;
        }

        @Override
        public String getOperatingSystemNameImpl() {
            return "WINDOWS";
        }
    }

    public static class AIXInfo
    extends SystemInfo {
        private AIXInfo() {
        }

        @Override
        public int getOperatingSystemImpl() {
            return 5;
        }

        @Override
        public int getOSClassImpl() {
            return 1;
        }

        @Override
        public int getWindowSystemImpl() {
            return 2;
        }

        @Override
        public String getOperatingSystemNameImpl() {
            return "AIX";
        }
    }

    public static class HPUXInfo
    extends SystemInfo {
        private HPUXInfo() {
        }

        @Override
        public int getOperatingSystemImpl() {
            return 4;
        }

        @Override
        public int getOSClassImpl() {
            return 1;
        }

        @Override
        public int getWindowSystemImpl() {
            return 2;
        }

        @Override
        public String getOperatingSystemNameImpl() {
            return "HPUX";
        }
    }

    public static class SolarisInfo
    extends SystemInfo {
        private SolarisInfo() {
        }

        @Override
        public int getOperatingSystemImpl() {
            return 6;
        }

        @Override
        public int getOSClassImpl() {
            return 1;
        }

        @Override
        public int getWindowSystemImpl() {
            return 2;
        }

        @Override
        public String getOperatingSystemNameImpl() {
            return "SUN";
        }
    }

    private static class LinuxInfo
    extends SystemInfo {
        private LinuxInfo() {
        }

        @Override
        public int getOperatingSystemImpl() {
            return 3;
        }

        @Override
        public int getOSClassImpl() {
            return 1;
        }

        @Override
        public int getWindowSystemImpl() {
            return 2;
        }

        @Override
        public String getOperatingSystemNameImpl() {
            return "LINUX";
        }
    }
}

