/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.micro.Installation;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.VersionInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = -4177049200287884854L;
    public static final String __PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/micro/Version.java#10 $";
    private static final DecimalFormat COMPONENT_FORMAT = new DecimalFormat("00");
    public static final int VT_UNKOWN = 0;
    public static final int VT_SAPGUI = 1;
    public static final int VT_SAPWDP = 2;
    public static final int VT_SAPNWBC = 5;
    private static final Pattern STRINGPATTERN = Pattern.compile("([0-9]+)\\.?([0-9]{2,2})(alpha|beta|rc|rev|a|b|r)?([0-9]+){0,2}\\.{0,1}([0-9]{0,2})", 2);
    private static final Pattern NUMERICPATTERN = Pattern.compile("([@ABE]{0,1})([0-9]{2,2})([0-9]{2,2})([0-9]{2,2})([0-9]{2,2})([0-9]{2,2})([0-9]{2,2})", 2);
    private boolean mStrict = true;
    private String[] mTypeToString = this.initTypeToString();
    private int[] mVersionComponents = this.initVersionComponents();
    private int mProductType = 0;
    private Integer mHashCode;
    public static final Version CURRENT = Version.getCurrent();

    private Version() {
        this.mHashCode = null;
    }

    public Version(Version v) {
        this.mProductType = v.mProductType;
        System.arraycopy(v.mVersionComponents, 0, this.mVersionComponents, 0, v.mVersionComponents.length);
        this.mHashCode = null;
    }

    public static Version valueOf(String v, int vType) {
        Version retVal = Version.valueOf(v);
        retVal.mProductType = vType;
        return retVal;
    }

    public static Version valueOf(String v) {
        Version retVal = new Version();
        Matcher m = NUMERICPATTERN.matcher(v);
        if (m.matches()) {
            retVal.parseFromNumeric(v);
        } else {
            retVal.parseFromString(v);
        }
        if (retVal.mProductType == 0) {
            retVal.mProductType = Version.guessVersionType();
        }
        return retVal;
    }

    private static Version getCurrent() {
        return Version.valueOf(VersionInfo.getJavaVersion());
    }

    public static String getLibVersion() {
        return VersionInfo.getLibVersion();
    }

    private int[] initVersionComponents() {
        return new int[]{0, 0, 0, 4, 0, 0};
    }

    private String[] initTypeToString() {
        return new String[]{"", "alpha", "beta", "rc", "rev"};
    }

    private void parseFromString(String v) {
        if ((v = v.toLowerCase()).indexOf("SAPGUI for Java".toLowerCase()) >= 0) {
            v = v.replaceAll("SAPGUI for Java".toLowerCase(), "");
            this.mProductType = 1;
        } else if (v.indexOf("SAPGUI".toLowerCase()) >= 0) {
            v = v.replaceAll("SAPGUI".toLowerCase(), "");
            this.mProductType = 1;
        } else if (v.indexOf("SAPWDP Client for Java".toLowerCase()) >= 0) {
            v = v.replaceAll("SAPWDP Client for Java".toLowerCase(), "");
            this.mProductType = 2;
        } else if (v.indexOf("SAPWDP".toLowerCase()) >= 0) {
            v = v.replaceAll("SAPWDP".toLowerCase(), "");
            this.mProductType = 2;
        } else if (v.indexOf("SAPNWBC Client for Java".toLowerCase()) >= 0) {
            v = v.replaceAll("SAP Netweaver Business Client".toLowerCase(), "");
            this.mProductType = 5;
        } else if (v.indexOf("SAPNWBC".toLowerCase()) >= 0) {
            v = v.replaceAll("SAPNWBC".toLowerCase(), "");
            this.mProductType = 5;
        } else if (v.indexOf("SAP Frontend".toLowerCase()) >= 0) {
            v = v.replaceAll("SAP Frontend".toLowerCase(), "");
            this.mProductType = 0;
        } else {
            this.mProductType = 0;
        }
        v = v.replaceAll(".app", "");
        v = v.replaceAll(" ", "");
        Matcher m = STRINGPATTERN.matcher(v);
        int groupNum = 0;
        if (m.matches()) {
            this.mVersionComponents = this.initVersionComponents();
            for (int a = 0; a < this.mVersionComponents.length; ++a) {
                if (a == 2) continue;
                int start = m.start(++groupNum);
                int end = m.end(groupNum);
                if (start < 0 || end < 0) continue;
                String grp = v.substring(start, end);
                if (a == 3) {
                    if ("alpha".equals(grp) || "a".equals(grp)) {
                        this.mVersionComponents[a] = 1;
                        continue;
                    }
                    if ("beta".equals(grp) || "b".equals(grp)) {
                        this.mVersionComponents[a] = 2;
                        continue;
                    }
                    if ("rc".equals(grp) || "rc".equals(grp)) {
                        this.mVersionComponents[a] = 3;
                        continue;
                    }
                    if (!"rev".equals(grp) && !"r".equals(grp)) continue;
                    this.mVersionComponents[a] = 4;
                    continue;
                }
                if (grp.length() <= 0) continue;
                this.mVersionComponents[a] = Integer.parseInt(grp);
            }
        }
    }

    private void parseFromNumeric(String v) {
        Matcher m = NUMERICPATTERN.matcher(v);
        int groupNum = 1;
        if (m.matches()) {
            if (m.start(1) >= 0 && m.end(1) >= 0 && m.start(1) != m.end(1)) {
                String grp = v.substring(m.start(1), m.end(1));
                this.mProductType = grp.charAt(0) - 64;
            }
            for (int a = 0; a < this.mVersionComponents.length; ++a) {
                String grp;
                int start = m.start(++groupNum);
                int end = m.end(groupNum);
                if (start < 0 || end < 0 || start < 0 || end < 0 || (grp = v.substring(start, end)).length() <= 0) continue;
                this.mVersionComponents[a] = Integer.parseInt(grp);
            }
        }
    }

    static int guessVersionType() {
        int retVal = 0;
        String productType = System.getProperty("com.sap.platin.productType");
        if (productType != null) {
            if ("SAPGUI".equals(productType)) {
                retVal = 1;
            } else if ("SAPWDP".equals(productType)) {
                retVal = 2;
            } else if ("SAPNWBC".equals(productType)) {
                retVal = 5;
            }
        } else {
            ClassLoader cl = Version.class.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : Version.class.getClassLoader();
            String[] descrs = new String[]{"com/sap/platin/micro/SAPGUIDescription.class", "com/sap/platin/micro/SAPWDPDescription.class", "com/sap/platin/micro/SAPNWBCDescription.class"};
            URL resourceUrl = null;
            String name = null;
            for (String r : descrs) {
                resourceUrl = cl.getResource(r);
                if (resourceUrl == null) continue;
                name = r;
                break;
            }
            if (name != null) {
                if (descrs[0].equals(name)) {
                    retVal = 1;
                } else if (descrs[1].equals(name)) {
                    retVal = 2;
                } else if (descrs[2].equals(name)) {
                    retVal = 5;
                }
            } else {
                Version v = Installation.getRunningVersionFromFile();
                if (v != null) {
                    retVal = v.getProductType();
                } else {
                    URL url = cl.getResource("com/sap/platin/base/application/GuiApplication.class");
                    if (url != null) {
                        url = cl.getResource("com/sap/platin/r3/R3Tag.class");
                        retVal = url != null ? 1 : 2;
                    }
                }
            }
        }
        return retVal;
    }

    public void setStrict(boolean strict) {
        this.mStrict = strict;
    }

    public void setProductType(int type) {
        if (type != this.mProductType) {
            if (this.mProductType == 0) {
                this.mProductType = type;
            } else if (this.mStrict) {
                throw new IllegalStateException("Can't change already defined product type " + this.mProductType + " to " + type + ".");
            }
        }
    }

    public boolean isOfSameType(Version v) {
        boolean retVal = false;
        if (v != null) {
            retVal = this.getProductType() == v.getProductType();
        }
        return retVal;
    }

    public boolean isOfSameType(int type) {
        return this.getProductType() == type;
    }

    public boolean isOfType(Version v) {
        return this.isOfType(v.getProductType());
    }

    public boolean isOfType(int type) {
        return (this.getProductType() & type) == type;
    }

    public int getProductType() {
        return this.mProductType;
    }

    public String getOfficialName() {
        String retVal = "SAP Frontend";
        if (this.getProductType() == 1) {
            retVal = "SAP GUI for the Java Environment";
        } else if (this.getProductType() == 2) {
            retVal = "Web Dynpro Client for Java";
        } else if (this.getProductType() == 5) {
            retVal = "SAP Netweaver Business Client";
        }
        return retVal;
    }

    public String getLongName() {
        String retVal = "SAP Frontend";
        if (this.getProductType() == 1) {
            retVal = "SAP GUI for Java";
        } else if (this.getProductType() == 2) {
            retVal = "SAP WDP Client for Java";
        } else if (this.getProductType() == 5) {
            retVal = "SAP Netweaver Business Client";
        }
        return retVal;
    }

    private String getCompressedLongName() {
        String retVal = "SAPFrontend";
        if (this.getProductType() == 1) {
            retVal = "SAPGUI for Java";
        } else if (this.getProductType() == 2) {
            retVal = "SAPWDP Client for Java";
        } else if (this.getProductType() == 5) {
            retVal = "SAP Netweaver Business Client";
        }
        return retVal;
    }

    public String getCompressedName() {
        String retVal = "SAPFrontend";
        if (this.getProductType() == 1) {
            retVal = "SAPGUI";
        } else if (this.getProductType() == 2) {
            retVal = "SAPWDP";
        } else if (this.getProductType() == 5) {
            retVal = "SAPNWBC";
        }
        return retVal;
    }

    public String getShortName() {
        String retVal = "SAP Frontend";
        if (this.getProductType() == 1) {
            retVal = "SAP GUI";
        } else if (this.getProductType() == 2) {
            retVal = "SAP WDP";
        } else if (this.getProductType() == 5) {
            retVal = "SAP NWBC";
        }
        return retVal;
    }

    public String getNumericVersionString() {
        String retVal = "";
        for (int a = 0; a < this.mVersionComponents.length; ++a) {
            retVal = retVal + COMPONENT_FORMAT.format(this.mVersionComponents[a]).toString();
        }
        return retVal;
    }

    public String getFullNumericVersionString() {
        String retVal = this.getStringForType(this.getProductType());
        retVal = retVal + this.getNumericVersionString();
        return retVal;
    }

    private String getStringForType(int type) {
        return new String(new char[]{(char)(64 + type)});
    }

    public String getLongVersion() {
        String retVal = "";
        String relMinor = COMPONENT_FORMAT.format(this.mVersionComponents[1]).toString();
        retVal = retVal + this.mVersionComponents[0] + "." + relMinor;
        String relType = this.mTypeToString[this.mVersionComponents[3]];
        if (this.mVersionComponents[4] > 0 || this.mVersionComponents[5] > 0) {
            retVal = retVal + " " + relType + " " + this.mVersionComponents[4];
            if (this.mVersionComponents[5] > 0) {
                retVal = retVal + "." + this.mVersionComponents[5];
            }
        }
        return retVal;
    }

    public String getShortVersion() {
        String retVal = "";
        String relMinor = COMPONENT_FORMAT.format(this.mVersionComponents[1]).toString();
        retVal = retVal + this.mVersionComponents[0] + "." + relMinor;
        String relType = this.mTypeToString[this.mVersionComponents[3]];
        if (this.mVersionComponents[4] > 0 || this.mVersionComponents[5] > 0) {
            retVal = retVal + relType + this.mVersionComponents[4];
            if (this.mVersionComponents[5] > 0) {
                retVal = retVal + "." + this.mVersionComponents[5];
            }
        }
        return retVal;
    }

    public String getStaticProductDirName() {
        String retVal = null;
        switch (SystemInfo.getOSClass()) {
            case 1: 
            case 3: {
                retVal = this.getCompressedName();
                break;
            }
            case 2: {
                retVal = this.getCompressedLongName();
            }
        }
        return retVal;
    }

    public String getProductDirName() {
        String retVal = null;
        switch (SystemInfo.getOSClass()) {
            case 1: {
                retVal = this.getStaticProductDirName() + this.getShortVersion();
                break;
            }
            case 2: 
            case 3: {
                retVal = this.getStaticProductDirName() + " " + this.getShortVersion();
            }
        }
        return retVal;
    }

    public String getOfficialProductName() {
        String retVal = this.getOfficialName() + " " + this.getLongVersion();
        return retVal;
    }

    public String getFullProductName() {
        String retVal = this.getLongName() + " " + this.getLongVersion();
        return retVal;
    }

    public String getCompressedFullProductName() {
        String retVal = this.getCompressedLongName() + " " + this.getLongVersion();
        return retVal;
    }

    public String getLongProductName() {
        String retVal = this.getShortName() + " " + this.getLongVersion();
        return retVal;
    }

    public String getCompressedProductName() {
        String retVal = this.getCompressedName() + this.getShortVersion();
        return retVal;
    }

    public String toString() {
        return this.getFullProductName();
    }

    public String dumpVersion() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getProductType()).append(":").append(this.getNumericVersionString());
        buf.append(":").append(this.getLongProductName());
        return buf.toString();
    }

    public static final int compare(String name1, String name2) {
        Version v1 = Version.valueOf(name1);
        Version v2 = Version.valueOf(name2);
        return v1.compareTo(v2);
    }

    @Override
    public int compareTo(Version that) {
        int retVal = -1;
        if (that == null) {
            throw new IllegalArgumentException("Can't compare " + this.getFullNumericVersionString() + " with <null>");
        }
        if (this.getProductType() != that.getProductType()) {
            throw new IllegalArgumentException("Product type " + this.getProductType() + " is not comparable to  " + that.getProductType());
        }
        retVal = this.getNumericVersionString().compareTo(that.getNumericVersionString());
        return retVal;
    }

    public boolean equals(Object obj) {
        boolean retVal = false;
        if (obj != null && obj instanceof Version) {
            Version that = (Version)obj;
            retVal = this.getFullNumericVersionString().equals(that.getFullNumericVersionString());
        }
        return retVal;
    }

    public int hashCode() {
        if (this.mHashCode == null) {
            int retVal = 29;
            int hashMultiplier = 59;
            for (int a = 0; a < this.mVersionComponents.length; ++a) {
                retVal += hashMultiplier * this.mVersionComponents[a];
            }
            this.mHashCode = new Integer(retVal += hashMultiplier * this.mProductType);
        }
        return this.mHashCode;
    }

    public static void main(String[] args) {
        Version v = CURRENT;
        if (args.length == 0) {
            System.out.println("Version type            : " + v.getProductType());
            System.out.println("Numeric Version         : " + v.getFullNumericVersionString());
            System.out.println("Short Version           : " + v.getShortVersion());
            System.out.println("Long Version            : " + v.getLongVersion());
            System.out.println("Short Name              : " + v.getShortName());
            System.out.println("Long Name               : " + v.getLongName());
            System.out.println("Compressed Product Name : " + v.getCompressedProductName());
            System.out.println("Long Product Name       : " + v.getLongProductName());
            System.out.println("Full Product Name       : " + v.getFullProductName());
            System.out.println("Official Product Name   : " + v.getOfficialProductName());
            System.exit(0);
        }
        if ("JavaFullVersion".equals(args[0])) {
            System.out.println(v.getFullProductName());
        } else if ("JavaVersion".equals(args[0])) {
            System.out.println(v.getLongVersion());
        } else if ("VersionNumber".equals(args[0])) {
            System.out.println(v.getNumericVersionString());
        } else if ("ShortVersion".equals(args[0])) {
            System.out.println(v.getShortVersion());
        } else if ("interactive".equals(args[0])) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String inputString = "";
            block2: while (true) {
                try {
                    while (true) {
                        System.out.print("\nEnter version string: ");
                        inputString = reader.readLine();
                        if ("quit".equals(inputString)) break block2;
                        Version v2 = Version.valueOf(inputString);
                        System.out.println("InputString             : " + inputString);
                        System.out.println("Version type            : " + v2.getProductType());
                        System.out.println("Numeric Version         : " + v2.getFullNumericVersionString());
                        System.out.println("Short Version           : " + v2.getShortVersion());
                        System.out.println("Long Version            : " + v2.getLongVersion());
                        System.out.println("Short Name              : " + v2.getShortName());
                        System.out.println("Long Name               : " + v2.getLongName());
                        System.out.println("Compressed Product Name : " + v2.getCompressedProductName());
                        System.out.println("Long Product Name       : " + v2.getLongProductName());
                        System.out.println("Full Product Name       : " + v2.getFullProductName());
                        System.out.println("Official Product Name   : " + v2.getOfficialProductName());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            System.exit(0);
        }
    }
}

