/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.trace.T;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Win32RegistryUtils {
    private static final String DEFAULTVALUE = "<NO NAME>";
    private static final String DEFAULTVALUE_VISTA = "(Default)";
    private static final File regCmd = Win32RegistryUtils.locateCommand("reg.exe");
    private static final File cmdCmd = Win32RegistryUtils.locateCommand("cmd.exe");

    public static boolean isRegistryAvailable() {
        boolean retVal = false;
        try {
            String key = "HKCU\\Volatile Environment";
            String value = Win32RegistryUtils.getRegistryData(key, "APPDATA");
            retVal = value != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String getRegistryData(String key, String value) {
        String retVal = null;
        if (key != null && key.length() > 0) {
            try {
                boolean useDefault = value == null || value.length() == 0;
                ArrayList<String> operation = new ArrayList<String>();
                operation.add(regCmd.getAbsolutePath());
                operation.add("query");
                operation.add(key);
                if (useDefault) {
                    operation.add("/ve");
                } else {
                    operation.add("/v");
                    operation.add(value);
                }
                ProcessBuilder pb = new ProcessBuilder(operation);
                Process p = pb.start();
                String line = null;
                BufferedReader ir = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = ir.readLine()) != null) {
                    line = line.trim();
                    if (!useDefault) {
                        retVal = Win32RegistryUtils.parseLine(line, value);
                    } else {
                        retVal = Win32RegistryUtils.parseLine(line, DEFAULTVALUE);
                        if (retVal == null) {
                            retVal = Win32RegistryUtils.parseLine(line, DEFAULTVALUE_VISTA);
                        }
                    }
                    if (retVal == null) continue;
                }
                if (p.waitFor() != 0) {
                    retVal = null;
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        T.race("MICRO", "Win32RegistryUtils.requestRegistryValue key: " + key + " value: " + value + " return: " + retVal);
        return retVal;
    }

    public static boolean setRegistryData(String key, String value, String data) {
        return Win32RegistryUtils.setRegistryData(key, value, data, "REG_SZ");
    }

    public static boolean setRegistryData(String key, String value, String data, String type) {
        int rc = -1;
        if (key != null && key.length() > 0) {
            try {
                ArrayList<String> operation = new ArrayList<String>();
                operation.add(regCmd.getAbsolutePath());
                operation.add("add");
                operation.add(key);
                if (value == null || value.length() == 0) {
                    operation.add("/ve");
                } else {
                    operation.add("/v");
                    operation.add(value);
                }
                if (data != null) {
                    operation.add("/d");
                    operation.add(data);
                }
                operation.add("/f");
                operation.add("/t");
                operation.add(type);
                ProcessBuilder pb = new ProcessBuilder(operation);
                Process p = pb.start();
                rc = p.waitFor();
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        T.race("MICRO", "Win32RegistryUtils.setRegistryValue key: " + key + " value: " + value + " data: " + data + " sucess: " + (rc == 0));
        return rc == 0;
    }

    public static boolean deleteRegistryData(String key, String value) {
        int rc = -1;
        if (key != null && key.length() > 0) {
            try {
                ArrayList<String> operation = new ArrayList<String>();
                operation.add(regCmd.getAbsolutePath());
                operation.add("delete");
                operation.add(key);
                if (value == null || value.length() == 0) {
                    operation.add("/ve");
                } else {
                    operation.add("/v");
                    operation.add("value");
                }
                operation.add("/f");
                ProcessBuilder pb = new ProcessBuilder(operation);
                Process p = pb.start();
                rc = p.waitFor();
            }
            catch (IOException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        T.race("MICRO", "Win32RegistryUtils.deleteRegistryValue key: " + key + " value: " + value + " sucess: " + (rc == 0));
        return rc == 0;
    }

    public static boolean deleteRegistryKey(String key) {
        int rc = -1;
        if (key != null && key.length() > 0) {
            try {
                String[] operation = new String[]{regCmd.getAbsolutePath(), "delete", key, "/f"};
                ProcessBuilder pb = new ProcessBuilder(operation);
                Process p = pb.start();
                rc = p.waitFor();
            }
            catch (IOException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        T.race("MICRO", "Win32RegistryUtils.deleteRegistryKey key: " + key + " sucess: " + (rc == 0));
        return rc == 0;
    }

    private static String parseLine(String line, String key) {
        String ret = null;
        boolean keyMatched = line.startsWith(key);
        StringTokenizer tok = new StringTokenizer(line, "\t ");
        while (tok.hasMoreElements()) {
            String tmp = tok.nextToken().trim();
            if (!tmp.startsWith("REG_") || !keyMatched && !DEFAULTVALUE.equals(key) && !DEFAULTVALUE_VISTA.equals(key)) continue;
            ret = line.substring(line.lastIndexOf(tmp) + tmp.length()).trim();
            if (!"REG_EXPAND_SZ".equalsIgnoreCase(tmp)) break;
            ret = Win32RegistryUtils.replaceEnvironmentVariables(ret);
            break;
        }
        return ret;
    }

    public static String replaceEnvironmentVariables(String data) {
        String retVal = null;
        if (data == null) {
            return null;
        }
        if (data.indexOf(37) == -1) {
            retVal = data;
        } else {
            try {
                String[] operation = new String[]{cmdCmd.getAbsolutePath(), "/C", "echo " + data};
                ProcessBuilder pb = new ProcessBuilder(operation);
                Process p = pb.start();
                retVal = p.waitFor() == 0 ? new BufferedReader(new InputStreamReader(p.getInputStream())).readLine() : data;
            }
            catch (Throwable e) {
                retVal = data;
            }
        }
        return retVal;
    }

    private static File locateCommand(String command) {
        String path;
        File retVal = null;
        if (command == null) {
            return retVal;
        }
        retVal = new File(command);
        if (retVal.exists()) {
            return retVal;
        }
        if (!command.endsWith(".exe") && !command.endsWith(".EXE") && (retVal = new File(command + ".exe")).exists()) {
            return retVal;
        }
        retVal = null;
        if (command.indexOf(File.separatorChar) < 0 && (path = System.getenv("PATH")) != null && path.length() > 0) {
            StringTokenizer dirs = new StringTokenizer(path, File.pathSeparator);
            while (dirs.hasMoreElements()) {
                String dir = (String)dirs.nextElement();
                File file = new File(dir.trim() + File.separator + command);
                if (file.exists()) {
                    return file;
                }
                if (command.endsWith(".exe") || command.endsWith(".EXE") || !(file = new File(dir.trim() + File.separator + command + ".exe")).exists()) continue;
                return file;
            }
        }
        return retVal;
    }
}

