/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro;

import com.sap.platin.micro.Installation;
import com.sap.platin.micro.PathInfo;
import com.sap.platin.trace.T;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class Win32ShortcutUtils {
    private static final String LIBEXENAME = "JPathShortcut.exe";
    private File mUtilityCommand = null;
    private Installation mInstallation;
    public static final int DESKTOP = 0;
    public static final int INTERNET = 1;
    public static final int PROGRAMS = 2;
    public static final int CONTROLS = 3;
    public static final int PRINTERS = 4;
    public static final int PERSONAL = 5;
    public static final int FAVORITES = 6;
    public static final int STARTUP = 7;
    public static final int RECENT = 8;
    public static final int SENDTO = 9;
    public static final int BITBUCKET = 10;
    public static final int STARTMENU = 11;
    public static final int MYDOCUMENTS = 12;
    public static final int MYMUSIC = 13;
    public static final int MYVIDEO = 14;
    public static final int DESKTOPDIRECTORY = 16;
    public static final int DRIVES = 17;
    public static final int NETWORK = 18;
    public static final int NETHOOD = 19;
    public static final int FONTS = 20;
    public static final int TEMPLATES = 21;
    public static final int COMMON_STARTMENU = 22;
    public static final int COMMON_PROGRAMS = 23;
    public static final int COMMON_STARTUP = 24;
    public static final int COMMON_DESKTOPDIRECTORY = 25;
    public static final int APPDATA = 26;
    public static final int PRINTHOOD = 27;
    public static final int LOCAL_APPDATA = 28;
    public static final int ALTSTARTUP = 29;
    public static final int COMMON_ALTSTARTUP = 30;
    public static final int COMMON_FAVORITES = 31;
    public static final int INTERNET_CACHE = 32;
    public static final int COOKIES = 33;
    public static final int HISTORY = 34;
    public static final int COMMON_APPDATA = 35;
    public static final int WINDOWS = 36;
    public static final int SYSTEM = 37;
    public static final int PROGRAM_FILES = 38;
    public static final int MYPICTURES = 39;
    public static final int PROFILE = 40;
    public static final int SYSTEMX86 = 41;
    public static final int PROGRAM_FILESX86 = 42;
    public static final int PROGRAM_FILES_COMMON = 43;
    public static final int PROGRAM_FILES_COMMONX86 = 44;
    public static final int COMMON_TEMPLATES = 45;
    public static final int COMMON_DOCUMENTS = 46;
    public static final int COMMON_ADMINTOOLS = 47;
    public static final int ADMINTOOLS = 48;
    public static final int CONNECTIONS = 49;
    public static final int COMMON_MUSIC = 53;
    public static final int COMMON_PICTURES = 54;
    public static final int COMMON_VIDEO = 55;
    public static final int RESOURCES = 56;
    public static final int RESOURCES_LOCALIZED = 57;
    public static final int COMMON_OEM_LINKS = 58;
    public static final int CDBURN_AREA = 59;
    public static final int COMPUTERSNEARME = 61;
    public static final int FLAG_CREATE = 32768;
    public static final int FLAG_DONT_VERIFY = 16384;
    public static final int FLAG_NO_ALIAS = 4096;
    public static final int FLAG_PER_USER_INIT = 2048;
    public static final int FLAG_MASK = 65280;
    private static Win32ShortcutUtils mMicroUtil;

    private Win32ShortcutUtils() {
    }

    private void init(Installation inst) {
        File binDir;
        File util;
        if ((this.mInstallation == null || this.mUtilityCommand == null) && (util = new File(binDir = PathInfo.get(inst).locatePath(10006), LIBEXENAME)).exists()) {
            this.mInstallation = inst;
            this.mUtilityCommand = util;
        }
    }

    public static Win32ShortcutUtils getCurrent(Installation inst) {
        if (mMicroUtil == null) {
            mMicroUtil = new Win32ShortcutUtils();
        }
        if (inst != null) {
            mMicroUtil.init(inst);
        }
        return mMicroUtil;
    }

    public File getExePath() {
        return this.mUtilityCommand;
    }

    public Installation getInstallation() {
        return this.mInstallation;
    }

    public static String getFolderLocation(Installation inst, int type) {
        return Win32ShortcutUtils.getCurrent(inst).getFolderLocationImpl(type);
    }

    public static boolean createShortcutFromFile(Installation inst, File fileName) {
        return Win32ShortcutUtils.getCurrent(inst).createShortcutFromFileImpl(fileName);
    }

    public static File[] getWinShortcutPaths(Installation inst) {
        String linkText = inst.getVersion().getProductDirName() + ".lnk";
        String menuShortCut = PathInfo.get(inst).getPart(30036) + File.separator + linkText;
        File shortcutPathCommonDesktop = new File(Win32ShortcutUtils.getFolderLocation(inst, 25), linkText);
        File shortcutPathDesktop = new File(Win32ShortcutUtils.getFolderLocation(inst, 0), linkText);
        File shortcutPathCommonProgram = new File(Win32ShortcutUtils.getFolderLocation(inst, 23), menuShortCut);
        File shortcutPathProgram = new File(Win32ShortcutUtils.getFolderLocation(inst, 2), menuShortCut);
        File[] retValue = new File[]{shortcutPathCommonDesktop, shortcutPathDesktop, shortcutPathCommonProgram, shortcutPathProgram};
        return retValue;
    }

    public boolean createShortcutFromFileImpl(File fileName) {
        int rc = -1;
        if (this.getExePath() != null) {
            Process p = null;
            String[] command = new String[]{this.getExePath().getAbsolutePath(), "createShortcutFromFile", "-f", fileName.getAbsolutePath()};
            try {
                p = Runtime.getRuntime().exec(command);
                rc = p.waitFor();
            }
            catch (IOException e) {
                T.raceError("Win32ShortcutUtils.createShortcutFromFile(): IOException while creating shortcut", e);
            }
            catch (InterruptedException e) {
                T.raceError("Win32ShortcutUtils.createShortcutFromFile(): InterruptedException while creating shortcut", e);
            }
        }
        return rc >= 0;
    }

    public String getFolderLocationImpl(int type) {
        int rc = -1;
        String retValue = null;
        if (this.getExePath() != null) {
            String[] command = new String[]{this.getExePath().getAbsolutePath(), "getPath", "-l", Integer.toString(type)};
            try {
                Process p = Runtime.getRuntime().exec(command);
                rc = p.waitFor();
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = reader.readLine();
                if (rc >= 0) {
                    retValue = line == null ? "" : line;
                }
                reader.close();
            }
            catch (Exception e) {
                e.getCause();
                e.printStackTrace();
            }
        }
        return retValue;
    }
}

