/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.event;

import com.sap.platin.micro.event.EventFilterI;
import com.sap.platin.trace.T;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class GuiEventQueue
extends EventQueue {
    public static final int kMouseEventFilter = 1;
    public static final int kMaxFilter = 2;
    private boolean mFiltersActive = false;
    private Vector<EventFilterI> mMouseEventFilter = new Vector();

    @Override
    public synchronized void push(EventQueue newEventQueue) {
        if (!(newEventQueue instanceof GuiEventQueue)) {
            T.raceError("GuiEventQueue.push() don't replace the GuiEventQueue because all event filtering mechanisms will NO logner work");
        } else {
            ((GuiEventQueue)newEventQueue).mMouseEventFilter = this.mMouseEventFilter;
            ((GuiEventQueue)newEventQueue).mFiltersActive = this.mFiltersActive;
        }
        super.push(newEventQueue);
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        if (T.race("KEYEVENTS") && event.getID() >= 1100 && event.getID() <= 1101) {
            T.race("KEYEVENTS", "GuiEventQueue.dispatchEvent(): InputMethodEvent: " + event);
        }
        if (this.mFiltersActive && this.filterEvent(event)) {
            return;
        }
        super.dispatchEvent(event);
    }

    public void addEventFilter(EventFilterI filter, int eventFilterType) {
        this.mFiltersActive = true;
        if (eventFilterType > 0 && eventFilterType < 2) {
            switch (eventFilterType) {
                case 1: {
                    this.mMouseEventFilter.add(filter);
                    break;
                }
                default: {
                    T.raceError("GuiEventQueue.addEventFilter() unknown event filter type: " + eventFilterType);
                }
            }
        }
    }

    public void removeEventFilter(EventFilterI filter, int eventFilterType) {
        if (eventFilterType > 0 && eventFilterType < 2) {
            switch (eventFilterType) {
                case 1: {
                    this.mMouseEventFilter.remove(filter);
                    break;
                }
                default: {
                    T.raceError("GuiEventQueue.removeEventFilter() unknown event filter type: " + eventFilterType);
                }
            }
        }
        this.checkFilterActivity();
    }

    private boolean filterEvent(AWTEvent event) {
        boolean retVal = false;
        try {
            if (event instanceof MouseEvent && this.mMouseEventFilter.size() > 0) {
                retVal = this.callFilter(this.mMouseEventFilter, event);
            }
        }
        catch (Throwable t) {
            T.raceError("GuiEventQueue.filterEvent() throwable occured: " + t, t);
        }
        return retVal;
    }

    private boolean callFilter(Vector<EventFilterI> filter, AWTEvent event) {
        boolean retVal = false;
        for (int i = 0; i < filter.size(); ++i) {
            retVal |= filter.elementAt(i).filterEvent(event);
        }
        return retVal;
    }

    private void checkFilterActivity() {
        if (this.mMouseEventFilter.size() > 0) {
            this.mFiltersActive = true;
        }
    }
}

