/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.installer;

import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.installer.DefaultMessageHandler;
import com.sap.platin.micro.installer.DefaultProgressHandler;
import com.sap.platin.micro.installer.InstallationController;
import com.sap.platin.micro.installer.InstallationFilter;
import com.sap.platin.micro.installer.InstallationOptions;
import com.sap.platin.micro.installer.MessageHandler;
import com.sap.platin.micro.installer.OptionType;
import com.sap.platin.micro.installer.ProgressHandler;
import com.sap.platin.micro.installer.SlaveMessageHandler;
import com.sap.platin.micro.installer.SlaveMessageReader;
import com.sap.platin.micro.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;

public abstract class AbstractInstallationFilter
implements InstallationFilter {
    protected MessageHandler mMessageHandler = null;
    protected ProgressHandler mProgressHandler = null;

    public static InstallationFilter createInstallationFilter(MessageHandler msg, ProgressHandler prg) {
        InstallationFilter retVal = null;
        retVal = InstallationOptions.elevated.booleanValue() ? AbstractInstallationFilter.createInstallationFilter(InstallationFilter.ControllerType.ElevatedSlave, msg, prg) : AbstractInstallationFilter.createInstallationFilter(InstallationFilter.ControllerType.Standard, msg, prg);
        return retVal;
    }

    public static InstallationFilter createInstallationFilter(InstallationFilter.ControllerType type, MessageHandler msg, ProgressHandler prg) {
        InstallationFilter retVal = AbstractInstallationFilter.createInstallationFilter(type);
        if (InstallationOptions.slave.booleanValue()) {
            SlaveMessageHandler s = new SlaveMessageHandler();
            msg = s;
            prg = s;
        }
        retVal.setHandler(msg, prg);
        return retVal;
    }

    public static InstallationFilter createInstallationFilter(InstallationFilter.ControllerType type) {
        InstallationFilter retVal = null;
        block0 : switch (type) {
            case Standard: {
                retVal = new InstallationController();
                break;
            }
            case ElevatedSlave: {
                switch (SystemInfo.getOSClass()) {
                    case 1: {
                        retVal = new UnixElevationFilter();
                        break block0;
                    }
                    case 3: {
                        retVal = new DummyElevationFilter();
                        break block0;
                    }
                    case 2: {
                        retVal = new DummyElevationFilter();
                        break block0;
                    }
                }
                retVal = new InstallationController();
            }
        }
        return retVal;
    }

    @Override
    public void setHandler(MessageHandler messageHandler, ProgressHandler progressHandler) {
        this.mMessageHandler = messageHandler;
        this.mProgressHandler = progressHandler;
        if (this.mMessageHandler == null) {
            this.mMessageHandler = new DefaultMessageHandler();
        }
        if (this.mProgressHandler == null) {
            this.mProgressHandler = new DefaultProgressHandler();
        }
    }

    public static boolean isFilterAvailable(InstallationFilter.ControllerType type) {
        boolean retVal = false;
        switch (type) {
            case Standard: {
                retVal = true;
                break;
            }
            case ElevatedSlave: {
                ElevationInstallationFilter f = (ElevationInstallationFilter)AbstractInstallationFilter.createInstallationFilter(type);
                retVal = f.canElevatePrivileges();
            }
        }
        return retVal;
    }

    private static class MacElevationFilter
    extends ElevationInstallationFilter {
        private MessageHandler mMessageHandler = null;
        private ProgressHandler mProgressHandler = null;

        @Override
        public InstallationFilter.Result addInstallation() {
            return InstallationFilter.Result.Unknown;
        }

        @Override
        public InstallationFilter.Result removeInstallation() {
            return InstallationFilter.Result.Unknown;
        }

        @Override
        public InstallationFilter.Result reinstallInstallation() {
            return InstallationFilter.Result.Unknown;
        }

        @Override
        public boolean canElevatePrivileges() {
            return false;
        }
    }

    private static class DummyElevationFilter
    extends ElevationInstallationFilter {
        private InstallationFilter mFilterDelegate = null;

        @Override
        public void setHandler(MessageHandler msg, ProgressHandler prg) {
            this.mFilterDelegate = new InstallationController(msg, prg);
        }

        @Override
        public InstallationFilter.Result addInstallation() {
            return this.mFilterDelegate.addInstallation();
        }

        @Override
        public InstallationFilter.Result removeInstallation() {
            return this.mFilterDelegate.removeInstallation();
        }

        @Override
        public InstallationFilter.Result reinstallInstallation() {
            return this.mFilterDelegate.reinstallInstallation();
        }

        @Override
        public boolean canElevatePrivileges() {
            return false;
        }
    }

    private static class UnixElevationFilter
    extends ElevationInstallationFilter {
        private String[] mKdesu = new String[]{"kdesu", "-t", "-d", "--noignorebutton", "-i", "guilogon", "--"};
        private String[] mGksu = new String[]{"gksu", "-w", "--"};
        private List<String> mCmd = this.initCommand();

        private List<String> initCommand() {
            List<String> cmd = null;
            String[] cmdString = this.mKdesu;
            File f = SystemUtils.locateCommand(cmdString[0]);
            if (f == null || !f.exists()) {
                cmdString = this.mGksu;
                f = SystemUtils.locateCommand(cmdString[0]);
            }
            if (f != null && f.exists()) {
                cmd = Arrays.asList(cmdString);
            }
            return cmd;
        }

        @Override
        public InstallationFilter.Result addInstallation() {
            InstallationFilter.Result retVal = InstallationFilter.Result.Unknown;
            if (this.mCmd != null) {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.addAll(this.mCmd);
                cmd = this.createSlaveCommand(cmd, "install");
                ProcessBuilder pb = new ProcessBuilder(cmd);
                SlaveMessageReader reader = new SlaveMessageReader(pb, this.mMessageHandler, this.mProgressHandler);
                try {
                    this.mProgressHandler.setSubTaskTitle("Start privileged installer process");
                    retVal = reader.run();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return retVal;
        }

        @Override
        public InstallationFilter.Result removeInstallation() {
            InstallationFilter.Result retVal = InstallationFilter.Result.Unknown;
            if (this.mCmd != null) {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.addAll(this.mCmd);
                cmd = this.createSlaveCommand(cmd, "uninstall");
                ProcessBuilder pb = new ProcessBuilder(cmd);
                SlaveMessageReader reader = new SlaveMessageReader(pb, this.mMessageHandler, this.mProgressHandler);
                try {
                    this.mProgressHandler.setSubTaskTitle("Start privileged installer process");
                    retVal = reader.run();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return retVal;
        }

        @Override
        public InstallationFilter.Result reinstallInstallation() {
            InstallationFilter.Result retVal = InstallationFilter.Result.Unknown;
            if (this.mCmd != null) {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.addAll(this.mCmd);
                cmd = this.createSlaveCommand(cmd, "reinstall");
                ProcessBuilder pb = new ProcessBuilder(cmd);
                SlaveMessageReader reader = new SlaveMessageReader(pb, this.mMessageHandler, this.mProgressHandler);
                try {
                    this.mProgressHandler.setSubTaskTitle("Start privileged installer process");
                    retVal = reader.run();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return retVal;
        }

        @Override
        public boolean canElevatePrivileges() {
            return this.mCmd != null;
        }
    }

    private static abstract class ElevationInstallationFilter
    extends AbstractInstallationFilter {
        private ElevationInstallationFilter() {
        }

        public abstract boolean canElevatePrivileges();

        private File getVMPath() {
            return new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        }

        private File getJarPath() {
            File retVal = null;
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            String name = this.getClass().getName();
            URL resourceUrl = cl.getResource(name = name.replace('.', '/') + ".class");
            if (resourceUrl != null) {
                try {
                    JarURLConnection conn;
                    URL url;
                    if (String.valueOf(resourceUrl).startsWith("jar:file:") && "file".equalsIgnoreCase((url = (conn = (JarURLConnection)resourceUrl.openConnection()).getJarFileURL()).getProtocol())) {
                        JarFile jf = conn.getJarFile();
                        retVal = new File(jf.getName());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return retVal;
        }

        public ArrayList<String> createSlaveCommand(ArrayList<String> cmd, String mode) {
            ArrayList<String> retVal = cmd;
            File vm = this.getVMPath();
            File jarPath = this.getJarPath();
            ArrayList<String> blackList = new ArrayList<String>();
            blackList.add("-e");
            blackList.add("-g");
            cmd.add(vm.getPath());
            if (jarPath != null) {
                cmd.add("-jar");
                cmd.add(jarPath.getPath());
            } else {
                cmd.add("-cp");
                cmd.add(System.getProperty("java.class.path"));
                cmd.add("com.sap.platin.micro.Microkernel");
            }
            cmd.add(mode);
            for (InstallationOptions opt : InstallationOptions.values()) {
                OptionType t = opt.getType();
                String s = opt.getShortKey(true);
                if (t == OptionType.USAGE || !opt.isValueSet()) continue;
                if (t == OptionType.BOOLEAN) {
                    if (!opt.booleanValue()) {
                        s = opt.getShortKey(false);
                    }
                    if (blackList.contains(s)) continue;
                    cmd.add(s);
                    continue;
                }
                Object o = opt.value();
                if (o == null) continue;
                cmd.add(s);
                cmd.add(String.valueOf(o));
            }
            cmd.add("-z");
            return retVal;
        }
    }
}

