/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.installer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class AccessoryJFileChooser
extends JPanel
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JFileChooser mFileChooser;
    private JButton mUp;

    public AccessoryJFileChooser(JFileChooser fc) {
        this.mFileChooser = fc;
        fc.addPropertyChangeListener(this);
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JButton mHome = new JButton(this.getHomeIcon());
        Dimension dim = mHome.getPreferredSize();
        mHome.setMinimumSize(dim);
        mHome.setActionCommand("Home");
        mHome.addActionListener(this);
        this.add(mHome);
        mHome = new JButton(this.getApplicationIcon());
        mHome.setPreferredSize(dim);
        mHome.setActionCommand("App");
        mHome.addActionListener(this);
        this.add(mHome);
        ArrowIcon icon = new ArrowIcon(1);
        icon.setIconSize(new Dimension(16, 16));
        this.mUp = new JButton(icon);
        this.mUp.setActionCommand("up");
        this.mUp.setPreferredSize(dim);
        this.mUp.addActionListener(this);
        this.add(this.mUp);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean update = false;
        String prop = evt.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            File dir = this.mFileChooser.getCurrentDirectory();
            this.mUp.setEnabled(dir.getParentFile() != null);
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            // empty if block
        }
        if (update && this.isShowing()) {
            this.repaint();
        }
    }

    public Icon getHomeIcon() {
        return this.getSystemIcon(System.getProperty("user.home"));
    }

    public Icon getApplicationIcon() {
        return this.getSystemIcon("/Applications");
    }

    public Icon getSystemIcon(String path) {
        Icon icon = null;
        File mFile = new File(path);
        FileView uiFileView = this.mFileChooser.getUI().getFileView(this.mFileChooser);
        FileSystemView fsv = this.mFileChooser.getFileSystemView();
        icon = uiFileView != null ? uiFileView.getIcon(mFile) : fsv.getSystemIcon(mFile);
        if (icon instanceof ImageIcon) {
            Image img = ((ImageIcon)icon).getImage();
            icon = new ImageIcon(img.getScaledInstance(16, 16, 2));
        }
        return icon;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        if (com.equals("Home")) {
            this.mFileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        } else if (com.equals("App")) {
            this.mFileChooser.setCurrentDirectory(new File("/Applications"));
        } else if (com.equals("up")) {
            this.mFileChooser.setCurrentDirectory(this.mFileChooser.getCurrentDirectory().getParentFile());
        }
    }

    class ArrowIcon
    implements Icon,
    SwingConstants {
        private int mWidth = 30;
        private int mHeight = 30;
        private int mDirection = 10;
        private int[] xPoints = new int[8];
        private int[] yPoints = new int[8];

        public ArrowIcon(int direction) {
            this.mDirection = direction;
            this.sizeUpdate();
        }

        private int newSize(int x) {
            int n = x = x > 0 ? x : 0;
            x = x >= 15 ? (x - 15) / 6 * 6 + 15 : (x >= 3 ? (x - 3) / 3 * 3 + 3 : 0);
            return x;
        }

        private void sizeUpdate() {
            int w = this.newSize(this.mWidth) - 1;
            int h = this.newSize(this.mHeight) - 1;
            int dx1 = w / 3;
            int dx2 = 2 * dx1 + 2;
            int dxHalf = w / 2;
            int dyHalf = h / 2;
            int dy1 = h / 3;
            int dy2 = 2 * dy1 + 2;
            if (this.mDirection == 1) {
                this.xPoints[0] = dxHalf;
                this.yPoints[0] = 0;
                this.xPoints[1] = 0;
                this.yPoints[1] = dyHalf;
                this.xPoints[2] = dx1;
                this.yPoints[2] = dyHalf;
                this.xPoints[3] = dx1;
                this.yPoints[3] = h - 1;
                this.xPoints[4] = dx2;
                this.yPoints[4] = h - 1;
                this.xPoints[5] = dx2;
                this.yPoints[5] = dyHalf;
                this.xPoints[6] = w;
                this.yPoints[6] = dyHalf;
                this.xPoints[7] = dxHalf;
                this.yPoints[7] = 0;
            } else if (this.mDirection == 11) {
                this.xPoints[0] = w;
                this.yPoints[0] = dyHalf;
                this.xPoints[1] = dxHalf;
                this.yPoints[1] = 0;
                this.xPoints[2] = dxHalf;
                this.yPoints[2] = dy1;
                this.xPoints[3] = 0;
                this.yPoints[3] = dy1;
                this.xPoints[4] = 0;
                this.yPoints[4] = dy2;
                this.xPoints[5] = dxHalf;
                this.yPoints[5] = dy2;
                this.xPoints[6] = dxHalf;
                this.yPoints[6] = h;
                this.xPoints[7] = w;
                this.yPoints[7] = dyHalf;
            } else if (this.mDirection == 5) {
                this.xPoints[0] = dxHalf;
                this.yPoints[0] = h;
                this.xPoints[1] = w;
                this.yPoints[1] = dyHalf;
                this.xPoints[2] = dx2;
                this.yPoints[2] = dyHalf;
                this.xPoints[3] = dx2;
                this.yPoints[3] = 0;
                this.xPoints[4] = dx1;
                this.yPoints[4] = 0;
                this.xPoints[5] = dx1;
                this.yPoints[5] = dyHalf;
                this.xPoints[6] = 0;
                this.yPoints[6] = dyHalf;
                this.xPoints[7] = dxHalf;
                this.yPoints[7] = h;
            } else {
                this.xPoints[0] = 0;
                this.yPoints[0] = dyHalf;
                this.xPoints[1] = dxHalf;
                this.yPoints[1] = h;
                this.xPoints[2] = dxHalf;
                this.yPoints[2] = dy2;
                this.xPoints[3] = w;
                this.yPoints[3] = dy2;
                this.xPoints[4] = w;
                this.yPoints[4] = dy1;
                this.xPoints[5] = dxHalf;
                this.yPoints[5] = dy1;
                this.xPoints[6] = dxHalf;
                this.yPoints[6] = 0;
                this.xPoints[7] = 0;
                this.yPoints[7] = dyHalf;
            }
        }

        @Override
        public int getIconHeight() {
            return this.mHeight;
        }

        public void setIconSize(Dimension size) {
            this.mHeight = size.height;
            this.mWidth = size.width;
            this.sizeUpdate();
        }

        public Dimension getIconSize() {
            return new Dimension(this.mWidth, this.mHeight);
        }

        @Override
        public int getIconWidth() {
            return this.mWidth;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.mHeight <= 0 || this.mWidth <= 0) {
                return;
            }
            g.translate(x, y);
            if (c.isEnabled()) {
                g.setColor(Color.lightGray);
                g.fillPolygon(this.xPoints, this.yPoints, this.xPoints.length);
            }
            if (c.isEnabled()) {
                g.setColor(c.getForeground());
            } else {
                g.setColor(Color.gray);
            }
            g.drawPolygon(this.xPoints, this.yPoints, this.xPoints.length);
            g.translate(-x, -y);
        }
    }
}

