/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.installer;

import com.sap.platin.micro.DownloadResource;
import com.sap.platin.micro.Installation;
import com.sap.platin.micro.InstallationDescription;
import com.sap.platin.micro.InstallationInfo;
import com.sap.platin.micro.MicroTransaction;
import com.sap.platin.micro.MicroUtils;
import com.sap.platin.micro.PathInfo;
import com.sap.platin.micro.SystemAccess;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.Version;
import com.sap.platin.micro.Win32RegistryUtils;
import com.sap.platin.micro.Win32ShortcutUtils;
import com.sap.platin.micro.installer.DefaultMessageHandler;
import com.sap.platin.micro.installer.DefaultProgressHandler;
import com.sap.platin.micro.installer.InstallationFilter;
import com.sap.platin.micro.installer.InstallationOptions;
import com.sap.platin.micro.installer.LogWriter;
import com.sap.platin.micro.installer.MessageHandler;
import com.sap.platin.micro.installer.MsgSubType;
import com.sap.platin.micro.installer.MsgType;
import com.sap.platin.micro.installer.ProgressHandler;
import com.sap.platin.micro.util.IOUtils;
import com.sap.platin.micro.util.XDGInfo;
import com.sap.platin.trace.T;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstallationController
implements InstallationFilter {
    private InstallationDescription mInstallationDescription = InstallationDescription.createInstance();
    private MessageHandler mMessageHandler = null;
    private ProgressHandler mProgressHandler = null;
    private InstProcessor mInstallationProcessor = this.getInstallationProcessor();
    private File mLockFile = null;

    public InstallationController() {
    }

    public InstallationController(MessageHandler messageHandler, ProgressHandler progressHandler) {
        this.setHandler(messageHandler, progressHandler);
    }

    @Override
    public void setHandler(MessageHandler messageHandler, ProgressHandler progressHandler) {
        this.mMessageHandler = messageHandler;
        this.mProgressHandler = progressHandler;
        if (this.mMessageHandler == null) {
            this.mMessageHandler = new DefaultMessageHandler();
        }
        if (this.mProgressHandler == null) {
            this.mProgressHandler = new DefaultProgressHandler();
        }
    }

    @Override
    public InstallationFilter.Result reinstallInstallation() {
        InstallationFilter.Result retVal = InstallationFilter.Result.Unknown;
        if (T.race("MICRO")) {
            T.race("MICRO", "InstallationController.reinstallInstallation(): Start reinstallation, remove old version ...");
        }
        if (InstallationController.isVersionInstalled(Version.CURRENT)) {
            retVal = this.removeInstallationImpl(true);
            if (T.race("MICRO")) {
                T.race("MICRO", "InstallationController.reinstallInstallation(): old installation has been removed.");
            }
        }
        if (retVal == InstallationFilter.Result.Successful || retVal == InstallationFilter.Result.Unknown) {
            if (T.race("MICRO")) {
                T.race("MICRO", "InstallationController.reinstallInstallation(): Start installation process ...");
            }
            retVal = this.addInstallation();
        }
        if (T.race("MICRO")) {
            T.race("MICRO", "InstallationController.reinstallInstallation(): End of reinstallation process.");
        }
        this.mMessageHandler.setReturnValue(retVal);
        return retVal;
    }

    @Override
    public InstallationFilter.Result removeInstallation() {
        InstallationFilter.Result retVal = InstallationFilter.Result.Unknown;
        if (T.race("MICRO")) {
            T.race("MICRO", "InstallationController.reinstallInstallation(): Start deinstallation process ...");
        }
        retVal = this.removeInstallationImpl(false);
        if (T.race("MICRO")) {
            T.race("MICRO", "InstallationController.reinstallInstallation(): End of deinstallation process.");
        }
        this.mMessageHandler.setReturnValue(retVal);
        return retVal;
    }

    @Override
    public InstallationFilter.Result addInstallation() {
        InstallationFilter.Result retVal = InstallationFilter.Result.Unknown;
        if (T.race("MICRO")) {
            T.race("MICRO", "InstallationController.addInstallation(): Start installation process ...");
        }
        retVal = this.addInstallationImpl(false);
        if (T.race("MICRO")) {
            T.race("MICRO", "InstallationController.addInstallation(): End of installation process.");
        }
        this.mMessageHandler.setReturnValue(retVal);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private InstallationFilter.Result addInstallationImpl(boolean reinstall) {
        block54: {
            retVal = InstallationFilter.Result.Unknown;
            logFile = PathInfo.get(null).locatePath(20001);
            version = Version.CURRENT;
            if (T.race("MICRO")) {
                T.race("MICRO", "InstallationController.addInstallationImpl(): open log file " + logFile);
            }
            try {
                block55: {
                    block57: {
                        block56: {
                            if (InstallationOptions.logfile.isValueSet()) {
                                logFile = (File)InstallationOptions.logfile.value();
                            }
                            if (LogWriter.openLog(logFile)) {
                                retVal = InstallationFilter.Result.Failed;
                            }
                            this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "");
                            this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "");
                            this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "");
                            this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.header2, "Installation details.");
                            if (retVal.failed()) break block55;
                            if (InstallationController.isVersionInstalled(version) && !InstallationOptions.force.booleanValue() && !InstallationOptions.gui.booleanValue()) break block56;
                            sb = new StringBuffer();
                            if (!SystemAccess.meetsRequirement(1, sb) || !SystemAccess.meetsRequirement(2, sb)) {
                                retVal = InstallationFilter.Result.Failed;
                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "System reqirements are not met.");
                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, sb.toString());
                                break block54;
                            }
                            if (SystemInfo.getOSClass() == 0) {
                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Your operating system is not supported.");
                                LogWriter.writeLog(MsgType.error, "Fatal error during installation: The operating system is not supported.");
                                var6_7 = retVal;
                                return var6_7;
                            }
                            installation = Installation.valueOf(version, Installation.Type.CHANGING);
                            installation.setPrefix(this.getPrefix());
                            if (InstallationOptions.installdir.isValueSet()) {
                                installation.setInstallationDir((File)InstallationOptions.installdir.value());
                            } else if (!InstallationOptions.prefix.isValueSet()) {
                                installation.setInstallationDir(PathInfo.get(null).locatePath(10015));
                            } else {
                                installation.setInstallationDir(PathInfo.get(null).locatePath(10014));
                            }
                            LogWriter.writeLog("------------------------------------------------------------");
                            LogWriter.writeLog("System Information");
                            LogWriter.writeLog("------------------------------------------------------------");
                            LogWriter.writeLog(MicroUtils.getInstallationSystemInfo());
                            LogWriter.writeLog("------------------------------------------------------------");
                            LogWriter.writeLog(this.mInstallationDescription.dump());
                            productDir = PathInfo.get(installation).locatePath(10004);
                            if (productDir.exists()) ** GOTO lbl-1000
                            if (!productDir.mkdirs()) {
                                retVal = InstallationFilter.Result.Failed;
                            }
                            if (retVal.failed()) {
                                message = "The versioned product directory : " + productDir + " could not be created. " + "This usually means you do not have the necessary privileges to write into " + installation.getInstallationDir();
                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, message, true);
                            } else lbl-1000:
                            // 2 sources

                            {
                                if ((lockFile = PathInfo.get(installation).locatePath(20002)).exists()) {
                                    retVal = InstallationFilter.Result.Failed;
                                }
                                if (retVal.failed()) {
                                    message = "The installation directory is locked. Either there is another installation process already running or a previous installation failed without being able to clear the lock.Please check if another installation is running and remove " + productDir;
                                    this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, message, true);
                                } else {
                                    if (this.createLockFile(installation)) {
                                        retVal = InstallationFilter.Result.Failed;
                                    }
                                    if (retVal.failed()) {
                                        message = "Unable to lock installation directory: " + String.valueOf(lockFile.getParent()) + ". This usually means you do not have the privileges to install into ths directory.";
                                        this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, message, true);
                                    } else if (this.checkInstallationConditions(installation)) {
                                        retVal = InstallationFilter.Result.Failed;
                                        this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "The installation requirements are not met, installation has been aborted.", true);
                                    } else {
                                        transaction = MicroTransaction.openTransaction(installation, this.mMessageHandler, this.mProgressHandler);
                                        if (transaction == null) {
                                            retVal = InstallationFilter.Result.Failed;
                                        }
                                        if (transaction == null) {
                                            message = "The installation could not start. It seems that there is another installation running inside this Java VM.";
                                            this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, message, true);
                                        } else {
                                            this.mProgressHandler.setTaskTitle("Install " + version.getFullProductName());
                                            numResources = this.mInstallationDescription.getNumberOfResources();
                                            this.mProgressHandler.setRange(0, numResources + 3);
                                            this.mProgressHandler.setValue(0);
                                            if (T.race("MICRO")) {
                                                T.race("MICRO", "InstallationController.addInstallationImpl(): download resources.");
                                            }
                                            if (this.downloadResources(installation, transaction, this.mInstallationDescription)) {
                                                if (T.race("MICRO")) {
                                                    T.race("MICRO", "InstallationController.addInstallationImpl(): abort transaction");
                                                }
                                                transaction.abortTransaction(installation);
                                                retVal = InstallationFilter.Result.Failed;
                                            } else {
                                                if (T.race("MICRO")) {
                                                    T.race("MICRO", "InstallationController.addInstallationImpl(): close transaction");
                                                }
                                                if (transaction.closeTransaction(installation)) {
                                                    retVal = InstallationFilter.Result.Failed;
                                                }
                                            }
                                            if (!retVal.failed()) {
                                                counter = numResources;
                                                this.mProgressHandler.setValue(counter++);
                                                this.mProgressHandler.setSubTaskTitle("Setup " + version.getFullProductName());
                                                this.mProgressHandler.setText("Create start scripts");
                                                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.header3, "Setup " + version.getFullProductName());
                                                if (this.postInstallation(installation)) {
                                                    retVal = InstallationFilter.Result.Failed;
                                                }
                                                if (!retVal.failed()) {
                                                    this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "Start scripts have been created.");
                                                    this.mProgressHandler.setValue(counter++);
                                                    this.mProgressHandler.setText("Register installation");
                                                    if (this.registerInstallation(installation)) {
                                                        retVal = InstallationFilter.Result.Failed;
                                                    }
                                                    if (!retVal.failed()) {
                                                        this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "Installation has been registered.");
                                                        this.mProgressHandler.setValue(counter++);
                                                        this.mProgressHandler.setText("Create desktop icons");
                                                        if (T.race("MICRO")) {
                                                            T.race("MICRO", "InstallationController.addInstallationImpl(): start housekeeping");
                                                        }
                                                        if (this.createDesktopShortcuts(installation)) {
                                                            retVal = InstallationFilter.Result.Failed;
                                                        }
                                                        installation.closeManifest();
                                                        if (T.race("MICRO")) {
                                                            T.race("MICRO", "InstallationController.addInstallationImpl(): manifest closed");
                                                        }
                                                        if (retVal.failed()) {
                                                            this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Desktop shortcuts and/or start menu entries could not be created. At least user specific shortcuts should not fail.");
                                                        } else {
                                                            this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "Desktop icons have been created.");
                                                            InstallationInfo.setStaticApplicationLinks(installation);
                                                            this.mProgressHandler.setValue(counter++);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            this.unlock();
                            break block57;
                        }
                        LogWriter.writeLog(MsgType.success, "=============================================================================");
                        LogWriter.writeLog(MsgType.success, "Install " + version.getLongProductName());
                        LogWriter.writeLog(MsgType.success, "-----------------------------------------------------------------------------");
                        LogWriter.writeLog(MsgType.success, " This version is already installed.");
                        LogWriter.writeLog("=============================================================================");
                        retVal = InstallationFilter.Result.Successful;
                    }
                    if (!retVal.failed()) {
                        if (reinstall) {
                            this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.header2, "Reinstallation of " + version.getFullProductName(), true);
                        } else {
                            this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.header2, "Installation of " + version.getFullProductName(), true);
                        }
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.header2, "Installed succesfully");
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.blockStart, "");
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.header3, "Installation has finished.", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.body, "The installation of the " + version.getLongName() + " has completed successfully.", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.body, "Please find the installation log file here: \"" + logFile.getAbsolutePath() + "\"", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.blockEnd, "");
                        retVal = InstallationFilter.Result.Successful;
                    } else {
                        if (reinstall) {
                            this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Reinstallation of " + version.getFullProductName(), true);
                        } else {
                            this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Installation of " + version.getFullProductName(), true);
                        }
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Installation failed");
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.blockStart, "");
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header3, "Installation has failed.", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.body, "The installation of the " + version.getLongName() + " has failed with fatal errors.", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.body, "Please check the installation log file: \"" + logFile.getAbsolutePath() + "\"", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.blockEnd, "");
                    }
                    LogWriter.writeLog("============================================================");
                    break block54;
                }
                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Unable to open installation log file \"" + logFile + "\".");
                retVal = InstallationFilter.Result.Failed;
            }
            catch (Throwable e) {
                if (reinstall) {
                    this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Reinstallation of " + version.getFullProductName(), true);
                } else {
                    this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Installation of " + version.getFullProductName(), true);
                }
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Installation has not finished succesfully.");
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.blockStart, "");
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header3, "Installation has failed.", true);
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.body, "The installation of the " + Version.CURRENT.getLongName() + " has failed with fatal errors.", true);
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.body, "Please check the installation log file: \"" + logFile.getAbsolutePath() + "\"", true);
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.blockEnd, "");
                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.header2, "Exception details.");
                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.header3, "Internal exception: " + e);
                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "<pre>\n" + T.formatStackTrace("", e) + "\n</pre>\n");
                LogWriter.writeLog(MsgType.error, "Internal exception during installation", e);
                LogWriter.writeLog("=============================================================================");
                retVal = InstallationFilter.Result.Failed;
            }
            finally {
                LogWriter.closeLog();
            }
        }
        this.mMessageHandler.setReturnValue(retVal);
        if (T.race("MICRO")) {
            T.race("MICRO", "InstallationController.addInstallation(): Now installation is done, leave addInstallation.");
        }
        PathInfo.reset();
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallationFilter.Result removeInstallationImpl(boolean reinstall) {
        InstallationFilter.Result retVal;
        block56: {
            if (T.race("MICRO")) {
                T.race("MICRO", "InstallationController.removeInstallation(): Begin deinstallation");
            }
            Version version = Version.CURRENT;
            File logFile = PathInfo.get(null).locatePath(20001);
            String sapClients = PathInfo.getCurrent().getPart(30036);
            retVal = InstallationFilter.Result.Unknown;
            try {
                if (InstallationOptions.logfile.isValueSet()) {
                    logFile = (File)InstallationOptions.logfile.value();
                }
                if (LogWriter.openLog(logFile)) {
                    retVal = InstallationFilter.Result.Failed;
                }
                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "");
                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "");
                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "");
                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.header2, "Remove installation details.");
                LogWriter.writeLog(MsgType.info, "-----------------------------------------------------------");
                LogWriter.writeLog(MsgType.info, "Remove " + version.getFullProductName());
                LogWriter.writeLog(MsgType.info, "-----------------------------------------------------------");
                if (!retVal.failed()) {
                    if (InstallationController.isVersionInstalled(version)) {
                        Installation inst = InstallationInfo.getInstallation(Version.CURRENT);
                        if (inst == null) {
                            retVal = InstallationFilter.Result.Successful;
                            this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "An installation of " + version.getFullProductName() + " could not be located.");
                            break block56;
                        }
                        File lockFile = PathInfo.get(inst).locatePath(20002);
                        File productDir = inst.getProductDir();
                        File instDir = inst.getInstallationDir();
                        StringBuffer sb = new StringBuffer();
                        if (!SystemAccess.meetsRequirement(1, sb)) {
                            retVal = InstallationFilter.Result.Failed;
                        }
                        if (retVal.failed()) {
                            this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "System reqirements are not met.");
                            this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, sb.toString());
                            break block56;
                        }
                        Installation.Validation installationState = inst.isValid();
                        if (installationState == Installation.Validation.EMPTY) {
                            InstallationFilter.Result result = retVal;
                            return result;
                        }
                        if (!productDir.exists()) {
                            InstallationFilter.Result result = retVal;
                            return result;
                        }
                        if (!retVal.failed()) {
                            retVal = InstallationFilter.Result.Successful;
                            this.mProgressHandler.setTaskTitle("Remove " + version.getFullProductName());
                            this.mProgressHandler.setSubTaskTitle("Check if the installation can be removed");
                            this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.header3, "Check if the installation can be removed.");
                            if (lockFile.exists()) {
                                retVal = InstallationFilter.Result.Failed;
                            }
                            if (retVal.failed()) {
                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Another installer process is currently running or a previous installation failed without removing its lock file.");
                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Please check if another installer process is running or remove \"" + lockFile + "\"");
                                InstallationFilter.Result result = retVal;
                                return result;
                            }
                            if (this.createLockFile(inst)) {
                                retVal = InstallationFilter.Result.Failed;
                            }
                            if (retVal.failed()) {
                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Unable to lock installation for removal.\nThis usually means you do not have the necessary privileges to remove " + version.getFullProductName() + " at this location: " + inst.getProductDir());
                                InstallationFilter.Result result = retVal;
                                return result;
                            }
                            File[] files = this.getFilesToDelete(inst);
                            if (files.length > 0) {
                                this.mProgressHandler.setText("Check deinstallation preconditions");
                                if (this.checkUninstallPreconditions(inst, files)) {
                                    retVal = InstallationFilter.Result.Failed;
                                }
                                if (retVal.failed()) {
                                    this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Can not verify all prerequisites to remove the " + version.getLongName() + ".\n" + "Usually this means files can not be deleted because of missing privileges.");
                                    this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "You can check the exact reason for the failure in the installation log file.");
                                } else {
                                    this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "All prerequisites to remove " + version.getLongName() + " have been verified.");
                                    this.mProgressHandler.setSubTaskTitle("Remove installation");
                                    this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.header3, "Remove installation");
                                    this.mProgressHandler.setText("Remove desktop icons");
                                    if (this.removeDesktopShortcuts(inst)) {
                                        retVal = InstallationFilter.Result.Failed;
                                    }
                                    if (retVal.failed()) {
                                        this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "The deinstaller was unable to remove the shortcuts on the desktop and / or application menu entries. The exact reason should be found in the installation log file.");
                                    } else {
                                        this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "Desktop icons have been removed.");
                                        if (this.deregisterInstallation(inst)) {
                                            retVal = InstallationFilter.Result.Failed;
                                        }
                                        if (retVal.failed()) {
                                            this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "The deinstaller was unable to deregister the installation with your desktop management system. The exact reason for this failure should be found in the installation log file.");
                                        } else {
                                            this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "Installation registration has been removed.");
                                            if (this.preDeinstallation(inst)) {
                                                retVal = InstallationFilter.Result.Failed;
                                            }
                                            if (InstallationInfo.remove(inst)) {
                                                retVal = InstallationFilter.Result.Failed;
                                            }
                                            this.mProgressHandler.setText("Installation has been deregistered.");
                                            boolean f = false;
                                            String prodDirName = productDir.getAbsolutePath();
                                            HashSet<File> menuDirs = new HashSet<File>();
                                            for (int a = 0; a < files.length; ++a) {
                                                File parentDir;
                                                File file = files[a];
                                                String label = file.getAbsolutePath();
                                                if (label.startsWith(prodDirName)) {
                                                    label = label.substring(prodDirName.length() + 1);
                                                }
                                                if (file.getName().endsWith(".lnk") && (parentDir = file.getParentFile()).getName().equals(sapClients)) {
                                                    menuDirs.add(parentDir);
                                                }
                                                this.mProgressHandler.setText("Remove file: " + label);
                                                file.delete();
                                                if (!file.exists() || file.getName().equals("GuiStartS.jar")) continue;
                                                LogWriter.writeLog(MsgType.info, "   can't delete " + file);
                                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Can't delete file: " + file);
                                                f = true;
                                            }
                                            if (f) {
                                                String message = "Some files from your gui installation could not be removed. The most common reason for this is that some other process still uses or locks these files.";
                                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, message);
                                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "You should find more information in the installation log file: " + logFile);
                                                this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Please consider manually removing the remaining files below\n" + productDir);
                                                retVal = InstallationFilter.Result.Failed;
                                            } else {
                                                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "Installed files have been removed.");
                                            }
                                            if (SystemInfo.getOSClass() == 2) {
                                                for (File menuDir : menuDirs) {
                                                    StringBuilder msg = new StringBuilder();
                                                    IOUtils.deleteEmptyDirectory(msg, menuDir);
                                                }
                                            }
                                            this.unlock();
                                            StringBuilder msg = new StringBuilder();
                                            boolean results = IOUtils.deleteEmptyDirectories(msg, productDir);
                                            if (SystemInfo.getOSClass() != 2) {
                                                InstallationInfo.removeStaticApplicationLinks(inst, true);
                                            }
                                            if (instDir.getName().equals(sapClients)) {
                                                results |= IOUtils.deleteEmptyDirectory(msg, instDir);
                                            }
                                            if (results) {
                                                LogWriter.writeLog(MsgType.error, msg.toString());
                                                String message = "The deinstaller was unable to remove some directories from your gui installation.The most common reason for this is that some other process still uses or locks the directories.Another common reason are files not related to the installation. So the directories mightnot be empty after removing the installation.";
                                                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, message);
                                                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "You should find more information in the installation log file: " + logFile);
                                                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "Please consider manually removing the remaining files below\n" + productDir);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Unable to open installation log file \"" + logFile + "\".");
                    }
                    if (!retVal.failed()) {
                        if (reinstall) {
                            this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.header2, "Reinstall " + version.getFullProductName(), false);
                            this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.header2, "Previous installation removed");
                        } else {
                            this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.header2, "Remove " + version.getFullProductName(), false);
                            this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.header2, "Installation removed");
                        }
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.blockStart, null);
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.header3, "Deinstallation has finished.", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.body, "The installation of has been removed successfully.", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.body, "Please also find the installation log file here:" + logFile.getAbsolutePath() + "\"", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.success, MsgSubType.blockEnd, null);
                    } else {
                        if (reinstall) {
                            this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Reinstall " + version.getFullProductName(), false);
                        } else {
                            this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Remove " + version.getFullProductName(), false);
                        }
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Deinstallation has not finished succesfully.");
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.blockStart, null);
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header3, "Deinstallation has finished.", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.body, "There were errors removing the installation.", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.body, "Please check the installation log file:" + logFile.getAbsolutePath() + "\"", true);
                        this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.blockEnd, null);
                    }
                    break block56;
                }
                LogWriter.writeLog(MsgType.success, "=============================================================================");
                LogWriter.writeLog(MsgType.success, "Remove " + version.getLongProductName());
                LogWriter.writeLog(MsgType.success, "-----------------------------------------------------------------------------");
                LogWriter.writeLog(MsgType.success, "This version is not installed.");
                LogWriter.writeLog(MsgType.success, "=============================================================================");
            }
            catch (Throwable e) {
                if (reinstall) {
                    this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Reinstall " + version.getFullProductName(), false);
                } else {
                    this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header2, "Remove " + version.getFullProductName(), false);
                }
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.blockStart, null);
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.header3, "Deinstallation has finished.", true);
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.body, "There were errors removing the installation.", true);
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.body, "Please check the installation log file:" + logFile.getAbsolutePath() + "\"", true);
                this.mMessageHandler.addSummaryMessage(MsgType.failure, MsgSubType.blockEnd, null);
                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.header3, "Exception details.");
                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.header3, "Internal exception: " + e);
                this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.body, "<pre>\n" + T.formatStackTrace("", e) + "\n</pre>");
                LogWriter.writeLog(MsgType.error, "Installation has not been removed due to internal exception", e);
                LogWriter.writeLog("============================================================");
            }
            finally {
                LogWriter.closeLog();
                this.unlock();
            }
        }
        if (T.race("MICRO")) {
            T.race("MICRO", "InstallationController.removeInstallation(): Now deinstallation is done, leave removeInstallation.");
        }
        PathInfo.reset();
        return retVal;
    }

    public static boolean isVersionInstalled(Version v) {
        Installation.Validation installationState;
        boolean retVal = false;
        Installation installation = InstallationInfo.getInstallation(v);
        if (installation != null && (installationState = installation.isValid()) == Installation.Validation.VALID) {
            retVal = true;
        }
        return retVal;
    }

    private InstProcessor getInstallationProcessor() {
        if (this.mInstallationProcessor == null) {
            int systemClass = SystemInfo.getOSClass();
            switch (systemClass) {
                case 3: {
                    this.mInstallationProcessor = new MacInstProcessor();
                    break;
                }
                case 2: {
                    this.mInstallationProcessor = new Win32InstProcessor();
                    break;
                }
                case 1: {
                    this.mInstallationProcessor = new UnixInstProcessor();
                }
            }
        }
        return this.mInstallationProcessor;
    }

    private File getPrefix() {
        return (File)InstallationOptions.prefix.value();
    }

    private boolean createLockFile(Installation inst) {
        boolean failed = false;
        try {
            this.mLockFile = PathInfo.get(inst).locatePath(20002);
            if (!(failed |= !this.mLockFile.createNewFile())) {
                this.mLockFile.deleteOnExit();
            } else {
                LogWriter.writeLog(MsgType.error, "MicroTransaction.createLockFile(): another update is currently running.");
            }
        }
        catch (IOException e) {
            failed = true;
            LogWriter.writeLog(MsgType.error, "MicroTransaction.createLockFile() failed with exception: " + e.getMessage());
        }
        return failed;
    }

    private boolean unlock() {
        boolean failed = false;
        if (this.mLockFile != null) {
            failed |= !this.mLockFile.delete();
            this.mLockFile = null;
        }
        return failed;
    }

    private File[] getFilesToDelete(Installation inst) {
        File[] files = inst.getFiles();
        if (files.length == 0) {
            files = this.getInstalledFiles(inst);
        }
        return files;
    }

    private File[] getInstalledFiles(Installation inst) {
        TreeSet<File> files = new TreeSet<File>();
        File prodDir = PathInfo.get(inst).locatePath(10004);
        File[] directories = new File[]{PathInfo.get(inst).locatePath(10006), PathInfo.get(inst).locatePath(10008), PathInfo.get(inst).locatePath(10011), PathInfo.get(inst).locatePath(10010), PathInfo.get(inst).locatePath(10009)};
        for (int a = 0; a < directories.length; ++a) {
            if (prodDir.equals(directories[a])) continue;
            File dir = directories[a];
            files.addAll(IOUtils.getFilesBelow(dir));
        }
        return files.toArray(new File[files.size()]);
    }

    private boolean checkInstallationConditions(Installation inst) {
        boolean failed = false;
        InstProcessor instProc = this.getInstallationProcessor();
        if (instProc != null) {
            failed |= instProc.checkInstallationRequirements(inst);
        }
        return failed;
    }

    private boolean checkUninstallPreconditions(Installation inst, File[] files) {
        boolean failed = false;
        InstProcessor instProc = this.getInstallationProcessor();
        if (instProc != null) {
            failed |= instProc.checkUninstall(inst);
        }
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < files.length; ++a) {
            File file = files[a];
            if (!file.exists() || IOUtils.canDelete(file)) continue;
            sb.append("Can not delete file: ").append(file).append("\n");
            failed = true;
        }
        if (failed) {
            LogWriter.writeLog(MsgType.error, "InstallationController.checkUninstallPreconditions(): \n" + sb);
        }
        return failed;
    }

    private boolean createDesktopShortcuts(Installation installation) {
        boolean failed = false;
        InstProcessor instProc = this.getInstallationProcessor();
        if (instProc != null && InstallationOptions.desktopicons.booleanValue()) {
            failed |= instProc.createDesktopShortcuts(installation);
        }
        return failed;
    }

    private boolean removeDesktopShortcuts(Installation inst) {
        boolean failed = false;
        InstProcessor instProc = this.getInstallationProcessor();
        if (instProc != null) {
            failed |= instProc.removeDesktopShortcuts(inst);
        }
        return failed;
    }

    private boolean registerInstallation(Installation installation) {
        boolean failed = false;
        InstProcessor instProc = this.getInstallationProcessor();
        if (instProc != null) {
            failed |= instProc.registerInstallation(installation);
        }
        return failed;
    }

    private boolean deregisterInstallation(Installation inst) {
        boolean failed = false;
        InstProcessor instProc = this.getInstallationProcessor();
        if (instProc != null) {
            failed |= instProc.deregisterInstallation(inst);
        }
        return failed;
    }

    private boolean postInstallation(Installation inst) {
        boolean failed = false;
        InstProcessor instProc = this.getInstallationProcessor();
        if (instProc != null) {
            failed |= instProc.postInstallation(inst);
        }
        return failed;
    }

    private boolean preDeinstallation(Installation inst) {
        boolean failed = false;
        InstProcessor instProc = this.getInstallationProcessor();
        if (instProc != null) {
            failed |= instProc.preDeinstallation(inst);
        }
        return failed;
    }

    public boolean downloadResources(Installation inst, MicroTransaction transaction, InstallationDescription jnlp) {
        boolean failed;
        boolean bl = failed = transaction == null;
        if (!failed) {
            LogWriter.writeLog("Loading resources from " + jnlp.getCodebase());
            this.mProgressHandler.setSubTaskTitle("Copy Resources");
            this.mMessageHandler.addLogMessage(MsgType.info, MsgSubType.header3, "Copy Resources");
            int counter = 0;
            for (DownloadResource resource : jnlp.getDownloadResources()) {
                if (!(failed |= resource == null) && resource != null) {
                    String message = "Load" + (resource.isNative() ? " native" : "") + (resource.isOptional() ? " optional" : "") + " resource : " + resource.getResource();
                    this.mProgressHandler.setValue(counter);
                    this.mProgressHandler.setText(message);
                    LogWriter.writeLog("   " + message);
                    boolean f = this.loadResource(inst, transaction, jnlp.getCodebase(), jnlp.getAlternateCodebase(), resource);
                    MsgType t = MsgType.info;
                    if (!f) {
                        message = "Installed " + (resource.isNative() ? " native" : "") + (resource.isOptional() ? " optional" : "") + " resource : " + resource.getResource();
                    } else if (resource.isOptional()) {
                        message = "Skipped " + (resource.isNative() ? " native" : "") + (resource.isOptional() ? " optional" : "") + " resource : " + resource.getResource();
                    } else {
                        message = "Failed to install " + (resource.isNative() ? " native" : "") + (resource.isOptional() ? " optional" : "") + " resource : " + resource.getResource();
                        t = MsgType.error;
                    }
                    this.mMessageHandler.addLogMessage(t, MsgSubType.body, message);
                    if (!resource.isOptional()) {
                        failed |= f;
                    }
                    if (failed) break;
                }
                ++counter;
            }
        } else {
            LogWriter.writeLog(MsgType.error, "MicroLoader.startLoading(): no transaction running.");
            failed = true;
        }
        return failed;
    }

    private boolean loadResource(Installation inst, MicroTransaction transaction, URI codebase, URI alternateCodebase, DownloadResource dr) {
        boolean failed = false;
        URL resourceUrl = null;
        InputStream resourceInputStream = null;
        URI resourceURI = null;
        try {
            resourceURI = new URI(codebase + dr.getResource());
            if (alternateCodebase != null && dr.isOptional() && "file".equalsIgnoreCase(alternateCodebase.getScheme())) {
                File resourceFile = null;
                resourceFile = new File(new URI(alternateCodebase + dr.getResource()));
                if (resourceFile.exists()) {
                    resourceURI = resourceFile.toURI();
                    LogWriter.writeLog(MsgType.info, "      external package for optional resource : " + resourceFile);
                } else {
                    LogWriter.writeLog(MsgType.info, "      no external package for optional resource : " + resourceFile);
                }
            } else if (alternateCodebase != null && dr.isOptional()) {
                resourceURI = new URI(alternateCodebase + dr.getResource());
                LogWriter.writeLog(MsgType.info, "      external package for optional resource : " + resourceURI);
            }
        }
        catch (URISyntaxException e) {
            LogWriter.writeLog(MsgType.error, "InstallationController.loadResource(): illegal resource URL: \"" + alternateCodebase + dr.getResource() + "\"");
        }
        if (resourceURI != null) {
            try {
                resourceUrl = resourceURI.toURL();
            }
            catch (MalformedURLException e) {
                LogWriter.writeLog(MsgType.error, "InstallationController.loadResource(): illegal resource URL: \"" + resourceUrl + "\"");
                failed = true;
            }
            if (!failed && resourceUrl != null) {
                try {
                    if (resourceUrl.getProtocol().startsWith("http")) {
                        HttpURLConnection httpUrlconnection = (HttpURLConnection)resourceUrl.openConnection();
                        httpUrlconnection.setInstanceFollowRedirects(true);
                        boolean bl = httpUrlconnection.getResponseCode() >= 400;
                        resourceInputStream = httpUrlconnection.getInputStream();
                        if ((failed |= bl) && dr.isOptional()) {
                            LogWriter.writeLog(MsgType.info, "      load optional resource failed:" + httpUrlconnection.getResponseMessage());
                            return failed;
                        }
                        if (failed) {
                            LogWriter.writeLog(MsgType.error, "MicroLoader.loadResource() failed: " + httpUrlconnection.getResponseMessage());
                        }
                    } else {
                        resourceInputStream = resourceUrl.openStream();
                    }
                }
                catch (IOException e) {
                    if (dr.isOptional()) {
                        LogWriter.writeLog(MsgType.info, "      load optional resource failed: " + e);
                        return true;
                    }
                    LogWriter.writeLog(MsgType.error, "MicroLoader.loadResource(): I/O error while loading resource " + resourceUrl + ": " + e.getMessage());
                    failed = true;
                }
            }
        }
        if (!failed) {
            this.mProgressHandler.setText("Loading resource " + dr.getResource());
            failed |= transaction.loadResource(inst, resourceURI, resourceInputStream, dr.getResource(), dr.isNative(), dr.isOptional());
        }
        return failed;
    }

    private class Win32InstProcessor
    extends InstProcessor {
        private String mLocalCodepage;

        private Win32InstProcessor() {
            this.mLocalCodepage = null;
        }

        private void writeShortcutControlFile(File filePath, String linkText, String comment, File shortcutPaths, File startTarget, String startArguments, File startIn, File iconPath, int iconIndex) {
            try {
                PrintStream writer = new PrintStream(new FileOutputStream(filePath));
                writer.println(linkText);
                writer.println(comment);
                writer.println(shortcutPaths.getAbsolutePath());
                writer.println(startTarget.getAbsolutePath());
                writer.println(startArguments);
                writer.println(startIn.getAbsolutePath());
                writer.println(iconPath.getAbsolutePath());
                writer.println(Integer.toString(iconIndex));
                writer.close();
            }
            catch (FileNotFoundException e) {
                LogWriter.writeLog(MsgType.error, "Win32InstProcessor.writeWinShortcutFile(): FileNotFoundException: " + filePath + "\n" + T.formatStackTrace("", e));
            }
        }

        @Override
        public boolean checkInstallationRequirements(Installation installation) {
            boolean failed = false;
            File installDir = installation.getInstallationDir();
            if (installDir != null) {
                if (!installDir.exists()) {
                    failed |= !installDir.mkdirs();
                }
                if (!failed) {
                    if (failed |= !IOUtils.isWritable(installDir)) {
                        LogWriter.writeLog(MsgType.info, "Insufficient process rights - not able to create a file in " + installDir.getAbsolutePath());
                    }
                    if (failed |= !IOUtils.isWritable(installDir, ".exe")) {
                        LogWriter.writeLog("Insufficient process rights - not able to create an executable [EXE] in " + installDir.getAbsolutePath());
                    }
                    if (failed |= !IOUtils.isWritable(installDir, ".bat")) {
                        LogWriter.writeLog("Insufficient process rights - not able to create an executable [BAT] in " + installDir.getAbsolutePath());
                    }
                    if (failed |= !IOUtils.isWritable(installDir, ".dll")) {
                        LogWriter.writeLog("Insufficient process rights - not able to create a library [DLL] in " + installDir.getAbsolutePath());
                    }
                } else {
                    LogWriter.writeLog("Directory for installation could not be created!");
                }
            } else {
                failed = true;
            }
            if (failed) {
                InstallationController.this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "The installation process could not create files in \"" + installDir + "\"", true);
                InstallationController.this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "You probably don't have the necessary access rights.", true);
            }
            return failed;
        }

        @Override
        public boolean createDesktopShortcuts(Installation inst) {
            boolean failed = false;
            Version version = inst.getVersion();
            File binDir = PathInfo.get(inst).locatePath(10006);
            String linkText = version.getLongProductName();
            String comment = "";
            File iconPath = version.isOfType(2) ? new File(binDir, "wdp.ico") : new File(binDir, "JPlatin.dll");
            File guilogon = new File(binDir, "guilogon.bat");
            int iconIndex = 0;
            File path = null;
            boolean resultdesktop = false;
            boolean resultprogram = false;
            File[] shortcutPaths = Win32ShortcutUtils.getWinShortcutPaths(inst);
            File filePath = new File(binDir, "shortcut.txt");
            if (!InstallationInfo.isUserLocalInstallation()) {
                path = shortcutPaths[0];
                resultdesktop = path.getParentFile().exists();
                if (!resultdesktop) {
                    resultdesktop = path.getParentFile().mkdirs();
                }
                if (resultdesktop) {
                    this.writeShortcutControlFile(filePath, linkText, comment, path, guilogon, "", binDir, iconPath, iconIndex);
                    resultdesktop = Win32ShortcutUtils.createShortcutFromFile(inst, filePath);
                    filePath.delete();
                }
            }
            if (!resultdesktop) {
                if (!InstallationInfo.isUserLocalInstallation()) {
                    LogWriter.writeLog(MsgType.info, "Win32InstProcessor.createDesktopShortcuts(): shortcut on all users desktop could not be written: " + shortcutPaths[0]);
                }
                if (!(resultdesktop = (path = shortcutPaths[1]).getParentFile().exists())) {
                    resultdesktop = path.getParentFile().mkdirs();
                }
                if (resultdesktop) {
                    this.writeShortcutControlFile(filePath, linkText, comment, path, guilogon, "", binDir, iconPath, iconIndex);
                    failed |= !Win32ShortcutUtils.createShortcutFromFile(inst, filePath);
                    filePath.delete();
                }
                if (failed) {
                    path = null;
                    LogWriter.writeLog(MsgType.info, "Win32InstProcessor.createDesktopShortcuts(): shortcut on the current users desktop could not be written: " + shortcutPaths[0]);
                }
            }
            if (path != null) {
                inst.addEntry(path);
            }
            if (!InstallationInfo.isUserLocalInstallation()) {
                path = shortcutPaths[2];
                resultprogram = path.getParentFile().exists();
                if (!resultprogram) {
                    resultprogram = path.getParentFile().mkdirs();
                }
                if (resultprogram) {
                    this.writeShortcutControlFile(filePath, linkText, comment, path, guilogon, "", binDir, iconPath, iconIndex);
                    resultprogram = Win32ShortcutUtils.createShortcutFromFile(inst, filePath);
                    filePath.delete();
                }
            }
            if (!resultprogram) {
                if (!InstallationInfo.isUserLocalInstallation()) {
                    LogWriter.writeLog(MsgType.info, "Win32InstProcessor.createDesktopShortcuts(): start menu entry in the all users start menu could not be written: " + shortcutPaths[1]);
                }
                if (!(resultprogram = (path = shortcutPaths[3]).getParentFile().exists())) {
                    resultprogram = path.getParentFile().mkdirs();
                }
                if (resultprogram) {
                    this.writeShortcutControlFile(filePath, linkText, comment, path, guilogon, "", binDir, iconPath, iconIndex);
                    failed |= !Win32ShortcutUtils.createShortcutFromFile(inst, filePath);
                    filePath.delete();
                }
                if (failed) {
                    path = null;
                    LogWriter.writeLog(MsgType.error, "Win32InstProcessor.createDesktopShortcuts(): shortcut in the current users start menu could not be written: " + shortcutPaths[0]);
                }
            }
            if (path != null) {
                inst.addEntry(path);
            }
            return failed;
        }

        private String getUninstallKey(Installation inst) {
            String key = "HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + inst.getVersion().getCompressedFullProductName();
            return key;
        }

        private String getAppPathKey(String commonExeName) {
            String appPath = "HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\" + commonExeName;
            return appPath;
        }

        @Override
        public boolean checkUninstall(Installation inst) {
            String value;
            boolean failed = false;
            String key = this.getUninstallKey(inst);
            String data = Win32RegistryUtils.getRegistryData(key, value = "DisplayName");
            if (data != null) {
                failed |= !Win32RegistryUtils.setRegistryData(key, value, data);
            }
            if (failed) {
                LogWriter.writeLog(MsgType.error, "MicroTransaction.checkWinUninstall(): user has no privileges to remove registry hirarchy below " + key);
            }
            return failed;
        }

        @Override
        public boolean registerInstallation(Installation inst) {
            boolean failed = false;
            if (!InstallationInfo.isUserLocalInstallation()) {
                File uninstaller = PathInfo.get(inst).locatePath(20006);
                File dllPath = PathInfo.get(inst).locatePath(20013);
                String regKeyPath = this.getUninstallKey(inst);
                if (!Win32RegistryUtils.setRegistryData(regKeyPath, "DisplayName", inst.getVersion().getFullProductName())) {
                    LogWriter.writeLog(MsgType.info, "Win32InstProcessor.registerInstallation(): can not create registry value DisplayName, " + regKeyPath);
                    failed = true;
                }
                if (!Win32RegistryUtils.setRegistryData(regKeyPath, "UninstallString", uninstaller.getAbsolutePath())) {
                    LogWriter.writeLog(MsgType.info, "Win32InstProcessor.registerInstallation(): can not create registry value UninstallString: " + regKeyPath);
                    failed = true;
                }
                if (!Win32RegistryUtils.setRegistryData(regKeyPath, "DisplayIcon", dllPath.getAbsolutePath() + ",0")) {
                    LogWriter.writeLog(MsgType.info, "Win32InstProcessor.registerInstallation(): can not create registry alue DisplayIcon:" + regKeyPath);
                    failed = true;
                }
                if (!Win32RegistryUtils.setRegistryData(regKeyPath, "Publisher", "SAP AG")) {
                    LogWriter.writeLog(MsgType.info, "Win32InstProcessor.registerInstallation(): can not create registry value Publisher: " + regKeyPath);
                    failed = true;
                }
                if (!Win32RegistryUtils.setRegistryData(regKeyPath, "NoModify", "1", "REG_DWORD")) {
                    LogWriter.writeLog(MsgType.info, "Win32InstProcessor.registerInstallation(): can not create registry value NoModify: " + regKeyPath);
                    failed = true;
                }
                if (InstallationOptions.register.booleanValue()) {
                    String commonExeName = PathInfo.get(inst).getPart(30034);
                    File commonExeFile = PathInfo.get(inst).locatePath(20023);
                    String appPath = this.getAppPathKey(commonExeName);
                    Win32RegistryUtils.setRegistryData(appPath, null, commonExeFile.getAbsolutePath());
                }
            }
            return failed &= SystemInfo.getOSClass() == 2 && Float.parseFloat(SystemInfo.getOSVersion()) >= 6.0f;
        }

        @Override
        public boolean postInstallation(Installation inst) {
            boolean failed = false;
            return failed |= this.createScripts(inst);
        }

        public String getLocalCodepage() {
            if (null == this.mLocalCodepage) {
                this.mLocalCodepage = null;
                Pattern pattern = Pattern.compile("\\D*(\\d+)");
                String retVal = null;
                String match = null;
                String chcpCmd = "cmd.exe /C chcp";
                try {
                    if (T.race("MICRO")) {
                        T.race("PRINT", "Win32InstProcessor.getLocalCodepage(): Try to get codepage for cmd.exe call: " + chcpCmd);
                    }
                    Process p = Runtime.getRuntime().exec(chcpCmd);
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = null;
                    boolean found = false;
                    while ((line = br.readLine()) != null) {
                        Matcher matcher = pattern.matcher(line);
                        if (found || line.length() <= 0 || !matcher.matches() || matcher.groupCount() != 1 || (match = matcher.group(1)) == null || match.length() <= 0) continue;
                        retVal = match;
                    }
                }
                catch (IOException e) {
                    T.raceError("Win32InstProcessor.getLocalCodepage(): IOException while cmd.exe code page: " + e, e);
                }
                this.mLocalCodepage = retVal;
            }
            return this.mLocalCodepage;
        }

        private boolean writeStartBatch(Installation inst, File jarDir, File batchFile, String startParam, boolean simple) {
            String match;
            String codePage;
            boolean failed = false;
            String localCodePage = this.getLocalCodepage();
            String startClass = PathInfo.get(inst).getPart(30017);
            String classpath = "-cp \"" + jarDir + "\\GuiStartS.jar\"";
            String params = "%*";
            String vmParams = "-Xmx512M";
            String defaultVM = "javaw.exe";
            String addPath = "if NOT \"%ProgramFiles(x86)%\" == \"\" set PATH=%ProgramFiles(x86)%\\Java\\jre7\\bin;%PATH%";
            Pattern pattern = Pattern.compile("\\D*(\\d+)");
            Matcher matcher = pattern.matcher(codePage = System.getProperty("file.encoding"));
            if (matcher.matches() && matcher.groupCount() == 1 && (match = matcher.group(1)) != null && match.length() > 0) {
                codePage = match;
            }
            try {
                if (batchFile.exists()) {
                    batchFile.delete();
                }
                PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(batchFile)));
                if (simple) {
                    writer.println("if \"%PLATIN_JAVA%\" == \"\" set PLATIN_JAVA=" + defaultVM);
                    writer.println("set STARTUPCMD=\"%PLATIN_JAVA%\"");
                    writer.println("if \"%MAPCLIENT_DEBUG%\" == \"\" set STARTUPCMD=start \"\" /MIN \"%PLATIN_JAVA%\"");
                    writer.println("%STARTUPCMD% " + vmParams + " " + classpath + " %PLATIN_JVMOPT% " + startClass + " " + startParam + " " + params);
                } else {
                    writer.println("mode con: cp select=" + codePage);
                    writer.println(addPath);
                    writer.println("if \"%PLATIN_JAVA%\" == \"\" set PLATIN_JAVA=" + defaultVM);
                    writer.println("start \"\" /MIN \"%PLATIN_JAVA%\" " + vmParams + " " + classpath + " %PLATIN_JVMOPT% " + startClass + " " + startParam + " " + params);
                    if (localCodePage != null) {
                        writer.println("mode con: cp select=" + localCodePage);
                    }
                }
                writer.close();
                inst.addEntry(batchFile);
            }
            catch (IOException e) {
                InstallationController.this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Installation is unable to write the start scripts.");
                InstallationController.this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Exception while writing to " + batchFile + "\n" + "Technical reason:\n" + e.getMessage());
                InstallationController.this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "See log file for complete error message and stack trace.");
                LogWriter.writeLog(MsgType.error, "InstallationController.postInstallation(): I/O Exception writing to file: " + batchFile + ", exception: " + e + "\n" + T.formatStackTrace("", e));
                failed = true;
            }
            return failed;
        }

        private boolean createScripts(Installation inst) {
            boolean failed = false;
            File instDir = inst.getInstallationDir();
            File appDir = inst.getApplicationDir();
            File jarDir = PathInfo.get(inst).locatePath(10008);
            File guistart = PathInfo.get(inst).locatePath(20008);
            File guilogon = PathInfo.get(inst).locatePath(20007);
            File guilogon2 = PathInfo.get(inst).locatePath(20025);
            File commonExec = PathInfo.get(inst).locatePath(20023);
            File uninstaller = PathInfo.get(inst).locatePath(20006);
            failed |= this.writeStartBatch(inst, jarDir, guistart, "-n -o", false);
            failed |= this.writeStartBatch(inst, jarDir, guilogon, "", false);
            failed |= this.writeStartBatch(inst, jarDir, guilogon2, "", true);
            if (!commonExec.equals(guilogon2)) {
                failed |= this.writeStartBatch(inst, jarDir, commonExec, "", true);
            }
            try {
                PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(uninstaller)));
                writer.println("java -cp \"" + jarDir.getAbsolutePath() + File.separator + "GuiStartS.jar\" com.sap.platin.micro.Microkernel uninstall");
                writer.println("if errorlevel 0 goto deleteFiles");
                writer.println("");
                writer.println("exit -1");
                writer.println("");
                writer.println(":deleteFiles");
                writer.println("del \"" + jarDir.getAbsolutePath() + File.separator + "GuiStartS.jar\" 2>NUL:");
                writer.println("rmdir \"" + jarDir.getAbsolutePath() + "\" 2>NUL:");
                writer.print("del \"" + uninstaller.getAbsolutePath() + "\" 2>NUL: & ");
                writer.print("rmdir \"" + appDir.getAbsolutePath() + "\" 2>NUL: & ");
                writer.println("rmdir \"" + instDir.getAbsolutePath() + "\" 2>NUL:");
                writer.close();
            }
            catch (IOException e) {
                InstallationController.this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Installation is unable to write the uninstall script.");
                InstallationController.this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Exception while writing to " + uninstaller);
                InstallationController.this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "Technical reason: " + e.getMessage());
                InstallationController.this.mMessageHandler.addLogMessage(MsgType.error, MsgSubType.body, "See log file for complete error message and stack trace.");
                LogWriter.writeLog(MsgType.error, "InstallationController.postInstallation(): I/O Exception writing to file: " + uninstaller + ", exception: " + e + "\n" + T.formatStackTrace("", e));
                failed = true;
            }
            return failed;
        }

        @Override
        public boolean removeDesktopShortcuts(Installation inst) {
            boolean failed = false;
            return failed;
        }

        @Override
        public boolean deregisterInstallation(Installation inst) {
            File execFile;
            String topLevelKey = this.getUninstallKey(inst);
            String data = Win32RegistryUtils.getRegistryData(topLevelKey, "DisplayName");
            if (data != null) {
                Win32RegistryUtils.deleteRegistryKey(topLevelKey);
            }
            String commonExeName = PathInfo.get(inst).getPart(30034);
            File binDir = PathInfo.get(inst).locatePath(10006);
            String appPath = this.getAppPathKey(commonExeName);
            String execFileName = Win32RegistryUtils.getRegistryData(appPath, null);
            if (execFileName != null && execFileName.length() > 0 && binDir.equals((execFile = new File(execFileName)).getParentFile())) {
                Win32RegistryUtils.deleteRegistryKey(appPath);
            }
            return false;
        }

        @Override
        public boolean preDeinstallation(Installation inst) {
            File uninstaller;
            boolean failed = false;
            File instDir = Installation.getRunningGuiBase();
            if (instDir != null) {
                instDir = instDir.getParentFile();
            }
            if ((uninstaller = PathInfo.get(inst).locatePath(20006)) != null && uninstaller.exists() && (instDir == null || !uninstaller.getAbsolutePath().startsWith(instDir.getAbsolutePath()))) {
                failed |= !uninstaller.delete();
            }
            return failed;
        }
    }

    private class UnixInstProcessor
    extends InstProcessor {
        private UnixInstProcessor() {
        }

        @Override
        public boolean postInstallation(Installation installation) {
            boolean failed = false;
            return failed;
        }

        @Override
        public boolean registerInstallation(Installation installation) {
            if (InstallationOptions.register.booleanValue()) {
                File prefix = (File)InstallationOptions.prefix.value();
                String prefixName = prefix != null ? prefix.getAbsolutePath() : "";
                File linkTarget = PathInfo.get(installation).locatePath(20023);
                if (linkTarget.getAbsolutePath().startsWith(prefixName)) {
                    linkTarget = new File(linkTarget.getAbsolutePath().substring(prefixName.length()));
                }
                File execDir = new File(prefix != null ? prefix.getPath() : "/", "usr/bin");
                File execFile = new File(execDir, PathInfo.get(installation).getPart(30034));
                try {
                    String targetName = linkTarget.getCanonicalPath();
                    if (!execDir.exists()) {
                        execDir.mkdirs();
                    }
                    Runtime.getRuntime().exec(new String[]{"ln", "-sf", targetName, execFile.getPath()});
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public boolean createDesktopShortcuts(Installation installation) {
            File[] baseDirectories;
            boolean failed = false;
            File prefix = (File)InstallationOptions.prefix.value();
            File desktopFileName = prefix == null ? PathInfo.get(installation).locatePath(20011) : new File(prefix, "usr/share/applications/" + installation.getVersion().getCompressedProductName() + ".desktop");
            File desktopDirFile = prefix == null ? PathInfo.get(installation).locatePath(20012) : new File(prefix, "usr/share/desktop-directories/SAPClients.directory");
            File desktopMenuFile = prefix == null ? PathInfo.get(installation).locatePath(20018) : new File(prefix, "etc/xdg/menus/applications-merged/SAPClients.menu");
            StringBuffer msg = new StringBuffer();
            File iconSet = PathInfo.get(installation).locatePath(10012);
            if (XDGInfo.installIconSet(msg, iconSet)) {
                LogWriter.writeLog(MsgType.info, "Could not install icon set for desktop icons.\n" + msg.toString());
            }
            for (File basedir : baseDirectories = new File[]{desktopFileName.getParentFile(), desktopDirFile.getParentFile(), desktopMenuFile.getParentFile()}) {
                if (basedir == null || basedir.exists()) continue;
                basedir.mkdirs();
            }
            StringBuffer desktopFileText = new StringBuffer();
            StringBuffer desktopDirText = new StringBuffer();
            StringBuffer desktopMenuText = new StringBuffer();
            String exePath = PathInfo.get(installation).locatePath(20007).getAbsolutePath();
            if (prefix != null && exePath.startsWith(prefix.getAbsolutePath())) {
                exePath = exePath.substring(prefix.getAbsolutePath().length());
            }
            desktopFileText.append("[Desktop Entry]\n").append("Exec=").append(exePath).append("\n").append("Type=Application\n").append("Icon=guilogon\n").append("Name=").append(installation.getVersion().getLongProductName()).append("\n").append("Categories=X-SAPClients;Office;");
            desktopDirText.append("[Desktop Entry]\n\n").append("Comment=Directory for SAP Clients\n").append("Type=Directory\n").append("Icon=SAPClients\n").append("Name=SAP Clients\n");
            desktopMenuText.append("<!DOCTYPE Menu PUBLIC \"-//freedesktop//DTD Menu 1.0//EN\" \"http://www.freedesktop.org/standards/menu-spec/1.0/menu.dtd\">\n").append("<Menu>\n").append("  <Menu>\n").append("      <Name>SAP Clients</Name>\n").append("      <Directory>SAPClients.directory</Directory>\n").append("      <Include>\n").append("      <Category>X-SAPClients</Category>\n").append("      </Include>\n").append("  </Menu>\n").append("</Menu>\n");
            if (!(failed |= this.writeDesktopFile(desktopFileName, desktopFileText.toString()))) {
                installation.addEntry(desktopFileName);
            }
            failed |= this.writeDesktopFile(desktopDirFile, desktopDirText.toString());
            failed |= this.writeDesktopFile(desktopMenuFile, desktopMenuText.toString());
            try {
                Runtime.getRuntime().exec(new String[]{"xdg-icon-resource", "forceupdate"});
            }
            catch (IOException e) {
                LogWriter.writeLog(MsgType.info, "Can't call \"xdg-icon-resource forceupdate\"\nusually this just means your system is not xdg compliant.\n" + e.getClass().getName() + " " + e.getMessage());
            }
            return failed;
        }

        private boolean writeDesktopFile(File file, String text) {
            boolean failed = true;
            try {
                File parentDirectory;
                if (file.exists()) {
                    file.delete();
                }
                if ((parentDirectory = file.getParentFile()) != null && !parentDirectory.exists()) {
                    parentDirectory.mkdirs();
                }
                PrintStream writer = new PrintStream(new FileOutputStream(file));
                writer.println(text);
                writer.close();
                failed = false;
            }
            catch (FileNotFoundException e) {
                LogWriter.writeLog(MsgType.error, "UnixInstProcessor.writeDesktopFile(): could not find path: \"" + file + "\"");
            }
            return failed;
        }

        @Override
        public boolean removeDesktopShortcuts(Installation installation) {
            return false;
        }

        @Override
        public boolean deregisterInstallation(Installation installation) {
            File binDir = PathInfo.get(installation).locatePath(10006);
            String execFileName = "/usr/bin/" + PathInfo.get(installation).getPart(30034);
            File execFile = new File(execFileName);
            if (execFile.exists()) {
                try {
                    File canonicalFile = execFile.getCanonicalFile();
                    if (binDir.equals(canonicalFile.getParentFile())) {
                        execFile.delete();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public boolean preDeinstallation(Installation installation) {
            return false;
        }

        @Override
        public boolean checkUninstall(Installation inst) {
            return false;
        }

        @Override
        public boolean checkInstallationRequirements(Installation installation) {
            return false;
        }
    }

    private class MacInstProcessor
    extends InstProcessor {
        private String mErrorString;

        private MacInstProcessor() {
        }

        @Override
        public boolean postInstallation(Installation installation) {
            boolean failed = false;
            PathInfo instPathInfo = PathInfo.get(installation);
            File productDir = instPathInfo.locatePath(10004);
            File resourceDir = instPathInfo.locatePath(10005);
            File docDir = instPathInfo.locatePath(10010);
            String docName = instPathInfo.getPart(30039);
            File docLink = new File(productDir, docName);
            String manFileName = new File(docDir, "manual.htm").getAbsolutePath();
            String[] langs = new String[]{"English.lproj", "French.lproj", "German.lproj", "Japanese.lproj", "Italian.lproj"};
            for (int i = 0; i < langs.length; ++i) {
                File langDir = new File(resourceDir, langs[i]);
                if (langDir.exists()) continue;
                try {
                    langDir.mkdir();
                    continue;
                }
                catch (RuntimeException e) {
                    LogWriter.writeLog(MsgType.warning, "InstallationController.postInstallation() Failed to create language folder " + langs[i]);
                }
            }
            try {
                File gmuxDir;
                if (installation.getVersion().isOfType(1) && (gmuxDir = instPathInfo.locatePath(10007)).exists()) {
                    File gawibDir = new File(gmuxDir, "SAP Graphics/gawib.framework");
                    File f = new File(gawibDir, "Versions/Current");
                    failed |= this.createLink(installation, "A", f);
                    f = new File(gawibDir, "Resources");
                    failed |= this.createLink(installation, "Versions/Current/Resources", f);
                    f = new File(gawibDir, "gawib");
                    failed |= this.createLink(installation, "Versions/Current/gawib", f);
                }
                String[] script = new String[]{"tell application \"Finder\"", "   set fileNamePosix to \"" + manFileName + "\"", "   set fileName to POSIX file fileNamePosix as alias", "   set folderNamePosix to \".\"", "   set folderName to POSIX file folderNamePosix as alias", "   make alias file to file fileName at folderName with properties {name:\"" + docName + "\"}", "end tell"};
                boolean deleted = true;
                int exitVal = 0;
                if (docLink.exists()) {
                    deleted = docLink.delete();
                }
                if (deleted) {
                    exitVal = this.executeOSAScript(script, productDir);
                } else {
                    this.mErrorString = "Could't delete existing file!";
                }
                if (exitVal != 0 || !deleted) {
                    LogWriter.writeLog(MsgType.warning, "Failed to create finder alias to documentation: " + docLink.getAbsolutePath() + "\n" + this.mErrorString);
                } else {
                    installation.addEntry(docLink);
                }
            }
            catch (IOException e) {
                failed = true;
                LogWriter.writeLog(MsgType.info, "InstallationController.postInstallation() " + e.getMessage());
            }
            catch (IllegalThreadStateException exState) {
                failed = true;
                LogWriter.writeLog(MsgType.error, "InstallationController.postInstallation() " + exState.getMessage());
            }
            this.noteFileSystemChangedAtPathR(installation);
            return failed;
        }

        private boolean createLink(Installation installation, String source, File targetFile) throws IOException {
            boolean failed = false;
            int exitValue = 0;
            Process p = Runtime.getRuntime().exec(new String[]{"ln", "-s", source, targetFile.getAbsolutePath()});
            try {
                p.waitFor();
                exitValue = p.exitValue();
                failed |= exitValue != 0;
            }
            catch (InterruptedException e) {
                failed = true;
                LogWriter.writeLog(MsgType.error, "InstallationController.postInstallation() creating link <" + source + "> " + e.getMessage() + "\n" + T.formatStackTrace("", e));
            }
            if (failed) {
                LogWriter.writeLog(MsgType.error, "InstallationController.createLink() creating link <" + source + "> failed with exit value <" + exitValue + "> !");
            } else {
                installation.addEntry(targetFile);
            }
            return failed;
        }

        @Override
        public boolean registerInstallation(Installation installation) {
            return false;
        }

        @Override
        public boolean createDesktopShortcuts(Installation installation) {
            return false;
        }

        @Override
        public boolean removeDesktopShortcuts(Installation installation) {
            return false;
        }

        @Override
        public boolean deregisterInstallation(Installation installation) {
            return false;
        }

        @Override
        public boolean preDeinstallation(Installation installation) {
            return false;
        }

        @Override
        public boolean checkUninstall(Installation inst) {
            return false;
        }

        private int executeOSAScript(String[] script, File workFolder) {
            int exitVal = 1;
            this.mErrorString = "";
            String[] comm = new String[3 + 2 * script.length];
            comm[0] = "osascript";
            comm[1] = "-s";
            comm[2] = "he";
            int i = 0;
            int k = 3;
            while (i < script.length) {
                comm[k] = "-e";
                comm[k + 1] = script[i];
                ++i;
                k += 2;
            }
            try {
                workFolder = new File(workFolder.getAbsolutePath());
                Process p = Runtime.getRuntime().exec(comm, (String[])null, workFolder);
                BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream(), "UTF-8"));
                String line = "";
                StringBuffer errorStringBuf = new StringBuffer();
                while ((line = error.readLine()) != null) {
                    errorStringBuf.append(line + "\n");
                }
                p.waitFor();
                exitVal = p.exitValue();
                if (exitVal != 0) {
                    this.mErrorString = errorStringBuf.toString();
                }
            }
            catch (IOException e) {
                exitVal = 2;
                this.mErrorString = "InstallationController.executeScriptOSAScript: " + e.getMessage();
                LogWriter.writeLog(MsgType.warning, this.mErrorString);
            }
            catch (InterruptedException e) {
                exitVal = 3;
                this.mErrorString = "InstallationController.executeScriptOSAScript: " + e.getMessage();
                LogWriter.writeLog(MsgType.warning, this.mErrorString);
            }
            return exitVal;
        }

        private void noteFileSystemChangedAtPathR(Installation installation) {
            try {
                String[] stringArray;
                String appPath = PathInfo.get(installation).locatePath(10009).getPath();
                String toolPath = new File(PathInfo.get(installation).locatePath(10012), "noteFSChange").getPath();
                if (T.race("MACOSX")) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = toolPath;
                    stringArray2[1] = "-v";
                    stringArray = stringArray2;
                    stringArray2[2] = appPath;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = toolPath;
                    stringArray = stringArray3;
                    stringArray3[1] = appPath;
                }
                String[] cmdarray = stringArray;
                Process p = Runtime.getRuntime().exec(cmdarray);
                p.waitFor();
                if (p.exitValue() != 0) {
                    LogWriter.writeLog(MsgType.warning, "noteFSChange exit status = " + p.exitValue() + " !");
                }
            }
            catch (Throwable e) {
                LogWriter.writeLog(MsgType.warning, "Couldn't update application icon! " + e.getClass().getName() + " " + e.getMessage());
            }
        }

        @Override
        public boolean checkInstallationRequirements(Installation installation) {
            return false;
        }
    }

    private abstract class InstProcessor {
        private InstProcessor() {
        }

        public abstract boolean checkInstallationRequirements(Installation var1);

        public abstract boolean postInstallation(Installation var1);

        public abstract boolean registerInstallation(Installation var1);

        public abstract boolean createDesktopShortcuts(Installation var1);

        public abstract boolean removeDesktopShortcuts(Installation var1);

        public abstract boolean deregisterInstallation(Installation var1);

        public abstract boolean preDeinstallation(Installation var1);

        public abstract boolean checkUninstall(Installation var1);
    }
}

