/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.installer;

import com.sap.platin.micro.installer.OptionType;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public enum InstallationOptions {
    help("-?", "--help", null, OptionType.USAGE, "Display this help text", ""),
    force("-f", "--force", Boolean.FALSE, OptionType.BOOLEAN, "Force installation and reinstall if already installed", "Force Installation"),
    verbose("-v", "--verbose", Boolean.FALSE, OptionType.BOOLEAN, "Provide verbose output on stderr", "Provide verbose output on stderr"),
    standard("-s", "--standard", Boolean.FALSE, OptionType.BOOLEAN, "Use standard options without user interaction", "Standard Options"),
    desktopicons("-m", "--desktopicons", Boolean.TRUE, OptionType.BOOLEAN, "Install desktop menu and shortcuts", "Install Desktop Icons"),
    gui("-g", "--gui", Boolean.TRUE, OptionType.BOOLEAN, "Use graphical installation gui", "Graphical Installer"),
    register("-r", "--register", Boolean.FALSE, OptionType.BOOLEAN, "Register executable with system", "Register Installation"),
    elevated("-e", "--elevated", Boolean.FALSE, OptionType.BOOLEAN, "Run installation with escalated privileges", "Install with elevated privileges"),
    slave("-z", "--slaveprocess", Boolean.FALSE, OptionType.BOOLEAN, "Run installation as inferior slave process", "Run installation as inferior slave process"),
    installdir("-d", "--installdir", null, OptionType.DIRECTORY, "Specify Installation directory", "Installation Directory"),
    inputfile("-i", "--inputfile", null, OptionType.FILE, "Specify installation response file", "Installation Response File"),
    prefix("-p", "--prefix", null, OptionType.DIRECTORY, "Specify installation prefix directory", "Installation Prefix"),
    logfile("-l", "--logfile", null, OptionType.FILE, "Specify file name for installation log", "Installation Log File"),
    jnlpfile("-j", "--jnlpfile", null, OptionType.FILE, "Specify file name for JNLP file", "JNLP File Name"),
    codebase("-c", "--codebase", null, OptionType.URI, "Specify URL for installation code base", "Codebase"),
    trace("-t", "--trace", "", OptionType.STRING, "Specify trace keys separated with \":\"", "Trace Keys");

    private static String space;
    private static boolean usageType;
    public static List<String> VMArgumentList;
    public static DeploymentModel deploymentModel;
    private String mShortKey = null;
    private String mLongKey = null;
    private String mDescription = null;
    private String mLabel = null;
    private Object mValue = null;
    private Object mDefaultValue = null;
    private OptionType mType = OptionType.NONE;
    private boolean mValueIsSet = false;

    private InstallationOptions(String shortKey, String longKey, Object defaultValue, OptionType type, String description, String label) {
        this.mShortKey = shortKey;
        this.mLongKey = longKey;
        this.mDefaultValue = defaultValue;
        this.mType = type;
        this.mDescription = description;
        this.mLabel = label;
        this.mValue = this.mDefaultValue;
        this.mValueIsSet = false;
    }

    public Object value() {
        return this.mValue;
    }

    public boolean booleanValue() {
        boolean retVal = this.isValueSet();
        if (this.getType() == OptionType.BOOLEAN) {
            retVal = (Boolean)this.value();
        }
        return retVal;
    }

    public String stringValue() {
        return String.valueOf(this.value());
    }

    public void setValue(boolean value) {
        if (this.getType() == OptionType.BOOLEAN) {
            this.mValue = value;
            this.mValueIsSet = true;
        }
    }

    public void setValue(Integer value) {
        if (this.getType() == OptionType.INTEGER) {
            this.mValue = value;
            this.mValueIsSet = true;
        }
    }

    public void setValue(File value) {
        if (this.getType() == OptionType.FILE || this.getType() == OptionType.DIRECTORY) {
            this.mValue = value;
            this.mValueIsSet = true;
        }
    }

    public void setValue(URI value) {
        if (this.getType() == OptionType.URI) {
            this.mValue = value;
            this.mValueIsSet = true;
        }
    }

    public void setValue(String value) {
        if (this.getType() == OptionType.STRING) {
            this.mValue = value;
            this.mValueIsSet = true;
        }
    }

    public boolean isValueSet() {
        return this.mValueIsSet;
    }

    public String getShortKey(boolean positive) {
        String retVal = this.mShortKey;
        if (!positive && this.getType() == OptionType.BOOLEAN) {
            char key = retVal.charAt(1);
            retVal = "-" + (Character.isLowerCase(key) ? Character.toUpperCase(key) : Character.toLowerCase(key));
        }
        return retVal;
    }

    public String getLongKey(boolean positive) {
        String retVal = this.mLongKey;
        if (!positive && this.getType() == OptionType.BOOLEAN) {
            retVal = "--no" + retVal.substring(2);
        }
        return retVal;
    }

    public String getDescription(boolean positive) {
        String retVal = this.mDescription;
        if (retVal != null && !positive && this.getType() == OptionType.BOOLEAN) {
            retVal = "Don't " + retVal.substring(0, 1).toLowerCase() + retVal.substring(1);
        }
        return retVal;
    }

    public String getLabel() {
        String retVal = this.mLabel;
        return retVal;
    }

    public void reset() {
        this.mValue = this.mDefaultValue;
        this.mValueIsSet = false;
    }

    public Object getDefaultValue() {
        return this.mDefaultValue;
    }

    public OptionType getType() {
        return this.mType;
    }

    private static String getSpace() {
        StringBuilder retVal = new StringBuilder();
        int length = 0;
        int offset = 3;
        for (InstallationOptions opt : InstallationOptions.values()) {
            String l = opt.getLongKey(false) + opt.getShortKey(false);
            if (l.length() <= length) continue;
            length = l.length();
        }
        if (length > 0) {
            length += offset;
            for (int i = 0; i < length; ++i) {
                retVal.append(" ");
            }
        }
        return retVal.toString();
    }

    private static String[] normalize(StringBuilder message, String[] argv) {
        return argv;
    }

    public static int parse(StringBuilder message, String[] opts, List<String> args) {
        int retVal;
        block19: {
            opts = InstallationOptions.normalize(message, opts);
            retVal = 0;
            boolean handled = false;
            int index = 0;
            for (index = 0; index < opts.length && !"--".equals(opts[index]); ++index) {
                String arg = opts[index];
                handled = false;
                for (InstallationOptions opt : InstallationOptions.values()) {
                    OptionType t = opt.getType();
                    String s = opt.getShortKey(true);
                    String l = opt.getLongKey(true);
                    if (t == OptionType.BOOLEAN) {
                        if (arg.equals(s) || arg.equals(l)) {
                            handled = true;
                            opt.setValue(true);
                            break;
                        }
                        s = opt.getShortKey(false);
                        l = opt.getLongKey(false);
                        if (!arg.equals(s) && !arg.equals(l)) continue;
                        handled = true;
                        opt.setValue(false);
                        break;
                    }
                    if (!arg.equals(s) && !arg.equals(l)) continue;
                    handled = true;
                    if (t != OptionType.USAGE) {
                        if (index + 1 >= opts.length || opts[index + 1].startsWith("-")) {
                            message.append("Missing mandatory argument for option ").append(s).append("/").append(l).append(".\n\n");
                            message.append(InstallationOptions.getUsage());
                            retVal = -2;
                            break block19;
                        }
                        arg = opts[++index];
                    }
                    switch (t) {
                        case USAGE: {
                            message.append(InstallationOptions.getUsage());
                            retVal = -1;
                            break block19;
                        }
                        case DIRECTORY: 
                        case FILE: {
                            opt.setValue(new File(arg));
                            break;
                        }
                        case STRING: {
                            opt.setValue(String.valueOf(arg));
                            break;
                        }
                        case URI: {
                            try {
                                File f = new File(arg);
                                if (arg.startsWith("/") || f.exists()) {
                                    opt.setValue(f.toURI());
                                    break;
                                }
                                opt.setValue(new URI(arg));
                                break;
                            }
                            catch (URISyntaxException e) {
                                message.append("Illegal URI argument for option ").append(s).append("/").append(l).append(":\n");
                                message.append("\"").append(arg).append("\"\n\n");
                                message.append(InstallationOptions.getUsage());
                                retVal = -2;
                                break block19;
                            }
                        }
                        case INTEGER: {
                            try {
                                opt.setValue(Integer.valueOf(arg));
                                break;
                            }
                            catch (NumberFormatException e) {
                                message.append("Illegal integer argument for option ").append(s).append("/").append(l).append(": ");
                                message.append("\"").append(arg).append("\"\n\n");
                                message.append(InstallationOptions.getUsage());
                                retVal = -3;
                                break block19;
                            }
                        }
                    }
                    break;
                }
                if (handled) continue;
                message.append("Illegal option ").append(arg).append(".\n\n");
                message.append(InstallationOptions.getUsage());
                retVal = -4;
                break block19;
            }
            if (retVal >= 0) {
                retVal = index;
            }
        }
        return retVal;
    }

    public static String dump() {
        String retVal = "";
        for (InstallationOptions opt : InstallationOptions.values()) {
            String l = opt.getLongKey(true);
            String s = opt.getShortKey(true);
            boolean valueSet = opt.isValueSet();
            Object defVal = opt.getDefaultValue();
            String line = (valueSet ? "Changed:  " : "          ") + s + " / " + l + " : " + String.valueOf(opt.value()) + " (" + String.valueOf(defVal) + ")";
            retVal = retVal + line + "\n";
        }
        return retVal;
    }

    public static String getUsage() {
        return InstallationOptions._getUsage(usageType);
    }

    private static String _getUsage(boolean type) {
        StringBuilder retVal = new StringBuilder();
        if (!type) {
            for (InstallationOptions opt : InstallationOptions.values()) {
                if (opt.getDescription(true) == null) continue;
                StringBuilder line = new StringBuilder();
                line.append(opt.getShortKey(true)).append("  ").append(opt.getLongKey(true)).append(space);
                line.setLength(space.length());
                line.append(opt.getDescription(true));
                if (opt.getType() == OptionType.BOOLEAN) {
                    line.append("\n").append(space).append("Default: ").append((Boolean)opt.getDefaultValue());
                    line.append(", (").append((Boolean)opt.getDefaultValue() == false);
                    line.append(type).append(": ").append(opt.getShortKey(false)).append(" / ").append(opt.getLongKey(false)).append(")");
                }
                retVal.append((CharSequence)line).append("\n\n");
            }
        } else {
            for (InstallationOptions opt : InstallationOptions.values()) {
                if (opt.getDescription(true) == null) continue;
                StringBuilder line = new StringBuilder();
                line.append(opt.getShortKey(true)).append("  ").append(opt.getLongKey(true)).append(space);
                line.setLength(space.length());
                line.append(opt.getDescription(true));
                if (opt.getType() == OptionType.BOOLEAN) {
                    StringBuilder line2 = new StringBuilder();
                    line2.append(opt.getShortKey(false)).append("  ").append(opt.getLongKey(false)).append(space);
                    line2.setLength(space.length());
                    line2.append(opt.getDescription(false));
                    line.append("\n").append((CharSequence)line2).append("\n").append(space);
                    line2.append("Default: ");
                    line2.append(opt.getShortKey((Boolean)opt.getDefaultValue())).append("\n");
                    retVal.append((CharSequence)line).append("\n");
                    continue;
                }
                retVal.append((CharSequence)line).append("\n\n");
            }
        }
        return retVal.toString();
    }

    public static void main(String[] args) {
        StringBuilder message = new StringBuilder();
        ArrayList<String> argList = new ArrayList<String>();
        int rc = InstallationOptions.parse(message, args, argList);
        System.err.println(message.toString());
        System.out.println("================================================================\n");
        System.err.println(InstallationOptions.dump());
        if (rc < -1) {
            System.exit(1);
        }
        System.out.println("Optionenliste Typ1:\n");
        System.out.println(InstallationOptions._getUsage(false));
        System.out.println("================================================================\n");
        System.out.println("Optionenliste Typ2:\n");
        System.out.println(InstallationOptions._getUsage(true));
    }

    static {
        space = InstallationOptions.getSpace();
        usageType = true;
        VMArgumentList = null;
        deploymentModel = DeploymentModel.APPLICATION;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        VMArgumentList = runtimeMXBean.getInputArguments();
    }

    public static enum DeploymentModel {
        UNDEFINED,
        APPLICATION,
        APPLET,
        WEBSTART;

    }
}

