/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.installer;

public enum InstallationStates {
    INTRO("Introduction", false),
    README("Readme", false),
    LICENSE("License", false),
    OPTIONS("Define Options", false),
    ACTION("Installation", false),
    SUMMARY("Summary", false);

    private String mStateLabel;
    private boolean mSkipped;
    private int mRunningNumber = -1;

    private InstallationStates(String stateLabel, boolean skipped) {
        this.mStateLabel = stateLabel;
        this.mSkipped = skipped;
    }

    public void setRunningNumber(int num) {
        this.mRunningNumber = num;
    }

    public int getRunningNumber() {
        return this.mRunningNumber;
    }

    public void setLabel(String text) {
        this.mStateLabel = text;
    }

    public void setSkipped(boolean s) {
        this.mSkipped = s;
    }

    public boolean isSkipped() {
        return this.mSkipped;
    }

    public String getLabel() {
        return this.mStateLabel;
    }

    public static void setFirstState(InstallationStates state) {
        InstallationStates[] states = InstallationStates.values();
        for (int a = 0; a < state.ordinal(); ++a) {
            states[a].setSkipped(true);
        }
    }

    public static InstallationStates firstState() {
        int retVal = -1;
        InstallationStates[] states = InstallationStates.values();
        InstallationStates s = states[0];
        while (states[retVal = Math.min(states.length, retVal + 1)].isSkipped() && retVal < states.length) {
        }
        return retVal == states.length ? s : states[retVal];
    }

    public InstallationStates next() {
        int retVal = this.ordinal();
        InstallationStates[] states = InstallationStates.values();
        while (states[retVal = Math.min(states.length, retVal + 1)].isSkipped() && retVal < states.length) {
        }
        return retVal == states.length ? this : states[retVal];
    }

    public InstallationStates previous() {
        int retVal = this.ordinal();
        InstallationStates[] states = InstallationStates.values();
        while (states[retVal = Math.max(0, retVal - 1)].isSkipped() && retVal > 0) {
        }
        return retVal == states.length ? this : states[retVal];
    }
}

