/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.installer;

import com.sap.platin.micro.MicroUtils;
import com.sap.platin.micro.PathInfo;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.micro.Version;
import com.sap.platin.micro.installer.AbstractInstallationFilter;
import com.sap.platin.micro.installer.AccessoryJFileChooser;
import com.sap.platin.micro.installer.InstallationActions;
import com.sap.platin.micro.installer.InstallationController;
import com.sap.platin.micro.installer.InstallationFilter;
import com.sap.platin.micro.installer.InstallationOptions;
import com.sap.platin.micro.installer.InstallationStates;
import com.sap.platin.micro.installer.LogWriter;
import com.sap.platin.micro.installer.MessageHandler;
import com.sap.platin.micro.installer.MsgSubType;
import com.sap.platin.micro.installer.MsgType;
import com.sap.platin.micro.installer.OptionType;
import com.sap.platin.micro.installer.ProgressHandler;
import com.sap.platin.micro.installer.StateDisplay;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class Installer
extends JFrame
implements ActionListener {
    private final Dimension mPreferredSize = new Dimension(800, 600);
    private StateDisplay mStateDisplay = null;
    private InstallationStates mCurrentState = null;
    private EventController mController = null;
    private JPanel mInstallationPanel = null;
    private Thread mActionThread = null;
    private JComponent[] mPanels = new JComponent[InstallationStates.values().length];
    private InstallationFilter.Result mFailed = InstallationFilter.Result.Unknown;
    private ProgressDisplay mProgressHandler = new ProgressDisplay();
    private SummaryDisplay mMessageHandler = new SummaryDisplay("");
    private Version mVersion = Version.CURRENT;

    public Installer() {
        this.initComponents();
        this.setVisible(true);
    }

    private String getIntroduction() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n<body class=\"i\">\n");
        sb.append("<h2>").append(this.mVersion.getLongName()).append(" Installation</h2>\n");
        sb.append("<h3>").append(this.mVersion.getFullProductName()).append("</h3>\n");
        sb.append("<p>This program will guide you through the installation of the " + this.mVersion.getFullProductName() + ".</p>");
        sb.append("<p>If this version is already installed you can remove the installation, or replace the old installation with a new one.\n</p>");
        sb.append("<p></p><p></p>");
        sb.append("<h3>Build Information</h3>");
        sb.append("<p>Version ID: ").append(this.mVersion.getFullNumericVersionString()).append("<br />\n");
        sb.append("Build Date: ").append(MicroUtils.getBuildDate()).append("<br />\n");
        sb.append("Build Info: ").append(MicroUtils.getBuildDetails()).append("<br />\n");
        sb.append("</p>\n");
        sb.append("</body>\n</html>");
        return sb.toString();
    }

    private String getReadme() {
        return this.getResourceAsString("com/sap/platin/micro/installer/resources/readme.html");
    }

    private String getLicense() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResourceAsString(String resourceName) {
        InputStream s1;
        ClassLoader cl = Installer.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((s1 = cl.getResourceAsStream(resourceName)) != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(s1, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    s1.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return sb.toString();
        }
        return null;
    }

    private void initComponents() {
        ClassLoader cl = Installer.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        URL iconURL = cl.getResource("com/sap/platin/micro/installer/resources/icon48.png");
        ImageIcon icon = new ImageIcon(iconURL);
        this.setIconImage(icon.getImage());
        JPanel content = new JPanel();
        content.setBackground(Color.white);
        this.setContentPane(content);
        this.setTitle("SAP GUI for Java: Installation");
        HeaderImage hi = new HeaderImage();
        this.setDefaultCloseOperation(2);
        content.setLayout(new BorderLayout());
        this.mInstallationPanel = new JPanel();
        this.mInstallationPanel.setLayout(new CardLayout());
        this.mInstallationPanel.setBorder(BorderFactory.createEmptyBorder(16, 0, 0, 8));
        content.add((Component)this.mInstallationPanel, "Center");
        String introText = this.getIntroduction();
        String readmeText = this.getReadme();
        String licenseText = this.getLicense();
        if (introText != null) {
            this.mPanels[InstallationStates.INTRO.ordinal()] = new TextDisplay(introText);
        } else {
            InstallationStates.INTRO.setSkipped(true);
        }
        if (readmeText != null) {
            this.mPanels[InstallationStates.README.ordinal()] = new TextDisplay(readmeText);
        } else {
            InstallationStates.README.setSkipped(true);
        }
        if (licenseText != null) {
            this.mPanels[InstallationStates.LICENSE.ordinal()] = new TextDisplay(licenseText);
        } else {
            InstallationStates.LICENSE.setSkipped(true);
        }
        this.mPanels[InstallationStates.OPTIONS.ordinal()] = new OptionsDisplay();
        this.mPanels[InstallationStates.ACTION.ordinal()] = this.mProgressHandler;
        this.mPanels[InstallationStates.SUMMARY.ordinal()] = this.mMessageHandler;
        if (InstallationOptions.standard.booleanValue()) {
            InstallationStates.setFirstState(InstallationStates.ACTION);
        }
        for (InstallationStates s : InstallationStates.values()) {
            if (s.isSkipped()) continue;
            this.mInstallationPanel.add((Component)this.mPanels[s.ordinal()], s.toString());
        }
        if (this.isInstalled()) {
            InstallationStates.ACTION.setLabel("Remove/Install");
        } else {
            InstallationStates.ACTION.setLabel("Install");
        }
        this.mStateDisplay = new StateDisplay();
        this.mStateDisplay.update(InstallationStates.ACTION);
        this.addPropertyChangeListener(this.mStateDisplay);
        this.mController = new EventController();
        this.mController.addActionListener(this);
        this.mController.setOpaque(true);
        this.mController.setBackground(this.mStateDisplay.getBackground());
        content.add((Component)hi, "North");
        content.add((Component)this.mStateDisplay, "West");
        content.add((Component)this.mController, "South");
        this.changeState(InstallationStates.firstState(), null);
        this.pack();
        this.setVisible(true);
    }

    private EnumSet<InstallationActions> getTriggerSet(InstallationStates currentState) {
        EnumSet<InstallationActions> retVal = EnumSet.noneOf(InstallationActions.class);
        InstallationStates first = InstallationStates.firstState();
        switch (currentState) {
            case INTRO: 
            case README: 
            case LICENSE: {
                if (first.ordinal() < currentState.ordinal()) {
                    retVal.add(InstallationActions.doPrevious);
                }
                if (this.isLicenseAccepted()) {
                    retVal.add(InstallationActions.doNext);
                }
                retVal.add(InstallationActions.doCancel);
                break;
            }
            case OPTIONS: {
                if (first.ordinal() < currentState.ordinal()) {
                    retVal.add(InstallationActions.doPrevious);
                }
                if (this.isInstalled()) {
                    retVal.add(InstallationActions.doRemove);
                    retVal.add(InstallationActions.doReinstall);
                } else {
                    retVal.add(InstallationActions.doInstall);
                }
                retVal.add(InstallationActions.doCancel);
                break;
            }
            case ACTION: {
                break;
            }
            case SUMMARY: {
                retVal.add(InstallationActions.doCancel);
            }
        }
        return retVal;
    }

    private boolean isLicenseAccepted() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        InstallationActions action = InstallationActions.valueOf(e.getActionCommand());
        this.changeState(this.mCurrentState, action);
    }

    public void fireAction(InstallationActions action) {
        this.actionPerformed(new ActionEvent(this, 1001, action.toString()));
    }

    private InstallationActions getDefaultAction(InstallationStates state) {
        InstallationActions retVal = InstallationActions.doNext;
        if (state == InstallationStates.ACTION) {
            retVal = this.isInstalled() ? InstallationActions.doReinstall : InstallationActions.doInstall;
        }
        return retVal;
    }

    private void changeState(InstallationStates state, InstallationActions action) {
        this.exitState(this.mCurrentState, action);
        InstallationStates newState = state;
        if (action == null) {
            action = this.getDefaultAction(newState);
        }
        switch (action) {
            case doPrevious: {
                newState = this.mCurrentState != null ? state.previous() : InstallationStates.firstState();
                break;
            }
            case doNext: {
                newState = this.mCurrentState != null ? state.next() : InstallationStates.firstState();
                break;
            }
            case doInstall: {
                InstallationStates.ACTION.setLabel("Install");
                newState = InstallationStates.ACTION;
                this.mStateDisplay.update(newState);
                break;
            }
            case doRemove: {
                InstallationStates.ACTION.setLabel("Remove");
                newState = InstallationStates.ACTION;
                this.mStateDisplay.update(newState);
                break;
            }
            case doReinstall: {
                InstallationStates.ACTION.setLabel("Reinstall");
                newState = InstallationStates.ACTION;
                this.mStateDisplay.update(newState);
                break;
            }
            case doCancel: {
                this.closeInstaller();
                newState = null;
            }
        }
        if (newState != null) {
            this.setInstallationState(newState);
        }
        this.enterState(this.mCurrentState, action);
    }

    private InstallationFilter.Result doReinstall() {
        InstallationFilter instCtrl = AbstractInstallationFilter.createInstallationFilter(this.mMessageHandler, this.mProgressHandler);
        InstallationFilter.Result retVal = instCtrl.reinstallInstallation();
        return retVal;
    }

    private InstallationFilter.Result doRemove() {
        InstallationFilter instCtrl = AbstractInstallationFilter.createInstallationFilter(this.mMessageHandler, this.mProgressHandler);
        InstallationFilter.Result retVal = instCtrl.removeInstallation();
        return retVal;
    }

    private InstallationFilter.Result doInstall() {
        InstallationFilter instCtrl = AbstractInstallationFilter.createInstallationFilter(this.mMessageHandler, this.mProgressHandler);
        InstallationFilter.Result retVal = instCtrl.addInstallation();
        return retVal;
    }

    private void enterState(InstallationStates state, InstallationActions action) {
        CardLayout cl = (CardLayout)this.mInstallationPanel.getLayout();
        cl.show(this.mInstallationPanel, state.toString());
        switch (state) {
            case INTRO: {
                break;
            }
            case README: {
                break;
            }
            case LICENSE: {
                break;
            }
            case OPTIONS: {
                break;
            }
            case ACTION: {
                final InstallationActions a = action;
                this.mActionThread = new Thread(){

                    @Override
                    public void run() {
                        Installer.this.mFailed = InstallationFilter.Result.Unknown;
                        switch (a) {
                            case doRemove: {
                                Installer.this.mFailed = Installer.this.doRemove();
                                break;
                            }
                            case doInstall: {
                                Installer.this.mFailed = Installer.this.doInstall();
                                break;
                            }
                            case doReinstall: {
                                Installer.this.mFailed = Installer.this.doReinstall();
                            }
                        }
                        Installer.this.fireAction(InstallationActions.doNext);
                    }
                };
                this.mActionThread.start();
                break;
            }
            case SUMMARY: {
                this.mMessageHandler.reload();
                InstallationActions.doCancel.setLabel("Close");
                this.mController.updateAction(InstallationActions.doCancel);
                if (this.mFailed.failed() || !InstallationOptions.standard.booleanValue()) break;
                this.fireAction(InstallationActions.doCancel);
            }
        }
    }

    private void exitState(InstallationStates state, InstallationActions action) {
        if (state != null) {
            switch (state) {
                case INTRO: {
                    break;
                }
                case README: {
                    break;
                }
                case LICENSE: {
                    break;
                }
                case OPTIONS: {
                    ((InstallerComponent)((Object)this.mPanels[state.ordinal()])).doSave();
                    break;
                }
                case ACTION: {
                    this.mActionThread = null;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInstaller() {
        Installer installer = this;
        synchronized (installer) {
            this.notifyAll();
        }
        this.dispose();
    }

    private boolean isInstalled() {
        return InstallationController.isVersionInstalled(this.mVersion);
    }

    public InstallationFilter.Result getResult() {
        return this.mFailed;
    }

    public void setResult(InstallationFilter.Result result) {
        this.mFailed = result;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.mPreferredSize;
    }

    private void setInstallationState(InstallationStates s) {
        InstallationStates oldState = this.mCurrentState;
        this.mCurrentState = s;
        EnumSet<InstallationActions> triggerSet = this.getTriggerSet(this.mCurrentState);
        this.mController.setupTrigger(triggerSet);
        this.firePropertyChange("installationState", (Object)oldState, (Object)this.mCurrentState);
    }

    public static void main(String[] args) {
        new Installer();
    }

    public class ProgressDisplay
    extends JPanel
    implements ProgressHandler {
        private JProgressBar mProgressBar = new JProgressBar();
        private JLabel mTaskTitle = new JLabel();
        private JLabel mSubTaskTitle = new JLabel();
        private JLabel mText = new JLabel();
        private Font mTitleFont = new Font("Dialog", 1, 24);
        private Font mSubTitleFont = new Font("Dialog", 1, 18);
        private Font mTextFont = new Font("Dialog", 0, 12);
        private Color mForeground = new Color(0, 52, 102);

        public ProgressDisplay() {
            this.initComponents();
        }

        private void initComponents() {
            Box p = new Box(1);
            BorderLayout bl0 = new BorderLayout();
            bl0.setHgap(0);
            this.setLayout(bl0);
            this.add(new JScrollPane(p));
            p.setOpaque(true);
            p.setBackground(Color.white);
            p.setBorder(BorderFactory.createEmptyBorder(30, 50, 0, 30));
            this.mProgressBar.setIndeterminate(true);
            this.mTaskTitle.setFont(this.mTitleFont);
            this.mTaskTitle.setForeground(this.mForeground);
            p.add(this.mTaskTitle);
            p.add(Box.createVerticalGlue());
            this.mSubTaskTitle.setFont(this.mSubTitleFont);
            this.mSubTaskTitle.setAlignmentX(0.0f);
            this.mSubTaskTitle.setForeground(this.mForeground);
            p.add(this.mSubTaskTitle);
            this.mText.setFont(this.mTextFont);
            this.mText.setAlignmentX(0.0f);
            this.mText.setForeground(this.mForeground);
            p.add(this.mText);
            p.add(Box.createVerticalStrut(25));
            this.mProgressBar.setAlignmentX(0.0f);
            p.add(this.mProgressBar);
            p.add(Box.createVerticalGlue());
        }

        @Override
        public void setText(String text) {
            this.mText.setText(text);
        }

        @Override
        public void setTaskTitle(String text) {
            this.mTaskTitle.setText(text);
        }

        @Override
        public void setSubTaskTitle(String text) {
            this.mSubTaskTitle.setText(text);
        }

        @Override
        public void setRange(int min, int max) {
            if (min != max) {
                this.mProgressBar.setIndeterminate(false);
                this.mProgressBar.setMinimum(Math.min(min, max));
                this.mProgressBar.setMaximum(Math.max(min, max));
            } else {
                this.mProgressBar.setIndeterminate(true);
            }
        }

        @Override
        public void setValue(int value) {
            this.mProgressBar.setValue(value);
        }
    }

    public class SummaryDisplay
    extends TextDisplay
    implements MessageHandler {
        private StringBuilder mMessages;
        private StringBuilder mSummary;

        public SummaryDisplay() {
            this.mMessages = new StringBuilder();
            this.mSummary = new StringBuilder();
            this.initComponents();
        }

        public SummaryDisplay(String text) {
            this();
            this.setText(text);
        }

        public void reload() {
            this.mEditorPane.setText(this.getMessages());
        }

        @Override
        public void addLogMessage(MsgType type, MsgSubType subType, String paragraph) {
            this.addLogMessage(type, subType, paragraph, false);
        }

        @Override
        public void addLogMessage(MsgType type, MsgSubType subType, String paragraph, boolean log) {
            if (type != MsgType.info) {
                log = true;
            }
            switch (subType) {
                case blockStart: {
                    this.mMessages.append("<div class=\"s").append(type.name()).append("\">\n");
                    break;
                }
                case header1: {
                    this.mMessages.append("<h1 class=\"s").append(type.name()).append("\">").append(paragraph).append("</h1>\n");
                    if (!log) break;
                    LogWriter.writeLog(MsgType.info, "===========================================================");
                    LogWriter.writeLog(MsgType.info, paragraph);
                    LogWriter.writeLog(MsgType.info, "===========================================================");
                    break;
                }
                case header2: {
                    this.mMessages.append("<h2 class=\"s").append(type.name()).append("\">").append(paragraph).append("</h1>\n");
                    if (!log) break;
                    LogWriter.writeLog(MsgType.info, "===========================================================");
                    LogWriter.writeLog(MsgType.info, paragraph);
                    LogWriter.writeLog(MsgType.info, "-----------------------------------------------------------");
                    break;
                }
                case header3: {
                    this.mMessages.append("<h3 class=\"s").append(type.name()).append("\">").append(paragraph).append("</h1>\n");
                    if (!log) break;
                    LogWriter.writeLog(MsgType.info, "-----------------------------------------------------------");
                    LogWriter.writeLog(MsgType.info, paragraph);
                    LogWriter.writeLog(MsgType.info, "-----------------------------------------------------------");
                    break;
                }
                case body: {
                    this.mMessages.append("<p class=\"s").append(type.name()).append("\">").append(paragraph).append("\n</p>\n");
                    if (!log) break;
                    LogWriter.writeLog(type, paragraph);
                    break;
                }
                case footer: {
                    break;
                }
                case blockEnd: {
                    this.mMessages.append("</div>\n");
                }
            }
        }

        @Override
        public void addSummaryMessage(MsgType type, MsgSubType subType, String paragraph) {
            this.addSummaryMessage(type, subType, paragraph, false);
        }

        @Override
        public void addSummaryMessage(MsgType type, MsgSubType subType, String paragraph, boolean log) {
            switch (subType) {
                case blockStart: {
                    this.mSummary.append("<div class=\"s").append(type.name()).append("\">\n");
                    break;
                }
                case header1: {
                    this.mSummary.append("<h1 class=\"s").append(type.name()).append("\">").append(paragraph).append("</h1>\n");
                    if (!log) break;
                    LogWriter.writeLog(MsgType.info, "===========================================================");
                    LogWriter.writeLog(MsgType.info, paragraph);
                    LogWriter.writeLog(MsgType.info, "===========================================================");
                    break;
                }
                case header2: {
                    this.mSummary.append("<h2 class=\"s").append(type.name()).append("\">").append(paragraph).append("</h1>\n");
                    if (!log) break;
                    LogWriter.writeLog(MsgType.info, "===========================================================");
                    LogWriter.writeLog(MsgType.info, paragraph);
                    LogWriter.writeLog(MsgType.info, "-----------------------------------------------------------");
                    break;
                }
                case header3: {
                    this.mSummary.append("<h3 class=\"s").append(type.name()).append("\">").append(paragraph).append("</h1>\n");
                    if (!log) break;
                    LogWriter.writeLog(MsgType.info, paragraph);
                    LogWriter.writeLog(MsgType.info, "-----------------------------------------------------------");
                    break;
                }
                case body: {
                    this.mSummary.append("<p class=\"s").append(MsgType.info.name()).append("\">").append(paragraph).append("\n</p>\n");
                    if (!log) break;
                    LogWriter.writeLog(MsgType.info, paragraph);
                    break;
                }
                case footer: {
                    break;
                }
                case blockEnd: {
                    this.mSummary.append("</div>\n");
                }
            }
        }

        @Override
        public void clearMessages() {
            this.mMessages.setLength(0);
        }

        @Override
        public String getLog() {
            return "<html>\n<body class=\"s\">\n" + this.mMessages.toString() + "\n</body>\n</html>";
        }

        @Override
        public String getSummary() {
            return "<html>\n<body class=\"s\">\n" + this.mSummary.toString() + "\n</body>\n</html>";
        }

        @Override
        public String getMessages() {
            return "<html>\n<body class=\"s\">\n" + this.mSummary.toString() + this.mMessages.toString() + "\n</body>\n</html>";
        }

        @Override
        public void setReturnValue(InstallationFilter.Result value) {
        }
    }

    public class OptionsDisplay
    extends JPanel
    implements InstallerComponent,
    ActionListener {
        private List<InstallationOptions> mOptionSet = new ArrayList<InstallationOptions>();
        private EnumMap<InstallationOptions, JLabel> mLabels = new EnumMap(InstallationOptions.class);
        private EnumMap<InstallationOptions, JComponent> mComponents = new EnumMap(InstallationOptions.class);
        private EnumMap<InstallationOptions, JButton> mButtons = new EnumMap(InstallationOptions.class);
        private JLabel mTitle = new JLabel("Installation Options");
        private Font mTitleFont = new Font("Dialog", 1, 24);
        private Font mTextFont = new Font("DialogInput", 0, 12);

        public OptionsDisplay() {
            boolean canElevate = AbstractInstallationFilter.isFilterAvailable(InstallationFilter.ControllerType.ElevatedSlave);
            this.mOptionSet.add(InstallationOptions.installdir);
            if (canElevate) {
                this.mOptionSet.add(InstallationOptions.elevated);
            }
            this.mOptionSet.add(InstallationOptions.desktopicons);
            this.mOptionSet.add(InstallationOptions.verbose);
            this.mOptionSet.add(InstallationOptions.logfile);
            this.initComponents();
        }

        private void initComponents() {
            JButton b;
            JComponent c;
            JLabel l;
            JPanel p = new JPanel();
            BorderLayout bl0 = new BorderLayout();
            bl0.setHgap(0);
            this.setLayout(bl0);
            this.add(new JScrollPane(p));
            p.setBorder(BorderFactory.createEmptyBorder(24, 8, 0, 8));
            BorderLayout bl = new BorderLayout();
            bl.setHgap(8);
            p.setLayout(bl);
            p.setBackground(Color.white);
            Box p0 = new Box(1);
            Box p1 = new Box(1);
            Box p2 = new Box(1);
            this.mTitle.setFont(this.mTitleFont);
            p.add((Component)this.mTitle, "North");
            p.add((Component)p0, "West");
            p.add((Component)p1, "Center");
            p.add((Component)p2, "East");
            p0.add(Box.createVerticalStrut(26));
            p1.add(Box.createVerticalStrut(26));
            p2.add(Box.createVerticalStrut(26));
            int maxHeight = 0;
            for (InstallationOptions o : this.mOptionSet) {
                l = null;
                c = null;
                b = null;
                String val = this.getDefaultValue(o);
                if (o.isValueSet() && o.value() != null) {
                    val = String.valueOf(o.value());
                }
                switch (o.getType()) {
                    case BOOLEAN: {
                        c = new JCheckBox(o.getLabel());
                        c.setBackground(Color.white);
                        ((JCheckBox)c).setSelected(o.booleanValue());
                        break;
                    }
                    case FILE: 
                    case DIRECTORY: {
                        l = new JLabel(o.getLabel() + ": ");
                        c = new JTextField(val);
                        c.setFont(this.mTextFont);
                        b = new JButton("Browse...");
                        b.addActionListener(this);
                        b.setActionCommand(o.name());
                        break;
                    }
                    default: {
                        l = new JLabel(o.getLabel() + ": ");
                        c = new JTextField(val);
                        c.setFont(this.mTextFont);
                    }
                }
                c.setAlignmentX(0.0f);
                this.mLabels.put(o, l);
                this.mComponents.put(o, c);
                this.mButtons.put(o, b);
                maxHeight = Math.max(c.getPreferredSize().height, maxHeight);
                if (b == null) continue;
                maxHeight = Math.max(b.getPreferredSize().height, maxHeight);
            }
            for (InstallationOptions o : this.mOptionSet) {
                Dimension ps;
                l = this.mLabels.get((Object)o);
                c = this.mComponents.get((Object)o);
                b = this.mButtons.get((Object)o);
                if (l != null) {
                    p0.add(l);
                } else {
                    p0.add(Box.createVerticalStrut(maxHeight));
                }
                p1.add(c);
                if (b != null) {
                    p2.add(b);
                } else {
                    p2.add(Box.createVerticalStrut(maxHeight));
                }
                if (c != null) {
                    ps = c.getPreferredSize();
                    c.setPreferredSize(new Dimension(ps.width, maxHeight));
                    c.setMaximumSize(new Dimension(Integer.MAX_VALUE, maxHeight));
                }
                if (l != null) {
                    ps = l.getPreferredSize();
                    l.setPreferredSize(new Dimension(ps.width, maxHeight));
                    l.setMinimumSize(new Dimension(ps.width, maxHeight));
                }
                if (b == null) continue;
                ps = b.getPreferredSize();
                ps.height = maxHeight;
                b.setPreferredSize(ps);
            }
            p0.add(Box.createVerticalGlue());
            p1.add(Box.createVerticalGlue());
        }

        @Override
        public void doSave() {
            for (InstallationOptions o : this.mOptionSet) {
                if (o.getType() == OptionType.BOOLEAN) {
                    JCheckBox cb = (JCheckBox)this.mComponents.get((Object)o);
                    boolean val = cb.isSelected();
                    if (val == o.booleanValue()) continue;
                    o.setValue(val);
                    continue;
                }
                JTextField tf = (JTextField)this.mComponents.get((Object)o);
                String val = tf.getText();
                if (val.length() == 0) {
                    val = this.getDefaultValue(o);
                }
                switch (o.getType()) {
                    case FILE: 
                    case DIRECTORY: {
                        o.setValue(new File(val));
                        break;
                    }
                    case URI: {
                        o.setValue(URI.create(val));
                        break;
                    }
                    case STRING: {
                        o.setValue(String.valueOf(val));
                    }
                }
            }
        }

        @Override
        public void setText(String text) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fillInFilename(InstallationOptions.valueOf(e.getActionCommand()));
        }

        private String getDefaultValue(InstallationOptions option) {
            String retVal = "";
            switch (option) {
                case installdir: {
                    if (!InstallationOptions.prefix.isValueSet()) {
                        retVal = String.valueOf(PathInfo.get(null).locatePath(10015));
                        break;
                    }
                    retVal = String.valueOf(PathInfo.get(null).locatePath(10014));
                    break;
                }
                case logfile: {
                    retVal = String.valueOf(PathInfo.get(null).locatePath(20001));
                }
            }
            return retVal;
        }

        private void fillInFilename(InstallationOptions option) {
            int retVal;
            JTextField tf = (JTextField)this.mComponents.get((Object)option);
            JFileChooser chooser = new JFileChooser();
            File f = new File(tf.getText());
            chooser.setDialogTitle("Choose file");
            if (option.getType() == OptionType.DIRECTORY) {
                chooser.setDialogTitle("Choose directory");
                chooser.setFileSelectionMode(1);
            }
            chooser.setSelectedFile(f);
            if (SystemInfo.getOSClass() == 3) {
                chooser.setAccessory(new AccessoryJFileChooser(chooser));
            }
            if ((retVal = chooser.showOpenDialog(this)) == 0) {
                File file = chooser.getSelectedFile();
                tf.setText(file.getPath());
            }
        }
    }

    public class TextDisplay
    extends JPanel
    implements InstallerComponent {
        protected JEditorPane mEditorPane = null;

        public TextDisplay() {
            Font font = UIManager.getFont("Label.font");
            this.mEditorPane = new JEditorPane();
            HTMLEditorKit editorKit = new HTMLEditorKit();
            StyleSheet ss = editorKit.getStyleSheet();
            ss.addRule("body.i       {margin:8px;}");
            ss.addRule("body.r       {margin:8px;}");
            ss.addRule("body.l       {margin:8px;}");
            ss.addRule("body.s       {margin:8px;}");
            ss.addRule("body         {font-family: " + font.getFamily() + ";");
            ss.addRule("body         {color: #003366}");
            ss.addRule("div.ssuccess {padding:8px;border-style:solid;border-width:2;border-color:#699943;background-color: #90d363}");
            ss.addRule("div.sfailure {padding:8px;border-style:solid;border-width:2;border-color:red;background-color: #ff93b0}");
            ss.addRule("h1.sinfo     {padding-left:3px;padding-right:3px;}");
            ss.addRule("h2.sinfo     {padding-left:3px;padding-right:3px;}");
            ss.addRule("h3.sinfo     {padding-left:3px;padding-right:3px;}");
            ss.addRule("h1.swarning  {padding-left:3px;padding-right:3px;}");
            ss.addRule("h2.swarning  {padding-left:3px;padding-right:3px;}");
            ss.addRule("h3.swarning  {padding-left:3px;padding-right:3px;}");
            ss.addRule("h1.serror    {padding-left:3px;padding-right:3px;}");
            ss.addRule("h2.serror    {padding-left:3px;padding-right:3px;}");
            ss.addRule("h3.serror    {padding-left:3px;padding-right:3px;}");
            ss.addRule("h1.ssuccess  {padding-left:3px;padding-right:3px;}");
            ss.addRule("h2.ssuccess  {padding-left:3px;padding-right:3px;}");
            ss.addRule("h3.ssuccess  {padding-left:3px;padding-right:3px;}");
            ss.addRule("h1.sfailure  {padding-left:3px;padding-right:3px;}");
            ss.addRule("h2.sfailure  {padding-left:3px;padding-right:3px;}");
            ss.addRule("h3.sfailure  {padding-left:3px;padding-right:3px;}");
            ss.addRule("p            {color:#000000}");
            ss.addRule("p.ssuccess   {margin:0;padding-left:3px;padding-right:3px;color:#000000}");
            ss.addRule("p.sfailure   {margin:0;padding-left:3px;padding-right:3px;background-color:#ff93b0;color:#000000}");
            ss.addRule("p.sinfo      {margin:0;padding-left:3px;padding-right:3px;color:#000000}");
            ss.addRule("p.swarning   {margin:0;padding-left:3px;padding-right:3px;color:#000000}");
            ss.addRule("p.serror     {margin:0;padding-left:3px;padding-right:3px;background-color:#ff93b0;color:#000000}");
            this.mEditorPane = new JEditorPane();
            this.mEditorPane.setEditorKit(editorKit);
        }

        public TextDisplay(URL url) {
            this();
            try {
                this.mEditorPane.setPage(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.initComponents();
        }

        public TextDisplay(String text) {
            this();
            this.initComponents();
            this.setText(text);
            this.mEditorPane.setCaretPosition(0);
        }

        @Override
        public void setText(String text) {
            this.mEditorPane.setText(text);
        }

        protected void initComponents() {
            this.setLayout(new BorderLayout());
            this.mEditorPane.setEditable(false);
            this.mEditorPane.setBackground(Color.white);
            this.add(new JScrollPane(this.mEditorPane));
        }

        @Override
        public void doSave() {
        }
    }

    public class EventController
    extends Box
    implements ActionListener {
        EnumSet<InstallationActions> mActiveActions;
        List<JButton> mTriggerButtons;

        public EventController() {
            super(0);
            this.mActiveActions = EnumSet.noneOf(InstallationActions.class);
            this.mTriggerButtons = new ArrayList<JButton>();
            this.initComponents();
        }

        private void initComponents() {
            int h = new JButton((String)"M").getPreferredSize().height;
            this.add(Box.createHorizontalGlue());
            this.add(Box.createVerticalStrut(h));
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            for (InstallationActions a : InstallationActions.values()) {
                this.mTriggerButtons.add(new JButton());
                JButton b = this.updateAction(a);
                b.addActionListener(this);
                b.setVisible(true);
                this.add(b);
                if (a == InstallationActions.doCancel) continue;
                b.putClientProperty("SPACER", Box.createHorizontalStrut(3));
                this.add((Box.Filler)b.getClientProperty("SPACER"));
            }
        }

        public void reset() {
            for (JButton b : this.mTriggerButtons) {
                this.remove(b);
                b.removeActionListener(this);
            }
            this.mTriggerButtons.clear();
        }

        public void setupTrigger(EnumSet<InstallationActions> triggerSet) {
            if (triggerSet == null) {
                triggerSet = EnumSet.noneOf(InstallationActions.class);
            }
            this.mActiveActions = triggerSet;
            for (InstallationActions a : InstallationActions.values()) {
                int idx = a.ordinal();
                this.updateAction(a);
                JButton b = this.mTriggerButtons.get(idx);
                Box.Filler f = (Box.Filler)b.getClientProperty("SPACER");
                if (this.mActiveActions.contains((Object)a)) {
                    b.setVisible(true);
                    if (f == null) continue;
                    f.setVisible(true);
                    continue;
                }
                b.setVisible(false);
                if (f == null) continue;
                f.setVisible(false);
            }
            this.revalidate();
        }

        public JButton updateAction(InstallationActions action) {
            JButton b = this.mTriggerButtons.get(action.ordinal());
            b.setActionCommand(action.toString());
            b.setText(action.getLabel());
            return b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireActionEvent(e);
        }

        public void addActionListener(ActionListener l) {
            this.listenerList.add(ActionListener.class, l);
        }

        public void removeActionListener(ActionListener l) {
            this.listenerList.remove(ActionListener.class, l);
        }

        private void fireActionEvent(ActionEvent e) {
            if (this.listenerList != null) {
                EventListener[] list = this.listenerList.getListeners(ActionListener.class);
                for (int i = 0; i < list.length; ++i) {
                    ActionListener target = (ActionListener)list[i];
                    target.actionPerformed(e);
                }
            }
        }
    }

    private static interface InstallerComponent {
        public void setText(String var1);

        public void doSave();
    }

    private class HeaderImage
    extends JComponent {
        ImageIcon mHLeft = null;
        ImageIcon mHMiddle = null;
        ImageIcon mHRight = null;

        public HeaderImage() {
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            URL urlLeft = cl.getResource("com/sap/platin/micro/installer/resources/headLeft.png");
            URL urlMiddle = cl.getResource("com/sap/platin/micro/installer/resources/headMiddle.png");
            URL urlRight = cl.getResource("com/sap/platin/micro/installer/resources/headRight.png");
            this.mHLeft = new ImageIcon(urlLeft);
            this.mHMiddle = new ImageIcon(urlMiddle);
            this.mHRight = new ImageIcon(urlRight);
            this.setVisible(true);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retVal = new Dimension(this.mHLeft.getIconWidth() + this.mHRight.getIconWidth(), this.mHLeft.getIconHeight());
            return retVal;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension retVal = new Dimension(this.mHLeft.getIconWidth() + this.mHRight.getIconWidth(), this.mHLeft.getIconHeight());
            return retVal;
        }

        @Override
        public void paint(Graphics g) {
            Rectangle rc = this.getBounds();
            int widthL = this.mHLeft.getIconWidth();
            int widthR = this.mHRight.getIconWidth();
            int heightL = this.mHLeft.getIconHeight();
            int heightR = this.mHRight.getIconHeight();
            int stretch = rc.width - (widthL + widthR);
            if (stretch > 0) {
                g.drawImage(this.mHRight.getImage(), rc.width - widthR, 0, rc.width, heightR, 0, 0, widthR, heightR, this);
                g.drawImage(this.mHLeft.getImage(), 0, 0, widthL, heightL, 0, 0, widthL, heightL, this);
                g.drawImage(this.mHMiddle.getImage(), widthL, 0, rc.width - widthR, heightL, 0, 0, 1, heightL, this);
            } else {
                g.drawImage(this.mHRight.getImage(), rc.width - widthR, 0, rc.width, heightR, 0, 0, widthR, heightR, this);
                g.drawImage(this.mHLeft.getImage(), 0, 0, widthL, heightL, 0, 0, widthL, heightL, this);
            }
        }
    }
}

