/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.installer;

import com.sap.platin.micro.installer.InstallationOptions;
import com.sap.platin.micro.installer.MsgType;
import com.sap.platin.trace.T;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class LogWriter {
    private static LogWriter mInstance = new LogWriter();
    private static PrintWriter mLogWriter = null;
    private File mLogFile;

    private LogWriter() {
    }

    public static boolean openLog(File logFile) {
        return mInstance.openLogImpl(logFile);
    }

    public static boolean closeLog() {
        return mInstance.closeLogImpl();
    }

    public static File getLogfile() {
        return LogWriter.mInstance.mLogFile;
    }

    public static void writeLog(String text) {
        LogWriter.writeLog(MsgType.info, text);
    }

    public static void writeLog(MsgType type, String text) {
        mInstance.writeLogImpl(type, text, null);
    }

    public static void writeLog(MsgType type, String text, Throwable t) {
        mInstance.writeLogImpl(type, text, t);
        mLogWriter.flush();
    }

    private boolean openLogImpl(File logFile) {
        boolean failed = true;
        if (logFile != null && mLogWriter == null) {
            this.mLogFile = logFile;
            File parent = logFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try {
                mLogWriter = new PrintWriter(new FileOutputStream(logFile, true), true);
                T.raceToFile(logFile.getAbsolutePath());
                failed = false;
            }
            catch (FileNotFoundException e) {
                T.raceError("MicroUtils.openLog(): can't open file output stream to installation log file " + logFile, e);
            }
        }
        return failed;
    }

    private boolean closeLogImpl() {
        boolean failed = false;
        if (mLogWriter != null) {
            T.raceToFile(null);
            mLogWriter.close();
            mLogWriter = null;
            this.mLogFile = null;
        }
        return failed;
    }

    private void warning(String outputString, Throwable t, boolean toScreen) {
        if (mLogWriter != null) {
            mLogWriter.println(T.formatLines(T.getPrefix("WARNING"), outputString));
            if (t != null) {
                mLogWriter.println(T.formatStackTrace(T.getPrefix("WARNING"), t));
            }
        }
        if (toScreen || mLogWriter == null) {
            System.out.println(T.formatLines(T.getPrefix("WARNING"), outputString));
            if (t != null) {
                System.out.println(T.formatStackTrace(T.getPrefix("WARNING"), t));
            }
        }
    }

    private void error(String outputString, Throwable t, boolean toScreen) {
        if (mLogWriter != null) {
            mLogWriter.println("############################# ERROR #############################");
            mLogWriter.println(T.formatLines(T.getPrefix("ERROR"), outputString));
            if (t != null) {
                mLogWriter.print(T.formatStackTrace(T.getPrefix("ERROR"), t));
            }
            mLogWriter.println("############################# ERROR #############################");
        }
        if (toScreen || mLogWriter == null) {
            System.out.println("############################# ERROR #############################");
            System.out.println(T.formatLines(T.getPrefix("ERROR"), outputString));
            if (t != null) {
                System.out.print(T.formatStackTrace(T.getPrefix("ERROR"), t));
            }
            System.out.println("############################# ERROR #############################");
        }
    }

    private void info(String outputString, Throwable t, boolean toScreen) {
        if (mLogWriter != null) {
            mLogWriter.println(T.formatLines(T.getPrefix(""), outputString));
            if (t != null) {
                mLogWriter.print(T.formatStackTrace(T.getPrefix("ERROR"), t));
            }
        }
        if (toScreen || mLogWriter == null) {
            System.out.println(T.formatLines(T.getPrefix(""), outputString));
            if (t != null) {
                System.out.print(T.formatStackTrace(T.getPrefix(""), t));
            }
        }
    }

    private void writeLogImpl(MsgType type, String text, Throwable t) {
        boolean toScreen;
        boolean bl = toScreen = InstallationOptions.verbose.booleanValue() || (type == MsgType.success || type == MsgType.failure) && (!InstallationOptions.gui.booleanValue() || InstallationOptions.slave.booleanValue());
        if (text == null || text.length() == 0) {
            T.raceError("text is null", new Throwable("LogWriter.writeLogImpl(): text is null"));
        }
        switch (type) {
            case failure: 
            case error: {
                this.error(text, t, toScreen);
                break;
            }
            case warning: {
                this.warning(text, t, toScreen);
                break;
            }
            case success: 
            case info: {
                this.info(text, t, toScreen);
            }
        }
    }

    static {
        mInstance = new LogWriter();
    }
}

