/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.installer;

import com.sap.platin.micro.installer.InstallationFilter;
import com.sap.platin.micro.installer.MessageHandler;
import com.sap.platin.micro.installer.MsgSubType;
import com.sap.platin.micro.installer.MsgType;
import com.sap.platin.micro.installer.ProgressHandler;
import com.sap.platin.trace.T;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class SlaveMessageReader {
    private ProcessBuilder mProcess = null;
    private MessageHandler mMessageHandler = null;
    private ProgressHandler mProgressHandler = null;
    private BufferedReader mReader = null;
    private InstallationFilter.Result mRetVal = InstallationFilter.Result.Unknown;

    public SlaveMessageReader(ProcessBuilder process, MessageHandler msg, ProgressHandler prg) {
        this.mProcess = process;
        this.mMessageHandler = msg;
        this.mProgressHandler = prg;
    }

    public InstallationFilter.Result run() throws IOException, InterruptedException {
        String line;
        this.mProcess.redirectErrorStream(false);
        Process p = this.mProcess.start();
        this.mReader = new BufferedReader(new InputStreamReader(p.getInputStream()), 80);
        if (T.race("MICRO")) {
            T.race("MICRO", "SlaveMessageReader.run(): running slave message reader");
        }
        while ((line = this.mReader.readLine()) != null) {
            boolean exit;
            if (T.race("MICRO")) {
                T.race("MICRO", "     line: " + line);
            }
            if (!(exit = this.parseLine(line))) continue;
            break;
        }
        this.mReader.close();
        this.mProgressHandler.setSubTaskTitle("Wait for slave to exit.");
        p.waitFor();
        if (p.exitValue() != 0) {
            this.mRetVal = InstallationFilter.Result.SlaveFailed;
        }
        this.mProgressHandler.setSubTaskTitle("Slave exited.");
        return this.mRetVal;
    }

    private boolean parseLine(String line) throws IOException {
        boolean retVal = false;
        String token = null;
        if (line.startsWith(">LOGMSG:")) {
            token = line.substring(">LOGMSG:".length());
            String[] params = this.splitParams(token);
            MsgType type = MsgType.valueOf(params[0]);
            MsgSubType subType = MsgSubType.valueOf(params[1]);
            boolean log = Boolean.valueOf(params[2]);
            String text = "";
            String l = null;
            while ((l = this.mReader.readLine()) != null && !l.startsWith("<LOGMSG")) {
                text = text + l;
            }
            this.mMessageHandler.addLogMessage(type, subType, text, log);
        } else if (line.startsWith(">SUMMSG:")) {
            token = line.substring(">SUMMSG:".length());
            String[] params = this.splitParams(token);
            MsgType type = MsgType.valueOf(params[0]);
            MsgSubType subType = MsgSubType.valueOf(params[1]);
            boolean log = Boolean.valueOf(params[2]);
            String text = "";
            String l = null;
            while ((l = this.mReader.readLine()) != null && !l.startsWith("<SUMMSG")) {
                text = text + l;
            }
            this.mMessageHandler.addSummaryMessage(type, subType, text, log);
        } else if (line.startsWith(">CLEARMSG")) {
            this.mMessageHandler.clearMessages();
        } else {
            if (line.startsWith(">RETVAL:")) {
                token = line.substring(">RETVAL:".length());
                this.mRetVal = InstallationFilter.Result.valueOf(token);
                return true;
            }
            if (line.startsWith(">PRGRANGE:")) {
                token = line.substring(">PRGRANGE:".length());
                String[] params = this.splitParams(token);
                int min = Integer.valueOf(params[0]);
                int max = Integer.valueOf(params[1]);
                this.mProgressHandler.setRange(min, max);
            } else if (line.startsWith(">PRGSUBTITLE:")) {
                token = line.substring(">PRGSUBTITLE:".length());
                this.mProgressHandler.setSubTaskTitle(token);
            } else if (line.startsWith(">PRGTASKTITLE:")) {
                token = line.substring(">PRGTASKTITLE:".length());
                this.mProgressHandler.setTaskTitle(token);
            } else if (line.startsWith(">PRGTEXT:")) {
                token = line.substring(">PRGTEXT:".length());
                this.mProgressHandler.setText(token);
            } else if (line.startsWith(">PRGVALUE:")) {
                token = line.substring(">PRGVALUE:".length());
                int val = Integer.valueOf(token);
                this.mProgressHandler.setValue(val);
            }
        }
        return retVal;
    }

    private String[] splitParams(String token) {
        return token.split(":");
    }
}

