/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.installer;

import com.sap.platin.micro.installer.InstallationStates;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StateDisplay
extends JPanel
implements PropertyChangeListener {
    private EnumSet<InstallationStates> mStates = EnumSet.allOf(InstallationStates.class);
    private InstallationStates mCurrentState = null;
    private JLabel mTitleLabel = null;
    private List<JLabel> mStateLabels = null;
    private Font mLabelFont = new Font("Dialog", 1, 12);

    private InstallationStates getCurrentState() {
        if (this.mCurrentState == null) {
            this.initComponents();
        }
        return this.mCurrentState;
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    public void setInitialState(InstallationStates state) {
        if (this.mCurrentState == null) {
            this.initComponents();
        }
        this.mCurrentState = state;
    }

    public void update() {
        for (InstallationStates state : this.mStates) {
            if (state.isSkipped()) continue;
            this.update(state);
        }
    }

    public void update(InstallationStates state) {
        if (this.mCurrentState == null) {
            this.initComponents();
        }
        if (!state.isSkipped()) {
            JLabel l = this.mStateLabels.get(state.ordinal());
            l.setFont(this.mLabelFont);
            String s = "   (" + state.getRunningNumber() + ") " + state.getLabel();
            l.setText(s);
            int active = this.getCurrentState().ordinal();
            int stateNum = state.ordinal();
            if (stateNum < active) {
                l.setForeground(StateColor.done.color);
            } else if (stateNum == active) {
                l.setForeground(StateColor.active.color);
            } else {
                l.setForeground(StateColor.future.color);
            }
        }
    }

    private String getLabelText(InstallationStates state) {
        String retVal = "";
        JLabel l = this.mStateLabels.get(state.ordinal());
        if (l != null) {
            retVal = l.getText();
        }
        return retVal;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("installationState".equals(evt.getPropertyName())) {
            Object ov = evt.getOldValue();
            Object nv = evt.getNewValue();
            if (ov instanceof InstallationStates && nv instanceof InstallationStates) {
                InstallationStates newState;
                InstallationStates oldState = (InstallationStates)((Object)ov);
                this.mCurrentState = newState = (InstallationStates)((Object)nv);
                this.update(oldState);
                this.update(newState);
            }
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag && this.mCurrentState == null) {
            this.initComponents();
        }
        super.setVisible(aFlag);
    }

    public void initComponents() {
        this.mTitleLabel = new JLabel("Installation Steps:");
        this.mTitleLabel.setForeground(StateColor.title.color);
        this.mCurrentState = InstallationStates.firstState();
        if (this.mStateLabels != null) {
            for (JLabel l : this.mStateLabels) {
                this.remove(l);
            }
            this.mStateLabels = null;
        }
        this.mStateLabels = new ArrayList<JLabel>(this.mStates.size());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 3));
        this.add(Box.createVerticalStrut(50));
        this.add(this.mTitleLabel);
        this.add(Box.createVerticalStrut(10));
        int runningNumber = 0;
        for (InstallationStates state : InstallationStates.values()) {
            JLabel jl = null;
            this.mStateLabels.add(state.ordinal(), null);
            if (state.isSkipped()) continue;
            jl = new JLabel();
            state.setRunningNumber(++runningNumber);
            this.mStateLabels.add(state.ordinal(), jl);
            this.update(state);
            this.add(jl);
            this.add(Box.createVerticalStrut(10));
        }
        this.add(Box.createVerticalGlue());
    }

    public void reset() {
    }

    public static enum StateColor {
        active(new Color(255, 153, 0)),
        done(new Color(128, 128, 128)),
        future(new Color(0, 52, 102)),
        title(new Color(0, 52, 102));

        public Color color = null;

        private StateColor(Color _color) {
            this.color = _color;
        }
    }
}

