/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.util;

import com.sap.platin.micro.Dynamic;
import com.sap.platin.micro.GuiPrincipal;
import com.sap.platin.micro.SystemInfo;
import com.sap.platin.trace.T;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.Subject;

public class IOUtils {
    public static boolean fileExists(final File file) {
        Boolean retVal = Boolean.FALSE;
        if (file != null) {
            retVal = Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return file.exists();
                }
            }, null);
        }
        return retVal;
    }

    public static File canonicalFile(final File file) {
        return Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<File>(){

            @Override
            public File run() {
                File r = file;
                try {
                    r = file.getCanonicalFile();
                }
                catch (IOException e) {
                    T.raceError("IOUtils.canonicalFile(): can't canonicalize file: \"" + file + "\"", e);
                }
                return r;
            }
        }, null);
    }

    public static boolean isDirectory(final File file) {
        Boolean retVal = Boolean.FALSE;
        if (file != null) {
            retVal = Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return file.isDirectory();
                }
            }, null);
        }
        return retVal;
    }

    public static boolean canDelete(File file) {
        boolean canDelete = true;
        if (SystemInfo.getOSClass() == 2) {
            Object canSetWritable = Dynamic.callMethod(file, "setWritable", new Class[]{Boolean.TYPE}, new Object[]{file.canWrite()});
            canDelete = !file.exists() || (canSetWritable != null ? (Boolean)canSetWritable != false : file.canWrite());
        } else {
            canDelete = file.getParent() != null && file.getParentFile().canWrite();
        }
        return canDelete;
    }

    public static boolean isWritable(File file) {
        return IOUtils.isWritable(file, null);
    }

    public static boolean isWritable(final File f, final String filetype) {
        Boolean retVal = Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File file;
                boolean rv = false;
                if (file != null) {
                    if (file.isDirectory()) {
                        try {
                            File testFile = new File(file, "tstFile" + (filetype != null ? filetype : ""));
                            if (testFile.exists()) {
                                testFile.delete();
                            }
                            File rc = File.createTempFile("tstFile", filetype, file);
                            rv = rc.exists();
                            rc.delete();
                        }
                        catch (IOException iOException) {}
                    } else if (file.exists()) {
                        rv = file.canWrite();
                    } else {
                        for (file = f; file != null && !file.exists(); file = file.getParentFile()) {
                        }
                        rv = IOUtils.isWritable(file, filetype);
                    }
                }
                return rv;
            }
        }, null);
        return retVal;
    }

    public static Collection<File> getFilesBelow(File dir) {
        File[] files;
        TreeSet<File> retVal = new TreeSet<File>();
        if (dir.exists() && (files = dir.listFiles()) != null) {
            for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                if (file.isDirectory()) {
                    retVal.addAll(IOUtils.getFilesBelow(file));
                    continue;
                }
                retVal.add(file);
            }
        }
        return retVal;
    }

    public static boolean copyFile(StringBuilder msg, File srcFile, File dstFile) {
        boolean failed = true;
        if (!srcFile.exists()) {
            msg.append("Can't copy \"" + srcFile + "\", file does not exist.");
            failed = true;
            return failed;
        }
        try {
            if (dstFile.exists()) {
                dstFile.delete();
            }
            FileChannel srcChannel = new FileInputStream(srcFile).getChannel();
            FileChannel dstChannel = new FileOutputStream(dstFile).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            failed = false;
        }
        catch (IOException e) {
            msg.append("Can't copy \"" + srcFile + "\" to \"" + dstFile + "\"");
            T.raceError("IOUtils.copyFile(): " + msg.toString(), e);
        }
        return failed;
    }

    public static boolean copyDirectory(List<String> messages, File srcDir, File dstDir) {
        boolean failed = false;
        StringBuilder message = new StringBuilder();
        if (!srcDir.exists()) {
            messages.add("Can't copy \"" + srcDir + "\", file does not exist.");
            failed = true;
            return failed;
        }
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdirs();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                failed |= IOUtils.copyDirectory(messages, new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            message.delete(0, message.length());
            boolean f = IOUtils.copyFile(message, srcDir, dstDir);
            if (f) {
                messages.add(message.toString());
            }
            failed |= f;
        }
        return failed;
    }

    public static boolean deleteDirectoryHierarchy(StringBuilder msg, File dir) {
        boolean failed = false;
        boolean actionFailed = false;
        if (T.race("MICRO")) {
            T.race("MICRO", "IOUtils.deleteDirectoryHierarchy(" + dir.getAbsolutePath() + ")");
        }
        if (dir == null || !IOUtils.fileExists(dir)) {
            return failed;
        }
        if (IOUtils.isDirectory(dir)) {
            File[] files = IOUtils.listFiles(dir);
            for (int i = 0; i < files.length; ++i) {
                File currentFile = files[i];
                if (IOUtils.isDirectory(currentFile) && IOUtils.listFiles(currentFile).length != 0) {
                    failed |= IOUtils.deleteDirectoryHierarchy(msg, currentFile);
                }
                IOUtils.deleteFile(currentFile);
                actionFailed = IOUtils.fileExists(currentFile);
                if (!actionFailed) continue;
                String text = "IOUtils.deleteDirectoryHierarchy(): can't delete file \"" + currentFile + "\"";
                if (T.race("MICRO")) {
                    T.raceError(text);
                }
                msg.append(text).append("\n");
            }
        }
        IOUtils.deleteFile(dir);
        actionFailed = IOUtils.fileExists(dir);
        if (actionFailed) {
            String text = "IOUtils.deleteDirectoryHierarchy(): can't delete file \"" + dir + "\"";
            if (T.race("MICRO")) {
                T.raceError(text);
            }
            msg.append(text).append("\n");
        }
        return failed;
    }

    public static boolean deleteEmptyDirectories(StringBuilder msg, File dir) {
        File[] files;
        boolean failed = false;
        if (T.race("MICRO")) {
            T.race("MICRO", "MicroKernel.deleteEmptyDirectories(" + dir.getAbsolutePath() + ")");
        }
        if (dir == null || !IOUtils.fileExists(dir) || !IOUtils.isDirectory(dir)) {
            return failed;
        }
        File dsstore = new File(dir, ".DS_Store");
        if (IOUtils.fileExists(dsstore)) {
            IOUtils.deleteFile(dsstore);
            if (IOUtils.fileExists(dsstore)) {
                String text = "IOUtils.deleteEmptyDirectories(): can't delete file" + dsstore;
                if (T.race("MICRO")) {
                    T.race("MICRO", text);
                }
                msg.append(text).append("\n");
                failed = true;
            }
        }
        if ((files = IOUtils.listFiles(dir)) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!IOUtils.isDirectory(files[i])) continue;
                failed |= IOUtils.deleteEmptyDirectories(msg, files[i]);
            }
        }
        return failed |= IOUtils.deleteEmptyDirectory(msg, dir);
    }

    public static boolean deleteFilesRecursive(Set<File> files) {
        File[] fileList;
        for (File f : fileList = files.toArray(new File[files.size()])) {
            if (!IOUtils.fileExists(f)) continue;
            if (IOUtils.isDirectory(f)) {
                StringBuilder sb = new StringBuilder();
                IOUtils.deleteDirectoryHierarchy(sb, f);
                if (IOUtils.fileExists(f)) continue;
                files.remove(f);
                continue;
            }
            if (!IOUtils.deleteFile(f)) continue;
            files.remove(f);
        }
        return files.isEmpty();
    }

    public static boolean deleteFiles(Set<File> files) {
        File[] fileList;
        for (File f : fileList = files.toArray(new File[files.size()])) {
            if (!IOUtils.deleteFile(f)) continue;
            files.remove(f);
        }
        return files.isEmpty();
    }

    public static boolean deleteFile(final File f) {
        Boolean retVal = Boolean.FALSE;
        if (f != null) {
            retVal = Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    f.delete();
                    return !f.exists();
                }
            }, null);
        }
        return retVal;
    }

    public static File[] listFiles(final File dir) {
        if (dir == null || !IOUtils.fileExists(dir)) {
            return new File[0];
        }
        return Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return dir.listFiles();
            }
        }, null);
    }

    public static boolean deleteEmptyDirectory(StringBuilder msg, File dir) {
        boolean failed = false;
        File[] files = IOUtils.listFiles(dir);
        if (files == null || files.length == 0) {
            IOUtils.deleteFile(dir);
            if (IOUtils.fileExists(dir)) {
                String r = "IOUtils.deleteEmptyDirectory(): can't delete empty directory \"" + dir + "\", most probably the directory is in use by some other process.";
                if (T.race("MICRO")) {
                    T.race("MICRO", r);
                }
                msg.append(r).append("\n");
                failed = true;
            }
        }
        return failed;
    }

    public static File patchRoot(File prefix, File path) {
        File retVal = path;
        if (SystemInfo.getOSClass() != 2 && prefix != null) {
            if (path.getPath().startsWith(prefix.getAbsolutePath())) {
                Thread.dumpStack();
                return path;
            }
            if (path.isAbsolute()) {
                retVal = new File(prefix, path.getPath().substring(1));
            }
        }
        return retVal;
    }

    public static boolean transferData(InputStream is, long size, File dstFile) throws IOException {
        boolean failed = false;
        FileOutputStream fout = new FileOutputStream(dstFile);
        if (!failed) {
            ReadableByteChannel cin = Channels.newChannel(is);
            FileChannel cout = fout.getChannel();
            if (!(failed |= cout == null) && cout != null) {
                cout.transferFrom(cin, 0L, size);
                cout.close();
            }
            cin.close();
        }
        return failed;
    }

    private static void transferData(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        int chunkSize = 16384;
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    public static boolean transferData(File srcFile, OutputStream outputStream) throws IOException {
        boolean failed;
        boolean bl = failed = srcFile == null || outputStream == null || !srcFile.exists();
        if (!failed) {
            FileInputStream fin = new FileInputStream(srcFile);
            if (!failed) {
                FileChannel cin = fin.getChannel();
                WritableByteChannel cout = Channels.newChannel(outputStream);
                if (!(failed |= cout == null) && cout != null) {
                    IOUtils.transferData(cin, cout);
                    cin.close();
                    cout.close();
                }
            }
        }
        return failed;
    }

    public static boolean transferData(InputStream inputStream, File dstFile) throws IOException {
        boolean failed = dstFile == null || inputStream == null;
        FileOutputStream fout = new FileOutputStream(dstFile);
        if (!failed) {
            FileChannel cout = fout.getChannel();
            ReadableByteChannel cin = Channels.newChannel(inputStream);
            if (!(failed |= cout == null) && cout != null) {
                IOUtils.transferData(cin, cout);
                cin.close();
                cout.close();
            }
        }
        return failed;
    }

    public static boolean transferData(InputStream inputStream, OutputStream outputStream) throws IOException {
        boolean failed;
        boolean bl = failed = outputStream == null || inputStream == null;
        if (!failed) {
            ReadableByteChannel cin = Channels.newChannel(inputStream);
            WritableByteChannel cout = Channels.newChannel(outputStream);
            if (!(failed |= cin == null || cout == null) && cout != null && cin != null) {
                IOUtils.transferData(cin, cout);
                cin.close();
                cout.close();
            }
        }
        return failed;
    }

    public static boolean transferData(File srcFile, File dstFile) throws IOException {
        boolean failed = false;
        FileInputStream fin = new FileInputStream(srcFile);
        FileOutputStream fout = new FileOutputStream(dstFile);
        FileChannel cin = fin.getChannel();
        FileChannel cout = fout.getChannel();
        cout.transferFrom(cin, 0L, cin.size());
        cin.close();
        cout.close();
        return failed;
    }

    public static void createDirectories(final File basePath) {
        Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!basePath.exists()) {
                    basePath.mkdirs();
                    basePath.setExecutable(false, false);
                    basePath.setReadable(false, false);
                    basePath.setWritable(false, false);
                    basePath.setReadable(true, true);
                    basePath.setWritable(true, true);
                    basePath.setExecutable(true, true);
                }
                return null;
            }
        }, null);
    }

    public static File createTempFile(final String prefix, final String suffix, final File basePath) {
        return Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<File>(){

            @Override
            public File run() {
                File rv = null;
                try {
                    if (!basePath.exists()) {
                        IOUtils.createDirectories(basePath);
                    }
                    rv = File.createTempFile(prefix, suffix, basePath);
                }
                catch (IOException e) {
                    T.raceError("Can't create temporary file: " + e, e);
                }
                catch (IllegalArgumentException e) {
                    T.raceError("Can't create temporary file prefix is to short: " + prefix, e);
                }
                return rv;
            }
        }, null);
    }

    public static File createTempDir(final File baseDir, final String prefix) {
        return Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<File>(){

            @Override
            public File run() {
                String baseName = prefix + System.currentTimeMillis() + ".";
                for (int counter = 0; counter < 5; ++counter) {
                    File tempDir = new File(baseDir, baseName + counter);
                    if (tempDir.mkdirs()) {
                        tempDir.deleteOnExit();
                        return tempDir;
                    }
                    T.raceError("Can't create temporary directory in " + baseDir);
                }
                return null;
            }
        }, null);
    }
}

