/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.util;

import com.apple.eio.FileManager;
import com.sap.platin.trace.T;
import java.io.FileNotFoundException;

public class MACOSXWellKnownFolders {
    public static final short kSystemDomain = -32766;
    public static final short kLocalDomain = -32765;
    public static final short kNetworkDomain = -32764;
    public static final short kUserDomain = -32763;
    public static final String kPreferences = "pref";
    public static final String kApplication = "apps";

    private MACOSXWellKnownFolders() {
    }

    private static int MRJOSTypeStringToInt(String code) {
        byte[] bytes = new byte[4];
        int len = code.length();
        if (len > 0) {
            if (len > 4) {
                len = 4;
            }
            byte[] bs = code.getBytes();
            System.arraycopy(bs, 0, bytes, 0, Math.min(4, bs.length));
        }
        int val = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0) {
                val <<= 8;
            }
            val |= bytes[i] & 0xFF;
        }
        return val;
    }

    public static String getWellKnownFolder(short domain, String key) {
        return MACOSXWellKnownFolders.getWellKnownFolder(domain, key, true);
    }

    public static String getWellKnownFolder(short domain, String key, boolean required) {
        String retVal;
        block3: {
            retVal = null;
            try {
                retVal = FileManager.findFolder((short)domain, (int)MACOSXWellKnownFolders.MRJOSTypeStringToInt(key), (boolean)false);
            }
            catch (FileNotFoundException e) {
                if (!required) break block3;
                T.raceError("Could not locate well known Mac OSX folder: " + key);
                e.printStackTrace();
            }
        }
        if (retVal == null) {
            retVal = System.getProperty("user.home");
        }
        return retVal;
    }
}

