/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.micro.util;

import com.sap.platin.micro.Dynamic;
import com.sap.platin.micro.GuiPrincipal;
import com.sap.platin.micro.util.IOUtils;
import com.sap.platin.micro.util.SystemUtils;
import com.sap.platin.trace.T;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public class XDGInfo {
    protected static final String _PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/micro/util/XDGInfo.java#22 $";
    private static final String LISTSEPARATOR = File.pathSeparator;
    private static final Subject mSAPGUICore = GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore);
    private static XDGInfo mInstance = null;
    private DesktopEnvironment mDesktopEnvironment = null;
    private Map<String, String> mDefaultLocations = null;
    private File mXDGMimeCmd = null;
    private File mXDGIconCmd = null;
    private Map<String, String> mUserDirs = null;

    private static XDGInfo getInstance() {
        if (mInstance == null) {
            mInstance = new XDGInfo();
        }
        return mInstance;
    }

    private XDGInfo() {
        Subject.doAsPrivileged(mSAPGUICore, new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                XDGInfo.this.mXDGMimeCmd = SystemUtils.locateCommand("xdg-mime");
                XDGInfo.this.mXDGIconCmd = SystemUtils.locateCommand("xdg-icon-resource");
                if (!IOUtils.fileExists(XDGInfo.this.mXDGMimeCmd)) {
                    XDGInfo.this.mXDGMimeCmd = null;
                }
                if (!IOUtils.fileExists(XDGInfo.this.mXDGIconCmd)) {
                    XDGInfo.this.mXDGIconCmd = null;
                }
                return null;
            }
        }, null);
    }

    public static DesktopEnvironment getDesktopEnvironment() {
        return XDGInfo.getInstance().getDesktopEnvironmentImpl();
    }

    public static List<File> getSystemDataDirectories() {
        return XDGInfo.getInstance().getSystemDataDirectoriesImpl();
    }

    public static List<File> getSystemConfigDirectories() {
        return XDGInfo.getInstance().getSystemConfigDirectoriesImpl();
    }

    public static File getUserDataDirectory() {
        return XDGInfo.getInstance().getUserDataDirectoryImpl();
    }

    public static File getUserDirectory(UserDirs dir) {
        return XDGInfo.getInstance().getUserDirectoryNameImpl(dir.key);
    }

    public static File getUserConfigDirectory() {
        return XDGInfo.getInstance().getUserConfigDirectoryImpl();
    }

    public static List<File> getExistingConfigFiles(String name) {
        return XDGInfo.getInstance().getExistingFiles("XDG_CONFIG_DIRS", name);
    }

    public static List<File> getExistingDataFiles(String name) {
        return XDGInfo.getInstance().getExistingFiles("XDG_DATA_DIRS", name);
    }

    public static File getFirstWritableConfigFile(String name, boolean restrictExisting) {
        return XDGInfo.getInstance().getFirstWritableFile("XDG_CONFIG_DIRS", name, restrictExisting);
    }

    public static File getFirstWritableDataFile(String name, boolean restrictExisting) {
        return XDGInfo.getInstance().getFirstWritableFile("XDG_DATA_DIRS", name, restrictExisting);
    }

    public static List<File> generateFileList(List<File> dirList, String fileName, boolean restrictExisting) {
        return XDGInfo.getInstance().generateFileListImpl(dirList, fileName, restrictExisting);
    }

    public static List<File> resolveDesktopFile(String basedir, String desktopFile) {
        return XDGInfo.getInstance().resolveDesktopFileImpl(basedir, desktopFile);
    }

    public static String getApplicationForMimeType(String mimeType) {
        return XDGInfo.getInstance().getApplicationForMimeTypeImpl(mimeType);
    }

    public static boolean installIconSet(StringBuffer messages, File iconSet) {
        return XDGInfo.getInstance().installIconSetImpl(messages, iconSet);
    }

    public static String getRootWindowProperty(String key) {
        return XDGInfo.getInstance().getRootWindowPropertyImpl(key);
    }

    public static String getMimeTypeForDocument(File file) {
        return null;
    }

    private DesktopEnvironment getDesktopEnvironmentImpl() {
        return Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<DesktopEnvironment>(){

            @Override
            public DesktopEnvironment run() {
                if (XDGInfo.this.mDesktopEnvironment == null) {
                    XDGInfo.this.mDesktopEnvironment = DesktopEnvironment.GENERIC;
                    String v1 = System.getenv("KDE_FULL_SESSION");
                    String v2 = System.getenv("GNOME_DESKTOP_SESSION_ID");
                    String v3 = XDGInfo.this.getRootWindowPropertyImpl("_DT_SAVE_MODE");
                    if (v1 != null && v1.length() > 0) {
                        XDGInfo.this.mDesktopEnvironment = DesktopEnvironment.KDE;
                    } else if (v2 != null && v2.length() > 0) {
                        XDGInfo.this.mDesktopEnvironment = DesktopEnvironment.GNOME;
                    } else if ("xfce4".equals(v3)) {
                        XDGInfo.this.mDesktopEnvironment = DesktopEnvironment.XFCE;
                    }
                }
                return XDGInfo.this.mDesktopEnvironment;
            }
        }, null);
    }

    private List<File> getSystemDataDirectoriesImpl() {
        return Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<List<File>>(){

            @Override
            public List<File> run() {
                List retVal = Collections.emptyList();
                retVal = XDGInfo.this.parseDirList("XDG_DATA_DIRS");
                return retVal;
            }
        }, null);
    }

    private List<File> getSystemConfigDirectoriesImpl() {
        return Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<List<File>>(){

            @Override
            public List<File> run() {
                List retVal = Collections.emptyList();
                retVal = XDGInfo.this.parseDirList("XDG_CONFIG_DIRS");
                return retVal;
            }
        }, null);
    }

    private File getUserDataDirectoryImpl() {
        String dirName = this.getDefaultLocations().get("XDG_DATA_HOME");
        return dirName != null ? new File(dirName) : null;
    }

    private File getUserDirectoryNameImpl(String dirKey) {
        File retVal = null;
        String name = this.getUserDesktopDirs().get(dirKey);
        if (name != null) {
            retVal = new File(name);
            try {
                retVal = retVal.getCanonicalFile();
            }
            catch (IOException e) {
                T.raceError("Can't access file \"" + name + "\"");
                name = null;
                retVal = null;
            }
        }
        return retVal;
    }

    private Map<String, String> getUserDesktopDirs() {
        if (this.mUserDirs == null) {
            this.mUserDirs = Subject.doAsPrivileged(GuiPrincipal.createSubject(GuiPrincipal.Subjects.SAPGUICore), new PrivilegedAction<Map<String, String>>(){

                @Override
                public Map<String, String> run() {
                    ArrayList error;
                    ArrayList output;
                    String[] cmd;
                    File ucd = XDGInfo.this.getUserConfigDirectoryImpl();
                    File userDirsFile = new File(ucd, "user-dirs.dirs");
                    HashMap<String, String> userDirs = new HashMap<String, String>();
                    if (IOUtils.fileExists(userDirsFile) && XDGInfo.this.runExternalCommand(cmd = new String[]{"/bin/sh", "-c", ". " + userDirsFile.getAbsolutePath() + ";set | grep -E '^XDG_.*_DIR=.*$'"}, output = new ArrayList(), error = new ArrayList()) == 0) {
                        for (String s : output) {
                            String[] tokens = s.split("=");
                            if (tokens[1].startsWith("'") && tokens[1].endsWith("'")) {
                                tokens[1] = tokens[1].substring(1, tokens[1].length() - 1);
                            }
                            userDirs.put(tokens[0], tokens[1]);
                        }
                    }
                    return userDirs;
                }
            }, null);
        }
        return this.mUserDirs;
    }

    private File getUserConfigDirectoryImpl() {
        String dirName = this.getDefaultLocations().get("XDG_CONFIG_HOME");
        return dirName != null ? new File(dirName) : null;
    }

    private List<File> resolveDesktopFileImpl(String basedir, String desktopFile) {
        ArrayList<File> retVal = new ArrayList<File>();
        if (T.race("DESKTOP")) {
            T.race("DESKTOP", "XDGInfo.resolveDesktopFileImpl(): look for \"" + desktopFile + "\"");
        }
        for (File d : XDGInfo.getExistingDataFiles(basedir)) {
            retVal.addAll(this.resolveDesktopFileImpl(d, desktopFile));
        }
        return retVal;
    }

    private List<File> resolveDesktopFileImpl(File baseDir, String desktopFile) {
        ArrayList<File> retVal = new ArrayList<File>();
        if (T.race("DESKTOP")) {
            T.race("DESKTOP", "XDGInfo.resolveDesktopFileImpl():    in directory \"" + baseDir + "\"");
        }
        if (IOUtils.isDirectory(baseDir)) {
            File f = new File(baseDir, desktopFile);
            if (IOUtils.fileExists(f)) {
                retVal.add(f);
            }
            for (File d : baseDir.listFiles()) {
                if (!d.isDirectory()) continue;
                retVal.addAll(this.resolveDesktopFileImpl(d, desktopFile));
            }
        }
        return retVal;
    }

    private boolean installIconSetImpl(final StringBuffer messages, final File i) {
        Boolean f = Subject.doAsPrivileged(mSAPGUICore, new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean failed = false;
                if (XDGInfo.this.mXDGIconCmd != null) {
                    File iconSet = new File(i, "hicolor");
                    String[] resolutions = iconSet.list();
                    failed = false;
                    for (String resolution : resolutions) {
                        String[] iconList;
                        File dir = new File(iconSet, resolution + File.separator + "apps");
                        String size = null;
                        int index = resolution.indexOf(120);
                        if (index > 0) {
                            size = resolution.substring(0, index);
                        }
                        if (!dir.isDirectory()) continue;
                        for (String iconName : iconList = dir.list()) {
                            ArrayList stderr;
                            File iconFile = new File(dir, iconName);
                            String[] command = new String[]{XDGInfo.this.mXDGIconCmd.getAbsolutePath(), "install", "--novendor", "--size", size, iconFile.getAbsolutePath()};
                            int retVal = XDGInfo.this.runExternalCommand(command, null, stderr = new ArrayList());
                            if (retVal == 0) continue;
                            messages.append("\"" + XDGInfo.this.mXDGIconCmd + "\" returns error:\n");
                            messages.append("     This could be a serious problem that should be investigated.\n");
                            messages.append("     Command     : \"" + T.join((Object)" ", command) + "\"\n");
                            messages.append("     Return value: " + retVal + "\n");
                            messages.append(T.formatLines("     ", T.join((Object)"\n", stderr)));
                        }
                    }
                } else {
                    messages.append("Can't install icon set: \"xdg-icon-resource\" command is not available.\n");
                    messages.append("    This is not a fatal error since you are only missing the desktop icons\n");
                    messages.append("    but it means your system is not really XDG compliant and so might lack\n");
                    messages.append("    other expected features.\n");
                    messages.append("    It might help to install a package like \"xdg-utils\"\n");
                }
                return failed;
            }
        }, null);
        return f;
    }

    private String getApplicationForMimeTypeImpl(final String mimeType) {
        return Subject.doAsPrivileged(mSAPGUICore, new PrivilegedAction<String>(){

            @Override
            public String run() {
                String retVal = null;
                ArrayList queryResult = new ArrayList();
                ArrayList queryError = new ArrayList();
                if (XDGInfo.this.mXDGMimeCmd != null) {
                    int rc;
                    if (T.race("DESKTOP")) {
                        T.race("DESKTOP", "XDGInfo.getApplicationForMimeTypeImpl(): use \"" + XDGInfo.this.mXDGMimeCmd + "\"");
                    }
                    if ((rc = XDGInfo.this.runExternalCommand(new String[]{XDGInfo.this.mXDGMimeCmd.getAbsolutePath(), "query", "default", mimeType}, queryResult, queryError)) == 0 && !queryResult.isEmpty()) {
                        String desktopFileName = (String)queryResult.get(0);
                        if (T.race("DESKTOP")) {
                            T.race("DESKTOP", "XDGInfo.getApplicationForMimeTypeImpl(): " + mimeType + " is handled by " + desktopFileName);
                        }
                        try {
                            DesktopFileInfo de = new DesktopFileInfo("applications", desktopFileName);
                            retVal = de.getValue("Desktop Entry", "Exec");
                        }
                        catch (FileNotFoundException e) {
                            T.raceError("XDGInfo.getApplicationForMimeTypeImpl(): can't find desktop entry file: " + desktopFileName, e);
                        }
                    } else if (rc != 0 && rc != 4) {
                        T.raceError("XDGInfo.getApplicationForMimeTypeImpl(): \"" + XDGInfo.this.mXDGMimeCmd + "\" returned the error code " + rc + "\n" + T.formatLines("ERROR", T.join((Object)"\n", queryError)));
                    } else if (T.race("DESKTOP")) {
                        T.race("DESKTOP", "XDGInfo.getApplicationForMimeTypeImpl(): there is no registered application for mime type: \"" + mimeType + "\"");
                    }
                } else {
                    Iterator<File> i$;
                    if (T.race("DESKTOP")) {
                        T.race("DESKTOP", "XDGInfo.getApplicationForMimeTypeImpl(): no trader application parse defaults.list files");
                    }
                    if ((i$ = XDGInfo.getExistingDataFiles("applications/defaults.list").iterator()).hasNext()) {
                        File f = i$.next();
                        if (T.race("DESKTOP")) {
                            T.race("DESKTOP", "XDGInfo.getApplicationForMimeTypeImpl(): check file: \"" + f + "\"");
                        }
                        try {
                            DesktopFileInfo de = new DesktopFileInfo(f);
                            retVal = de.getFirstValue("Default Applications", mimeType);
                            if (retVal.endsWith(".desktop")) {
                                if (T.race("DESKTOP")) {
                                    T.race("DESKTOP", "XDGInfo.getApplicationForMimeTypeImpl(): Resolve desktop file to find application: \"" + retVal + "\"");
                                }
                                DesktopFileInfo handlerDesktopFile = new DesktopFileInfo("applications", retVal);
                                retVal = handlerDesktopFile.getValue("Desktop Entry", "Exec");
                            }
                            if (retVal == null && T.race("DESKTOP")) {
                                T.race("DESKTOP", "XDGInfo.getApplicationForMimeTypeImpl(): there is no registered application for mime type: \"" + mimeType + "\"");
                            }
                        }
                        catch (FileNotFoundException e) {
                            T.raceError("XDGInfo.getApplicationForMimeTypeImpl(): can't find desktop entry file: " + f, e);
                        }
                    }
                }
                if (T.race("DESKTOP")) {
                    T.race("DESKTOP", "XDGInfo.getApplicationForMimeTypeImpl(): " + mimeType + ": \"" + retVal + "\"");
                }
                return retVal;
            }
        }, null);
    }

    private String getRootWindowPropertyImpl(String key) {
        String retVal = null;
        if ("sun.awt.X11.XToolkit".equals(Toolkit.getDefaultToolkit().getClass().getName())) {
            Class<?> xtoolkitC = Dynamic.createClass("sun.awt.X11.XToolkit", this.getClass().getClassLoader());
            Long rootWindow = (Long)Dynamic.callMethod(xtoolkitC, "getDefaultRootWindow", new Class[0], new Object[0]);
            Object xatom = Dynamic.callMethod(Dynamic.createClass("sun.awt.X11.XAtom", this.getClass().getClassLoader()), "get", new Class[]{String.class}, new Object[]{key});
            retVal = (String)Dynamic.callMethod(xatom, "getProperty", new Class[]{Long.TYPE}, new Object[]{rootWindow});
        }
        return retVal;
    }

    private Map<String, String> getDefaultLocations() {
        if (this.mDefaultLocations == null || this.mDefaultLocations.isEmpty()) {
            this.mDefaultLocations = new HashMap<String, String>();
            this.mDefaultLocations.put("XDG_DATA_DIRS", "/usr/local/share:/usr/share");
            this.mDefaultLocations.put("XDG_CONFIG_DIRS", "/etc/xdg");
            this.mDefaultLocations.put("XDG_DATA_HOME", System.getProperty("user.home") + "/.local/share");
            this.mDefaultLocations.put("XDG_CONFIG_HOME", System.getProperty("user.home") + "/.config");
        }
        return this.mDefaultLocations;
    }

    private List<File> getExistingDirectories(final String dirPath) {
        return Subject.doAsPrivileged(mSAPGUICore, new PrivilegedAction<List<File>>(){

            @Override
            public List<File> run() {
                ArrayList<File> retVal = new ArrayList<File>();
                StringTokenizer tokens = new StringTokenizer(dirPath, LISTSEPARATOR);
                while (tokens.hasMoreTokens()) {
                    File dir = new File(tokens.nextToken());
                    if (!dir.exists()) continue;
                    retVal.add(dir);
                }
                return retVal;
            }
        }, null);
    }

    private List<File> parseDirList(String dirListName) {
        String dirList = System.getenv(dirListName);
        if (dirList == null || dirList.length() == 0) {
            dirList = this.getDefaultLocations().get(dirListName);
        }
        List<File> retVal = this.getExistingDirectories(dirList);
        return retVal;
    }

    private List<File> getExistingFiles(final String type, final String name) {
        return Subject.doAsPrivileged(mSAPGUICore, new PrivilegedAction<List<File>>(){

            @Override
            public List<File> run() {
                List dirs = XDGInfo.this.parseDirList(type);
                if ("XDG_DATA_DIRS".equals(type)) {
                    dirs.add(0, XDGInfo.this.getUserDataDirectoryImpl());
                } else if ("XDG_CONFIG_DIRS".equals(type)) {
                    dirs.add(0, XDGInfo.this.getUserConfigDirectoryImpl());
                }
                return XDGInfo.this.generateFileListImpl(dirs, name, true);
            }
        }, null);
    }

    private File getFirstWritableFile(final String type, final String name, final boolean restrictExisting) {
        return Subject.doAsPrivileged(mSAPGUICore, new PrivilegedAction<File>(){

            @Override
            public File run() {
                List files = Collections.emptyList();
                files = XDGInfo.this.generateFileListImpl(XDGInfo.this.parseDirList(type), name, restrictExisting);
                File writable = null;
                for (File fileToTest : files) {
                    if (!IOUtils.isWritable(fileToTest)) continue;
                    writable = fileToTest;
                    break;
                }
                if (writable == null) {
                    File directory = null;
                    if ("XDG_DATA_DIRS".equals(type)) {
                        directory = XDGInfo.this.getUserDataDirectoryImpl();
                    } else if ("XDG_CONFIG_DIRS".equals(type)) {
                        directory = XDGInfo.this.getUserConfigDirectoryImpl();
                    }
                    writable = new File(directory, name);
                }
                return writable;
            }
        }, null);
    }

    private List<File> generateFileListImpl(final List<File> dirList, final String fileName, final boolean restrictExisting) {
        return Subject.doAsPrivileged(mSAPGUICore, new PrivilegedAction<List<File>>(){

            @Override
            public List<File> run() {
                ArrayList<File> retVal = new ArrayList<File>();
                Iterator i = dirList.iterator();
                while (i.hasNext()) {
                    File file = new File((File)i.next(), fileName);
                    if (restrictExisting && !file.exists() || retVal.contains(file)) continue;
                    retVal.add(file);
                }
                return retVal;
            }
        }, null);
    }

    private int runExternalCommand(final String[] cmd, final List<String> output, final List<String> error) {
        Integer val = Subject.doAsPrivileged(mSAPGUICore, new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                ProcessBuilder pb = new ProcessBuilder(cmd);
                if (T.race("DESKTOP")) {
                    T.race("DESKTOP", "XDGInfo.runExternalCommand(): Execute >" + T.join((Object)" ", pb.command().toArray()) + "<");
                }
                Process cmdP = null;
                try {
                    BufferedReader br;
                    cmdP = pb.start();
                    cmdP.waitFor();
                    if (output != null) {
                        br = new BufferedReader(new InputStreamReader(cmdP.getInputStream()));
                        XDGInfo.this.readCommandOutputStream(output, br, cmdP);
                    }
                    if (error != null) {
                        br = new BufferedReader(new InputStreamReader(cmdP.getErrorStream()));
                        XDGInfo.this.readCommandOutputStream(error, br, cmdP);
                    }
                }
                catch (IOException e) {
                    T.raceError("XDGInfo.runExternalCommand(): IOException running " + pb, e);
                }
                catch (InterruptedException e) {
                    T.raceError("XDGInfo.runExternalCommand(): running job was interrupted.", e);
                }
                return cmdP != null ? cmdP.exitValue() : -1;
            }
        }, null);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCommandOutputStream(List<String> output, BufferedReader br, Process cmdP) {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                output.add(line);
            }
        }
        catch (IOException e) {
            T.raceError("readCommandOutputStream(): can't read process output/error stream.", e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                T.raceError("readCommandOutputStream(): can't close buffered reader.", e);
            }
        }
    }

    public static class DesktopFileInfo {
        private File mDesktopFile = null;
        private Map<String, Map<String, String>> mEntryMap = new HashMap<String, Map<String, String>>();

        public DesktopFileInfo(File name) throws FileNotFoundException {
            if (!name.exists()) {
                throw new FileNotFoundException("Can't find desktopfile " + name);
            }
            this.mDesktopFile = name;
            if (T.race("DESKTOP")) {
                T.race("DESKTOP", "DesktopFileInfo.<init>: create desktop file info from \"" + this.mDesktopFile + "\"");
            }
            this.parse();
        }

        public DesktopFileInfo(String basedir, String name) throws FileNotFoundException {
            List<File> df = XDGInfo.resolveDesktopFile(basedir, name);
            if (df.isEmpty()) {
                throw new FileNotFoundException("Can't find matching desktopfile " + basedir + "/" + name);
            }
            this.mDesktopFile = df.get(0);
            if (T.race("DESKTOP")) {
                T.race("DESKTOP", "DesktopFileInfo.<init>: create desktop file info from \"" + this.mDesktopFile + "\"");
            }
            this.parse();
        }

        public String getValue(String section, String key) {
            String retVal = null;
            Map<String, String> map = this.mEntryMap.get(section);
            if (map != null) {
                retVal = map.get(key);
            }
            return retVal;
        }

        public String getFirstValue(String section, String key) {
            String retVal = null;
            List<String> list = this.getList(section, key);
            if (!list.isEmpty()) {
                retVal = list.get(0);
            }
            return retVal;
        }

        public String getLastValue(String section, String key) {
            String retVal = null;
            List<String> list = this.getList(section, key);
            if (!list.isEmpty()) {
                retVal = list.get(list.size() - 1);
            }
            return retVal;
        }

        public List<String> getList(String section, String key) {
            List<String> retVal = Collections.emptyList();
            String line = this.getValue(section, key);
            if (line != null) {
                String[] tokens = line.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
                retVal = Arrays.asList(tokens);
            }
            return retVal;
        }

        public void clear() {
            this.mEntryMap.clear();
        }

        private void parse() {
            String section = null;
            if (this.mDesktopFile != null && this.mDesktopFile.exists()) {
                try {
                    HashMap<String, String> sectionMap = null;
                    BufferedReader br = new BufferedReader(new FileReader(this.mDesktopFile));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        int pos;
                        if ((line = line.trim()).startsWith("[") && line.endsWith("]")) {
                            if (sectionMap != null && section != null) {
                                this.mEntryMap.put(section, sectionMap);
                            }
                            section = line.substring(1, line.length() - 1);
                            sectionMap = new HashMap<String, String>();
                            continue;
                        }
                        if (sectionMap == null || section == null || (pos = line.indexOf(61)) <= 0) continue;
                        String key = line.substring(0, pos).trim();
                        String val = line.substring(Math.min(line.length(), pos + 1)).trim();
                        sectionMap.put(key, val);
                    }
                    br.close();
                    if (sectionMap != null && section != null) {
                        this.mEntryMap.put(section, sectionMap);
                    }
                }
                catch (IOException e) {
                    T.raceError("DesktopFileInfo.parse(): can't read \"" + this.mDesktopFile + "\"", e);
                }
            }
        }
    }

    public static enum UserDirs {
        Public("XDG_PUBLICSHARE_DIR"),
        Templates("XDG_TEMPLATES_DIR"),
        Downloads("XDG_DOWNLOAD_DIR"),
        Pictures("XDG_PICTURES_DIR"),
        Documents("XDG_DOCUMENTS_DIR"),
        Music("XDG_MUSIC_DIR"),
        Desktop("XDG_DESKTOP_DIR"),
        Videos("XDG_VIDEOS_DIR");

        public String key;

        private UserDirs(String _key) {
            this.key = _key;
        }
    }

    public static enum DesktopEnvironment {
        GENERIC,
        KDE,
        GNOME,
        XFCE;

    }
}

