/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.trace;

import com.sap.platin.trace.T;
import com.sap.platin.trace.TraceHookI;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;

public class GuiTraceStream
extends PrintStream
implements TraceHookI {
    private HashMap<File, PrintStream> mTraceStreams = new HashMap();
    private static GuiTraceStream theInstance = null;

    private GuiTraceStream(PrintStream stderr) {
        super(stderr);
    }

    private PrintStream getStdErr() {
        return (PrintStream)this.out;
    }

    private static GuiTraceStream createInstance() {
        if (theInstance == null) {
            try {
                PrintStream stderr = System.err;
                if ("com.sap.platin.trace.GuiTraceStream".equals(stderr.getClass().getName())) {
                    Object value = null;
                    Field f = FilterOutputStream.class.getDeclaredField("out");
                    f.setAccessible(true);
                    value = f.get(stderr);
                    stderr = (PrintStream)value;
                }
                theInstance = new GuiTraceStream(stderr);
                System.setErr(theInstance);
                T.addTraceHook(theInstance);
            }
            catch (Exception e) {
                T.raceError("GuiTraceStream.createInstance(): Exception while setting up GuiTraceStream iinstance: " + e, e);
            }
        }
        return theInstance;
    }

    private static void destroyInstance() {
        if (T.race("TRACE")) {
            T.race("TRC", "Shut down GuiTraceStream.");
        }
        if (theInstance != null) {
            System.setErr(theInstance.getStdErr());
            for (File traceFile : GuiTraceStream.theInstance.mTraceStreams.keySet()) {
                theInstance.stopImpl(traceFile);
            }
            GuiTraceStream.theInstance.mTraceStreams = null;
            T.removeTraceHook(theInstance);
            theInstance = null;
        }
    }

    public static File start(final File f) {
        return AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                if (f != null) {
                    GuiTraceStream.stop(f);
                    GuiTraceStream instance = GuiTraceStream.createInstance();
                    if (instance.startImpl(f) == null) {
                        return null;
                    }
                }
                return f;
            }
        });
    }

    public static void stop(final File f) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (theInstance != null) {
                    boolean destroyInstance = !theInstance.mTraceStreams.isEmpty();
                    theInstance.stopImpl(f);
                    if (destroyInstance && theInstance.mTraceStreams.isEmpty()) {
                        GuiTraceStream.destroyInstance();
                    }
                }
                return null;
            }
        });
    }

    private OutputStream createOutputStream(File f) {
        PrintStream _out = null;
        if (f != null) {
            try {
                _out = new PrintStream(new FileOutputStream(f, true), true);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return _out;
    }

    private OutputStream startImpl(File f) {
        OutputStream _out = this.createOutputStream(f);
        if (_out != null) {
            PrintStream p = new PrintStream(_out, true);
            this.mTraceStreams.put(f, p);
            if (T.race("TRACE")) {
                T.race("TRC", "Trace file opened: " + f);
                T.race("TRC", this.getSystemInfo());
            }
        }
        return _out;
    }

    @Override
    public String getAdvancedSystemInfo() {
        return this.getSystemInfo();
    }

    @Override
    public String getSystemInfo() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String line = "-----------------------------------------------------------\n";
                StringBuffer sb = new StringBuffer();
                sb.append("Trace file details").append("\n");
                sb.append(line);
                sb.append("Trace stream instance = ").append(this.getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(this))).append("\n");
                sb.append("System error stream   = ").append(GuiTraceStream.this.getStdErr().getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(GuiTraceStream.this.getStdErr()))).append("\n");
                sb.append("Open trace files:\n");
                for (File traceFile : GuiTraceStream.this.mTraceStreams.keySet()) {
                    sb.append("   ").append(traceFile.getAbsolutePath()).append("\n");
                }
                return sb.toString();
            }
        });
    }

    private void stopImpl(File f) {
        PrintStream _out;
        if (T.race("TRACE")) {
            T.race("TRC", "Trace file " + f + " closed");
        }
        if ((_out = this.mTraceStreams.remove(f)) != null) {
            try {
                _out.close();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void write(int b) {
        boolean printSysErr = true;
        for (PrintStream stream : this.mTraceStreams.values()) {
            stream.write(b);
            if (this.getStdErr() != stream) continue;
            printSysErr = false;
        }
        if (printSysErr) {
            this.getStdErr().write(b);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        boolean printSysErr = true;
        for (PrintStream stream : this.mTraceStreams.values()) {
            stream.write(buf, off, len);
            if (this.getStdErr() != stream) continue;
            printSysErr = false;
        }
        if (printSysErr) {
            this.getStdErr().write(buf, off, len);
        }
    }

    public static String dumpTraceFiles() {
        String retVal = "none";
        if (theInstance != null && !GuiTraceStream.theInstance.mTraceStreams.isEmpty()) {
            retVal = T.join((Object)"\n", GuiTraceStream.theInstance.mTraceStreams.keySet());
        }
        return retVal;
    }
}

