/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.trace;

import com.sap.platin.trace.T;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class P {
    private static P mInstance = null;
    private OperatingSystemMXBean mOSMXBean = null;
    private MemoryMXBean mMemoryMXBean = null;
    private Map<String, ClockTimer> mClocks = new HashMap<String, ClockTimer>();

    public static long getMemoryUsed() {
        P.mInstance.mMemoryMXBean.gc();
        MemoryUsage retVal = P.mInstance.mMemoryMXBean.getHeapMemoryUsage();
        return retVal.getUsed();
    }

    public static long getCurrentProcessCPUTime() {
        return P.mInstance.mOSMXBean.getProcessCpuTime();
    }

    public static void clearWallClocks() {
        P.mInstance.mClocks.clear();
    }

    public static void createClock(String key, String description) {
        if (!P.mInstance.mClocks.containsKey(key)) {
            ClockTimer clock = mInstance.createClockImpl(key);
            clock.setDescription(description);
            P.mInstance.mClocks.put(key, clock);
        }
    }

    public static ClockTimer getClock(String key) {
        return P.mInstance.mClocks.get(key);
    }

    public static ClockTimer removeClock(String key) {
        return P.mInstance.mClocks.remove(key);
    }

    public static void startClock(String key) {
        P.startClock(key, null);
    }

    public static void startClock(String key, String description) {
        ClockTimer clock = null;
        if (P.mInstance.mClocks.containsKey(key)) {
            clock = P.mInstance.mClocks.get(key);
        } else {
            P.createClock(key, description);
            clock = P.mInstance.mClocks.get(key);
        }
        clock.start();
    }

    public static void describeClock(String key, String description) {
        ClockTimer clock = P.mInstance.mClocks.get(key);
        if (clock != null) {
            clock = P.mInstance.mClocks.get(key);
            clock.setDescription(description);
        }
    }

    public static void stopClock(String key) {
        ClockTimer clock = P.mInstance.mClocks.get(key);
        if (clock != null) {
            clock.stop();
        }
    }

    public static void resetClock(String key) {
        ClockTimer clock = P.mInstance.mClocks.get(key);
        if (clock != null) {
            clock.reset();
        }
    }

    private ClockTimer createClockImpl(String key) {
        return new ClockTimer(key);
    }

    public static String formatClockReport() {
        StringBuffer sb = new StringBuffer();
        TreeSet<ClockTimer> values = new TreeSet<ClockTimer>(P.mInstance.mClocks.values());
        for (ClockTimer timer : values) {
            sb.append(timer.formatTimer());
        }
        return sb.toString();
    }

    static {
        mInstance = new P();
        P.mInstance.mOSMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        P.mInstance.mMemoryMXBean = ManagementFactory.getMemoryMXBean();
    }

    class ClockTimer
    implements Comparable<ClockTimer> {
        private String mTimerDescription = null;
        private String mTimerKey = null;
        private long mEngaged = 0L;
        private long mCumulatedWallClockTime = 0L;
        private long mBaseWallClockTime = -1L;
        private List<Long> mSingleWallClockTimes = null;
        private long mCumulatedCPUTime = 0L;
        private long mBaseCPUTime = -1L;
        private List<Long> mSingleCPUTimes = null;

        public ClockTimer(String timerKey) {
            this.mTimerKey = timerKey;
            if (T.race("DETAILEDTIMES")) {
                this.mSingleWallClockTimes = new ArrayList<Long>();
            }
        }

        public Object formatTimer() {
            StringBuffer retVal = new StringBuffer();
            retVal.append(this.mTimerKey).append(": cum. time(clk): ").append((double)this.mCumulatedWallClockTime / 1000000.0).append(" ms (").append(this.mEngaged).append("), avg time : ").append((double)this.mCumulatedWallClockTime / 1000000.0 / (double)this.mEngaged).append(" ms/call").append(this.mTimerDescription == null ? "" : ": " + this.mTimerDescription).append("\n");
            retVal.append(this.mTimerKey).append(": cum. time(cpu): ").append((double)this.mCumulatedCPUTime / 1000000.0).append(" ms (").append(this.mEngaged).append("), avg time : ").append((double)this.mCumulatedCPUTime / 1000000.0 / (double)this.mEngaged).append(" ms/call").append(this.mTimerDescription == null ? "" : ": " + this.mTimerDescription).append("\n");
            if (T.race("DETAILEDTIMES")) {
                retVal.append("Detailed times:\n");
                for (int a = 0; a < this.mSingleWallClockTimes.size(); ++a) {
                    retVal.append("    [").append(a).append("] ").append("Wall clock: ").append((double)this.mSingleWallClockTimes.get(a).longValue() / 1000000.0).append(" ms, CPU Time: ").append((float)this.mSingleCPUTimes.get(a).longValue() / 1000000.0f).append(" ms\n");
                }
            }
            return retVal.toString();
        }

        public void start() {
            this.mBaseWallClockTime = System.nanoTime();
            this.mBaseCPUTime = P.getCurrentProcessCPUTime();
            ++this.mEngaged;
        }

        public void stop() {
            long time = System.nanoTime() - this.mBaseWallClockTime;
            long cpuTime = P.getCurrentProcessCPUTime() - this.mBaseCPUTime;
            this.mBaseWallClockTime = -1L;
            if (this.mSingleWallClockTimes != null) {
                this.mSingleWallClockTimes.add(time);
            }
            if (this.mSingleCPUTimes != null) {
                this.mSingleCPUTimes.add(cpuTime);
            }
            this.addTime(time, cpuTime);
        }

        public void reset() {
            this.mCumulatedWallClockTime = 0L;
            this.mCumulatedCPUTime = 0L;
        }

        public void addTime(long value, long cpuTime) {
            this.mCumulatedWallClockTime += value;
            this.mCumulatedCPUTime += cpuTime;
        }

        public long getCumulatedTime() {
            return this.mCumulatedWallClockTime;
        }

        public long getCumulatedCPUTime() {
            return this.mCumulatedCPUTime;
        }

        public void setCumulatedTime(long cumulatedTime) {
            this.mCumulatedWallClockTime = cumulatedTime;
        }

        public void setCumulatedCPUTime(long cumulatedTime) {
            this.mCumulatedCPUTime = cumulatedTime;
        }

        public String getTimerDescription() {
            return this.mTimerDescription;
        }

        public void setDescription(String description) {
            this.mTimerDescription = description;
        }

        public void setTimerDescription(String timerDescription) {
            this.mTimerDescription = timerDescription;
        }

        public String getTimerKey() {
            return this.mTimerKey;
        }

        public void setTimerKey(String timerKey) {
            this.mTimerKey = timerKey;
        }

        @Override
        public int compareTo(ClockTimer o) {
            return Long.signum(this.mCumulatedWallClockTime - o.mCumulatedWallClockTime);
        }

        public long getEngaged() {
            return this.mEngaged;
        }

        public void setEngaged(long engaged) {
            this.mEngaged = engaged;
        }
    }
}

