/*
 * Decompiled with CFR 0.152.
 */
package com.sap.platin.trace;

import com.sap.platin.micro.util.IOUtils;
import com.sap.platin.trace.GuiTraceStream;
import com.sap.platin.trace.NativeTraceHookI;
import com.sap.platin.trace.TraceHookI;
import com.sap.platin.trace.TracePrefix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.awt.AppContext;

public class T {
    public static final String __PerforceId = "$Id: //javagui/730_REL/src/java_base/com/sap/platin/trace/T.java#22 $";
    private static Set<String> mTraceKeys = new HashSet<String>();
    private static boolean mTimePrefix = true;
    private static boolean mThreadPrefix = false;
    private static boolean mMilliPrefix = false;
    private static boolean mContextPrefix = false;
    private static SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat("dd.MM. HH:mm:ss.SSS", Locale.getDefault());
    private static long mCurrentTimeMillis = -1L;
    private static DecimalFormat mDecimalFormat = new DecimalFormat("00000");
    private static File mFile = null;
    private static File mDefaultTracefile = null;
    private static File mTracePath = null;
    private static boolean race = false;
    private static String mTraceDefaults = "";
    private static String mHardDefaults = "";
    private static NativeTraceHookI mNativeTraceHook = null;
    private static List<TraceHookI> mTraceHooks = new ArrayList<TraceHookI>();
    public static final String LINESEP = System.getProperty("line.separator");

    private static File getTraceDir() {
        if (mTracePath == null) {
            try {
                Field d_tracedir;
                Class<?> pathInfoClass = Class.forName("com.sap.platin.micro.SystemAccess");
                if (pathInfoClass != null && (d_tracedir = pathInfoClass.getField("PTH_TRACEDIR")) != null) {
                    int traceDirKey = d_tracedir.getInt(null);
                    Method locatePath = pathInfoClass.getMethod("locatePath", Integer.TYPE);
                    if (locatePath != null) {
                        mTracePath = (File)locatePath.invoke(null, traceDirKey);
                    }
                }
            }
            catch (AccessControlException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                cause.printStackTrace();
            }
            if (mTracePath != null) {
                if (!IOUtils.fileExists(mTracePath)) {
                    IOUtils.createDirectories(mTracePath);
                }
            } else {
                mTracePath = new File(System.getProperty("user.home"));
            }
        }
        return mTracePath;
    }

    private static String[] readLines(BufferedReader reader) {
        String[] retVal = new String[]{};
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        if (reader != null) {
            try {
                line = "";
                line = reader.readLine();
                while (line != null) {
                    if ("".equals(line = line.trim())) {
                        line = reader.readLine();
                        continue;
                    }
                    if (line.startsWith("#")) {
                        line = reader.readLine();
                        continue;
                    }
                    int cpos = line.indexOf(35);
                    if (cpos >= 0) {
                        line = line.substring(0, cpos);
                    }
                    if (line.length() > 0) {
                        lines.add(line);
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        if (lines.size() > 0) {
            retVal = lines.toArray(new String[lines.size()]);
        }
        return retVal;
    }

    private static String trimStart(String s) {
        String retVal = s;
        int pos = 0;
        if (s != null) {
            while (retVal.charAt(pos) == ' ' || retVal.charAt(pos) == ':' || retVal.charAt(pos) == '=') {
                ++pos;
            }
            if (pos > 0) {
                retVal = retVal.substring(pos);
            }
        }
        return retVal;
    }

    public static boolean raceGetDefaults() {
        boolean retVal = false;
        String traceKeys = "";
        String traceFileName = "";
        File traceConfig = new File(System.getProperty("user.home"), "platinrc");
        if (traceConfig.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(traceConfig)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            retVal = true;
            String[] lines = T.readLines(reader);
            for (int a = 0; a < lines.length; ++a) {
                if (lines[a].startsWith("traceKeys")) {
                    traceKeys = lines[a].substring(9);
                    traceKeys = T.trimStart(traceKeys);
                    continue;
                }
                if (!lines[a].startsWith("traceFile")) continue;
                traceFileName = lines[a].substring(9);
                traceFileName = T.trimStart(traceFileName);
            }
        }
        if (mHardDefaults.length() > 0) {
            mTraceDefaults = mHardDefaults;
        }
        if (traceKeys.length() > 0) {
            mTraceDefaults = mTraceDefaults.length() > 0 ? mTraceDefaults + ":" + traceKeys : traceKeys;
        }
        if (traceFileName.length() > 0) {
            mDefaultTracefile = new File(traceFileName);
        }
        return retVal;
    }

    public static String join(Object delimiter, Iterable<?> elements) {
        Iterator<?> it;
        if (elements == null || !(it = elements.iterator()).hasNext()) {
            return "";
        }
        String first = String.valueOf(it.next());
        if (!it.hasNext()) {
            return first;
        }
        StringBuilder result = new StringBuilder(first);
        do {
            result.append(delimiter).append(it.next());
        } while (it.hasNext());
        return result.toString();
    }

    public static String join(Object delimiter, Object ... elements) {
        String retVal = "";
        if (elements != null) {
            retVal = T.join(delimiter, Arrays.asList(elements));
        }
        return retVal;
    }

    public static String[] wordWrap(String rawText, int breakWidth) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (rawText != null) {
            Pattern wrapPattern = Pattern.compile("(\\S\\S{" + breakWidth + ",}|.{1," + breakWidth + "})(\\s+|$)");
            Matcher m = wrapPattern.matcher(rawText);
            while (m.find()) {
                retVal.add(m.group().trim());
            }
        }
        return retVal.toArray(new String[retVal.size()]);
    }

    public static String formatLines(String prefix, String text) {
        StringBuffer retVal = new StringBuffer();
        if (text != null) {
            StringTokenizer st = new StringTokenizer(text, "\n");
            String lineDelimiter = "";
            while (st.hasMoreTokens()) {
                retVal.append(lineDelimiter).append(prefix).append(st.nextToken());
                lineDelimiter = LINESEP;
            }
        } else {
            Thread.dumpStack();
        }
        return retVal.toString();
    }

    public static void dumpSystemProperties(String key) {
        Properties p = System.getProperties();
        T.race(key, "System properties [Properties@" + Integer.toHexString(System.identityHashCode(p)) + "]: ");
        Iterator<Object> iter = p.keySet().iterator();
        while (iter.hasNext()) {
            String k = iter.next().toString();
            Object o = p.get(k);
            String v = o != null ? o.toString() : "<null>";
            T.race(key, "   " + k + ": " + v);
        }
    }

    public static String formatStackTrace() {
        return T.formatStackTrace("", new Exception("Stack trace"));
    }

    public static String formatStackTrace(String prefix) {
        return T.formatStackTrace(prefix, new Exception("Stack trace"));
    }

    public static String formatStackTrace(String prefix, Throwable t) {
        StringBuffer retVal = new StringBuffer();
        String delimiter = prefix != null && prefix.trim().length() > 0 ? "\tat " : "at: ";
        retVal.append(prefix).append(t.toString()).append(LINESEP);
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            retVal.append(prefix).append(delimiter).append(trace[i]).append(LINESEP);
        }
        Throwable ourCause = t.getCause();
        if (ourCause != null) {
            retVal.append(" ").append(LINESEP);
            retVal.append(prefix).append("caused by : ").append(ourCause.toString()).append(LINESEP);
            retVal.append(T.formatStackTrace(prefix, ourCause)).append(LINESEP);
        }
        return retVal.toString();
    }

    public static void raceWarning(String outputString) {
        T.raceWarning(outputString, null);
    }

    public static void raceWarning(String outputString, Throwable t) {
        System.err.println(T.formatLines(T.getPrefix("WARNING"), outputString));
        if (t != null) {
            System.err.println(T.formatStackTrace(T.getPrefix("WARNING"), t));
        }
        System.err.flush();
    }

    public static void raceError(String outputString) {
        Throwable t = null;
        if (T.race("ADVINFO")) {
            t = new Throwable("Stack Trace");
        }
        T.raceError(outputString, t);
    }

    public static void raceError(String outputString, Throwable t) {
        System.err.println("############################# ERROR #############################");
        System.err.println(T.formatLines(T.getPrefix("ERROR"), outputString));
        if (t != null) {
            System.err.print(T.formatStackTrace(T.getPrefix("ERROR"), t));
        }
        System.err.println("############################# ERROR #############################");
        System.err.flush();
    }

    public static void raceLog(String key, String outputString) {
        System.err.println(T.formatLines(T.getPrefix(key), outputString));
        System.err.flush();
    }

    public static void race(String key, String outputString) {
        if (mTraceKeys.contains(key)) {
            System.err.println(T.formatLines(T.getPrefix(key), outputString));
            System.err.flush();
        }
    }

    public static void raceBlob(String key, byte[] blob) {
        if (mTraceKeys.contains(key)) {
            T.raceBlob(key, blob, "Blob of " + blob.length + " bytes:");
        }
    }

    public static void raceBlob(String key, byte[] blob, String outputString) {
        if (mTraceKeys.contains(key)) {
            if (blob == null) {
                System.err.println(T.formatLines(T.getPrefix(key), outputString));
                return;
            }
            System.err.println(T.formatLines(T.getPrefix(key), outputString) + T.getHexDump(blob));
        }
    }

    private static String getHexDump(byte[] blob) {
        String outputString = "";
        if (blob == null) {
            return "[null]";
        }
        String countBuf = "";
        int counter = 0;
        char[] lineHexBuf = new char[48];
        char[] lineCharBuf = new char[16];
        int blobLen = blob.length;
        int numLines = blobLen / 16 + (blobLen % 16 != 0 ? 1 : 0);
        if (blob.length > 0) {
            String ln;
            outputString = ln = "   ---------------------------------------------------------------------------";
            for (int line = 0; line < numLines; ++line) {
                for (int i = 0; i < lineHexBuf.length; ++i) {
                    lineHexBuf[i] = 32;
                }
                for (int j = 0; j < lineCharBuf.length; ++j) {
                    lineCharBuf[j] = 32;
                }
                counter = line * 16;
                countBuf = mDecimalFormat.format(counter);
                int numCols = line < numLines - 1 ? 16 : (blobLen % 16 != 0 ? blobLen % 16 : 16);
                for (int col = 0; col < numCols; ++col) {
                    int currentByte = blob[16 * line + col] & 0xFF;
                    String byteString = Integer.toHexString(currentByte);
                    if (byteString.length() == 1) {
                        byteString = "0" + byteString;
                    }
                    lineHexBuf[3 * col] = byteString.charAt(0);
                    lineHexBuf[3 * col + 1] = byteString.charAt(1);
                    lineCharBuf[1 * col] = currentByte >= 32 && currentByte <= 126 ? (int)currentByte : 46;
                }
                outputString = outputString + "\n   " + countBuf + ": " + new String(lineHexBuf) + "| " + new String(lineCharBuf) + " |";
            }
            outputString = outputString + "\n" + ln;
        }
        return outputString;
    }

    public static void raceSystemInfo() {
        String str = "";
        for (TraceHookI hook : mTraceHooks) {
            if (str.length() != 0) {
                str = str + "\n-----------------------------------------------------------\n";
            }
            str = str + (T.race("ADVINFO") ? hook.getAdvancedSystemInfo() : hook.getSystemInfo());
        }
        T.race("TRC", str);
    }

    public static void raceOn(boolean state) {
        boolean changed = state != race;
        race = state;
        if (mNativeTraceHook != null) {
            if (state) {
                mNativeTraceHook.setNativeTraceEnabled(mTraceKeys);
            } else {
                mNativeTraceHook.setNativeTraceEnabled(false);
            }
        }
        if (state && changed) {
            T.raceSystemInfo();
        }
    }

    public static boolean race() {
        return race;
    }

    public static void raceOn(String key, boolean state) {
        if (state) {
            mTraceKeys.add(key);
        } else {
            mTraceKeys.remove(key);
        }
    }

    public static boolean race(String key) {
        return race && mTraceKeys.contains(key);
    }

    public static boolean raceKeyIsSet(String key) {
        return mTraceKeys.contains(key);
    }

    public static void raceSetup(String keyList, String delimiters) {
        boolean traceOn = false;
        String oldKeys = T.join((Object)":", mTraceKeys);
        T.raceReset();
        if (mTraceDefaults != null && mTraceDefaults.length() > 0) {
            if (keyList == null) {
                keyList = "";
            }
            keyList = keyList.trim();
            if (delimiters.indexOf(58) < 0) {
                delimiters = delimiters + ":";
            }
            String string = keyList = keyList.length() > 0 ? mTraceDefaults + ":" + keyList : mTraceDefaults;
        }
        if (keyList == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(keyList, delimiters);
        while (stringTokenizer.hasMoreTokens()) {
            String traceKey;
            try {
                traceKey = stringTokenizer.nextToken();
                traceKey = traceKey.trim();
                if (traceKey.length() == 0) {
                }
            }
            catch (NoSuchElementException e) {}
            continue;
            if (traceKey.startsWith("P_")) {
                try {
                    switch (TracePrefix.valueOf(traceKey)) {
                        case P_MILLI: {
                            T.raceWithMilliPrefix(true);
                            break;
                        }
                        case P_THREAD: {
                            T.raceWithThreadPrefix(true);
                            break;
                        }
                        case P_TIME: {
                            T.raceWithTimePrefix(true);
                            break;
                        }
                        case P_CONTEXT: {
                            T.raceWithContextPrefix(true);
                        }
                    }
                }
                catch (IllegalArgumentException e) {}
                continue;
            }
            T.raceOn(traceKey, true);
            traceOn = true;
        }
        if (traceOn) {
            T.raceOn(traceOn);
        }
        String newKeys = T.join((Object)":", mTraceKeys);
        if (mNativeTraceHook != null) {
            mNativeTraceHook.updateEnvironment(mTraceKeys);
        }
        if (traceOn && !oldKeys.equals(newKeys)) {
            T.race("TRC", "Active trace keys: " + newKeys + (mTraceDefaults != null && mTraceDefaults.length() > 0 ? " (<" + mTraceDefaults + "> from ~/platinrc)" : ""));
        }
    }

    public static void raceReset() {
        mTraceKeys.clear();
        if (mNativeTraceHook != null) {
            mNativeTraceHook.setNativeTraceEnabled(false);
        }
        T.raceOn("TRC", true);
        T.raceOn("AUTDMP", true);
    }

    public static String raceGetSetup() {
        if (!race) {
            return null;
        }
        String activeKeys = "// currently active keys (set externally)\n";
        for (String key : mTraceKeys) {
            if (key.equals("TRC") || key.equals("AUTDMP")) continue;
            activeKeys = activeKeys + key + "\n";
        }
        return activeKeys;
    }

    public static File raceToFile(String fileName) {
        if (fileName != null && (fileName = fileName.trim()).length() == 0) {
            fileName = null;
        }
        if (fileName == null && mFile == null) {
            return null;
        }
        File f = null;
        if (fileName != null) {
            if (fileName.startsWith("~" + File.separator)) {
                String homeDir = System.getProperty("user.home");
                fileName = fileName.substring(2);
                f = new File(homeDir, fileName);
            } else {
                f = new File(fileName);
            }
            mFile = T.raceToAdditionalFile(f);
        } else {
            T.removeAdditionalFile(mFile);
            mFile = null;
        }
        return mFile;
    }

    public static File raceToAdditionalFile(File traceFile) {
        if (!traceFile.isAbsolute()) {
            File traceDir = T.getTraceDir();
            traceFile = new File(traceDir, traceFile.getName());
        }
        String oldData = GuiTraceStream.dumpTraceFiles();
        File retVal = GuiTraceStream.start(traceFile);
        if (retVal != null) {
            T.race("TRC", "Opened redirection to \"" + traceFile + "\"");
            String newData = GuiTraceStream.dumpTraceFiles();
            if (!oldData.equals(newData)) {
                T.race("TRC", "Active redirections:\n   " + newData + "\n");
            }
        }
        return retVal;
    }

    public static void removeAdditionalFile(File traceFile) {
        String oldData = GuiTraceStream.dumpTraceFiles();
        T.race("TRC", "Closing redirection to \"" + traceFile + "\"");
        GuiTraceStream.stop(traceFile);
        String newData = GuiTraceStream.dumpTraceFiles();
        if (!oldData.equals(newData)) {
            T.race("TRC", "Active redirections:\n" + newData + "\n");
        }
    }

    public static String raceFileName() {
        String retVal = "";
        if (mFile != null) {
            retVal = mFile.getAbsolutePath();
        }
        return retVal;
    }

    public static String getPrefix(String key) {
        String retval = key + ": ";
        if (mMilliPrefix) {
            long lastTimeMillis = mCurrentTimeMillis;
            mCurrentTimeMillis = System.currentTimeMillis();
            if (lastTimeMillis != -1L) {
                retval = "(+ " + mDecimalFormat.format(mCurrentTimeMillis - lastTimeMillis) + " ms) " + retval;
            }
        }
        if (mThreadPrefix) {
            retval = "[" + Thread.currentThread().getName() + "] " + retval;
        }
        if (mContextPrefix) {
            retval = "<Context@" + Integer.toHexString(System.identityHashCode(AppContext.getAppContext())) + "> " + retval;
        }
        if (mTimePrefix) {
            retval = mSimpleDateFormat.format(new Date()) + " " + retval;
        }
        return retval;
    }

    public static void raceWithContextPrefix(boolean value) {
        mContextPrefix = value;
    }

    public static boolean raceWithContextPrefix() {
        return mContextPrefix;
    }

    public static void raceWithTimePrefix(boolean value) {
        mTimePrefix = value;
    }

    public static boolean raceWithTimePrefix() {
        return mTimePrefix;
    }

    public static void raceWithThreadPrefix(boolean value) {
        mThreadPrefix = value;
    }

    public static boolean raceWithThreadPrefix() {
        return mThreadPrefix;
    }

    public static void raceWithMilliPrefix(boolean value) {
        mMilliPrefix = value;
    }

    public static boolean raceWithMilliPrefix() {
        return mMilliPrefix;
    }

    public static void removeTraceHook(TraceHookI hook) {
        mTraceHooks.remove(hook);
    }

    public static void addTraceHook(TraceHookI hook) {
        mTraceHooks.add(hook);
    }

    public static void setNativeTraceHook(NativeTraceHookI nativeTraceHook) {
        mNativeTraceHook = nativeTraceHook;
        if (mNativeTraceHook != null && T.race()) {
            mNativeTraceHook.setNativeTraceEnabled(mTraceKeys);
            mNativeTraceHook.updateEnvironment(mTraceKeys);
        }
    }

    static {
        Class<?> microUtilsClass = null;
        try {
            microUtilsClass = Class.forName("com.sap.platin.micro.MicroUtils");
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        if (microUtilsClass != null) {
            try {
                Field instance = microUtilsClass.getField("mInstance");
                if (instance != null) {
                    TraceHookI microUtils = (TraceHookI)instance.get(null);
                    T.addTraceHook(microUtils);
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        T.raceReset();
        T.raceGetDefaults();
        try {
            if (mDefaultTracefile != null) {
                T.raceToAdditionalFile(mDefaultTracefile);
            }
            if (mFile != null) {
                T.raceToAdditionalFile(mFile);
            }
            T.raceSetup("", ":");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

