/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xml;

import com.sap.xml.XMLHandler;
import com.sap.xml.XMLParser;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class XMLNode
implements Cloneable,
Serializable {
    public static final int PARSER_INTERNAL = 0;
    private String mName;
    private String mValue;
    private Hashtable<String, Object> mAttributes = new Hashtable();
    private Vector<XMLNode> mChildren = new Vector();
    private XMLNode mParent;
    public static final String kATTR_XMLSPACES = "xml:space";
    public static final String kATTR_XMLSPACES_PRESERVE = "preserve";
    private boolean mXMLPreserveSpace = false;

    public XMLNode() {
        this.mName = "ROOT";
    }

    public XMLNode(String name) {
        this.mName = name;
    }

    public Object clone() {
        Object retVal = null;
        try {
            retVal = super.clone();
            ((XMLNode)retVal).mName = this.mName;
            ((XMLNode)retVal).mValue = this.mValue;
            ((XMLNode)retVal).mChildren = new Vector();
            ((XMLNode)retVal).mAttributes = new Hashtable();
            ((XMLNode)retVal).mXMLPreserveSpace = false;
        }
        catch (Exception e) {
            System.err.println("XMLNode.clone() exception occured: " + e);
        }
        return retVal;
    }

    public Object cloneAll() {
        Object retVal = null;
        try {
            retVal = super.clone();
            ((XMLNode)retVal).mName = this.mName;
            ((XMLNode)retVal).mValue = this.mValue;
            ((XMLNode)retVal).mParent = this.mParent;
            ((XMLNode)retVal).mChildren = new Vector();
            ((XMLNode)retVal).mAttributes = new Hashtable();
            ((XMLNode)retVal).mXMLPreserveSpace = this.mXMLPreserveSpace;
            Enumeration<String> keys = this.mAttributes.keys();
            while (keys.hasMoreElements()) {
                String currKey = keys.nextElement();
                ((XMLNode)retVal).mAttributes.put(new String(currKey), new String((String)this.mAttributes.get(currKey)));
            }
            for (int i = 0; i < this.getNumOfChildren(); ++i) {
                XMLNode currChild = this.getChildAt(i);
                XMLNode clonedChild = (XMLNode)currChild.cloneAll();
                clonedChild.setParent((XMLNode)retVal);
                ((XMLNode)retVal).mChildren.add(clonedChild);
            }
        }
        catch (Exception e) {
            System.err.println("XMLNode.cloneAll() exception occured: " + e);
        }
        return retVal;
    }

    public static XMLNode parseFrom(String xmlDocument, int parserType) throws Exception {
        StringReader xmlReader = new StringReader(xmlDocument);
        return XMLNode.parseFrom(xmlReader, parserType);
    }

    public static XMLNode parseFrom(Reader xmlReader) throws Exception {
        return XMLNode.parseFrom(xmlReader, 0);
    }

    public static XMLNode parseFrom(Reader xmlReader, int parserType) throws Exception {
        XMLHandler handler = new XMLHandler();
        if (parserType != 0) {
            throw new Exception("XMLNode.parseFrom: invalid parser type " + parserType);
        }
        XMLParser parser = new XMLParser();
        parser.setHandler(handler);
        parser.parse(xmlReader);
        return handler.getTopNode().getChildAt(0);
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setValue(String value) {
        this.mValue = value == null ? "(null)" : value;
    }

    public void setValueData(char[] ch, int start, int length) {
        String str = new String(ch, start, length);
        if (this.mXMLPreserveSpace) {
            if (this.mValue == null) {
                this.mValue = str;
            }
        } else {
            this.mValue = str.trim();
        }
    }

    public String getValue() {
        return this.mValue;
    }

    public int getNumOfAttributes() {
        return this.mAttributes.size();
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.mAttributes.put(name, value);
        }
    }

    public void setAttribute(String name, String value) {
        if (name.startsWith("xml:") && kATTR_XMLSPACES.equals(name)) {
            this.mXMLPreserveSpace = kATTR_XMLSPACES_PRESERVE.equals(value);
        }
        this.mAttributes.put(name, value == null ? "(null)" : value);
    }

    public void setAttribute(String name, int value) {
        this.mAttributes.put(name, Integer.toString(value));
    }

    public void setAttribute(String name, boolean value) {
        this.mAttributes.put(name, value ? "1" : "0");
    }

    public void removeAttribute(String name) {
        if (name.startsWith("xml:") && kATTR_XMLSPACES.equals(name)) {
            this.mXMLPreserveSpace = false;
        }
        this.mAttributes.remove(name);
    }

    public void removeAllAttributes() {
        this.mXMLPreserveSpace = false;
        this.mAttributes.clear();
    }

    public boolean hasAttribute(String name) {
        return this.mAttributes.containsKey(name);
    }

    public String getAttribute(String name) {
        String retVal = null;
        Object o = this.mAttributes.get(name);
        if (o != null) {
            retVal = o.toString();
        }
        return retVal;
    }

    public int getAttributeAsInt(String name) {
        return Integer.parseInt(this.mAttributes.get(name).toString());
    }

    public boolean getAttributeAsBoolean(String name) {
        return this.mAttributes.get(name).toString().equals("1");
    }

    public Object getAttributeAsObject(String name) {
        return this.mAttributes.get(name);
    }

    public Enumeration<String> getAttributes() {
        return this.mAttributes.keys();
    }

    public void add(XMLNode child) {
        this.mChildren.addElement(child);
        child.setParent(this);
    }

    public void add(XMLNode child, int index) {
        this.mChildren.insertElementAt(child, index);
        child.setParent(this);
    }

    public void remove(XMLNode child) {
        if (child != null) {
            this.mChildren.removeElement(child);
            child.setParent(null);
        }
    }

    public void removeAll() {
        XMLNode[] children = this.mChildren.toArray(new XMLNode[this.mChildren.size()]);
        for (int i = 0; i < children.length; ++i) {
            children[i].setParent(null);
        }
        this.mChildren.removeAllElements();
    }

    public Enumeration<XMLNode> getChildren() {
        return this.mChildren.elements();
    }

    public Iterator<XMLNode> getChildrenIterator() {
        return this.mChildren.iterator();
    }

    public int getNumOfChildren() {
        return this.mChildren.size();
    }

    public int getNumOfChildren(String name) {
        int retval = 0;
        Enumeration<XMLNode> en = this.mChildren.elements();
        while (en.hasMoreElements()) {
            XMLNode childNode = en.nextElement();
            if (!childNode.getName().equals(name)) continue;
            ++retval;
        }
        return retval;
    }

    public XMLNode getChildAt(int idx) {
        return this.mChildren.elementAt(idx);
    }

    public XMLNode getChildByName(String name) {
        Enumeration<XMLNode> en = this.getChildren();
        while (en.hasMoreElements()) {
            XMLNode childNode = en.nextElement();
            if (!childNode.getName().equals(name)) continue;
            return childNode;
        }
        return null;
    }

    public int getChildIndexByName(String name) {
        int index = 0;
        Enumeration<XMLNode> en = this.getChildren();
        while (en.hasMoreElements()) {
            XMLNode childNode = en.nextElement();
            if (childNode.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    void setParent(XMLNode parent) {
        this.mParent = parent;
    }

    public XMLNode getParent() {
        return this.mParent;
    }

    public static String escape(String str) {
        return XMLNode.escape(str, false);
    }

    public static String escape(String str, boolean lf2cr) {
        return XMLNode.escape(str, lf2cr, false);
    }

    public static String escape(String str, boolean lf2cr, boolean specialEsc) {
        StringBuffer buf = new StringBuffer(str.length());
        block9: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block9;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block9;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block9;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block9;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block9;
                }
                case '\n': {
                    buf.append(lf2cr ? "\r\n" : "\n");
                    continue block9;
                }
                case '\r': {
                    if (lf2cr) {
                        if (i != str.length() && str.charAt(i + 1) == '\n') continue block9;
                        buf.append("\r\n");
                        ++i;
                        continue block9;
                    }
                    if (specialEsc) {
                        buf.append("&#x0D;");
                        continue block9;
                    }
                    buf.append('\r');
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        str = new String(buf);
        return str;
    }

    public static String unEscape(String str) throws Exception {
        return XMLNode.unEscape(str, null);
    }

    public static String unEscape(String str, String encoding) throws Exception {
        int idx = str.indexOf(38);
        if (idx == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        while (idx != -1) {
            buf.append(str.substring(0, idx));
            str = str.substring(idx);
            if (str.startsWith("&amp;")) {
                buf.append('&');
                str = str.substring(5);
            } else if (str.startsWith("&lt;")) {
                buf.append('<');
                str = str.substring(4);
            } else if (str.startsWith("&gt;")) {
                buf.append('>');
                str = str.substring(4);
            } else if (str.startsWith("&apos;")) {
                buf.append('\'');
                str = str.substring(6);
            } else if (str.startsWith("&quot;")) {
                buf.append('\"');
                str = str.substring(6);
            } else if (str.startsWith("&#")) {
                int idxEnd = str.indexOf(59);
                if (idxEnd != 4) {
                    throw new Exception("XMLNode.unescape: unknown entity: " + str);
                }
                str = str.substring(2);
                String numStr = str.substring(0, 2);
                buf.append(XMLNode.UnicodeToString(numStr, encoding));
                str = str.substring(3);
            } else {
                throw new Exception("XMLNode.unescape: unknown entity: " + str);
            }
            idx = str.indexOf(38);
        }
        buf.append(str);
        return new String(buf);
    }

    public static String UnicodeToString(String strNum) {
        return XMLNode.UnicodeToString(XMLNode.StringToInt(strNum));
    }

    public static String UnicodeToString(String strNum, String enc) {
        if (enc == null) {
            return XMLNode.UnicodeToString(XMLNode.StringToInt(strNum));
        }
        return XMLNode.UnicodeToString(XMLNode.StringToInt(strNum), enc);
    }

    public static String UnicodeToString(int ucNum) {
        byte[] bArray = new byte[]{(byte)ucNum};
        return new String(bArray);
    }

    public static String UnicodeToString(int ucNum, String enc) {
        byte[] bArray = new byte[]{(byte)ucNum};
        String str = "";
        try {
            str = new String(bArray, enc);
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
        return str;
    }

    public static int StringToInt(String str) {
        int val = 0;
        val = str.toUpperCase().charAt(0) == 'X' ? Integer.parseInt(str.substring(1), 16) : (str.charAt(0) == '0' ? Integer.parseInt(str.substring(1), 8) : Integer.parseInt(str));
        return val;
    }

    private boolean isLeafWithoutValue() {
        return this.mChildren.isEmpty() && (this.mValue == null || this.mValue.length() == 0);
    }

    private static StringBuffer indent(StringBuffer buf, int level, boolean indent) {
        if (!indent) {
            return buf;
        }
        for (int i = 0; i < level; ++i) {
            buf.append("  ");
        }
        return buf;
    }

    public void dump(Writer writer) throws IOException {
        writer.write("<");
        writer.write(this.mName);
        this.dumpAttributes(writer);
        if (this.isLeafWithoutValue()) {
            writer.write("/>");
        } else {
            writer.write(">\n");
            this.dumpValue(writer);
            this.dumpChildren(writer);
            writer.write("</");
            writer.write(this.mName);
            writer.write(">");
        }
    }

    private void dumpAttributes(Writer writer) throws IOException {
        Enumeration<String> en = this.getAttributes();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            String value = this.getAttribute(XMLNode.escape(name));
            writer.write(" ");
            writer.write(name);
            writer.write("=\"");
            writer.write(XMLNode.escape(value));
            writer.write("\"");
        }
    }

    private void dumpValue(Writer writer) throws IOException {
        if (this.mValue != null && this.mValue.length() != 0) {
            writer.write(XMLNode.escape(this.mValue));
        }
    }

    private void dumpChildren(Writer writer) throws IOException {
        Enumeration<XMLNode> en = this.getChildren();
        while (en.hasMoreElements()) {
            XMLNode child = en.nextElement();
            child.dump(writer);
        }
    }

    public String dump(boolean indent) {
        return this.dump(indent, false);
    }

    public String dump(boolean indent, boolean specialEsc) {
        StringBuffer buf = new StringBuffer(8192);
        this.dump(buf, 0, indent, specialEsc);
        return new String(buf);
    }

    public String dumpNode(boolean indent) {
        int level = 0;
        StringBuffer buf = new StringBuffer(1024);
        XMLNode.indent(buf, level, indent).append("<").append(this.mName);
        this.dumpAttributes2(buf, level, indent);
        if (this.isLeafWithoutValue()) {
            buf.append("/>");
            if (indent) {
                buf.append("\n");
            }
        } else {
            buf.append(">");
            if (indent) {
                buf.append("\n");
            }
            this.dumpValue(buf, level, indent);
            Enumeration<XMLNode> en = this.getChildren();
            while (en.hasMoreElements()) {
                XMLNode child = en.nextElement();
                String name = child.getName();
                XMLNode.indent(buf, level + 1, indent).append("<").append(name).append(" ... />");
                if (!indent) continue;
                buf.append("\n");
            }
            XMLNode.indent(buf, level, indent).append("</").append(this.mName).append(">");
            if (indent) {
                buf.append("\n");
            }
        }
        return new String(buf);
    }

    StringBuffer dump(StringBuffer buf, int level, boolean indent) {
        return this.dump(buf, level, indent, false);
    }

    StringBuffer dump(StringBuffer buf, int level, boolean indent, boolean specialEsc) {
        return this.dump(buf, level, indent, specialEsc, false);
    }

    StringBuffer dump(StringBuffer buf, int level, boolean indent, boolean specialEsc, boolean parentPreserveSpace) {
        XMLNode.indent(buf, level, indent && !parentPreserveSpace).append("<").append(this.mName);
        this.dumpAttributes(buf, level, indent, specialEsc);
        if (this.isLeafWithoutValue()) {
            buf.append("/>");
            if (indent && !parentPreserveSpace) {
                buf.append("\n");
            }
        } else {
            buf.append(">");
            if (indent && !this.mXMLPreserveSpace) {
                buf.append("\n");
            }
            this.dumpValue(buf, level, indent);
            this.dumpChildren(buf, level, indent, specialEsc);
            XMLNode.indent(buf, level, indent && !this.mXMLPreserveSpace).append("</").append(this.mName).append(">");
            if (indent && !this.mXMLPreserveSpace) {
                buf.append("\n");
            }
        }
        return buf;
    }

    private StringBuffer dumpAttributes(StringBuffer buf, int level, boolean indent, boolean specialEsc) {
        Enumeration<String> en = this.getAttributes();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            String value = this.getAttribute(name);
            buf.append(" ").append(name).append("=\"").append(XMLNode.escape(value, false, specialEsc)).append("\"");
        }
        return buf;
    }

    private StringBuffer dumpAttributes2(StringBuffer buf, int level, boolean indent) {
        Enumeration<String> en = this.getAttributes();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            String value = this.getAttribute(name);
            if (indent) {
                buf.append("\n");
                XMLNode.indent(buf, level + 1, indent).append(name).append("=\"").append(XMLNode.escape(value)).append("\"");
                continue;
            }
            buf.append(" ").append(name).append("=\"").append(XMLNode.escape(value)).append("\"");
        }
        return buf;
    }

    private StringBuffer dumpValue(StringBuffer buf, int level, boolean indent) {
        if (this.mValue != null && this.mValue.length() != 0) {
            if (this.mXMLPreserveSpace) {
                buf.append(XMLNode.escape(this.mValue));
            } else {
                XMLNode.indent(buf, level, indent);
                if (indent) {
                    buf.append("    ");
                }
                buf.append(XMLNode.escape(this.mValue));
                if (indent) {
                    buf.append("\n");
                }
            }
        }
        return buf;
    }

    private StringBuffer dumpChildren(StringBuffer buf, int level, boolean indent, boolean specialEsc) {
        Enumeration<XMLNode> en = this.getChildren();
        while (en.hasMoreElements()) {
            XMLNode child = en.nextElement();
            child.dump(buf, level + 1, indent, specialEsc, this.mXMLPreserveSpace);
        }
        return buf;
    }

    public String toString() {
        String retVal = this.getClass().getName();
        retVal = retVal + "\n   {\n";
        String tmp = "";
        for (String element : this.mAttributes.keySet()) {
            Object value = this.mAttributes.get(element);
            tmp = tmp + "      " + element.toString() + " : " + " \"" + value.toString() + "\"\n";
        }
        retVal = retVal + tmp;
        retVal = retVal + "   }\n";
        return retVal;
    }

    protected boolean isXMLPreserveSpace() {
        return this.mXMLPreserveSpace;
    }
}

