/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xml;

import com.sap.xml.XMLHandlerI;
import com.sap.xml.XMLNode;
import java.io.Reader;

public class XMLParser {
    private Reader mReader = null;
    private XMLHandlerI mHandler = null;
    private char[] mBuffer = new char[8192];
    private int mBufferPos = 0;
    private int mBufferLength = 0;
    private int mState = 1;
    private char mLastChar;
    private char[] mStringBuffer = new char[256];
    private int mStringBufferPos = 0;
    private int mStringBufferSize = 256;
    private int mStringBufferIncrement = 512;
    private int mLine = 1;
    private int mCol = 0;
    private static final int ST_INIT = 1;
    private static final int ST_LT = 2;
    private static final int ST_LT_SLASH = 3;
    private static final int ST_GT = 4;
    private static final int ST_SLASH_GT = 5;
    private static final int ST_ATTRIBUTE = 6;
    private static final int ST_EQUALS = 7;
    private static final int ST_ELEMENTNAME = 8;

    public void setHandler(XMLHandlerI handler) {
        this.mHandler = handler;
    }

    public void parse(Reader reader) throws Exception {
        this.mReader = reader;
        if (this.mHandler != null) {
            this.mHandler.startDocument();
        }
        this.mState = 1;
        this.parseProlog();
        this.parseFirstComment();
        this.parseElement();
        if (this.mHandler != null) {
            this.mHandler.endDocument();
        }
    }

    private final boolean parseProlog() throws Exception {
        char c = this.eatWhiteSpace();
        if (c != '<') {
            this.error("expected '<'");
        }
        this.mState = 2;
        if (this.mBuffer[this.mBufferPos] == '?') {
            this.requireHeader("?xml version");
            this.mState = 4;
            return true;
        }
        return false;
    }

    private final void parseComment() throws Exception {
        this.require('-');
        this.require('-');
        char c2 = this.getChar();
        char c3 = this.getChar();
        while (c2 != '-' || c3 != '-') {
            c2 = c3;
            c3 = this.getChar();
        }
        this.require('>');
        this.mState = 4;
    }

    private final boolean parseFirstComment() throws Exception {
        char c;
        if (this.mState == 4 || this.mState == 5) {
            this.parseCharData();
        }
        if (this.mState != 2) {
            this.error("expected '<'");
        }
        if ((c = this.getChar()) == '!') {
            this.parseComment();
            this.parseFirstComment();
            return true;
        }
        --this.mBufferPos;
        return false;
    }

    private final boolean parseElement() throws Exception {
        char c;
        if (this.mState == 4 || this.mState == 5) {
            this.parseCharData();
        }
        if (this.mState != 2) {
            this.error("expected '<'");
        }
        if ((c = this.getChar()) == '/') {
            this.mState = 3;
            return false;
        }
        if (c == '!') {
            this.parseComment();
            return true;
        }
        this.mState = 8;
        String name = this.parseElementName(c);
        while (this.mState == 6) {
            this.parseAttribute();
        }
        if (this.mHandler != null) {
            this.mHandler.startElement(name);
        }
        if (this.mState == 4) {
            boolean foundChild = this.parseElement();
            while (foundChild) {
                foundChild = this.parseElement();
            }
            if (this.mState != 3) {
                this.error("expected '</'");
            }
            this.require(name);
            this.require('>');
            this.mState = 4;
        } else if (this.mState != 5) {
            this.error("expected '>' or '/>'");
        }
        if (this.mHandler != null) {
            this.mHandler.endElement(name);
        }
        return true;
    }

    private final boolean parseAttribute() throws Exception {
        char c = this.eatWhiteSpace();
        if (c == '/') {
            this.require('>');
            this.mState = 5;
            return false;
        }
        if (c == '>') {
            this.mState = 4;
            return false;
        }
        String name = this.parseAttributeName(c);
        String value = this.parseAttributeValue();
        if (this.mHandler != null) {
            this.mHandler.attribute(name, value, false);
        }
        this.mState = 6;
        return true;
    }

    private final char eatWhiteSpace() throws Exception {
        char c;
        block3: while (true) {
            c = this.getChar();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return c;
    }

    private final void parseCharData() throws Exception {
        char c = this.getChar();
        while (c != '<') {
            if (c == '&') {
                this.parseCharacterEntity();
            } else {
                this.storeToStringBuf(c);
            }
            c = this.getChar();
        }
        if (this.mStringBufferPos > 0 && this.mHandler != null) {
            this.mHandler.charData(this.mStringBuffer, 0, this.mStringBufferPos);
        }
        this.mStringBufferPos = 0;
        this.mState = 2;
    }

    private final String parseElementName(char c) throws Exception {
        while (true) {
            switch (c) {
                case '/': {
                    this.require('>');
                    this.mState = 5;
                    return this.stringBufToString();
                }
                case '>': {
                    this.mState = 4;
                    return this.stringBufToString();
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.mState = 6;
                    return this.stringBufToString();
                }
            }
            this.storeToStringBuf(c);
            c = this.getChar();
        }
    }

    private final String parseAttributeName(char c) throws Exception {
        while (c != '=' && c != ' ') {
            this.storeToStringBuf(c);
            c = this.getChar();
        }
        if (c == ' ') {
            c = this.eatWhiteSpace();
        }
        if (c != '=') {
            this.error("expected '='");
        }
        this.mState = 7;
        return this.stringBufToString();
    }

    private final String parseAttributeValue() throws Exception {
        boolean unEscape = false;
        this.mState = 6;
        char start = this.eatWhiteSpace();
        if (start != '\'' && start != '\"') {
            this.error("expected '\"'");
        }
        char c = this.getChar();
        while (true) {
            switch (c) {
                case '\"': {
                    if (start != c) {
                        this.storeToStringBuf(c);
                        break;
                    }
                    return this.stringBufToString();
                }
                case '\'': {
                    if (start != c) {
                        this.storeToStringBuf(c);
                        break;
                    }
                    return this.stringBufToString();
                }
                case '&': {
                    this.parseCharacterEntity();
                    break;
                }
                default: {
                    this.storeToStringBuf(c);
                }
            }
            c = this.getChar();
        }
    }

    private final void parseCharacterEntity() throws Exception {
        char c = this.getChar();
        switch (c) {
            case 'a': {
                c = this.getChar();
                if (c == 'm') {
                    this.require('p');
                    this.require(';');
                    this.storeToStringBuf('&');
                    break;
                }
                if (c == 'p') {
                    this.require('o');
                    this.require('s');
                    this.require(';');
                    this.storeToStringBuf('\'');
                    break;
                }
                this.error("invalid character entity starting with '&a" + c + "'");
                break;
            }
            case 'l': {
                this.require('t');
                this.require(';');
                this.storeToStringBuf('<');
                break;
            }
            case 'g': {
                this.require('t');
                this.require(';');
                this.storeToStringBuf('>');
                break;
            }
            case 'q': {
                this.require('u');
                this.require('o');
                this.require('t');
                this.require(';');
                this.storeToStringBuf('\"');
                break;
            }
            case '#': {
                this.storeToStringBuf(this.parseCharacterEntityNum());
                break;
            }
            default: {
                this.error("invalid character entity starting with '&" + c + "'");
            }
        }
    }

    private final char parseCharacterEntityNum() throws Exception {
        char c = this.getChar();
        String str = "";
        while (c != ';') {
            str = str + c;
            c = this.getChar();
        }
        if (c != ';') {
            this.error("expected ';'");
        }
        try {
            c = XMLNode.UnicodeToString(str).charAt(0);
        }
        catch (NumberFormatException e) {
            this.error("expected a unicode number entity but got '" + str + "'");
        }
        return c;
    }

    private final void require(char exp) throws Exception {
        char got = this.getChar();
        if (got != exp) {
            this.error("expected '" + exp + "'");
        }
    }

    private final void require(String s) throws Exception {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.require(s.charAt(i));
        }
    }

    private final void requireHeader(String s) throws Exception {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.require(s.charAt(i));
        }
        while (this.getChar() != '?') {
        }
        this.require('>');
    }

    private final char getChar() throws Exception {
        if (this.mBufferPos >= this.mBufferLength) {
            this.mBufferPos = 0;
            this.mBufferLength = this.mReader.read(this.mBuffer);
            if (this.mBufferLength < 0) {
                this.error("unexpected end of file");
            }
        }
        this.mLastChar = this.mBuffer[this.mBufferPos++];
        ++this.mCol;
        if (this.mLastChar == '\n') {
            ++this.mLine;
        }
        return this.mLastChar;
    }

    private void storeToStringBuf(char c) {
        if (this.mStringBufferPos >= this.mStringBufferSize) {
            int newSize = this.mStringBufferSize + this.mStringBufferIncrement;
            this.mStringBufferIncrement *= 2;
            char[] newStringBuffer = new char[newSize];
            System.arraycopy(this.mStringBuffer, 0, newStringBuffer, 0, this.mStringBufferSize);
            this.mStringBufferSize = newSize;
            this.mStringBuffer = newStringBuffer;
        }
        this.mStringBuffer[this.mStringBufferPos++] = c;
    }

    private String stringBufToString() {
        String retval = new String(this.mStringBuffer, 0, this.mStringBufferPos);
        this.mStringBufferPos = 0;
        return retval;
    }

    private final void error(String text) throws Exception {
        throw new Exception("Syntax error: " + text + " (line " + this.mLine + ", col " + this.mCol + ", char='" + this.mLastChar + "', state=" + this.mState + ")");
    }
}

