/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xml;

import java.io.Writer;
import java.util.Stack;

public class XMLStream {
    private Writer mWriter;
    private Stack mElementNames;
    private Stack mState;
    private boolean mInsertLineFeeds = false;
    private static final int ST_INIT = 0;
    private static final int ST_DOCUMENT = 1;
    private static final int ST_ELEMENT = 2;
    private static final int ST_ATTRIBUTES = 3;

    public XMLStream(Writer writer) {
        this.mWriter = writer;
        this.mElementNames = new Stack();
        this.mState = new Stack();
        this.pushState(0);
    }

    public void startDocument() throws Exception {
        if (this.mInsertLineFeeds) {
            this.mWriter.write("\n");
        }
        this.pushState(1);
    }

    public void endDocument() throws Exception {
        this.popState(1);
    }

    public void startElement(String name) throws Exception {
        if (this.getState() == 3) {
            this.mWriter.write(">");
            this.popState(3);
            if (this.mInsertLineFeeds) {
                this.mWriter.write("\n");
            }
        }
        this.mWriter.write("<");
        this.mWriter.write(name);
        this.pushName(name);
        this.pushState(2);
        this.pushState(3);
    }

    public void endElement(String name) throws Exception {
        this.popName(name);
        if (this.getState() == 3) {
            this.mWriter.write("/>");
            this.popState(3);
            if (this.mInsertLineFeeds) {
                this.mWriter.write("\n");
            }
        } else {
            this.mWriter.write("</");
            this.mWriter.write(name);
            this.mWriter.write(">");
            if (this.mInsertLineFeeds) {
                this.mWriter.write("\n");
            }
        }
        this.popState(2);
    }

    public void addAttribute(String name, String value) throws Exception {
        if (this.getState() != 3) {
            throw new Exception("XML Error: Attribute '" + name + "=\"" + value + "\"' illegal in state " + this.getState());
        }
        this.mWriter.write(" ");
        this.mWriter.write(name);
        this.mWriter.write("=\"");
        if (value != null) {
            this.mWriter.write(value);
        }
        this.mWriter.write("\"");
    }

    public void addAttribute(String name, int value) throws Exception {
        this.addAttribute(name, Integer.toString(value));
    }

    public void addAttribute(String name, boolean value) throws Exception {
        this.addAttribute(name, value ? "1" : "0");
    }

    public void addValueData(String valueData) throws Exception {
        if (this.getState() == 3) {
            this.mWriter.write(">");
            this.popState(3);
        }
        if (this.getState() != 2) {
            throw new Exception("XML Error: ValueData '" + valueData + "' illegal in state " + this.getState());
        }
        this.mWriter.write(valueData);
    }

    public void addValueDataElement(String name, String valueData) throws Exception {
        if (this.getState() == 3) {
            this.mWriter.write(">");
            this.popState(3);
            if (this.mInsertLineFeeds) {
                this.mWriter.write("\n");
            }
        }
        this.mWriter.write("<");
        this.mWriter.write(name);
        this.mWriter.write(">");
        this.mWriter.write(valueData);
        this.mWriter.write("</");
        this.mWriter.write(name);
        this.mWriter.write(">");
        if (this.mInsertLineFeeds) {
            this.mWriter.write("\n");
        }
    }

    public void addValueDataElement(String name, boolean valueData) throws Exception {
        this.addValueDataElement(name, valueData ? "1" : "0");
    }

    public void addValueDataElement(String name, int valueData) throws Exception {
        this.addValueDataElement(name, Integer.toString(valueData));
    }

    private void pushState(int state) {
        this.mState.push(new Integer(state));
    }

    private void popState(int state) throws Exception {
        Integer topState = (Integer)this.mState.pop();
        if (topState != state) {
            throw new Exception("XML Error: expected end of state '" + topState + "', got '" + state + "' instead");
        }
    }

    private int getState() {
        return (Integer)this.mState.peek();
    }

    private void pushName(String name) {
        this.mElementNames.push(name);
    }

    private void popName(String name) throws Exception {
        String topName = (String)this.mElementNames.pop();
        if (!name.equals(topName)) {
            throw new Exception("XML Error: expected end of '" + topName + "', got '" + name + "' instead");
        }
    }
}

