<?php

function date_mysql2german($date="0000-00-00") {
    $d    =    explode("-",$date);
    
    return    sprintf("%02d.%02d.%04d", $d[2], $d[1], $d[0]);
}


function loadGetVars($names, $prefix = "", $force = false, $db = null){
	//check if every single variable is set
	$ok = true;
	foreach($names as $name){
		if(!isset($_GET[$name])){
			//if(DEBUG) echo "missing GET[\"$name\"]";
			if($force) $ok = false; else return false;
		}
	}
	
	//load variables
	foreach($names as $name){
		$pName = $prefix.$name;
		
		global $$pName;
		$$pName = null;
		if(isset($_GET[$name])){
			if($db == null){
				$$pName = $_GET[$name];
			}else{
				$$pName = $db->escape_string($_GET[$name]);
			}
		}
	}
	
	//tell if every single variable is set
	return $ok;
}

function loadPostVars($names, $prefix = "", $force = false, $db = null){
	$ok = true;
	foreach($names as $name){
		if(!isset($_POST[$name])){
			//if(DEBUG) echo "missing POST[\"$name\"]";
			if($force) $ok = false; else return false;
		}
	}
	
	//load variables
	foreach($names as $name){
		$pName = $prefix.$name;
		
		global $$pName;
		$$pName = null;
		if(isset($_POST[$name])){
			if($db == null){
				$$pName = $_POST[$name];
			}else{
				$$pName = $db->escape_string($_POST[$name]);
			}
		}
	}
	
	//say that every single variable is set
	return $ok;
}



function escapeVars($names, $db, $prefix = ""){
	foreach($names as $name){
		$pName = $prefix.$name;
		
		global $$pName;
		$$pName = $db->escape_string($$pName);
	}
}

function htmlEscapeVars($names, $prefix = ""){
	foreach($names as $name){
		$pName = $prefix.$name;
		
		global $$pName;
		$$pName = htmlspecialchars($$pName, ENT_NOQUOTES || ENT_QUOTES);
	}
}
	
function copyVars($names, $prefix, $db = null){
	foreach($names as $xxx_oldName){
		$xxx_newName = $prefix.$xxx_oldName;
		
		global $$xxx_oldName, $$xxx_newName;
		if($db == null) $$xxx_newName = $$xxx_oldName; else $$xxx_newName = $db->escape_string($$xxx_oldName);
	}
}
	
function checkVarsNotEmpty($names, $prefix = ""){
	foreach($names as $name){
		$pName = $prefix.$name;
		global $$pName;
		if(!isset($$pName) || $$pName == null || $$pName == "") return false;
	}
	return true;
}

function emptyVars($names, $prefix = ""){
	foreach($names as $name){
		$pName = $prefix.$name;
		
		global $$pName;
		$$pName = "";
	}
}

function unsetVars($names, $prefix = "") {
	foreach($names as $name){
		$pName = $prefix.$name;
		
		global $$pName;
		unset($$pName);
	}
}

function html($str){
	echo "$str\n";
}



function Companydata(){
  echo "<div id=companydata>
			<table id=headtable>
				<tr>
					<td VALIGN=top id=headtabletd><b>Benutzer:<b></td>
					<td id=headtabletd>".$_SESSION['firstname']."&nbsp;".$_SESSION['lastname']."</td>
					<td id=headtabletd><b>Firma:</b></td>
					<td id=headtabletd>".$_SESSION['cname']."</td>
				</tr><tr>
					<td id=headtabletd>&nbsp;</td>
					<td id=headtabletd>".$_SESSION['email']."</td>
					<td id=headtabletd>&nbsp;</td>
					<td id=headtabletd>".$_SESSION['cstreet']."</td>
				</tr><tr>
					<td id=headtabletd>&nbsp;</td>
					<td id=headtabletd>&nbsp;</td>
					<td id=headtabletd>&nbsp;</td>
					<td id=headtabletd>".$_SESSION['czipcode']."&nbsp;".$_SESSION['ccity']."</td>
				</tr><tr>
					<td id=headtabletd>&nbsp;</td>
					<td id=headtabletd>&nbsp;</td>
					<td id=headtabletd>&nbsp;</td>
					<td id=headtabletd>".$_SESSION['coname']."</td>
				</tr>
			</table>
		</DIV>";
//		".$_SESSION[cname]."<PRE></div>";
}

function Admindata(){
  echo "<div id=companydata>
			<table border=0 id=headtable>
				<tr>
					<td VALIGN=top><b>Benutzer:<b></td>
					<td>Super&nbsp;Admin</td>
					<td><b>Firma:</b></td>
					<td>Agilos</td>
				</tr><tr>
					<td>&nbsp;</td>
					<td>Martin@Agilos.de</td>
					<td>&nbsp;</td>
					<td>&nbsp;</td>
				</tr><tr>
					<td>&nbsp;</td>
					<td>&nbsp;</td>
					<td>&nbsp;</td>
					<td>&nbsp;</td>
				</tr><tr>
					<td>&nbsp;</td>
					<td>&nbsp;</td>
					<td>&nbsp;</td>
					<td>&nbsp;</</td>
				</tr>
			</table>
		</DIV>";
//		".$_SESSION[cname]."<PRE></div>";
}

function getTable(){
echo "<table><tr><td VALIGN=top>";
}

function getCustomerIdByEmail($db,$mail){
  $sql = "SELECT id FROM p_user WHERE email = '".$mail."';";
  $result = $db->query($sql);
  while ($row = $result->fetch_assoc()) {
    return $row['id'];
  }
  //if($row = $result->fetch_assoc()) return $row['id'];
}

function getCompanies($db){
  $sql = "SELECT * FROM p_company;";
  $result = $db->query($sql);
  $rows = array();
  while ($row = $result->fetch_assoc()) {
  	$rows[count($rows)] = $row;
  }
  return $rows;
}

function Usermenu($db){
  getTable();
  echo "<div id=menu><br><b>Men&uuml;</b><br>";
  getModuleMenu($db);
  echo "</div></td>";
}

function ChkVar($chk = ""){
  if (isset($chk) AND $chk != "") return true;
  return false;
}

function PageTitle($title = "Kein Titel angegeben!"){
  echo "<div id=pagetitle>".$title."</div>";
}

function Adminmenu($db){
  getTable();
  echo "<div id=menu><br><b>Men&uuml;</b><br>";
  echo "<a href=index.php?page=createcompany>Firma erstellen</a><br>";
  echo "<a href=index.php?page=changecompany>Firma bearbeiten</a><br>";
  echo "<br><a href=index.php?page=createuser>Benutzer erstellen</a><br>";
  echo "<a href=index.php?page=changeuser>Benutzer bearbeiten</a><br>";
  getAdminModuleMenu($db);
  echo "</div></td>";
}

function getMenueTargetByPrefixAndID($db,$prefix,$id){
  $sql = "SELECT p_mod_".$prefix."menue.target FROM p_mod_".$prefix."menue WHERE p_mod_".$prefix."menue.id = '".$id."';";
  $result = $db->query($sql);
  while ($row = $result->fetch_assoc()) {
    return $row['target'];
  }
}

function getMenueParameterByPrefixAndID($db,$prefix,$id){
  $sql = "SELECT p_mod_".$prefix."menue.parameter FROM p_mod_".$prefix."menue WHERE p_mod_".$prefix."menue.id = '".$id."';";
  $result = $db->query($sql);
  while ($row = $result->fetch_assoc()) {
    return $row['parameter'];
  }
}

function getAdminMenueTargetByPrefixAndID($db,$prefix,$id){
  $sql = "SELECT p_adm_mod_".$prefix."menue.target FROM p_adm_mod_".$prefix."menue WHERE p_adm_mod_".$prefix."menue.id = '".$id."';";
  $result = $db->query($sql);
  while ($row = $result->fetch_assoc()) {
    return $row['target'];
  }
}


function getModulePrefixByID($db,$id){
  $sql = "SELECT p_modules.tableprefix FROM p_modules WHERE p_modules.id = '".$id."';";
  $result = $db->query($sql);
  while ($row = $result->fetch_assoc()) {
    return $row['tableprefix'];
  }
}
function getAdminModulePrefixByID($db,$id){
  $sql = "SELECT p_adm_modules.tableprefix FROM p_adm_modules WHERE p_adm_modules.id = '".$id."';";
  $result = $db->query($sql);
  while ($row = $result->fetch_assoc()) {
    return $row['tableprefix'];
  }
}

function ChkUserRights($db,$modulID){
  if (!isset($modulID) OR $modulID == "") return true;
  $sql = "SELECT p_rights.rights FROM p_rights WHERE p_rights.module = '".$modulID."' AND p_rights.user = '".$_SESSION['userID']."' AND p_rights.rights > '0';";
  $result = $db->query($sql);
  if($result->num_rows > 0) return true;
  @session_destroy();
  return false;  
	
}

function getModuleFolderByID($db,$id){
  $sql = "SELECT p_modules.folder FROM p_modules WHERE p_modules.id = '".$id."';";
  $result = $db->query($sql);
  while ($row = $result->fetch_assoc()) {
    return $row['folder'];
  }
}

function getAdminModuleFolderByID($db,$id){
  $sql = "SELECT p_adm_modules.folder FROM p_adm_modules WHERE p_adm_modules.id = '".$id."';";
  $result = $db->query($sql);
  while ($row = $result->fetch_assoc()) {
    return $row['folder'];
  }
}

function getAdminModuleMenu($db){
  $sql['mod'] = "SELECT * FROM p_adm_modules";
  $result['mod'] = $db->query($sql['mod']);
  if($result['mod']->num_rows > 0) {
    while ($row = $result['mod']->fetch_assoc()) {
	  echo "<br><b>" . $row['name'] . "</b><br>";
	  $sql[$row['id']] = "SELECT target,parent,name,id FROM p_adm_mod_" . $row['tableprefix'] . "menue
					 WHERE active = '1' AND visible = '1' AND parent = 0 ORDER BY id ASC";
	  $result[$row['id']] = $db->query($sql[$row['id']]);
	
	  while ($data = $result[$row['id']]->fetch_assoc()) {
	  	$id = $data['id'];
		$parent = $data['parent'];
	    if (!ChkVar($data['target'])){
			if ($parent == 0) echo "<b>&nbsp; ".$data['name']."</b><br>";
			else echo "&nbsp;&nbsp; ".$data['name']."<br>";
			
		}else{	
			if ($parent == 0) echo "<b>&nbsp;&gt; <a href=index.php?page=modulesite&module=" . $row['id'] . "&menue=" . $data['id'] . ">".$data['name']."</a></b><br>";
			else echo "&nbsp;&nbsp;&gt; <a href=index.php?page=modulesite&module=" . $row['id'] . "&menue=" . $data['id'] . ">".$data['name']."</a><br>";
		}
		$sql['submenu'] = "SELECT target, parent, name, id FROM p_adm_mod_".$row['tableprefix']."menue WHERE active='1' AND visible='1' AND parent='$id';";
		$result["submenu"] = $db->query($sql['submenu']);
		while($row2 = $result["submenu"]->fetch_array()){
			echo "&nbsp;&nbsp;&nbsp;&nbsp;&gt; <a href=index.php?page=modulesite&module=" . $row['id'] . "&menue=" . $row2['id'] . ">".$row2['name']."</a><br>";
		}
	  }
	}
  }
}

function getModuleMenu($db){
  $sql['mod'] = "SELECT p_modules.id,p_modules.name,p_modules.folder,p_modules.tableprefix FROM p_modules
			JOIN p_rights ON (p_modules.id = p_rights.module)
			WHERE  p_rights.user = '".$_SESSION['userID']."' AND p_rights.rights > '0'";
  $result['mod'] = $db->query($sql['mod']);
  if($result['mod']->num_rows > 0) {
    while ($row = $result['mod']->fetch_assoc()) {
	  echo "<br><b>" . $row['name'] . "</b><br>";
	  $sql[$row['id']] = "SELECT parent,name,id,parameter FROM p_mod_" . $row['tableprefix'] . "menue
					 WHERE active = '1' AND visible = '1' ORDER by parent ASC";
	  $result[$row['id']] = $db->query($sql[$row['id']]);

	  while ($data = $result[$row['id']]->fetch_assoc()) {
		if ($data['parent'] == 0) echo "<b>&nbsp;&gt; <a href=index.php?module=" . $row['id'] . "&menue=" . $data['id'] . "&".$data['parameter'].">".$data['name']."</a></b><br>";
	    else echo "&nbsp;&nbsp;&gt; <a href=index.php?module=" . $row['id'] . "&menue=" . $data['id'] . ">".$data['name']."</a><br>";

	  }
	}
  }else echo "Keine Module aktiviert";
}

function dbConnect() {
	$db = @new mysqli(DBHOST,DBUSER,DBPASS,DBNAME);
	if (mysqli_connect_errno()) {
		die ('Konnte keine Verbindung zur Datenbank aufbauen: ' . mysqli_connect_error() . '('.mysqli_connect_errno().')');
	}
	return $db;
}

function isSAdmin() {
	if (isset($_SESSION['isSAdmin']) AND $_SESSION['isSAdmin'] === true) return true;
	return false;
}

function isUser() {
	if (isset($_SESSION['isUser']) AND $_SESSION['isUser'] === true) return true;
	return false;
}

function throwError($isAdmin,$description,$show_backlink = true) {
	$_SESSION['error'] = $description;
	if($isAdmin)
		writeLog('admin',$description);	
	else {
		$log = '['.$_SESSION['userId'].'] '.$description;
		writeLog('user',$log);	
	}
	$goto = 'Location: index.php?page=error';
	if(!$show_backlink)
		$goto .= '&no_backlink=true';	
	header($goto);
	exit();
}

function writeLog($fileName,$newEntry) {
	$newEntry = '['.date('d.m.Y H:i:s',time()).'] ['.getIp().'] '.$newEntry."\r\n";
	$fileName = 'logs/'.$fileName.'.txt'; 
	$file = fopen($fileName,'a+');
	fputs($file,$newEntry);
	fclose($file);
 
}

function getIp() {
    if(getenv("HTTP_X_FORWARDED_FOR"))
        $ip = getenv("HTTP_X_FORWARDED_FOR");     
    else
        $ip = getenv("REMOTE_ADDR");
    return $ip;   
}
function getError() {
	$error = $_SESSION['error'];
	$_SESSION['error'] = null;
	return $error;
}
?>
