<?php
	$MENUE				= $_SESSION["menue"];
	$MODULE				= $_SESSION["module"];
	$USERID				= $_SESSION["userID"];
	
	$MODLINK			= "index.php?module=$MODULE";
	$HTML_IMG_ADD		= "<img src='$MODPATH/gfx/add.png' alt='Hinzuf&uuml;gen' title='Hinzuf&uuml;gen'>";
	$HTML_IMG_ADD_ABOVE	= "<img src='$MODPATH/gfx/add.png' alt='Dar&uuml;ber hinzuf&uuml;gen' title='Dar&uuml;ber hinzuf&uuml;gen'>";
	$HTML_IMG_EDIT		= "<img src='$MODPATH/gfx/edit.png' alt='Bearbeiten' title='Bearbeiten'>";
	$HTML_IMG_YES		= "<img src='$MODPATH/gfx/yes.png' alt='Ja' title='Ja' align='center'>";
	$HTML_IMG_NO		= "<img src='$MODPATH/gfx/no.png' alt='Nein' title='Nein' align='center'>";
	$HTML_IMG_UP		= "<img src='$MODPATH/gfx/up.png' alt='Nein' title='Hoch' align='center'>";
	$HTML_IMG_DOWN		= "<img src='$MODPATH/gfx/down.png' alt='Ja' title='Runter' align='center'>";
	$HTML_IMG_UP_OFF	= "<img src='$MODPATH/gfx/up_off.png' alt='Nein' title='Hoch' align='center'>";
	$HTML_IMG_DOWN_OFF	= "<img src='$MODPATH/gfx/down_off.png' alt='Ja' title='Runter' align='center'>";
	
	$MENUE_CHAINS		= 1;
	$MENUE_TELNUM		= 2;
	
	$IBS_CHAINS				= "p_mod_ibs_chains";
	$IBS_CHAIN_RIGHTS		= "p_mod_ibs_rights";
	$IBS_CHAINS_POSITIONS	= "p_mod_ibs_chains_positions";
	$COMPANIES				= "p_company";
	
	$ROW_LIGHT				= "#EEEEEE";
	$ROW_DARK				= "#AAAAAA";
	
	function getUserChains(){
		global $db, $USERID, $IBS_CHAIN_RIGHTS, $IBS_CHAINS, $IBS_;
		
		$sql = "SELECT c.* FROM $IBS_CHAIN_RIGHTS r JOIN $IBS_CHAINS c ON r.company = c.company AND r.chain = c.chain WHERE r.userid='$USERID';";
		
		if($res = $db->query($sql)){
			$rows = array();
			while($row = $res->fetch_array()) $rows[count($rows)] = $row;
			$res->free();
			return $rows;
		}else{
			echo "ERROR IN: '$sql':<br>".$db->error."<br>";
		}
		return null;
	}
	
	function getChainPositions($company, $chain){
		global $db, $USERID, $IBS_CHAIN_RIGHTS, $IBS_CHAINS_POSITIONS;
		
		$sql = "SELECT e.* FROM $IBS_CHAIN_RIGHTS r JOIN $IBS_CHAINS_POSITIONS e ON r.company = e.company AND r.chain = e.chain WHERE r.userid='$USERID' AND e.company='$company' AND e.chain='$chain' ORDER BY e.position";
		
		if($res = $db->query($sql)){
			$rows = array();
			while($row = $res->fetch_array()) $rows[count($rows)] = $row;
			$res->free();
			return $rows;
		}else{
			echo "ERROR IN: '$sql':<br>".$db->error."<br>";
		}
		return null;
	}
	
	$CHAIN_POSITION_TYPES = array(
		"CALL"	=> "Anruf",
		"SMS"	=> "SMS",
		"EMAIL"	=> "E-Mail"
	);
	
	
	
	
	
	function getTypeName($type){
		global $CHAIN_POSITION_TYPES;
		if(isset($CHAIN_POSITION_TYPES[$type])) return $CHAIN_POSITION_TYPES[$type]; else return null;
	}
	
	function checkChainPositionType($type){
		global $CHAIN_POSITION_TYPES;
		return isset($CHAIN_POSITION_TYPES[$type]);
	}
	
	
	
	
	
	function getChainMaxPosition($company, $chain){
		global $db, $IBS_CHAINS_POSITIONS;
		$company		= intval($company);
		$chain			= intval($chain);
		
		$maxPosition = 0;
		$query = "SELECT max(position) as maxposition FROM $IBS_CHAINS_POSITIONS WHERE company='$company' AND chain='$chain' GROUP BY company, chain;";
		if($result = $db->query($query)){
			if($row = $result->fetch_array()) $maxPosition = intval($row["maxposition"]);
		}else{
			if(DEBUG) html("<font style='background-color: red;'>$query<br>".$db->error."</font><br>");
		}
		$result->free();
		//if(DEBUG) html("maxPosition: $maxPosition<br>");
		return $maxPosition;
	}
	
	
	function getChainPosition($company, $chain, $position){
		global $db, $IBS_CHAINS_POSITIONS;
		$company		= intval($company);
		$chain			= intval($chain);
		$position		= intval($position);
		
		$row = null;
		$query = "SELECT * FROM $IBS_CHAINS_POSITIONS WHERE company='$company' AND chain='$chain' AND position='$position';";
		if($result = $db->query($query)){
			$row = $result->fetch_array();
		}else{
			if(DEBUG) html("<font style='background-color: red;'>$query<br>".$db->error."</font><br>");
		}
		$result->free();
		return $row;
	}
	
	function getChainPositionsGreaterEqual($company, $chain, $position){
		global $db, $IBS_CHAINS_POSITIONS;
		$company		= intval($company);
		$chain			= intval($chain);
		$position		= intval($position);
		
		$rows = array();
		$query = "SELECT * FROM $IBS_CHAINS_POSITIONS WHERE company='$company' AND chain='$chain' AND position>='$position';";
		if($result = $db->query($query)){
			while($row = $result->fetch_array()){
				$rows[count($rows)] = $row;
			}
		}else{
			if(DEBUG) html("<font style='background-color: red;'>$query<br>".$db->error."</font><br>");
		}
		$result->free();
		return $rows;
	}
	
	
	
	function addChainPosition($company, $chain, $position, $type, $address, $message, $description){
		global $db, $IBS_CHAINS_POSITIONS;
		$company		= intval($company);
		$chain			= intval($chain);
		$position		= intval($position);
		$type			= $db->real_escape_string($type);
		$address		= $db->real_escape_string($address);
		$message		= $db->real_escape_string($message);
		$description	= $db->real_escape_string($description);
		
		//catch mysql-error
		//if(DEBUG) html("adding $position<br>");
		$query = "INSERT INTO $IBS_CHAINS_POSITIONS (company, chain, position, type, address, message, description) VALUE ('$company', '$chain', '$position', '$type', '$address', '$message', '$description');";
		if(!$db->query($query)){
			if(DEBUG) html("<font style='background-color: red;'>$query<br>".$db->error."</font><br>");
			return false;
		}
		return ($db->affected_rows == 1);
	}
	
	function editChainPosition($company, $chain, $position, $type, $address, $message, $description){
		global $db, $IBS_CHAINS_POSITIONS;
		$company		= intval($company);
		$chain			= intval($chain);
		$position		= intval($position);
		$type			= $db->real_escape_string($type);
		$address		= $db->real_escape_string($address);
		$message		= $db->real_escape_string($message);
		$description	= $db->real_escape_string($description);
		
		//catch mysql-error
		$query = "UPDATE $IBS_CHAINS_POSITIONS SET position='$position', type='$type', address='$address', message='$message', description='$description' WHERE company='$company' AND chain='$chain' AND position='$position';";
		if(!$db->query($query)){
			if(DEBUG) html("<font style='background-color: red;'>$query<br>".$db->error."</font><br>");
			return false;
		}
		return ($db->affected_rows == 1);
	}
	
	function moveChainPosition($company, $chain, $position, $newPosition){
		global $db, $IBS_CHAINS_POSITIONS;
		$company		= intval($company);
		$chain			= intval($chain);
		$position		= intval($position);
		$newPosition	= intval($newPosition);
		
		//catch mysql-error
		if(DEBUG) html("moving #$position to #$newPosition<br>");
		$query = "UPDATE $IBS_CHAINS_POSITIONS SET position='$newPosition' WHERE company='$company' AND chain='$chain' AND position='$position';";
		if(!$db->query($query)){
			if(DEBUG) html("<font style='background-color: red;'>$query<br>".$db->error."</font><br>");
			return false;
		}
		return ($db->affected_rows == 1);
	}
	
	function moveChainPositions($company, $chain, $first, $last, $step){
		global $db, $IBS_CHAINS_POSITIONS;
		$company		= intval($company);
		$chain			= intval($chain);
		$first			= intval($first);
		$last			= intval($last);
		$step			= intval($step);
		
		if($first < $last){
			$dir = 1;
		}else{
			$dir = -1;
		}
		//if(DEBUG) html("first: $first, last: $last, dir: $dir<br>");
		
		for($src = $first; $src * $dir <= $last * $dir; $src += $dir){
			$dst = $src + $step;
			if(DEBUG) html("moving #$src to #$dst<br>");
			$query = "UPDATE $IBS_CHAINS_POSITIONS SET position='$dst' WHERE company='$company' AND chain='$chain' AND position='$src';";
			if(!$db->query($query)){
				if(DEBUG) html("<font style='background-color: red;'>$query<br>".$db->error."</font><br>");
				return false;
			}else{
				//if(DEBUG) html("ok<br>");
			}
		}
		return true;
	}
	
	function deleteChainPosition($company, $chain, $position){
		global $db, $IBS_CHAINS_POSITIONS;
		$company		= intval($company);
		$chain			= intval($chain);
		$position		= intval($position);
		
		//catch mysql-error
		$query = "DELETE FROM $IBS_CHAINS_POSITIONS WHERE company='$company' AND chain='$chain' AND position='$position';";
		if(!$db->query($query)){
			if(DEBUG) html("<font style='background-color: red;'>$query<br>".$db->error."</font><br>");
			return false;
		}
		return ($db->affected_rows == 1);
	}
?>
