<?php
	define("MODPATH", dirname(__FILE__));
	include(MODPATH."/config.php");
	
	PageTitle("Kette Bearbeiten");
	html("<br>");
	
	
	
	//get primary key of chain
	$oldFields = array("oldCompany", "oldChain");
	if(!loadGetVars($oldFields)) return;	//exit include
	copyVars($oldFields, "escaped_", $db);
	
	
	
	//getting oldChainName to display
	$sql = "SELECT name FROM p_mod_ibs_chains WHERE company='$escaped_oldCompany' AND chain='$escaped_oldChain';";
	$result = $db->query($sql);
	if(!($row = $result->fetch_array())) return;	//exit include
	$oldName = $row["name"];
	$result->free();
	
	
	
	//getting oldCompanyName to display
	$sql = "SELECT name FROM p_company WHERE id='$escaped_oldCompany';";
	$result = $db->query($sql);
	if(!($row = $result->fetch_array())) return;	//exit include
	$oldCompanyName = $row["name"];
	$result->free();
	
	
	
	//define field-names to load
	$newFields = array("action", "newCompany", "newChain", "newMaxEntries", "newName", "newDescription");
	$oldFields = array("oldCompany", "oldChain", "oldMaxEntries", "oldName", "oldDescription");
	
	
	
	$allFields	= loadPostVars($newFields);
	$requested	= $allFields && ($action == "chainEdit");
	
	$allFilled = false;
	if($requested){
		$allFilled = checkVarsNotEmpty($newFields);
		if(!$allFilled) html("<font style='background-color: red;'>Es wurden nicht alle Informationen angegeben!</font><br>");
	}
	
	$gotNewCompanyName = false;
	if($allFilled){
		copyVars($newFields, "escaped_", $db);
				
		//getting newCompanyName to display
		$sql = "SELECT name FROM p_company WHERE id='$escaped_newCompany';";
		$result2 = $db->query($sql);
		
		$gotNewCompanyName = ($row = $result2->fetch_array());
	}
	
	$canUpdate = false;
	if($gotNewCompanyName){
		$newCompanyName = $row["name"];
		if($oldCompany == $newCompany && $oldChain == $newChain){
			$updatePrimaryKey = "";
			$canUpdate = true;
		}else{
			$updatePrimaryKey = "company='$escaped_newCompany', chain='$escaped_newChain',";
			$sql = "SELECT * FROM p_mod_ibs_chains WHERE company='$escaped_newCompany' AND chain='$escaped_newChain';";
			$result = $db->query($sql);
			$canUpdate = !($row = $result->fetch_array());
			$result->free();
			
			if(!$canUpdate) html("<font style='background-color: red;'>Es existiert bereits eine Kette #$newChain f&uuml;r Kunde '$newCompanyName'.</font><br>");
		}
	}
	
	$updateOK = false;
	if($canUpdate){
		$sql = "UPDATE p_mod_ibs_chains SET $updatePrimaryKey maxentries='$escaped_newMaxEntries', name='$escaped_newName', description='$escaped_newDescription' WHERE company='$escaped_oldCompany' AND chain='$escaped_oldChain';";
		$updateOK = $db->query($sql);
		if($updateOK) html("<font style='background-color: green;'>Kette #$newChain ($newName) von '$newCompanyName' erfolgreich geändert!</font><br>");
	}
	
	
	
	if($allFields){
		$oldCompany		= $newCompany;
		$oldChain		= $newChain;
		$oldMaxEntries	= $newMaxEntries;
		$oldName		= $newName;
		$oldDescription	= $newDescription;
		if($allFilled) unsetVars($newFields, "escaped_");
	}else{
		// LOAD OLD VALUES FROM DATABASE
		$sql	= "SELECT * FROM p_mod_ibs_chains WHERE company='$escaped_oldCompany' AND chain='$escaped_oldChain';";
		$result	= $db->query($sql);
		if($CHAIN = $result->fetch_array()){
			$oldCompany		= $CHAIN["company"];
			$oldChain		= $CHAIN["chain"];
			$oldMaxEntries	= $CHAIN["maxentries"];
			$oldName		= $CHAIN["name"];
			$oldDescription	= $CHAIN["description"];
		}
		$result->free();
	}
	
	
	// PRINT
	
	htmlEscapeVars($oldFields);
	
	html("<form action='$MODLINK&menue=$MENUE_CHAIN_EDIT&oldCompany=$oldCompany&oldChain=$oldChain' method='post'>");
		html("<input type='hidden' name='action'  value='chainEdit'>");
		html("<table>");
			html("<tr>");
				html("<td>Kunde:</td>");
				html("<td>");
					html("<select name='newCompany'>");
						foreach(getCompanies($db) as $company){
							$id			= $company["id"];
							$name		= $company["name"];
							$selected	= ($id == $oldCompany) ? "selected" : "";
							html("<option $selected value='$id'>$name</option>");
						}
					html("</select>");
				html("</td>");
			html("</tr>");
			html("<tr>");
				html("<td>Nummer:</td>");
				html("<td><input type='text' name='newChain' value='$oldChain'></td>");
			html("</tr>");
			html("<tr>");
				html("<td>Max. Eintr&auml;ge:</td>");
				html("<td><input type='text' name='newMaxEntries' maxlength='5' value='$oldMaxEntries'></td>");
			html("</tr>");
			html("<tr>");
				html("<td>Name:</td>");
				html("<td><input type='text' name='newName' value='$oldName'></td>");
			html("</tr>");
			html("<tr>");
				html("<td>Beschreibung:</td>");
				html("<td><textarea name='newDescription'>$oldDescription</textarea></td>");
			html("</tr>");
			html("<tr>");
				html("<td colspan='2' align='right'><input type='submit' name='submit' value='&Uuml;bernehmen'></td>");
			html("</tr>");
		html("</table>");
	html("</form>");
?>
